/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.awt.NativeLibLoader;
import sun.font.CompositeFont;
import sun.font.CoreMetrics;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontLineMetrics;
import sun.font.FontManager;
import sun.font.GlyphLayout;
import sun.font.StandardGlyphVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    private static final Map EMPTY_MAP;
    private static final TransformAttribute IDENT_TX_ATTRIBUTE;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient Font2DHandle font2DHandle;
    private transient int superscript;
    private transient float width = 1.0f;
    private transient boolean createdFont = false;
    private transient double[] matrix;
    private transient boolean nonIdentityTx;
    private static final AffineTransform identityTx;
    private static final long serialVersionUID = -4206021311591459213L;
    private static SoftReference cacheRef;
    private static final float[] ssinfo;
    private int fontSerializedDataVersion = 1;
    private static double[] cachedMat;
    private transient SoftReference flmref;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;

    @Deprecated
    public FontPeer getPeer() {
        return this.getPeer_NoClientCode();
    }

    final FontPeer getPeer_NoClientCode() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.peer = toolkit.getFontPeer(this.name + "." + this.size, this.style);
        }
        return this.peer;
    }

    private Hashtable getRequestedAttributes() {
        if (this.fRequestedAttributes == null) {
            this.fRequestedAttributes = new Hashtable(7, 0.9f);
            this.fRequestedAttributes.put(TextAttribute.TRANSFORM, IDENT_TX_ATTRIBUTE);
            this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
            this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
            this.fRequestedAttributes.put(TextAttribute.WEIGHT, (this.style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            this.fRequestedAttributes.put(TextAttribute.POSTURE, (this.style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
            this.fRequestedAttributes.put(TextAttribute.SUPERSCRIPT, new Integer(this.superscript));
            this.fRequestedAttributes.put(TextAttribute.WIDTH, new Float(this.width));
        }
        return this.fRequestedAttributes;
    }

    private void initializeFont(Hashtable hashtable) {
        if (hashtable != null) {
            Object v = hashtable.get(TextAttribute.TRANSFORM);
            if (v instanceof TransformAttribute) {
                this.nonIdentityTx = !((TransformAttribute)v).isIdentity();
            } else if (v instanceof AffineTransform) {
                this.nonIdentityTx = !((AffineTransform)v).isIdentity();
            }
            v = hashtable.get(TextAttribute.SUPERSCRIPT);
            if (v instanceof Integer) {
                this.superscript = (Integer)v;
                this.nonIdentityTx |= this.superscript != 0;
            }
            if ((v = hashtable.get(TextAttribute.WIDTH)) instanceof Integer) {
                this.width = ((Float)v).floatValue();
                this.nonIdentityTx |= this.width != 1.0f;
            }
        }
    }

    private Font2D getFont2D() {
        if (FontManager.usingPerAppContextComposites && this.font2DHandle != null && this.font2DHandle.font2D instanceof CompositeFont && ((CompositeFont)this.font2DHandle.font2D).isStdComposite()) {
            return FontManager.findFont2D(this.name, this.style, 2);
        }
        if (this.font2DHandle == null) {
            this.font2DHandle = FontManager.findFont2D((String)this.name, (int)this.style, (int)2).handle;
        }
        return this.font2DHandle.font2D;
    }

    public Font(String string, int n, int n2) {
        this.name = string != null ? string : "Default";
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = n2;
        this.pointSize = n2;
    }

    private Font(String string, int n, float f) {
        this.name = string != null ? string : "Default";
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = (int)((double)f + 0.5);
        this.pointSize = f;
    }

    private Font(File file, int n, boolean bl) throws FontFormatException {
        this.createdFont = true;
        this.font2DHandle = FontManager.createFont2D((File)file, (int)n, (boolean)bl).handle;
        this.name = this.font2DHandle.font2D.getFontName(Locale.getDefault());
        this.style = 0;
        this.size = 1;
        this.pointSize = 1.0f;
    }

    private Font(Map map, boolean bl, Font2DHandle font2DHandle) {
        this.createdFont = bl;
        if (bl) {
            this.font2DHandle = font2DHandle;
        }
        this.initFromMap(map);
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        this.initFromMap(map);
    }

    private void initFromMap(Map map) {
        this.name = "Dialog";
        this.pointSize = 12.0f;
        this.size = 12;
        if (map != null && !((Object)map).equals(EMPTY_MAP)) {
            this.fRequestedAttributes = new Hashtable(map);
            Object v = map.get(TextAttribute.FAMILY);
            if (v != null) {
                this.name = (String)v;
            }
            if ((v = map.get(TextAttribute.WEIGHT)) != null && v.equals(TextAttribute.WEIGHT_BOLD)) {
                this.style |= 1;
            }
            if ((v = map.get(TextAttribute.POSTURE)) != null && v.equals(TextAttribute.POSTURE_OBLIQUE)) {
                this.style |= 2;
            }
            if ((v = map.get(TextAttribute.SIZE)) != null) {
                this.pointSize = ((Float)v).floatValue();
                this.size = (int)((double)this.pointSize + 0.5);
            }
            if ((v = map.get(TextAttribute.TRANSFORM)) != null) {
                if (v instanceof TransformAttribute) {
                    this.nonIdentityTx = !((TransformAttribute)v).isIdentity();
                } else if (v instanceof AffineTransform) {
                    boolean bl = this.nonIdentityTx = !((AffineTransform)v).isIdentity();
                }
            }
            if ((v = map.get(TextAttribute.SUPERSCRIPT)) != null && v instanceof Integer) {
                this.superscript = (Integer)v;
                this.nonIdentityTx |= this.superscript != 0;
            }
            if ((v = map.get(TextAttribute.WIDTH)) != null && v instanceof Float) {
                this.width = ((Float)v).floatValue();
                this.nonIdentityTx |= this.width != 1.0f;
            }
        }
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font != null) {
            return font;
        }
        return Font.get(new Key(map));
    }

    private static Font get(Key key) {
        Font font = null;
        HashMap<Key, Font> hashMap = (HashMap<Key, Font>)cacheRef.get();
        if (hashMap == null) {
            hashMap = new HashMap<Key, Font>();
            cacheRef = new SoftReference(hashMap);
        } else {
            font = (Font)hashMap.get(key);
        }
        if (font == null) {
            font = new Font(key.attrs);
            hashMap.put(key, font);
        }
        return font;
    }

    public static Font createFont(int n, InputStream inputStream) throws FontFormatException, IOException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("font format not recognized");
        }
        final InputStream inputStream2 = inputStream;
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = null;
                try {
                    file = File.createTempFile("+~JF", ".tmp", null);
                    file.deleteOnExit();
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream2);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    int n = 0;
                    int n2 = 8192;
                    byte[] byArray = new byte[n2];
                    while (n != -1) {
                        n = bufferedInputStream.read(byArray, 0, n2);
                        if (n == -1) continue;
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    return iOException;
                }
                return file;
            }
        });
        if (t instanceof File) {
            return new Font((File)t, n, true);
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        throw new FontFormatException("Couldn't access font stream");
    }

    public static Font createFont(int n, File file) throws FontFormatException, IOException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("font format not recognized");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            FilePermission filePermission = new FilePermission(file.getPath(), "read");
            securityManager.checkPermission(filePermission);
        }
        if (!file.canRead()) {
            throw new IOException("Can't read " + file);
        }
        return new Font(file, n, false);
    }

    public AffineTransform getTransform() {
        if (this.nonIdentityTx) {
            AffineTransform affineTransform = null;
            Object v = this.getRequestedAttributes().get(TextAttribute.TRANSFORM);
            if (v != null) {
                if (v instanceof TransformAttribute) {
                    affineTransform = ((TransformAttribute)v).getTransform();
                } else if (v instanceof AffineTransform) {
                    affineTransform = new AffineTransform((AffineTransform)v);
                }
            } else {
                affineTransform = new AffineTransform();
            }
            if (this.superscript != 0) {
                int n;
                double d = 0.0;
                int n2 = 0;
                boolean bl = this.superscript > 0;
                int n3 = bl ? -1 : 1;
                int n4 = n = bl ? this.superscript : -this.superscript;
                while ((n & 7) > n2) {
                    int n5 = n & 7;
                    d += (double)((float)n3 * (ssinfo[n5] - ssinfo[n2]));
                    n >>= 3;
                    n3 = -n3;
                    n2 = n5;
                }
                double d2 = Math.pow(0.6666666666666666, n2);
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(0.0, d *= (double)this.pointSize));
                affineTransform.scale(d2, d2);
            }
            if (this.width != 1.0f) {
                affineTransform.scale(this.width, 1.0);
            }
            return affineTransform;
        }
        return new AffineTransform();
    }

    public String getFamily() {
        return this.getFamily_NoClientCode();
    }

    final String getFamily_NoClientCode() {
        return this.getFamily(Locale.getDefault());
    }

    public String getFamily(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null locale doesn't mean default");
        }
        return this.getFont2D().getFamilyName(locale);
    }

    public String getPSName() {
        return this.getFont2D().getPostscriptName();
    }

    public String getName() {
        return this.name;
    }

    public String getFontName() {
        return this.getFontName(Locale.getDefault());
    }

    public String getFontName(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("null locale doesn't mean default");
        }
        return this.getFont2D().getFontName(locale);
    }

    public int getStyle() {
        return this.style;
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isTransformed() {
        return this.nonIdentityTx;
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public static Font decode(String string) {
        int n;
        int n2;
        int n3;
        char c;
        int n4;
        int n5;
        String string2;
        String string3;
        block20: {
            int n6;
            string3 = string;
            string2 = "";
            n5 = 12;
            n4 = 0;
            if (string == null) {
                return new Font("Dialog", n4, n5);
            }
            int n7 = string.lastIndexOf(45);
            c = n7 > (n6 = string.lastIndexOf(32)) ? (char)'-' : ' ';
            n3 = string.lastIndexOf(c);
            n2 = string.lastIndexOf(c, n3 - 1);
            n = string.length();
            if (n3 > 0 && n3 + 1 < n) {
                try {
                    n5 = Integer.valueOf(string.substring(n3 + 1));
                    if (n5 <= 0) {
                        n5 = 12;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = n3;
                    n3 = n;
                    if (string.charAt(n3 - 1) != c) break block20;
                    --n3;
                }
            }
        }
        if (n2 >= 0 && n2 + 1 < n) {
            string2 = string.substring(n2 + 1, n3);
            if ((string2 = string2.toLowerCase(Locale.ENGLISH)).equals("bolditalic")) {
                n4 = 3;
            } else if (string2.equals("italic")) {
                n4 = 2;
            } else if (string2.equals("bold")) {
                n4 = 1;
            } else if (string2.equals("plain")) {
                n4 = 0;
            } else {
                n2 = n3;
                if (string.charAt(n2 - 1) == c) {
                    --n2;
                }
            }
            string3 = string.substring(0, n2);
        } else {
            int n8 = n;
            if (n2 > 0) {
                n8 = n2;
            } else if (n3 > 0) {
                n8 = n3;
            }
            if (n8 > 0 && string.charAt(n8 - 1) == c) {
                --n8;
            }
            string3 = string.substring(0, n8);
        }
        return new Font(string3, n4, n5);
    }

    public static Font getFont(String string, Font font) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            try {
                Font font = (Font)object;
                if (this.size == font.size && this.pointSize == font.pointSize && this.style == font.style && this.superscript == font.superscript && this.width == font.width && this.name.equals(font.name)) {
                    double[] dArray;
                    double[] dArray2 = this.getMatrix();
                    return dArray2[0] == (dArray = font.getMatrix())[0] && dArray2[1] == dArray[1] && dArray2[2] == dArray[2] && dArray2[3] == dArray[3] && dArray2[4] == dArray[4] && dArray2[5] == dArray[5];
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.pointSize == 0.0f) {
            this.pointSize = this.size;
        }
        this.width = 1.0f;
        this.initializeFont(this.fRequestedAttributes);
    }

    public int getNumGlyphs() {
        return this.getFont2D().getNumGlyphs();
    }

    public int getMissingGlyphCode() {
        return this.getFont2D().getMissingGlyphCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double[] getMatrix() {
        if (this.matrix != null) return this.matrix;
        double d = this.getSize2D();
        if (this.nonIdentityTx) {
            AffineTransform affineTransform = this.getTransform();
            affineTransform.scale(d, d);
            this.matrix = new double[6];
            affineTransform.getMatrix(this.matrix);
            return this.matrix;
        }
        Class<Font> clazz = Font.class;
        synchronized (Font.class) {
            double[] dArray = cachedMat;
            if (dArray == null || dArray[0] != d) {
                dArray = new double[]{d, 0.0, 0.0, d, 0.0, 0.0};
                cachedMat = dArray;
            }
            this.matrix = dArray;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.matrix;
        }
    }

    public byte getBaselineFor(char c) {
        return this.getFont2D().getBaselineFor(c);
    }

    public Map<TextAttribute, ?> getAttributes() {
        return (Map)this.getRequestedAttributes().clone();
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SIZE, TextAttribute.TRANSFORM, TextAttribute.SUPERSCRIPT, TextAttribute.WIDTH};
        return attributeArray;
    }

    public Font deriveFont(int n, float f) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyStyle(n, hashtable);
        Font.applySize(f, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(int n, AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyStyle(n, hashtable);
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(float f) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applySize(f, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(int n) {
        Hashtable hashtable = (Hashtable)this.getRequestedAttributes().clone();
        Font.applyStyle(n, hashtable);
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        if (map == null || map.size() == 0) {
            return this;
        }
        Hashtable hashtable = new Hashtable(this.getAttributes());
        AttributedCharacterIterator.Attribute[] attributeArray = this.getAvailableAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            Object obj = map.get(attributeArray[i]);
            if (obj == null) continue;
            hashtable.put((TextAttribute)attributeArray[i], obj);
        }
        return new Font(hashtable, this.createdFont, this.font2DHandle);
    }

    public boolean canDisplay(char c) {
        return this.getFont2D().canDisplay(c);
    }

    public boolean canDisplay(int n) {
        if (!Character.isValidCodePoint(n)) {
            throw new IllegalArgumentException("invalid code point: " + Integer.toHexString(n));
        }
        return this.getFont2D().canDisplay(n);
    }

    public int canDisplayUpTo(String string) {
        return this.canDisplayUpTo(new StringCharacterIterator(string), 0, string.length());
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        while (n < n2 && this.canDisplay(cArray[n])) {
            ++n;
        }
        return n == n2 ? -1 : n;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        int n3 = characterIterator.setIndex(n);
        while (characterIterator.getIndex() < n2 && this.canDisplay((char)n3)) {
            n3 = characterIterator.next();
        }
        n3 = characterIterator.getIndex();
        return n3 == n2 ? -1 : n3;
    }

    public float getItalicAngle() {
        AffineTransform affineTransform = this.isTransformed() ? this.getTransform() : identityTx;
        return this.getFont2D().getItalicAngle(this, affineTransform, false, false);
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = null;
        if (this.flmref == null || (fontLineMetrics = (FontLineMetrics)this.flmref.get()) == null || !fontLineMetrics.frc.equals(fontRenderContext)) {
            float[] fArray = new float[4];
            this.getFont2D().getFontMetrics(this, identityTx, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), fArray);
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            float f4 = 0.0f;
            if (this.superscript != 0) {
                f4 = (float)this.getTransform().getTranslateY();
                f -= f4;
                f2 += f4;
            }
            float f5 = f + f2 + f3;
            int n = 0;
            float[] fArray2 = new float[]{0.0f, (f2 / 2.0f - f) / 2.0f, -f};
            float f6 = f4 - fArray[0] / 2.5f;
            float f7 = (float)Math.log(this.pointSize / 4.0f);
            float f8 = f4 + f7 / 1.5f;
            float f9 = f7;
            float f10 = this.getItalicAngle();
            CoreMetrics coreMetrics = new CoreMetrics(f, f2, f3, f5, n, fArray2, f6, f7, f8, f9, f4, f10);
            fontLineMetrics = new FontLineMetrics(0, coreMetrics, fontRenderContext);
            this.flmref = new SoftReference<FontLineMetrics>(fontLineMetrics);
        }
        return (FontLineMetrics)fontLineMetrics.clone();
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        fontLineMetrics.numchars = string.length();
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n3 = n2 - n;
        fontLineMetrics.numchars = n3 < 0 ? 0 : n3;
        return fontLineMetrics;
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n, n2);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > cArray.length) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        boolean bl = true;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c < '\u0590' || c > '\u206f') continue;
            bl = false;
            break;
        }
        if (bl) {
            StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this, cArray, n, n2 - n, fontRenderContext);
            return ((GlyphVector)standardGlyphVector).getLogicalBounds();
        }
        String string = new String(cArray, n, n2 - n);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getDescent() + textLayout.getLeading());
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        int n3 = characterIterator.getBeginIndex();
        int n4 = characterIterator.getEndIndex();
        if (n < n3) {
            throw new IndexOutOfBoundsException("beginIndex: " + n);
        }
        if (n2 > n4) {
            throw new IndexOutOfBoundsException("limit: " + n2);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("range length: " + (n2 - n));
        }
        char[] cArray = new char[n2 - n];
        characterIterator.setIndex(n);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = characterIterator.current();
            characterIterator.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        float[] fArray = new float[4];
        this.getFont2D().getFontMetrics(this, fontRenderContext, fArray);
        return new Rectangle2D.Float(0.0f, -fArray[0], fArray[3], fArray[0] + fArray[1] + fArray[2]);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return new StandardGlyphVector(this, string, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return new StandardGlyphVector(this, cArray, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new StandardGlyphVector(this, characterIterator, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return new StandardGlyphVector(this, nArray, fontRenderContext);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        GlyphLayout glyphLayout = GlyphLayout.get(null);
        StandardGlyphVector standardGlyphVector = glyphLayout.layout(this, fontRenderContext, cArray, n, n2, n3, null);
        GlyphLayout.done(glyphLayout);
        return standardGlyphVector;
    }

    private static void applyTransform(AffineTransform affineTransform, Map map) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("transform must not be null");
        }
        if (affineTransform.isIdentity()) {
            map.remove(TextAttribute.TRANSFORM);
        } else {
            map.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
        }
    }

    private static void applyStyle(int n, Map map) {
        if ((n & 1) != 0) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            map.remove(TextAttribute.WEIGHT);
        }
        if ((n & 2) != 0) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            map.remove(TextAttribute.POSTURE);
        }
    }

    private static void applySize(float f, Map map) {
        map.put(TextAttribute.SIZE, new Float(f));
    }

    private static native void initIDs();

    private native void pDispose();

    protected void finalize() throws Throwable {
        if (this.peer != null) {
            this.pDispose();
        }
        super.finalize();
    }

    static {
        NativeLibLoader.loadLibraries();
        Font.initIDs();
        EMPTY_MAP = new Hashtable(5, 0.9f);
        IDENT_TX_ATTRIBUTE = new TransformAttribute(new AffineTransform());
        identityTx = new AffineTransform();
        cacheRef = new SoftReference(new HashMap());
        ssinfo = new float[]{0.0f, 0.375f, 0.625f, 0.7916667f, 0.9027778f, 0.9768519f, 1.0262346f, 1.0591564f};
    }

    private static class Key {
        String family = "Dialog";
        float weight = 1.0f;
        float posture = 0.0f;
        float size = 12.0f;
        int superscript = 0;
        float width = 1.0f;
        double[] txdata = null;
        Map attrs;
        int hashCode = 0;

        Key(Map map) {
            float f;
            this.attrs = map;
            Object v = map.get(TextAttribute.FAMILY);
            if (v != null) {
                this.family = (String)v;
            }
            this.hashCode = this.family.hashCode();
            v = map.get(TextAttribute.WEIGHT);
            if (v != null && v != TextAttribute.WEIGHT_REGULAR && (f = ((Float)v).floatValue()) == TextAttribute.WEIGHT_BOLD.floatValue()) {
                this.weight = f;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.weight);
            }
            if ((v = map.get(TextAttribute.POSTURE)) != null && v != TextAttribute.POSTURE_REGULAR && (f = ((Float)v).floatValue()) == TextAttribute.POSTURE_OBLIQUE.floatValue()) {
                this.posture = f;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.posture);
            }
            if ((v = map.get(TextAttribute.SIZE)) != null) {
                this.size = ((Float)v).floatValue();
                if (this.size != 12.0f) {
                    this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.size);
                }
            }
            if ((v = map.get(TextAttribute.TRANSFORM)) != null) {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = null;
                if (v instanceof TransformAttribute) {
                    TransformAttribute transformAttribute = (TransformAttribute)v;
                    if (!transformAttribute.isIdentity()) {
                        affineTransform2 = transformAttribute.getTransform();
                    }
                } else if (v instanceof AffineTransform && !(affineTransform = (AffineTransform)v).isIdentity()) {
                    affineTransform2 = affineTransform;
                }
                if (affineTransform2 != null) {
                    this.txdata = new double[6];
                    affineTransform2.getMatrix(this.txdata);
                    this.hashCode = this.hashCode << 3 ^ new Double(this.txdata[0]).hashCode();
                }
            }
            if ((v = map.get(TextAttribute.SUPERSCRIPT)) != null && v instanceof Integer) {
                this.superscript = (Integer)v;
                this.hashCode = this.hashCode << 3 ^ this.superscript;
            }
            if ((v = map.get(TextAttribute.WIDTH)) != null && v instanceof Float) {
                this.width = ((Float)v).floatValue();
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.width);
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            if (this.hashCode == key.hashCode && this.size == key.size && this.weight == key.weight && this.posture == key.posture && this.superscript == key.superscript && this.width == key.width && this.family.equals(key.family) && this.txdata == null == (key.txdata == null)) {
                if (this.txdata != null) {
                    for (int i = 0; i < this.txdata.length; ++i) {
                        if (this.txdata[i] == key.txdata[i]) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    }
}

