/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class WindowsTabbedPaneUI
extends BasicTabbedPaneUI {
    private static Set managingFocusForwardTraversalKeys;
    private static Set managingFocusBackwardTraversalKeys;
    private boolean contentOpaque = true;

    protected void installDefaults() {
        super.installDefaults();
        this.contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        if (managingFocusForwardTraversalKeys == null) {
            managingFocusForwardTraversalKeys = new TreeSet();
            managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 0));
        }
        this.tabPane.setFocusTraversalKeys(0, managingFocusForwardTraversalKeys);
        if (managingFocusBackwardTraversalKeys == null) {
            managingFocusBackwardTraversalKeys = new TreeSet();
            managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 1));
        }
        this.tabPane.setFocusTraversalKeys(1, managingFocusBackwardTraversalKeys);
    }

    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTabbedPaneUI();
    }

    protected void setRolloverTab(int n) {
        if (XPStyle.getXP() != null) {
            int n2 = this.getRolloverTab();
            super.setRolloverTab(n);
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n2 >= 0) {
                rectangle = this.getTabBounds(this.tabPane, n2);
            }
            if (n >= 0) {
                rectangle2 = this.getTabBounds(this.tabPane, n);
            }
            if (rectangle != null) {
                if (rectangle2 != null) {
                    this.tabPane.repaint(rectangle.union(rectangle2));
                } else {
                    this.tabPane.repaint(rectangle);
                }
            } else if (rectangle2 != null) {
                this.tabPane.repaint(rectangle2);
            }
        }
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        XPStyle.Skin skin;
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null && (this.contentOpaque || this.tabPane.isOpaque()) && (skin = xPStyle.getSkin("tab.pane")) != null) {
            int n3;
            Insets insets = this.tabPane.getInsets();
            Insets insets2 = UIManager.getInsets("TabbedPane.tabAreaInsets");
            int n4 = insets.left;
            int n5 = insets.top;
            int n6 = this.tabPane.getWidth() - insets.right - insets.left;
            int n7 = this.tabPane.getHeight() - insets.top - insets.bottom;
            if (n == 2 || n == 4) {
                n3 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                if (n == 2) {
                    n4 += n3 - insets2.bottom;
                }
                n6 -= n3 - insets2.bottom;
            } else {
                n3 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                if (n == 1) {
                    n5 += n3 - insets2.bottom;
                }
                n7 -= n3 - insets2.bottom;
            }
            Color color = xPStyle.getColor("tab.pane.bordercolorhint", null);
            if (color != null) {
                graphics.setColor(color);
                graphics.fillRect(n4, n5, n6, n7);
            }
            this.paintRotatedSkin(graphics, skin, n, n4, n5, n6, n7, 0);
            return;
        }
        super.paintContentBorder(graphics, n, n2);
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (XPStyle.getXP() == null) {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            String string;
            int n7 = this.tabPane.getTabCount();
            int n8 = this.getRunForTab(n7, n2);
            if (this.tabRuns[n8] == n2) {
                string = "tab.tabitemleftedge";
            } else if (n7 > 1 && this.lastTabInRun(n7, n8) == n2) {
                string = "tab.tabitemrightedge";
                if (bl) {
                    if (n == 1 || n == 3) {
                        ++n5;
                    } else {
                        ++n6;
                    }
                }
            } else {
                string = "tab.tabitem";
            }
            int n9 = 0;
            if (bl) {
                n9 = 2;
            } else if (n2 == this.getRolloverTab()) {
                n9 = 1;
            }
            this.paintRotatedSkin(graphics, xPStyle.getSkin(string), n, n3, n4, n5, n6, n9);
        } else {
            super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    private void paintRotatedSkin(Graphics graphics, XPStyle.Skin skin, int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n2, n3);
        switch (n) {
            case 4: {
                graphics2D.translate(n4, 0);
                graphics2D.rotate(Math.toRadians(90.0));
                skin.paintSkin(graphics2D, 0, 0, n5, n4, n6);
                break;
            }
            case 2: {
                graphics2D.scale(-1.0, 1.0);
                graphics2D.rotate(Math.toRadians(90.0));
                skin.paintSkin(graphics2D, 0, 0, n5, n4, n6);
                break;
            }
            case 3: {
                graphics2D.translate(0, n5);
                graphics2D.scale(-1.0, 1.0);
                graphics2D.rotate(Math.toRadians(180.0));
                skin.paintSkin(graphics2D, 0, 0, n4, n5, n6);
                break;
            }
            default: {
                skin.paintSkin(graphics2D, 0, 0, n4, n5, n6);
            }
        }
        graphics2D.dispose();
    }
}

