/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.BlueprintStyle;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.CellRendererPane;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.security.action.GetPropertyAction;
import sun.swing.plaf.synth.SynthUI;

class BlueprintEngine
extends GTKEngine
implements GTKConstants {
    private static final Object RENDERING_HINT = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.pixmap.smoothScaling"))) ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : null;
    private int COMPONENT_NORTH_WEST = 1;
    private int COMPONENT_NORTH = 2;
    private int COMPONENT_NORTH_EAST = 4;
    private int COMPONENT_WEST = 8;
    private int COMPONENT_CENTER = 16;
    private int COMPONENT_EAST = 32;
    private int COMPONENT_SOUTH_EAST = 64;
    private int COMPONENT_SOUTH = 128;
    private int COMPONENT_SOUTH_WEST = 256;
    private int COMPONENT_ALL = 512;
    private int _clipX1;
    private int _clipX2;
    private int _clipY1;
    private int _clipY2;

    BlueprintEngine() {
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("SLIDER", string, n, n2, n7, -100, -100, null))) {
            super.paintSlider(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7);
        }
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        Object object;
        SynthStyle synthStyle = synthContext.getStyle();
        Container container = synthContext.getComponent();
        if ((container = container.getParent()) instanceof JPopupMenu && (object = this.getStyle((JPopupMenu)container, ((JPopupMenu)container).getUI())) != null) {
            synthStyle = object;
        }
        if ((object = ((BlueprintStyle)synthStyle).getInfo("HLINE", string, n, -100, 0, -100, -100, null)) != null && ((BlueprintStyle.Info)object).getImage() != null) {
            this.themeBlueprintRender(synthContext, graphics, n2, n3, n4, n5, ((BlueprintStyle.Info)object).getImage(), ((BlueprintStyle.Info)object).getImageInsets(), this.COMPONENT_ALL, ((BlueprintStyle.Info)object).getStretch(), false, ((BlueprintStyle.Info)object).isBkgMask(), ((BlueprintStyle.Info)object).isRecolorable(), ((BlueprintStyle.Info)object).getColorizeColor());
        } else {
            super.paintHline(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        BlueprintStyle.Info info = ((BlueprintStyle)synthContext.getStyle()).getInfo("VLINE", string, n, -100, 1, -100, -100, null);
        if (info != null && info.getImage() != null) {
            this.themeBlueprintRender(synthContext, graphics, n2, n3, n4, n5, info.getImage(), info.getImageInsets(), this.COMPONENT_ALL, info.getStretch(), false, info.isBkgMask(), info.isRecolorable(), info.getColorizeColor());
        } else {
            super.paintVline(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        Container container = synthContext.getComponent();
        if (container.getName() == "Spinner.nextButton" || container.getName() == "Spinner.previousButton" || container.getName() == "ComboBox.arrowButton") {
            return;
        }
        String string2 = null;
        if ((container = container.getParent()) != null && container instanceof JComponent && (container = container.getParent()) != null && container instanceof JComponent) {
            string2 = this.getComponentType((JComponent)container);
        }
        if (!this.paintSimpleImage(synthContext, graphics, n4, n5, n6, n7, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("ARROW", string, n, n2, -100, -100, n3, string2))) {
            super.paintArrow(synthContext, graphics, n, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        Region region = synthContext.getRegion();
        Container container = synthContext.getComponent();
        SynthStyle synthStyle = synthContext.getStyle();
        Integer n7 = (Integer)((JComponent)container).getClientProperty("__arrow_direction__");
        if (string == "vscrollbar" || string == "hscrollbar" && n7 != null) {
            int n8 = n7;
            switch (n8) {
                case 1: {
                    n8 = 100;
                    break;
                }
                case 5: {
                    n8 = 101;
                    break;
                }
                case 3: {
                    n8 = 103;
                    break;
                }
                case 7: {
                    n8 = 102;
                }
            }
            container = (JComponent)container.getParent();
            if (container == null || !(container instanceof JComponent)) {
                return;
            }
            if (container instanceof JScrollBar) {
                SynthStyle synthStyle2 = this.getStyle((JScrollBar)container, ((JScrollBar)container).getUI());
                if (synthStyle2 != null) {
                    synthStyle = synthStyle2;
                }
                if (this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthStyle).getInfo("STEPPER", string, n, -100, -100, -100, n8, null))) {
                    return;
                }
                if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthStyle).getInfo("BOX", string, n, n2, -100, -100, -100, null))) {
                    super.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
                }
                return;
            }
        }
        if (container.getName() == "Spinner.nextButton" || container.getName() == "Spinner.previousButton" && n7 != null) {
            SynthStyle synthStyle3;
            string = n7 == 1 ? "spinbutton_up" : "spinbutton_down";
            if ((container = container.getParent()) instanceof JSpinner && (synthStyle3 = this.getStyle((JSpinner)container, ((JSpinner)container).getUI())) != null) {
                synthStyle = synthStyle3;
            }
        }
        int n9 = region == Region.SCROLL_BAR ? (((JScrollBar)container).getOrientation() == 0 ? 0 : 1) : (region == Region.SLIDER_TRACK ? (((JSlider)container).getOrientation() == 0 ? 0 : 1) : -100);
        String string2 = null;
        if (container != null && (container = container.getParent()) != null && container instanceof JComponent) {
            string2 = this.getComponentType((JComponent)container);
        }
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthStyle).getInfo("BOX", string, n, n2, n9, -100, -100, string2))) {
            super.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        BlueprintStyle.Info info = ((BlueprintStyle)synthContext.getStyle()).getInfo("BOX_GAP", string, n, n2, -100, n7, -100, null);
        if (info != null) {
            this.paintGapImage(synthContext, info, graphics, n3, n4, n5, n6, true, n7, n8, n9);
        } else {
            super.paintBoxGap(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7, n8, n9);
        }
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        if (string == "handlebox" || string == "dockitem") {
            n5 -= 2;
            --n6;
        }
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("HANDLE", string, n, n2, n7, -100, -100, null))) {
            super.paintHandle(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7);
        }
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("OPTION", string, n, n2, -100, -100, -100, null))) {
            super.paintOption(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (!this.paintSimpleImage(synthContext, graphics, n2, n3, n4, n5, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("FOCUS", string, n, -100, -100, -100, -100, null))) {
            super.paintFocus(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        JComboBox jComboBox;
        Component component;
        Container container = synthContext.getComponent();
        String string2 = null;
        SynthStyle synthStyle = synthContext.getStyle();
        if (container.getName() == "ComboBox.textField") {
            string2 = "GtkCombo";
        } else if (container.getName() == "ComboBox.renderer" && (container = container.getParent()) != null) {
            container = container.getParent();
            string2 = "GtkCombo";
        }
        if (container instanceof JComboBox && (component = (jComboBox = (JComboBox)container).getEditor().getEditorComponent()) instanceof JTextField) {
            SynthStyle synthStyle2;
            if (!jComboBox.isEditable() && component.getParent() == null) {
                jComboBox.add(component);
                jComboBox.remove(component);
            }
            if ((synthStyle2 = this.getStyle((JTextField)component, ((JTextField)component).getUI())) != null) {
                synthStyle = synthStyle2;
            }
        }
        if (string == "menu" && string2 == "GtkHBox") {
            return;
        }
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthStyle).getInfo("SHADOW", string, n, n2, -100, -100, -100, string2))) {
            super.paintShadow(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        super.paintExpander(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("CHECK", string, n, n2, -100, -100, -100, null))) {
            super.paintCheck(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintSimpleImage(synthContext, graphics, n3, n4, n5, n6, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("EXTENSION", string, n, n2, -100, n7, -100, null))) {
            super.paintExtension(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7, n8);
        }
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (string == "checkbutton" && n == 2) {
            return;
        }
        Container container = synthContext.getComponent();
        String string2 = null;
        if ((container = container.getParent()) instanceof CellRendererPane) {
            container = container.getParent();
        }
        if (container != null && container instanceof JComponent) {
            string2 = this.getComponentType((JComponent)container);
        }
        if (!this.paintSimpleImage(synthContext, graphics, n2, n3, n4, n5, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("FLAT_BOX", string, n, -100, -100, -100, -100, string2))) {
            super.paintFlatBox(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    void paintBackground(SynthContext synthContext, Graphics graphics, int n, Color color, int n2, int n3, int n4, int n5) {
        JComponent jComponent = synthContext.getComponent();
        if (jComponent instanceof JPopupMenu && this.paintSimpleImage(synthContext, graphics, n2, n3, n4, n5, true, ((BlueprintStyle)synthContext.getStyle()).getInfo("BACKGROUND", null, n, -100, -100, -100, -100, null))) {
            return;
        }
        super.paintBackground(synthContext, graphics, n, color, n2, n3, n4, n5);
    }

    private void paintGapImage(SynthContext synthContext, BlueprintStyle.Info info, Graphics graphics, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        int n8 = 0;
        int n9 = this.COMPONENT_ALL;
        Image image = info.getGapStartImage();
        Image image2 = info.getGapImage();
        Image image3 = info.getGapEndImage();
        if (!bl) {
            n9 |= this.COMPONENT_CENTER;
        }
        n8 = image != null ? (n5 == 2 || n7 == 3 ? image.getHeight(null) : image.getWidth(null)) : (n5 == 2 || n7 == 3 ? ((BlueprintStyle)synthContext.getStyle()).getYThickness() : ((BlueprintStyle)synthContext.getStyle()).getXThickness());
        if (n7 > 0) {
            switch (n5) {
                case 2: {
                    if (!bl) {
                        n9 |= this.COMPONENT_NORTH_WEST | this.COMPONENT_NORTH | this.COMPONENT_NORTH_EAST;
                    }
                    rectangle.x = n;
                    rectangle.y = n2;
                    rectangle.width = n6;
                    rectangle.height = n8;
                    rectangle2.x = n + n6;
                    rectangle2.y = n2;
                    rectangle2.width = n7;
                    rectangle2.height = n8;
                    rectangle3.x = n + n6 + n7;
                    rectangle3.y = n2;
                    rectangle3.width = n3 - (n6 + n7);
                    rectangle3.height = n8;
                    break;
                }
                case 3: {
                    if (!bl) {
                        n9 |= this.COMPONENT_SOUTH_WEST | this.COMPONENT_SOUTH | this.COMPONENT_SOUTH_EAST;
                    }
                    rectangle.x = n;
                    rectangle.y = n2 + n4 - n8;
                    rectangle.width = n6;
                    rectangle.height = n8;
                    rectangle2.x = n + n6;
                    rectangle2.y = n2 + n4 - n8;
                    rectangle2.width = n7;
                    rectangle2.height = n8;
                    rectangle3.x = n + n6 + n7;
                    rectangle3.y = n2 + n4 - n8;
                    rectangle3.width = n3 - (n6 + n7);
                    rectangle3.height = n8;
                    break;
                }
                case 0: {
                    if (!bl) {
                        n9 |= this.COMPONENT_NORTH_WEST | this.COMPONENT_WEST | this.COMPONENT_SOUTH_WEST;
                    }
                    rectangle.x = n;
                    rectangle.y = n2;
                    rectangle.width = n8;
                    rectangle.height = n6;
                    rectangle2.x = n;
                    rectangle2.y = n2 + n6;
                    rectangle2.width = n8;
                    rectangle2.height = n7;
                    rectangle3.x = n;
                    rectangle3.y = n2 + n6 + n7;
                    rectangle3.width = n8;
                    rectangle3.height = n4 - (n6 + n7);
                    break;
                }
                case 1: {
                    if (!bl) {
                        n9 |= this.COMPONENT_NORTH_EAST | this.COMPONENT_EAST | this.COMPONENT_SOUTH_EAST;
                    }
                    rectangle.x = n + n3 - n8;
                    rectangle.y = n2;
                    rectangle.width = n8;
                    rectangle.height = n6;
                    rectangle2.x = n + n3 - n8;
                    rectangle2.y = n2 + n6;
                    rectangle2.width = n8;
                    rectangle2.height = n7;
                    rectangle3.x = n + n3 - n8;
                    rectangle3.y = n2 + n6 + n7;
                    rectangle3.width = n8;
                    rectangle3.height = n4 - (n6 + n7);
                }
            }
            this.themeBlueprintRender(synthContext, graphics, n, n2, n3, n4, info.getImage(), info.getImageInsets(), n9, true, false, info.isBkgMask(), info.isRecolorable(), info.getColorizeColor());
            if (image != null) {
                this.themeBlueprintRender(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, image, info.getGapStartInsets(), this.COMPONENT_ALL, true, false, false, false, null);
            }
            if (image2 != null) {
                this.themeBlueprintRender(synthContext, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, image2, info.getGapInsets(), this.COMPONENT_ALL, true, false, false, false, null);
            }
            if (image3 != null) {
                this.themeBlueprintRender(synthContext, graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, image3, info.getGapEndInsets(), this.COMPONENT_ALL, true, false, false, false, null);
            }
        }
    }

    private boolean paintSimpleImage(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, boolean bl, BlueprintStyle.Info info) {
        if (info != null) {
            Rectangle rectangle = graphics.getClipBounds();
            this._clipX1 = rectangle.x;
            this._clipY1 = rectangle.y;
            this._clipX2 = this._clipX1 + rectangle.width;
            this._clipY2 = this._clipY1 + rectangle.height;
            this.themeBlueprintRender(synthContext, graphics, n, n2, n3, n4, info.getImage(), info.getImageInsets(), bl ? this.COMPONENT_ALL : this.COMPONENT_ALL | this.COMPONENT_CENTER, info.getStretch(), false, info.isBkgMask(), info.isRecolorable(), info.getColorizeColor());
            if (bl) {
                this.themeBlueprintRender(synthContext, graphics, n, n2, n3, n4, info.getOverlayImage(), info.getOverlayInsets(), this.COMPONENT_ALL, info.getOverlayStretch(), true, false, false, null);
            }
            return true;
        }
        return false;
    }

    private void themeBlueprintRender(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4, Image object, Insets insets, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color) {
        int n6;
        int n7;
        int n8;
        int n9;
        Object object2;
        int n10;
        Object object3;
        Object object4;
        if (object == null) {
            return;
        }
        if (insets == null) {
            insets = GTKPainter.EMPTY_INSETS;
        }
        int n11 = ((Image)object).getWidth(null);
        int n12 = ((Image)object).getHeight(null);
        if (bl3) {
            object4 = new BufferedImage(n11, n12, 2);
            object3 = ((BufferedImage)object4).createGraphics();
            n10 = 0;
            object2 = synthContext.getComponent();
            for (n9 = 0; n10 == 0 && n9 <= 2; ++n9) {
                object2 = ((Component)object2).getParent();
                if (object2 != null) {
                    Color color2 = ((Component)object2).getBackground();
                    if (color2 == null || color2.equals(color) || color2.equals(Color.black) || object2 instanceof JFileChooser) continue;
                    color = color2;
                    n10 = 1;
                    continue;
                }
                n10 = 1;
            }
            if (color == null) {
                color = ((GTKStyle)synthContext.getStyle()).getGTKColor(synthContext.getComponent(), synthContext.getRegion(), synthContext.getComponentState(), ColorType.BACKGROUND);
            }
            ((Graphics)object3).setColor(color);
            ((Graphics)object3).fillRect(0, 0, n11, n12);
            ((Graphics2D)object3).setComposite(AlphaComposite.DstIn);
            ((Graphics)object3).drawImage((Image)object, 0, 0, null);
            ((Graphics)object3).dispose();
            object = object4;
        } else if (bl4) {
            object4 = new BufferedImage(n11, n12, 2);
            object3 = ((BufferedImage)object4).createGraphics();
            ((Graphics2D)object3).setComposite(AlphaComposite.Src);
            ((Graphics)object3).drawImage((Image)object, 0, 0, null);
            ((Graphics)object3).dispose();
            n10 = color.getRed();
            n9 = color.getGreen();
            int n13 = color.getBlue();
            int n14 = color.getAlpha();
            Color color3 = this.RGBtoHLS(n10, n9, n13);
            n8 = color3.getRed();
            n7 = color3.getGreen();
            n6 = color3.getBlue();
            int[] nArray = null;
            nArray = ((BufferedImage)object4).getRaster().getPixels(0, 0, n11, n12, nArray);
            for (int i = 0; i < nArray.length; i += 4) {
                n10 = nArray[i];
                n9 = nArray[i + 1];
                n13 = nArray[i + 2];
                color3 = this.RGBtoHLS(n10, n9, n13);
                n10 = n8;
                n9 = color3.getGreen();
                n13 = n6;
                color3 = this.HLStoRGB(n10, n9, n13);
                nArray[i] = color3.getRed();
                nArray[i + 1] = color3.getGreen();
                nArray[i + 2] = color3.getBlue();
                nArray[i + 3] = Math.min(nArray[i + 3], n14);
            }
            ((BufferedImage)object4).getRaster().setPixels(0, 0, n11, n12, nArray);
            object = object4;
        }
        if (bl) {
            // empty if block
        }
        if (n11 <= 0 || n12 <= 0) {
            return;
        }
        object3 = RENDERING_HINT;
        if (object3 != null && bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            object4 = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object4 == null) {
                object4 = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object3);
        } else {
            object4 = null;
        }
        if (!bl) {
            if (bl2) {
                this.blueprintRender((Image)object, graphics, 0, 0, n11, n12, n + n3 / 2 - n11 / 2, n2 + n4 / 2 - n12 / 2, n11, n12);
            } else {
                int n15 = 0;
                int n16 = n2 + n4;
                for (n9 = n2; n9 < n16; n9 += n12 - n15) {
                    int n17 = 0;
                    n8 = n + n3;
                    for (int i = n; i < n8; i += n11 - n17) {
                        n7 = Math.min(n8, i + n11 - n17);
                        if (this.intersectsClip(i, n9, n7, n6 = Math.min(n16, n9 + n12 - n15))) {
                            graphics.drawImage((Image)object, i, n9, n7, n6, n17, n15, n17 + n7 - i, n15 + n6 - n9, null);
                        }
                        n17 = 0;
                    }
                    n15 = 0;
                }
            }
        } else {
            int[] nArray = new int[4];
            int[] nArray2 = new int[4];
            object2 = new int[4];
            int[] nArray3 = new int[4];
            nArray[0] = 0;
            nArray[1] = insets.left;
            nArray[2] = n11 - insets.right;
            nArray[3] = n11;
            nArray2[0] = 0;
            nArray2[1] = insets.top;
            nArray2[2] = n12 - insets.bottom;
            nArray2[3] = n12;
            object2[0] = n;
            object2[1] = n + insets.left;
            object2[2] = n + n3 - insets.right;
            object2[3] = n + n3;
            nArray3[0] = n2;
            nArray3[1] = n2 + insets.top;
            nArray3[2] = n2 + n4 - insets.bottom;
            nArray3[3] = n2 + n4;
            if ((n5 & this.COMPONENT_ALL) != 0) {
                n5 = this.COMPONENT_ALL - 1 & ~n5;
            }
            if ((n5 & this.COMPONENT_NORTH_WEST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[0], nArray2[0], nArray[1] - nArray[0], nArray2[1] - nArray2[0], (int)object2[0], nArray3[0], (int)(object2[1] - object2[0]), nArray3[1] - nArray3[0]);
            }
            if ((n5 & this.COMPONENT_NORTH) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[1], nArray2[0], nArray[2] - nArray[1], nArray2[1] - nArray2[0], (int)object2[1], nArray3[0], (int)(object2[2] - object2[1]), nArray3[1] - nArray3[0]);
            }
            if ((n5 & this.COMPONENT_NORTH_EAST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[2], nArray2[0], nArray[3] - nArray[2], nArray2[1] - nArray2[0], (int)object2[2], nArray3[0], (int)(object2[3] - object2[2]), nArray3[1] - nArray3[0]);
            }
            if ((n5 & this.COMPONENT_WEST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[0], nArray2[1], nArray[1] - nArray[0], nArray2[2] - nArray2[1], (int)object2[0], nArray3[1], (int)(object2[1] - object2[0]), nArray3[2] - nArray3[1]);
            }
            if ((n5 & this.COMPONENT_CENTER) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[1], nArray2[1], nArray[2] - nArray[1], nArray2[2] - nArray2[1], (int)object2[1], nArray3[1], (int)(object2[2] - object2[1]), nArray3[2] - nArray3[1]);
            }
            if ((n5 & this.COMPONENT_EAST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[2], nArray2[1], nArray[3] - nArray[2], nArray2[2] - nArray2[1], (int)object2[2], nArray3[1], (int)(object2[3] - object2[2]), nArray3[2] - nArray3[1]);
            }
            if ((n5 & this.COMPONENT_SOUTH_WEST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[0], nArray2[2], nArray[1] - nArray[0], nArray2[3] - nArray2[2], (int)object2[0], nArray3[2], (int)(object2[1] - object2[0]), nArray3[3] - nArray3[2]);
            }
            if ((n5 & this.COMPONENT_SOUTH) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[1], nArray2[2], nArray[2] - nArray[1], nArray2[3] - nArray2[2], (int)object2[1], nArray3[2], (int)(object2[2] - object2[1]), nArray3[3] - nArray3[2]);
            }
            if ((n5 & this.COMPONENT_SOUTH_EAST) != 0) {
                this.blueprintRender((Image)object, graphics, nArray[2], nArray2[2], nArray[3] - nArray[2], nArray2[3] - nArray2[2], (int)object2[2], nArray3[2], (int)(object2[3] - object2[2]), nArray3[3] - nArray3[2]);
            }
        }
        if (object4 != null) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object4);
        }
    }

    private void blueprintRender(Image image, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n7 <= 0 || n8 <= 0 || !this.intersectsClip(n5, n6, n5 + n7, n6 + n8)) {
            return;
        }
        if (n3 == 0 && n4 == 0 || n4 == 0 && n8 == n4 || n4 != 0 || n7 == n3) {
            // empty if block
        }
        graphics.drawImage(image, n5, n6, n5 + n7, n6 + n8, n, n2, n + n3, n2 + n4, null);
    }

    private boolean hasAncestorOfTypeFromList(JComponent jComponent, ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (!this.hasAncestorOfType(jComponent, (String)iterator.next())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAncestorOfType(JComponent jComponent, String string) {
        String string2 = null;
        while (jComponent != null) {
            string2 = this.getComponentType(jComponent);
            if (string2 == string) {
                return true;
            }
            if (jComponent.getParent() instanceof JComponent) {
                jComponent = (JComponent)jComponent.getParent();
                continue;
            }
            jComponent = null;
        }
        return false;
    }

    private String getComponentType(JComponent jComponent) {
        return GTKStyleFactory.gtkClassFor(SynthLookAndFeel.getRegion(jComponent));
    }

    private SynthStyle getStyle(JComponent jComponent, ComponentUI componentUI) {
        if (componentUI instanceof SynthUI) {
            SynthContext synthContext = ((SynthUI)componentUI).getContext(jComponent);
            return synthContext.getStyle();
        }
        return null;
    }

    private boolean intersectsClip(int n, int n2, int n3, int n4) {
        return !(n3 >= n && n3 <= this._clipX1 || n4 >= n2 && n4 <= this._clipY1 || this._clipX2 >= this._clipX1 && this._clipX2 <= n || this._clipY2 >= this._clipY1 && this._clipY2 <= n2);
    }

    private Color RGBtoHLS(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        if (n > n2) {
            n7 = Math.max(n, n3);
            n6 = Math.min(n2, n3);
        } else {
            n7 = Math.max(n2, n3);
            n6 = Math.min(n, n3);
        }
        int n8 = (n7 + n6) / 2;
        if (n7 == n6) {
            n5 = 0;
            n4 = 0;
        } else {
            int n9 = n7 - n6;
            n5 = n8 < 128 ? 255 * n9 / (n7 + n6) : 255 * n9 / (511 - n7 - n6);
            n4 = n == n7 ? (n2 - n3) / n9 : (n2 == n7 ? 2 + (n3 - n) / n9 : 4 + (n - n2) / n9);
            if ((n4 = (int)((double)n4 * 42.5)) < 0) {
                n4 += 255;
            } else if (n4 > 255) {
                n4 -= 255;
            }
        }
        return new Color(n4, n8, n5);
    }

    private Color HLStoRGB(int n, int n2, int n3) {
        double d = n;
        double d2 = n2;
        double d3 = n3;
        if (d3 == 0.0) {
            n = n2;
            n3 = n2;
        } else {
            double d4 = d2 < 128.0 ? d2 * (255.0 + d3) / 65025.0 : (d2 + d3 - d2 * d3 / 255.0) / 255.0;
            double d5 = d2 / 127.5 - d4;
            n = this.HLSvalue(d5, d4, d + 85.0);
            n2 = this.HLSvalue(d5, d4, d);
            n3 = this.HLSvalue(d5, d4, d - 85.0);
        }
        return new Color(n, n2, n3);
    }

    private int HLSvalue(double d, double d2, double d3) {
        if (d3 > 255.0) {
            d3 -= 255.0;
        } else if (d3 < 0.0) {
            d3 += 255.0;
        }
        double d4 = d3 < 42.5 ? d + (d2 - d) * (d3 / 42.5) : (d3 < 127.5 ? d2 : (d3 < 170.0 ? d + (d2 - d) * ((170.0 - d3) / 42.5) : d));
        return (int)(d4 * 255.0);
    }
}

