/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import java.security.DigestException;
import java.security.MessageDigestSpi;

public final class SHA
extends MessageDigestSpi
implements Cloneable {
    private static final int SHA_LENGTH = 20;
    private static final int BLOCK_LENGTH = 64;
    private int[] state = new int[6];
    private byte[] buffer;
    private int bufferIndex;
    private int bufferLeft;

    public SHA() {
        this.init();
    }

    private SHA(SHA sHA) {
        this();
        this.state = (int[])sHA.state.clone();
        this.buffer = (byte[])sHA.buffer.clone();
        this.bufferIndex = sHA.bufferIndex;
        this.bufferLeft = sHA.bufferLeft;
    }

    public Object clone() {
        SHA sHA = null;
        try {
            sHA = (SHA)super.clone();
            sHA.state = (int[])this.state.clone();
            sHA.buffer = (byte[])this.buffer.clone();
            sHA.bufferIndex = this.bufferIndex;
            sHA.bufferLeft = this.bufferLeft;
            return sHA;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return sHA;
        }
    }

    protected byte[] engineDigest() {
        byte[] byArray = new byte[20];
        this.processBuffer(this.buffer, 0, this.bufferIndex, byArray, 0);
        this.init();
        return byArray;
    }

    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        byte[] byArray2 = new byte[20];
        this.processBuffer(this.buffer, 0, this.bufferIndex, byArray2, 0);
        if (n2 < 20) {
            throw new DigestException("partial digests not returned");
        }
        if (byArray.length - n < 20) {
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(byArray2, 0, byArray, n, 20);
        this.init();
        return 20;
    }

    protected int engineGetDigestLength() {
        return 20;
    }

    protected void engineReset() {
        this.init();
    }

    protected synchronized void engineUpdate(byte by) {
        byte[] byArray = new byte[]{by};
        this.engineUpdate(byArray, 0, 1);
    }

    protected synchronized void engineUpdate(byte[] byArray, int n, int n2) {
        this.bufferLeft = 64 - this.bufferIndex;
        for (int i = 0; i < n2; i += this.bufferLeft) {
            if (this.bufferLeft <= n2 - i) {
                System.arraycopy(byArray, i + n, this.buffer, this.bufferIndex, this.bufferLeft);
                this.processBuffer(this.buffer, 0, this.buffer.length, null, 0);
                this.bufferIndex = 0;
                this.bufferLeft = 64;
                continue;
            }
            System.arraycopy(byArray, i + n, this.buffer, this.bufferIndex, n2 - i);
            this.bufferIndex += n2 - i;
            this.bufferLeft = 64 - this.bufferIndex;
            i = n2;
            break;
        }
    }

    public void init() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.state[5] = 0;
        this.buffer = new byte[64];
        this.bufferIndex = 0;
        this.bufferLeft = 64;
    }

    static void msbf(int n, byte[] byArray, int n2, int n3) {
        do {
            byArray[n2++] = (byte)(n >>> --n3 * 8);
        } while (n3 > 0);
    }

    static void msbf(long l, byte[] byArray, int n, int n2) {
        do {
            byArray[n++] = (byte)(l >>> --n2 * 8);
        } while (n2 > 0);
    }

    static long msbf(byte[] byArray, int n, int n2) {
        long l = 0L;
        do {
            l |= (long)(byArray[n++] & 0xFF) << --n2 * 8;
        } while (n2 > 0);
        return l;
    }

    void processBuffer(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = this.state[0];
        int n5 = this.state[1];
        int n6 = this.state[2];
        int n7 = this.state[3];
        int n8 = this.state[4];
        int[] nArray = new int[80];
        int n9 = n2 / 4;
        boolean bl = false;
        boolean bl2 = false;
        while (!bl) {
            int n10;
            int n11 = 0;
            while (n11 < 16 && n9 > 0) {
                nArray[n11++] = byArray[n + 3] & 0xFF | (byArray[n + 2] & 0xFF) << 8 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24;
                --n9;
                n += 4;
            }
            if (n11 < 16) {
                if (byArray2 == null) break;
                if (!bl2) {
                    n10 = n2 % 4;
                    int n12 = nArray[n11++] = n10 != 0 ? (int)SHA.msbf(byArray, n, n10) << (4 - n10) * 8 | 1 << 31 - n10 * 8 : Integer.MIN_VALUE;
                    if (n11 == 15) {
                        nArray[15] = 0;
                    }
                    bl2 = true;
                }
                if (n11 <= 14) {
                    while (n11 < 14) {
                        nArray[n11++] = 0;
                    }
                    if (this.state != null) {
                        n2 += this.state[5];
                    }
                    nArray[14] = n2 >>> 29;
                    nArray[15] = n2 << 3;
                    bl = true;
                }
                n11 = 16;
            }
            do {
                n10 = nArray[n11 - 3] ^ nArray[n11 - 8] ^ nArray[n11 - 14] ^ nArray[n11 - 16];
                nArray[n11] = n10 << 1 | n10 >>> 31;
            } while (++n11 < 80);
            int n13 = n4;
            int n14 = n5;
            int n15 = n6;
            int n16 = n7;
            int n17 = n8;
            n11 = 0;
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | ~n5 & n7) + n8 + nArray[n11] + 1518500249;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 20);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + nArray[n11] + 1859775393;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 40);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 & n6 | n5 & n7 | n6 & n7) + n8 + nArray[n11] + -1894007588;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 60);
            do {
                n10 = (n4 << 5 | n4 >>> 27) + (n5 ^ n6 ^ n7) + n8 + nArray[n11] + -899497514;
                n8 = n7;
                n7 = n6;
                n6 = n5 << 30 | n5 >>> 2;
                n5 = n4;
                n4 = n10;
            } while (++n11 < 80);
            n4 += n13;
            n5 += n14;
            n6 += n15;
            n7 += n16;
            n8 += n17;
        }
        if (byArray2 == null) {
            this.state[0] = n4;
            this.state[1] = n5;
            this.state[2] = n6;
            this.state[3] = n7;
            this.state[4] = n8;
            this.state[5] = this.state[5] + n2;
        } else {
            SHA.msbf(n4, byArray2, n3, 4);
            SHA.msbf(n5, byArray2, n3 + 4, 4);
            SHA.msbf(n6, byArray2, n3 + 8, 4);
            SHA.msbf(n7, byArray2, n3 + 12, 4);
            SHA.msbf(n8, byArray2, n3 + 16, 4);
        }
    }
}

