/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11.provider;

import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAParameters
extends AlgorithmParametersSpi {
    protected BigInteger p;
    protected BigInteger q;
    protected BigInteger g;

    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.p);
        derOutputStream2.putInteger(this.q);
        derOutputStream2.putInteger(this.g);
        derOutputStream.write((byte)48, derOutputStream2);
        return derOutputStream.toByteArray();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        try {
            Class<?> clazz2 = Class.forName("java.security.spec.DSAParameterSpec");
            if (clazz2.isAssignableFrom(clazz)) {
                return new DSAParameterSpec(this.p, this.q, this.g);
            }
            throw new InvalidParameterSpecException("Inappropriate parameter Specification");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + classNotFoundException.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.p = ((DSAParameterSpec)algorithmParameterSpec).getP();
        this.q = ((DSAParameterSpec)algorithmParameterSpec).getQ();
        this.g = ((DSAParameterSpec)algorithmParameterSpec).getG();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.getTag() != 48) {
            throw new IOException("DSA params parsing error");
        }
        derValue.getData().reset();
        this.p = derValue.getData().getInteger();
        this.q = derValue.getData().getInteger();
        this.g = derValue.getData().getInteger();
        if (derValue.getData().available() != 0) {
            throw new IOException("encoded params have " + derValue.getData().available() + " extra bytes");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return "\n\tp: " + this.p.toString() + "\n\tq: " + this.q.toString() + "\n\tg: " + this.g.toString() + "\n";
    }
}

