/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.util.PkPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.net.SocketFactory;

public class PkTcpClient
extends PkPipe {
    private final String host;
    private final int port;
    private final PkEventFormatter eventFormatter;
    private final SocketFactory socketFactory;
    private int numConns;
    private PkPool conns;

    public PkTcpClient(String host, int port, PkEventFormatter eventFormatter, int numConns) throws PkException {
        this.host = host;
        this.port = port;
        this.eventFormatter = eventFormatter;
        this.numConns = numConns;
        if (this.numConns <= 0) {
            PkException myE = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw myE;
        }
        this.socketFactory = SocketFactory.getDefault();
        this.conns = new PkPool();
        this.connect();
    }

    public PkTcpClient(String host, int port, PkEventFormatter eventFormatter, int numConns, SocketFactory socketFactory) throws PkException {
        this.host = host;
        this.port = port;
        this.eventFormatter = eventFormatter;
        this.numConns = numConns;
        if (this.numConns <= 0) {
            PkException myE = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw myE;
        }
        this.socketFactory = socketFactory;
        this.conns = new PkPool();
        this.connect();
    }

    public void finalize() throws PkException {
        this.close();
    }

    public synchronized void close() throws PkException {
        while (this.numConns > 0) {
            TcpConn c = (TcpConn)this.conns.pop();
            try {
                c.out.close();
                c.in.close();
                c.socket.close();
            }
            catch (IOException e) {
                throw new PkException(PkNLSConstants.TCPCLIENT_FAILED_CONNECTION_TO_HOST + this.host + ":" + this.port, e);
            }
            finally {
                --this.numConns;
            }
        }
    }

    public PkRepEvent doReq(PkReqEvent req) throws PkException {
        TcpConn conn = (TcpConn)this.conns.pop();
        try {
            try {
                req.write(this.eventFormatter, conn.out);
                conn.out.flush();
            }
            catch (IOException e) {
                this.connect();
                try {
                    req.write(this.eventFormatter, conn.out);
                    conn.out.flush();
                }
                catch (IOException e2) {
                    throw new PkException(PkNLSConstants.TCPCLIENT_ERROR_SENDING_REQUEST, e2);
                }
            }
            try {
                PkRepEvent e = (PkRepEvent)this.eventFormatter.readEvent(this, conn.in, req);
                return e;
            }
            catch (IOException e) {
                this.connect();
                throw new PkException(PkNLSConstants.TCPCLIENT_ERROR_RECEIVING_REPLY, e);
            }
        }
        finally {
            this.conns.push(conn);
        }
    }

    private synchronized void connect() throws PkException {
        long maxWait = new Date().getTime() + 60000L;
        boolean connectFail = true;
        if (this.numConns <= 0) {
            PkException myE = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw myE;
        }
        for (int i = 0; i < this.numConns; ++i) {
            while (connectFail) {
                try {
                    TcpConn c = new TcpConn();
                    c.socket = this.socketFactory.createSocket(this.host, this.port);
                    c.in = new BufferedInputStream(c.socket.getInputStream());
                    c.out = new BufferedOutputStream(c.socket.getOutputStream());
                    this.conns.push(c);
                    connectFail = false;
                }
                catch (IOException e) {
                    if (new Date().getTime() < maxWait) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException ee) {}
                        continue;
                    }
                    throw new PkException(PkNLSConstants.TCPCLIENT_FAILED_CONNECTION_TO_HOST + this.host + ":" + this.port, e);
                }
            }
        }
    }

    private final class TcpConn {
        private Socket socket;
        private InputStream in;
        private OutputStream out;

        private TcpConn() {
        }
    }
}

