/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.Converter;
import com.ibm.nio.cs.IBMCharsetEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class SBCS_Encoder
extends IBMCharsetEncoder {
    private final short[] index;
    private final char[] data;
    private final byte[] byteMap;
    private final int mask1;
    private final int mask2;
    private final int shift;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    protected SBCS_Encoder(Charset charset, short[] sArray, char[] cArray, byte[] byArray, int n, byte[] byArray2) {
        super(charset, 1.0f, 1.0f);
        this.index = sArray;
        this.data = cArray;
        this.byteMap = byArray;
        this.mask1 = Converter.mask1[n];
        this.mask2 = Converter.mask2[n];
        this.shift = n;
        if (byArray2 != null) {
            this.replaceWith(byArray2);
        }
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    protected SBCS_Encoder(Charset charset, short[] sArray, String string, int n, int n2, int n3) {
        this(charset, sArray, string.toCharArray(), null, n3, null);
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return true;
    }

    public boolean canEncode(char c) {
        if (this.byteMap != null) {
            byte by = this.byteMap[c];
            return by != 0 || c == '\u0000';
        }
        char c2 = this.data[this.index[c >> this.shift] + (c & this.mask2)];
        return c2 != '\u0000' || c == '\u0000';
    }

    private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n;
        char[] cArray = charBuffer.array();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        byte[] byArray = byteBuffer.array();
        int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
        int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
        CoderResult coderResult = CoderResult.UNDERFLOW;
        if (this.byteMap != null) {
            for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    coderResult = this.sgp.parse(c, cArray, n, n2) < 0 ? this.sgp.error() : this.sgp.unmappableResult();
                    break;
                }
                byte by = this.byteMap[c];
                if (by == 0 && c != '\u0000') {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = by;
            }
        } else {
            while (n < n2) {
                char c = cArray[n];
                if (Surrogate.is(c)) {
                    coderResult = this.sgp.parse(c, cArray, n, n2) < 0 ? this.sgp.error() : this.sgp.unmappableResult();
                    break;
                }
                byte by = (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                if (by == 0 && c != '\u0000') {
                    coderResult = CoderResult.unmappableForLength(1);
                    break;
                }
                if (n4 - n3 < 1) {
                    coderResult = CoderResult.OVERFLOW;
                    break;
                }
                byArray[n3++] = by;
                ++n;
            }
        }
        charBuffer.position(n - charBuffer.arrayOffset());
        byteBuffer.position(n3 - byteBuffer.arrayOffset());
        return coderResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        int n = charBuffer.position();
        try {
            while (charBuffer.hasRemaining()) {
                byte by;
                char c = charBuffer.get();
                if (Surrogate.is(c)) {
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                byte by2 = by = this.byteMap != null ? this.byteMap[c] : (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                if (by == 0 && c != '\u0000') {
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                if (!byteBuffer.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                ++n;
                byteBuffer.put(by);
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            charBuffer.position(n);
        }
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        BidiConvert bidiConvert;
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(charBuffer, UseBuffer, this.bidiParms, this.toString())) {
            int n;
            int n2;
            int n3;
            int n4 = charBuffer.remaining();
            if (n4 > byteBuffer.remaining()) {
                n4 = byteBuffer.remaining();
            }
            if (charBuffer.hasArray() && !UseBuffer) {
                char[] cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + charBuffer.position();
                n2 = n3 + n4;
                char c = cArray[n3];
                byte by = this.byteMap != null ? this.byteMap[c] : (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                boolean bl = by == 0 && c != '\u0000';
                for (n = n3 + 1; n < n2; ++n) {
                    c = cArray[n];
                    by = this.byteMap != null ? this.byteMap[c] : (byte)this.data[this.index[c >> this.shift] + (c & this.mask2)];
                    if ((by == 0 && c != '\u0000') != bl) break;
                }
                n4 = n - n3;
            } else {
                int n5 = charBuffer.position();
                n2 = n4;
                n = charBuffer.get();
                byte by = this.byteMap != null ? this.byteMap[n] : (byte)this.data[this.index[n >> this.shift] + (n & this.mask2)];
                boolean bl = by == 0 && n != 0;
                for (n3 = 1; n3 < n2; ++n3) {
                    n = charBuffer.get();
                    by = this.byteMap != null ? this.byteMap[n] : (byte)this.data[this.index[n >> this.shift] + (n & this.mask2)];
                    if ((by == 0 && n != 0) != bl) break;
                }
                charBuffer.position(n5);
                n4 = n3;
            }
            int n6 = charBuffer.limit();
            charBuffer.limit(charBuffer.position() + n4);
            CharBuffer charBuffer2 = bidiConvert.toSbcs(charBuffer, UseBuffer, this.bidiParms, this.toString());
            charBuffer.limit(n6);
            n2 = charBuffer2.position();
            CoderResult coderResult = charBuffer2.hasArray() && byteBuffer.hasArray() && !UseBuffer ? this.encodeArrayLoop(charBuffer2, byteBuffer) : this.encodeBufferLoop(charBuffer2, byteBuffer);
            n2 = charBuffer.position() + charBuffer2.position() - n2;
            charBuffer.position(n2);
            if (coderResult == CoderResult.UNDERFLOW && charBuffer.hasRemaining()) {
                coderResult = CoderResult.OVERFLOW;
            }
            return coderResult;
        }
        if (charBuffer.hasArray() && byteBuffer.hasArray() && !UseBuffer) {
            return this.encodeArrayLoop(charBuffer, byteBuffer);
        }
        return this.encodeBufferLoop(charBuffer, byteBuffer);
    }
}

