/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.io.CharToByteConverter;
import sun.nio.cs.Surrogate;

class ISO2022_Encoder
extends CharsetEncoder {
    private static final byte ISO_ESC = 27;
    private static final byte ISO_SI = 15;
    private static final byte ISO_SO = 14;
    private static final char REPLACE_CHAR = '\ufffd';
    private final byte P3 = (byte)-93;
    private final int S0Def = 1;
    private final int S1Def = 2;
    private final int S2Def = 4;
    private final int S3Def = 8;
    protected byte[] SODes;
    protected byte[] SO2Des;
    protected byte[] SS2Des = new byte[]{27, 36, 42, 72};
    protected byte[] SS3Des = new byte[]{27, 36, 43, 73};
    protected CharToByteConverter codeConverter = null;
    protected CharToByteConverter altConverter = null;
    private final Surrogate.Parser sgp = new Surrogate.Parser();
    private boolean shiftout = false;
    private int sxdefined = 0;
    private byte[] tmpbuf = new byte[8];
    private byte[] convByte = new byte[8];
    private char[] convChar = new char[2];

    ISO2022_Encoder(Charset charset, String string) {
        super(charset, 4.0f, 8.0f);
        try {
            if ("KR".equals(string)) {
                this.SODes = new byte[]{27, 36, 41, 67};
                this.codeConverter = CharToByteConverter.getConverter("KSC5601");
            } else if ("CN".equals(string) | "CN_CNS".equals(string)) {
                this.SODes = new byte[]{27, 36, 41, 71};
                this.SO2Des = new byte[]{27, 36, 41, 65};
                this.codeConverter = CharToByteConverter.getConverter("EUC-TW");
                this.altConverter = CharToByteConverter.getConverter("GB2312");
            } else if ("CN_GB".equals(string)) {
                this.SODes = new byte[]{27, 36, 41, 65};
                this.SO2Des = new byte[]{27, 36, 41, 71};
                this.codeConverter = CharToByteConverter.getConverter("GB2312");
                this.altConverter = CharToByteConverter.getConverter("EUC-TW");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isLegalReplacement(byte[] byArray) {
        return byArray.length == 1 && byArray[0] >= 0 && byArray[0] <= 127;
    }

    private CoderResult setForReplacement(CoderResult coderResult, ByteBuffer byteBuffer) {
        if (this.shiftout) {
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
            this.shiftout = false;
        }
        return coderResult;
    }

    public boolean canEncode(char c) {
        if (c < '\u0080') {
            return true;
        }
        if (this.codeConverter != null && this.codeConverter.canConvert(c)) {
            return true;
        }
        return this.altConverter != null && this.altConverter.canConvert(c);
    }

    protected void implReset() {
        this.shiftout = false;
        this.sxdefined = 0;
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        if (this.shiftout) {
            if (!byteBuffer.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byteBuffer.put((byte)15);
            this.shiftout = false;
        }
        return CoderResult.UNDERFLOW;
    }

    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        boolean bl = this.shiftout;
        int n = this.sxdefined;
        while (charBuffer.hasRemaining()) {
            int n2;
            int n3;
            byte[] byArray = this.tmpbuf;
            int n4 = charBuffer.position();
            char c = charBuffer.get();
            if (Surrogate.is(c) && this.sgp.parse(c, charBuffer) < 0) {
                charBuffer.position(n4);
                return this.setForReplacement(this.sgp.error(), byteBuffer);
            }
            if (c < '\u0080') {
                if (!this.shiftout) {
                    n3 = 1;
                    byArray[0] = (byte)(c & 0x7F);
                } else {
                    bl = false;
                    n3 = 2;
                    byArray[0] = 15;
                    byArray[1] = (byte)(c & 0x7F);
                }
                if (c == '\n') {
                    n = 0;
                }
            } else {
                n2 = 0;
                int n5 = 0;
                this.convChar[0] = c;
                try {
                    this.codeConverter.reset();
                    n5 = this.codeConverter.convert(this.convChar, 0, 1, this.convByte, 0, 8);
                    if (n5 == 1 && this.convByte[0] == 63 && this.altConverter != null) {
                        this.altConverter.reset();
                        n5 = this.altConverter.convert(this.convChar, 0, 1, this.convByte, 0, 8);
                        if (n5 == 2) {
                            n5 = 1;
                            n = 2;
                            System.arraycopy(this.SO2Des, 0, byArray, 0, this.SO2Des.length);
                            n2 = this.SO2Des.length;
                            if (!this.shiftout) {
                                bl = true;
                                byArray[n2++] = 14;
                            }
                            byArray[n2++] = (byte)(this.convByte[0] & 0x7F);
                            byArray[n2++] = (byte)(this.convByte[1] & 0x7F);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n5 == 2) {
                    if ((this.sxdefined & 1) == 0) {
                        n = 1;
                        System.arraycopy(this.SODes, 0, byArray, 0, this.SODes.length);
                        n2 = this.SODes.length;
                    }
                    if (!this.shiftout) {
                        bl = true;
                        byArray[n2++] = 14;
                    }
                    byArray[n2++] = (byte)(this.convByte[0] & 0x7F);
                    byArray[n2++] = (byte)(this.convByte[1] & 0x7F);
                } else if (n5 == 4) {
                    if (this.convByte[0] == -114 && this.convByte[1] == -94) {
                        if ((this.sxdefined & 4) == 0) {
                            n |= 4;
                            System.arraycopy(this.SS2Des, 0, byArray, 0, this.SS2Des.length);
                            n2 = this.SS2Des.length;
                        }
                        byArray[n2++] = 27;
                        byArray[n2++] = 78;
                        byArray[n2++] = (byte)(this.convByte[2] & 0x7F);
                        byArray[n2++] = (byte)(this.convByte[3] & 0x7F);
                    }
                    if (this.convByte[0] == -114 && this.convByte[1] == -93) {
                        if ((this.sxdefined & 8) == 0) {
                            n |= 8;
                            System.arraycopy(this.SS3Des, 0, byArray, 0, this.SS3Des.length);
                            n2 = this.SS3Des.length;
                        }
                        byArray[n2++] = 27;
                        byArray[n2++] = 79;
                        byArray[n2++] = (byte)(this.convByte[2] & 0x7F);
                        byArray[n2++] = (byte)(this.convByte[3] & 0x7F);
                    }
                }
                n3 = n2;
            }
            if (n3 == 0) {
                charBuffer.position(n4);
                return this.setForReplacement(CoderResult.unmappableForLength(1), byteBuffer);
            }
            if (byteBuffer.remaining() < n3) {
                charBuffer.position(n4);
                return CoderResult.OVERFLOW;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                byteBuffer.put(byArray[n2]);
            }
            this.shiftout = bl;
            this.sxdefined = n;
        }
        return CoderResult.UNDERFLOW;
    }
}

