/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

final class LSResourceResolverAdapter
implements EntityResolver2 {
    private static final String XML_TYPE = "http://www.w3.org/TR/REC-xml";
    protected LSResourceResolver fEntityResolver;

    public LSResourceResolverAdapter() {
    }

    public LSResourceResolverAdapter(LSResourceResolver lSResourceResolver) {
        this.setEntityResolver(lSResourceResolver);
    }

    public void setEntityResolver(LSResourceResolver lSResourceResolver) {
        this.fEntityResolver = lSResourceResolver;
    }

    public LSResourceResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        return null;
    }

    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        LSInput lSInput;
        if (this.fEntityResolver != null && (lSInput = this.fEntityResolver.resolveResource(XML_TYPE, null, string2, string4, string3)) != null) {
            String string5 = lSInput.getPublicId();
            String string6 = lSInput.getSystemId();
            String string7 = lSInput.getBaseURI();
            Reader reader = lSInput.getCharacterStream();
            InputStream inputStream = lSInput.getByteStream();
            String string8 = lSInput.getStringData();
            String string9 = lSInput.getEncoding();
            InputSource inputSource = new InputSource();
            inputSource.setPublicId(string5);
            inputSource.setSystemId(string7 != null ? this.resolveSystemId(string4, string7) : string4);
            if (reader != null) {
                inputSource.setCharacterStream(reader);
            } else if (inputStream != null) {
                inputSource.setByteStream(inputStream);
            } else if (string8 != null && string8.length() != 0) {
                inputSource.setCharacterStream(new StringReader(string8));
            }
            inputSource.setEncoding(string9);
            return inputSource;
        }
        return null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.resolveEntity(null, string, null, string2);
    }

    private String resolveSystemId(String string, String string2) {
        try {
            return XMLEntityManager.expandSystemId(string, string2, false);
        }
        catch (URI.MalformedURIException malformedURIException) {
            return string;
        }
    }
}

