/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.b2b.scan.utf16;

import com.ibm.xml.b2b.scan.DocumentEntityState;
import com.ibm.xml.b2b.scan.MarkupDeclHandler;
import com.ibm.xml.b2b.scan.utf16.UTF16WFCDocumentScannerSupport;
import com.ibm.xml.b2b.util.ErrorReporter;
import com.ibm.xml.b2b.util.QName;
import com.ibm.xml.b2b.util.SymbolTable;
import com.ibm.xml.b2b.util.XMLName;
import com.ibm.xml.b2b.util.XMLString;
import com.ibm.xml.b2b.util.XMLStringBuffer;
import com.ibm.xml.b2b.util.entity.ParsedEntity;

public final class UTF16WFCScannerSupport
extends UTF16WFCDocumentScannerSupport {
    private QName fCurrentElementType = new QName();
    private QName fCurrentAttributeName = new QName();
    private int fEntityDepth;
    private static final char[] fgNOTATION = new char[]{'N', 'O', 'T', 'A', 'T', 'I', 'O', 'N'};
    private static final byte[] pubidCharMap = new byte[]{4, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3};

    public UTF16WFCScannerSupport(SymbolTable symbolTable, XMLStringBuffer xMLStringBuffer, ErrorReporter errorReporter) {
        super(symbolTable, xMLStringBuffer, errorReporter);
    }

    public void reset(boolean bl) {
        super.reset(bl);
        this.fCurrentElementType.clear();
        this.fCurrentAttributeName.clear();
        this.fEntityDepth = 0;
    }

    public boolean entityReferenceInDefaultAttValue(MarkupDeclHandler markupDeclHandler, XMLName xMLName) {
        ++this.fEntityDepth;
        if (!markupDeclHandler.entityReferenceInDefaultAttValue(xMLName)) {
            return false;
        }
        --this.fEntityDepth;
        return true;
    }

    public void startDefaultAttValue(QName qName, QName qName2) {
        this.fCurrentElementType.setValues(qName);
        this.fCurrentAttributeName.setValues(qName2);
    }

    public void setAttValueErrorParameters() {
        this.setParameter(0, this.fCurrentElementType);
        this.setParameter(1, this.fCurrentAttributeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int scanNmtoken(ParsedEntity parsedEntity, XMLString xMLString) {
        byte by;
        int n;
        byte[] byArray = DocumentEntityState.nameCharMap;
        char[] cArray = parsedEntity.chars;
        xMLString.offset = n = parsedEntity.offset;
        char c = cArray[n];
        if (c < '\u0080') {
            by = byArray[c];
            if ((by & 2) == 0 && by != 4) return 0;
            ++n;
        } else {
            if (!parsedEntity.skipNameCharacter()) return 0;
            n = parsedEntity.offset;
        }
        while (true) {
            if ((c = cArray[n]) < '\u0080') {
                by = byArray[c];
                if ((by & 2) != 0 || by == 4) {
                    ++n;
                    continue;
                }
                xMLString.endOffset = n;
                parsedEntity.offset = n;
                return by >> 2;
            }
            parsedEntity.offset = n;
            if (!parsedEntity.skipNameCharacter()) break;
            n = parsedEntity.offset;
        }
        xMLString.endOffset = n;
        return 2;
    }

    public boolean scanPublicID(ParsedEntity parsedEntity, int n, XMLString xMLString) {
        int n2;
        char[] cArray = parsedEntity.chars;
        xMLString.offset = n2 = parsedEntity.offset;
        char c = cArray[n2];
        block6: while (c < '\u0080') {
            switch (pubidCharMap[c]) {
                case 1: {
                    c = cArray[++n2];
                    continue block6;
                }
                case 2: {
                    if (c == n) {
                        xMLString.endOffset = n2;
                        parsedEntity.offset = n2 + 1;
                        return true;
                    }
                    if (c == '\'') {
                        c = cArray[++n2];
                        continue block6;
                    }
                }
                case 3: {
                    parsedEntity.offset = n2;
                    this.setInvalidCharParameter(0, parsedEntity);
                    this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 12);
                    return false;
                }
                case 4: {
                    if (n2 != parsedEntity.endOffset) break;
                    this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 11);
                    return false;
                }
            }
            parsedEntity.offset = n2;
            this.setInvalidCharParameter(0, parsedEntity);
            this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 3);
            return false;
        }
        parsedEntity.offset = n2;
        this.setInvalidCharParameter(0, parsedEntity);
        if (parsedEntity.skipValidCharacter()) {
            this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 12);
            return false;
        }
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 3);
        return false;
    }

    public boolean scanSystemID(ParsedEntity parsedEntity, int n, XMLString xMLString) {
        byte[] byArray = DocumentEntityState.attValueMap;
        char[] cArray = parsedEntity.chars;
        int n2 = parsedEntity.offset;
        boolean bl = false;
        xMLString.offset = n2;
        char c = cArray[n2];
        block6: while (true) {
            if (c < '\u0080') {
                switch (byArray[c]) {
                    case 1: {
                        if (c == '#') {
                            bl = true;
                        }
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        c = cArray[++n2];
                        continue block6;
                    }
                    case 4: {
                        if (c == n) {
                            xMLString.endOffset = n2;
                            parsedEntity.offset = n2 + 1;
                            if (bl) {
                                this.setParameter(0, xMLString);
                                this.reportRecoverableError("http://www.w3.org/TR/2000/REC-xml-20001006", 63);
                            }
                            return true;
                        }
                        c = cArray[++n2];
                        continue block6;
                    }
                    case 5: {
                        if (n2 != parsedEntity.endOffset) break;
                        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 9);
                        return false;
                    }
                }
                parsedEntity.offset = n2;
                this.setInvalidCharParameter(0, parsedEntity);
                this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 2);
                return false;
            }
            parsedEntity.offset = n2;
            if (!parsedEntity.skipValidCharacter()) break;
            n2 = parsedEntity.offset;
            c = cArray[n2];
        }
        this.setInvalidCharParameter(0, parsedEntity);
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 2);
        return false;
    }

    public boolean scanPEReference(ParsedEntity parsedEntity, XMLName xMLName) {
        int n = this.scanName(parsedEntity, xMLName);
        if (n == 7) {
            ++parsedEntity.offset;
            return true;
        }
        if (n == 0) {
            this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 48);
            return false;
        }
        this.setParameter(0, xMLName);
        this.reportFatalError("http://www.w3.org/TR/2000/REC-xml-20001006", 49);
        return false;
    }

    public boolean isNotationType(XMLString xMLString) {
        int n = xMLString.offset;
        int n2 = xMLString.endOffset;
        if (n + 8 == n2) {
            char[] cArray = xMLString.chars;
            int n3 = 0;
            while (n < n2) {
                if (cArray[n++] == fgNOTATION[n3++]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

