/*
 * @(#)src/tools/sov/java.h, tool, asdev, 20060428 1.20
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */


/*
 *
 * Change activity:
 *
 * Reason  Date   Origin   Description
 * ------  ----   ------   ----------------------------------------------------
 * 073964  010604 seb      Make jvmset a standard part of the build
 * 082771  100205 cwhite   Remove Shiraz code
 * 088699  130505 kaaruna  Upgrade to 5.0 launcher
 * 076310  210705 bygravec Remove J9J2SE ifdefs
 */







#ifndef _JAVA_H_
#define _JAVA_H_

/*
 * Get system specific defines.
 */
#include "jni.h"
#include "java_md.h"

/*
 * function types used for InvocationFunctions data type below.
 * ibm.91
 */
typedef jint (JNICALL *inv_func_create_t)(JavaVM **pvm, void **env, void *args);
typedef jint (JNICALL *inv_func_getargs_t)(void *args);
typedef jint (JNICALL *inv_func_getXUsage_t)(char *exename);   /*ibm@71326*/

/*
 * Pointers to the needed JNI invocation API, initialized by LoadJavaVM.
 */
typedef struct {
    inv_func_create_t CreateJavaVM;                     /* ibm.91 */
    inv_func_getargs_t GetDefaultJavaVMInitArgs;        /* ibm.91 */
    inv_func_getXUsage_t GetXUsage;                     /*ibm@76310*/
} InvocationFunctions;

/*ibm@9648*/
#ifndef SetInternalLinkage
#define SetInternalLinkage()
#endif

/*
 * Message functions from java.c
 */
//ibm.41302   begin
int AddOption(char *str, void *info);                   /*ibm@73964*/
void *   MemAlloc(size_t size);
void     MemFree(void * mem);
jchar *  c2jc(char * str);
jchar *  js2jc(JNIEnv * env, jstring jstr);
jchar *  subMessage(jchar * msg, jchar * rep1, jchar * rep2, jint * lenp);
jchar *  getMessage(char * name);
jboolean showMessage(FILE * f, char * name, jchar * rep1,
                            jchar * rep2, int reterr);
//ibm.41302   end

/* ibm@88699
 * Report an error message to stderr or a window as appropriate.  The
 * flag always is set to JNI_TRUE if message is to be reported to both
 * strerr and windows and set to JNI_FALSE if the message should only
 * be sent to a window.
 */
void ReportErrorMessage(char * message, jboolean always);
void ReportErrorMessage2(char * format, char * string, jboolean always);

/* ibm@88699
 * Report an exception which terminates the vm to stderr or a window
 * as appropriate.
 */
void ReportExceptionDescription(JNIEnv * env);				
jboolean RemovableMachineDependentOption(char * option);		/*ibm@88699*/
void PrintMachineDependentOptions();							/*ibm@88699*/


/*
 * Protoypes for launcher functions in the system specific java_md.c.
 */
jboolean LoadJavaVM(char *jvmtype, InvocationFunctions *ifn);
void GetXUsagePath(char *buf, jint bufsize);
jboolean GetApplicationHome(char *buf, jint bufsize);
void ExpandCommandLineArgs(void);                                   /*ibm@1369*/

//ibm.41302   begin
char * PlatformName(char * in, char * * cpath);
char * GetMessageFile(char *buf, int bufsize);
void ShowUnicode(FILE * f, jchar * str, int len);
//ibm.41302   end


/*
 * Make launcher spit debug output.
 */
extern jboolean _launcher_debug;									/*ibm@88699*/

#endif /* _JAVA_H_ */
