/*
 * @(#)src/tools/sov/java.c, tool, asdev, 20060428 1.83.1.23
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */


/*
 *
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 005558  150300 hdece:  Missing -showversion
 * 011412  310500 hdngmr  Fixed PrintJavaVersion() (calls sun.misc.Version.print)
 * 011978  010600 hdtdg   Get jarfile name in platform encoding
 * 009648  110800 addeb   OS/2 Provide JNI compatibility for 1.1.x EXEs
 * 004561  310800 fgp     Javadump changes
 * 031774  300401 hdece   Not supporting either -hotspot or -server
 * 024586  130601 corbin  Command line options not in Javacore
 * 033260  150601 hdtdg   24586 causes LE heap damage on OS/390
 * 033224  190601 corbin  Tidy up comments
 * 033468  210601 hdpsm   Type mismatch causes 64bit compiler warnings
 * 035562  040901 hdajc   Command line arguments broken when file.encoding is ascii
 * 035768  120901 kwb     Back out change from defect 35562
 * 034732  141101 sripathi Made 'main' call '_exit' for Linux.
 * 39014.1 070102 nrichard Enable mtrace diagnostics
 * 39353.1 170102 dwc     Command line args incorrectly translated
 * 41302   070302 kwb     Globalization support
 * 41953   150302 kwb     Cleanup of warnings and error handling
 * 42279   270302 corbin  Change setclasspth to not add a separator
 * 42088   020402 kwb     Fix trap in vfprintf
 * 42647   120402 kwb     Fix another trap in vfprintf
 * 42804   180402 kennard Wrong arguments supplied to showMessage cannot load class
 * 42847   180402 kwb     Turn off vfprintf hook at end of init
 * 42986   210402 bygravec Change definition of peekArg for linux 390
 * 43108   250402 kwb     Allow -version and -showversion with JAVA_ARGS
 * 50616   060502 kwb     Allow -Djava.class.path to override -cp
 * 50678   090502 kennard Attempt to free illegal address
 * 52259   200602 kwb     Allow "\ " in properties files
 * 54079.1 130802 hdkpc   Unable to set -Xnoargsconversion by environment variable
 * 55366   291002 pratunga To initialize the variable rc in j_vfprintf
 * 57338.1 100103 pratunga To remove the redundant code
 * 57633   130103 kiranram Changed stderr to stdout while getting fullversion
 * 57595   200103 belldav Change #if defined for peekArgs for debugging to work on ppc32
 * 57762   200103 r1msrini Reverted back the changes done in 57633
 * 58160   200203 mpartrid SVT:BlueJ Application hangs, -classic option not recognised
 * 57204   150103 websterm Sidecar launcher
 * 59678   260303 mpartrid Listed java command line options not recognised
 * 60272   100404 pratunga -J-classpath option fails for rmic command
 * 61690   020603 pratunga To make -Xdebug and -Xj9 options work for z/OS
 * 61974   100603 hardillb Fix the parsing of the -Xdebug/-debug options
 * 61373.1 120603 kiranram Allow use of -Xj9 without requiring -Xdebug
 * 62225   170603 hardillb refix for 61974
 * 61542.1 300603 pratunga Modified the fix of 34732 for j9
 * 62955   170703 vijayg    Classes from the current directory are incorrectly loaded
 * 62796   180703 sgawande Running with -Xdebug prints argv, argc info
 * 63819.1 260803 andyt    LE Heap corruption using DBCS chars on command line
 * 64410   160903 andyt    moved setting of java.execsuffix from InitializeJVM
 *                         to ciCreateJVM
 * 064541  220903 cwhite   Fix 64bit warnings
 * 064806  061003 cwhite   Test for -classic before initMain2
 * 064915  031103 pratunga Launcher changes for j9 releases
 * 065848  161103 pratunga Check for J9J2SE flag to identify j9 builds
 * 064618  011203 dineeno  Getting rid of extra -Xdebug output
 * 064360  050304 pratunga launch j9 VM with -J-Xj9 option on sidecar builds
 * 065167  300304 pratunga Produce correct -X usage text for J9
 * 067741  010404 mbluemel PD Build - support -Xpd
 * 073964  020604 seb      Make jvmset a standard part of the build
 * 071326  230604 pratunga Produce correct -X usage text for J9
 * 075655  120704 pratunga -Xj9 should not be recognized by non-sidecar builds
 * 075991  180704 pratunga backout changes of 75655
 * 072836  160804 preece   Default . if classpath empty ( and not jar )
 * 082771  080205 cwhite   Remove Shiraz code
 * 088699  130505 kaaruna  Upgrade to 5.0 launcher
 * 088830  060605 andyt    JCK:tableswitch00410m1 throws failed  to reject invalid class
 * 088767  140605 andyt    java executive triggers JNI warnings
 * 076310  210705 bygravec Remove J9J2SE ifdefs
 * 093101  260705 bygravec Check for exceptions on JNI calls in GetMainClassName
 * 093382  230805 bygravec Missing call to EnsureLocalCapacity in NewPlatformString
 * 096837  181005 cwhite   DefaultUncaughtException handler not honoured for main thread
 * 096927.1201005 cwhite   java: classpath not ignored with -jar option
 * 097111  241005 bygravec make above fix specific to jars
 * 097000  251005  cwhite  remove stray ret = 0
 * 099356.1100106 jenningm Non-zero return codes should ABEND TCB on z/OS for MQ
 * 100997.1020306 jenningm Flush the stdout buffer before abending (fix to 99356.1)
 * 102209  200406 andyt    Vanilla Java doesn't shutdown correctly.
 *
 * ===========================================================================
 * Module Information:
 *
 * DESCRIPTION: Shared source for 'java' command line tool.
 *
 * If JAVA_ARGS is defined, then acts as a launcher for applications. For
 * instance, the JDK command line tools such as javac and javadoc (see
 * makefiles for more details) are built with this program.  Any arguments
 * prefixed with '-J' will be passed directly to the 'java' command.
 *
 * ===========================================================================
 */
#if !defined(lint)
#include <oco_header.h>
static char sccsid[] = "@(#)src/tools/sov/java.c, tool, asdev, 20060428 1.83.1.23";   /* CMVC and SCCS what string */
static char oco_header[] = OCO_HEADER; /* IBM copyright for object code */
#endif /* !lint */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <jni.h>
#include "java.h"
#include "manifest_info.h"										/*ibm@88699*/
#include "version_comp.h"										/*ibm@88699*/

#if defined(IBM_GNUMALLOC)                                      /*ibm@39014.1*/
#include <mcheck.h>                                             /*ibm@39014.1*/
#endif /* +IBM_GNUMALLOC */                                     /*ibm@39014.1*/

/* ibm@99356.1 begin */
#ifdef IBM_MVS
#ifdef _LP64
#include <ctest.h>
#else
#include <leawi.h>
#endif
#endif
/* ibm@99356.1 end */

#ifndef FULL_VERSION
#define FULL_VERSION "1.4"                              /*ibm@5558*/
#endif

#ifndef OSVERSION
#define OSVERSION "0"
#endif

#define AE_PLATFORM 0
#define AE_ESCAPE   1
#define AE_LATIN    2
#define AE_UTF8     3

/* ibm@88699 start
 * The following environment variable is used to influence the behavior
 * of the jre exec'd through the SelectVersion routine.  The command line
 * options which specify the version are not passed to the exec'd version,
 * because that jre may be an older version which wouldn't recognize them.
 * This environment variable is known to this (and later) version and serves
 * to suppress the version selection code.  This is not only for efficiency,
 * but also for correctness, since any command line options have been
 * removed which would cause any value found in the manifest to be used.
 * This would be incorrect because the command line options are defined
 * to take precedence.
 *
 * The value associated with this environment variable is the MainClass
 * name from within the executable jar file (if any). This is strictly a
 * performance enhancement to avoid re-reading the jar file manifest.
 *
 * ibm@88699 end */

#define ENV_ENTRY "_JAVA_VERSION_SET"						/*ibm@88699*/

static char      osVersion[] = OSVERSION;                    /*ibm@409*/

static jboolean  printVersion = JNI_FALSE;               /*print and exit*/
static jboolean  showVersion = JNI_FALSE;                /*ibm@5558 print but continue*/
static char *    progname;
       jboolean  _launcher_debug = JNI_FALSE;						 /*ibm@88699*/
static jclass    StringCls = 0;                                      //ibm.41302
static jmethodID newStringB  = 0;                                    //ibm.41302
static jmethodID newStringBE = 0;                                    //ibm.41302
static int       VerboseOutput = 0;                                  //ibm.41302
static int       ArgEncoding = AE_PLATFORM;                          //ibm.41302
static int       badMsgCount = 0;                                    //ibm.41302
static char    * cpath1 = NULL;                                      //ibm.41302
static char    * cpath2 = NULL;                                      //ibm.41302
static int       disablePrintfHook = 0;                              //ibm.41302
static InvocationFunctions ifn;                                      /*ibm@71326*/
jboolean  pdBuild = JNI_FALSE;                                       /*ibm@67741*//*ibm@73964*/

/*
 * List of VM options to be specified when the VM is created.
 */
static JavaVMOption *options;
static int numOptions, maxOptions;

/*
 * Prototypes for functions internal to launcher.
 */
static void SetClassPath(char * s1, char * s2);
static void SelectVersion(int argc, char **argv, char **main_class);		/*ibm@88699*/
static jboolean ParseArguments(int *pargc, char ***pargv, char **pjarfile,
                               char **pclassname, int *pret);
static jboolean InitializeJVM(JavaVM **pvm, JNIEnv **penv);          /*ibm@71326*/
static jobjectArray NewPlatformStringArray(JNIEnv *env, char **strv, int strc);
//ibm.41302   begin
static void DefaultArguments(char * opt);
static jstring NewPlatformString(JNIEnv *env, char * s, int encoding);
static jclass LoadClass(JNIEnv *env, char *name, int convert);
static jstring GetMainClassName(JNIEnv *env, jstring jarname, int * where);
static jstring NewEncodedString(JNIEnv *env, char *s, char * encoding);
static jstring NewEscapeString(JNIEnv *env, jstring str);
static int jcharlen(jchar * str);
jint JNICALL j_vfprintf (FILE * f, const char * tmp, va_list args);
//ibm.41302   end

#ifdef JAVA_ARGS
static void TranslateDashJArgs(int *pargc, char ***pargv);
static jboolean AddApplicationOptions(void);
#endif

static void PrintJavaVersion(JNIEnv *env);
static void PrintUsage(void);
static jint PrintXUsage(void);
static jint PrintJ9XUsage(void);                                     /*ibm@76310*/

static char * jarerror [4];

/**************************************************************************
 * name         - main
 * description  - Entry point.
 * parameters   - argc  Count of command line arguments in argv
 *                argv  Array of char* holding command line parameters.
 * returns      - int status code (0=run successfully, 1=failure)
 **************************************************************************/
int
main(int argc, char **argv)
{
    JavaVM *vm = 0;
    JNIEnv *env = 0;
    char *jarfile = 0;
    char *classname = 0;
    char *s = 0;
    jclass mainClass;
    jmethodID mainID;
    jobjectArray mainArgs;
    int ret;
    char *jvmtype = 0;
    jboolean jvmspecified = JNI_FALSE;     /* Assume no option specified. */ /*ibm@58160*/
    jlong start, end;
    char *commandLine;                              /*ibm@24586*/
    int   i;                                        /*ibm@24586*/
    int   commandLineLength;                        /*ibm@33468*/
    int    saveargc = argc;                         //ibm.41302
    char * * saveargv = argv;                       //ibm.41302
    jstring mainClassName = 0;                      //ibm.41953
    char *prevArg = 0;                              /*ibm@61974*/
    char *main_class = NULL;						/*ibm@88699*/
    
    /*ibm@39014.1 start*/
#if defined(IBM_GNUMALLOC)
    /*
     * The mtrace facility is enabled if IBM_MALLOCTRACE and MALLOC_TRACE
     * are both set.
     * See: http://www.gnu.org/manual/glibc-2.2.3/html_node/libc_37.html
     */
    if (getenv("IBM_MALLOCTRACE") != NULL) {
        mtrace();
    }
#endif /* +IBM_GNUMALLOC */

    /* Commandline arguments need to be converted to ASCII 
     * before processing.This function is only for z/OS and 
     * does nothing on other platforms.
     */
    /*ibm@61690*/
    InitMain1(argc, argv, jvmtype);

    /*ibm@39014.1 end*/

     /* ibm@61974
      *  We need to stop searching the command line for -Xj9 when we get
	  *  to the jar file or the class name, so we do not parse the application
	  *  args for these options.
      */
      
     prevArg = "java";
     
    /*ibm@67741 - check for -Xpd*/
    for (i = 1; i < argc; i++) {
        if (argv[i][0] != '-'){
            if (strcmp(prevArg,"-cp") == 0 || strcmp(prevArg,"-classpath") == 0)
            {
                /* This is the classpath so no need to continue this iteration */
                prevArg = argv[i];
                continue;
            }
            /* Reached the jar file or the class name, time to stop looking*/
            break;
        }

        prevArg = argv[i];
        /*ibm@61974 end*/

        if (strcmp(argv[i], "-Xpd") == 0) {
            pdBuild = JNI_TRUE;
        }
#if defined(JAVA_ARGS)
        /* Command line tools should be able to launch PD Build VM */
        else if (strcmp(argv[i], "-J-Xpd") == 0) {
            pdBuild = JNI_TRUE;
        }
#endif
    }

    /*ibm@76310..*/
    if (pdBuild) {
        PrintUsage();
        goto leave;
    }
    /*ibm@67741 end*/

    jvmtype = "j9vm";
    /*..ibm@76310*/

    /*
     * This function does nothing on Windows, but is used on Unix to
     * make sure the libraries are loaded correctly (no back level
     * shared objects will be used).  To find the libararies, we need
     * to know which jvm we are loading, so we pass that here.
     */
    /*ibm@61690*/
    InitMain2(argc, argv, jvmtype);                                   //ibm.41302

    /*
     * Determine if we are in debug mode
     */
    if (getenv("_JAVA_LAUNCHER_DEBUG") != 0) {
        _launcher_debug = JNI_TRUE;									/*ibm@88699*/
        printf("----_JAVA_LAUNCHER_DEBUG----\n");
    }

    /* ibm@88699 start 
     * Make sure the specified version of the JRE is running.
     *
     * There are three things to note about the SelectVersion() routine:
     *	1) If the version running isn't correct, this routine doesn't
     *	   return (either the correct version has been exec'd or an error
     *	   was issued).
     *  2) Argc and Argv in this scope are *not* altered by this routine.
     *	   It is the responsibility of subsequent code to ignore the
     *	   arguments handled by this routine.
     *  3) As a side-effect, the variable "main_class" is guaranteed to
     *     be set (if it should ever be set).  This isn't exactly the
     *	   poster child for structured programming, but it is a small
     *	   price to pay for not processing a jar file operand twice.
     *	   (Note: This side effect has been disabled.  See comment on
     *	   bugid 5030265 below.)
     *  ibm@88699 end */
    SelectVersion(argc, argv, &main_class);						/*ibm@88699*/


    // ibm@24586 ibm@33224 start
    /*
     *  Remember the command line from the user.  This is used in
     *  the javacore when something goes wrong.
     */
    commandLineLength=0;
    for(i=0; i<argc; i++) {
        commandLineLength += (int)strlen(argv[i])+1;                 //ibm.41953
    }

    commandLine = (char *) calloc(commandLineLength, sizeof(char));
    if(commandLine) {
        char *envName="IBM_JAVA_COMMAND_LINE", *envString;
        strcpy(commandLine, argv[0]);                         /*ibm@33260*/
        for(i=1; i<argc; i++) {                               /*ibm@33260*/
            strcat(commandLine, " ");                         /*ibm@33260*/
            strcat(commandLine, argv[i]);
        }
        envString = (char *) calloc(strlen(envName)+1 +
                                    strlen(commandLine)+1,
                                    sizeof(char));
        if(envString) {
            /*sprintf(envString, "%s=%s", envName, commandLine);   ibm@63819.1*/
            strcpy(envString, envName);                          /*ibm@63819.1*/
            strcat(envString, "=");                              /*ibm@63819.1*/
            strcat(envString, commandLine);                      /*ibm@63819.1*/
            putenv(envString);
        }
    }
    // ibm@24586 end
  
    /* Set an error return code which will either get used at leave_nodestroy */
    /* or will get reset by the call to ParseArguments */
    ret = 1; /* ibm@99356.1 */

    #ifndef NO_COMMAND_EXPANSION
    /*
     * Do generic processing on the command line.  This is not required
     * on Unix platforms since it is done by the shell there.
     */
    ExpandCommandLineArgs();                                        /*ibm@1369*/
    #endif

    /*
     * Load the jvm DLL or shared library
     */
    ifn.CreateJavaVM = 0; ifn.GetDefaultJavaVMInitArgs = 0;
    ifn.GetXUsage = 0;                                               /*ibm@76310*/
    if (!LoadJavaVM(jvmtype, &ifn))
        goto leave_nodestroy; /* ibm@99356.1 */

    /* Send output during options processing for us for possible translation */
    AddOption("vfprintf", (void *)&j_vfprintf);

    /*
     * Parse argv[0] to get the base program name.  This is not safe
     * for all encodings, but we assume here that our executable is
     * an ASCII-7 name.
     */
    progname = *argv++;
    if ((s = strrchr(progname, FILE_SEPARATOR)) != 0) {
        progname = s + 1;
    }
    --argc;

    /*ibm@58160 start*/

    /* Skip over a specified -classic option ibm@31774 */
    if (jvmspecified) {
        argv++;
        argc--;
    }
    /*ibm@58160 end*/

#ifdef JAVA_ARGS
    /* Preprocess wrapper arguments */
    TranslateDashJArgs(&argc, &argv);
    if (!AddApplicationOptions())
        goto leave_nodestroy; /* ibm@99356.1 */
#endif

#ifndef JAVA_ARGS
    cpath2 = getenv("CLASSPATH");                                       /*ibm@72836*/
#endif

    /*
     * Parse command line options.  On most systems the command arguments
     * are in the locale encoding, so we process them in the java platform
     * encoding by using the java default string constructer.  On Windows,
     * the command line is in the system ACP which may or may not match
     * the thread locale.  We use the default platform encoding anyway.
     */
    DefaultArguments(getenv("IBM_JAVA_OPTIONS"));
    if (!ParseArguments(&argc, &argv, &jarfile, &classname, &ret)) {
        goto leave_nodestroy;  /* ibm@99356.1 */
    }
    else {                     /* ibm@100997.1 */
        ret = 1;               /* ibm@100997.1 */
    }                          /* ibm@100997.1 */



#ifndef JAVA_ARGS
    /*
     * Set default CLASSPATH to current directory ibm@72836
     */
    if (!cpath2 && (jarfile == 0) )                        /*ibm@62955*/ /*ibm@72836*/
        cpath2 = ".";
#endif


    //ibm.41302  start changes
    /*
     * Check if we should do escape processing on the args
     */
    if (ArgEncoding == AE_ESCAPE) {
        ArgEncoding = AE_PLATFORM;
        for(i=1; i<saveargc; i++) {
            if (strstr(saveargv[i], "\\u")) {
                ArgEncoding = AE_ESCAPE;
                break;
            }
        }
    }

#ifndef JAVA_ARGS
    /*
     * Set the classpath
     */
    SetClassPath(cpath1, cpath2);
#endif
    //ibm.41302  end changes

    /* ibm@88699
     * Done with all command line processing and potential re-execs so
     * clean up the environment.
     */
    (void)UnsetEnv(ENV_ENTRY);					/*ibm@88699*/

    /*
     * Initialize the virtual machine
     */
    if (_launcher_debug)								  /*ibm@88699*/
        start = CounterGet();
    if (!InitializeJVM(&vm, &env)) {                      /*ibm@71326*/
        goto leave_nodestroy;  /* ibm@99356.1 */
    }

    /*
     * Show the version information
     */
    if (printVersion || showVersion) {                    /*ibm@5558*/
        PrintJavaVersion(env);
        if ((*env)->ExceptionOccurred(env)) {
            disablePrintfHook = 1;                                   //ibm.41953
            ReportExceptionDescription(env);			  /*ibm@88699*/
            goto leave;
        }
        if (printVersion) {
            ret = 0;
            goto leave;
        }
        if (showVersion) {
            fprintf(stderr, "\n");
        }
    }

    /*
     * If the user specified neither a class name or a JAR file
     */
    if (jarfile == 0 && classname == 0) {
        PrintUsage();
        goto leave;
    }

    /*
     * Put out some debug information
     */
    /* Start: ibm@62796 */
	if (_launcher_debug) {										/*ibm@88699*/
        int i;

        end = CounterGet();
        printf("%ld micro seconds to Initialize the JVM\n",
               (long)(jint)Counter2Micros(end-start));

        printf("Entry point Java class: '%s'\n", classname ? classname : "");
        printf("Number of arguments   : %d\n", argc);
		printf("---- Argument list ----\n");

        for (i = 0; i < argc; i++) {
			printf("    argv[%2d] : '%s'\n", i, argv[i]);
        }
    }
	/* End: ibm@62796 */


    /*
     * Get the String class which we will use later.  It is a severe
     * error if we cannot find this class.
     */
    StringCls = (*env)->FindClass(env, "java/lang/String");
    if (StringCls == 0) {
        disablePrintfHook = 1;                                       //ibm.41953
        ReportExceptionDescription(env);							/*ibm@88699*/
        goto leave;
    }

    /*
     * Find and Load the specified class
     */
    if (jarfile != 0) {
        jstring str;
        int     where = 0;
        char *platformJarfile = strdup(jarfile);                /*ibm@11978*/

        if (ArgEncoding != AE_LATIN)
            ConvertArgsToPlatform(1, &platformJarfile);             /*ibm@11978*/
        str = NewPlatformString(env, platformJarfile, ArgEncoding);
        free(platformJarfile);                                  /*ibm@11978*/

        mainClassName = GetMainClassName(env, str, &where);          //ibm.41302
        if (mainClassName == NULL) {
            showMessage(stderr, jarerror[where],                     //ibm.41302
                        js2jc(env, str), NULL, 0);                   //ibm.41302
            goto leave;
        }
        (*env)->DeleteLocalRef(env, str);                            //ibm.41302
        classname = (char *)(*env)->GetStringUTFChars(env, mainClassName, 0);
        if (classname == NULL) {
            disablePrintfHook = 1;                                   //ibm.41953
            ReportExceptionDescription(env);					/*ibm@88699*/
            goto leave;
        }
        mainClass = LoadClass(env, classname, 0);
        (*env)->ReleaseStringUTFChars(env, mainClassName, classname);
    } else {
        mainClass = LoadClass(env, classname, ArgEncoding!=AE_UTF8);
    }
    if (mainClass == NULL) {
        goto leave;
    }

    /*
     * Get the main method for this application
     */
    mainID = (*env)->GetStaticMethodID(env, mainClass, "main",
                                       "([Ljava/lang/String;)V");
    if (mainID == NULL || (*env)->ExceptionOccurred(env)) {          /*ibm@88767*/
        (*env)->ExceptionClear(env);                                 /*ibm@88767*/
        if (!mainClassName)                                          //ibm.41953
            mainClassName = (*env)->NewStringUTF(env, classname);    //ibm.41953
        showMessage(stderr, "No.main.method.in.class",               //ibm.41302
                    js2jc(env, mainClassName), NULL, 0);             //ibm.41302
        goto leave;
    }

    /*
     * Make sure the main method is public
     */
    {
        jobject obj = (*env)->ToReflectedMethod(env, mainClass,
                                                mainID, JNI_TRUE);
        jint mods;
        jmethodID mid =
          (*env)->GetMethodID(env,
                              (*env)->GetObjectClass(env, obj),
                              "getModifiers", "()I");
        if ((*env)->ExceptionOccurred(env)) {
            disablePrintfHook = 1;                                   //ibm.41953
            ReportExceptionDescription(env);						/*ibm@88699*/
            goto leave;
        }

        mods = (*env)->CallIntMethod(env, obj, mid);
        (*env)->ExceptionClear(env);                                 /*ibm@88767*/
        if ((mods & 1) == 0) { /* if (!Modifier.isPublic(mods)) ... */
            if (!mainClassName)                                      //ibm.41953
                mainClassName = (*env)->NewStringUTF(env, classname);//ibm.41953
            showMessage(stderr, "main.not.public.in.class",          //ibm.41302
                                js2jc(env, mainClassName), NULL, 0); //ibm.41302
            goto leave;
        }
    }

    /*
     * On zOS, the basic argv processing has convertered the args
     * from EBCDIC to ASCII (Cp1047->ISO8859-1).  This call is used
     * to convert them back to EBCDIC.  If noargconversion is specified,
     * we will keep them in ASCII and convert to Unicode using ISO8859-1.
     */
    if (ArgEncoding != AE_LATIN)                                   /*ibm@39353.1*/
        ConvertArgsToPlatform(argc, argv);                         /*ibm@1140*/

    /*
     * Build argument array by converting the arguments to Unicode to
     * pass to Java.  The conversion is normally done using the platform
     * encoding.
     */
    mainArgs = NewPlatformStringArray(env, argv, argc);
    if (mainArgs == NULL) {
        disablePrintfHook = 1;                                       //ibm.41593
        ReportExceptionDescription(env);							/*ibm@88699*/
        goto leave;
    }

    /*
     * Invoke the main method of the class
     */
    disablePrintfHook = 1;
    (*env)->CallStaticVoidMethod(env, mainClass, mainID, mainArgs);

                                                                                /*ibm@96837...*/
    /*
     * The launcher's exit code (in the absence of calls to 
    * System.exit) will be non-zero if main threw an exception. 
    */ 
    ret = (*env)->ExceptionOccurred(env) == NULL ? 0 : 1;

    /* 
    * Detach the main thread so that it appears to have ended when 
    * the application's main method exits.  This will invoke the 
    * uncaught exception handler machinery if main threw an 
    * exception.  An uncaught exception handler cannot change the 
    * launcher's return code except by calling System.exit. 
    */                                                                          /*...ibm@96837*/
    if ((*vm)->DetachCurrentThread(vm) != 0) {
        showMessage(stderr, "Thread.detach.error", NULL, NULL, 0);
        goto leave;
    }

    /* ret = 0; */ /* ibm@100997.1 No longer wanted here as set above by fix for ibm@96837 */

leave:
    (*vm)->DestroyJavaVM(vm);

/* ibm@34732. Linux: There exists some race condition within glibc code when more than one
 * threads try to exit simultaneously. This can result in the main thread hanging
 * indefinitely after calling 'return' or 'exit'. We are told that this problem in
 * glibc will not be fixed. Hence until we adopt NGPT, we have to call '_exit' instead
 * of 'return'.
 * Known side effect: Other threads may be reported as 'defunct' for a short duration until
 * the main thread exits and other threads are cleaned up.
 * Please refer to defect 34732 for a detailed explanation.
 */

/* ibm@61542.1
 * The problem with _exit() is that it terminates immediately without calling
 * any registered atexit() handlers.  This causes a problem for j9, so let's
 * try reinstating the return() call.
 */
 
 /* ibm@76310
  * Removed the j9Override check and ifdef wrapper
  */

/* ibm@99356.1 begin */
leave_nodestroy:
#ifdef IBM_MVS
    if(getenv("IBM_JAVA_ABEND_ON_FAILURE") != NULL) {                /*ibm@102209*/
        /* Make sure we ABEND the TCB under z/OS if the return 
         * code is non-zero.  This signals to z/OS that the process
         * has failed. */
        /* NB: The CEE3ABD() call is only valid in 31-bit mode */
        if (ret != 0) {
#ifdef _LP64
            fflush(NULL);         /* ibm@100997.1 */
            __cabend(0x0020, 0, 0);
#else    
            _INT4 code, timing;
            code = 0x0020;
            timing = 0;
            fflush(NULL);         /* ibm@100997.1 */
            CEE3ABD(&code, &timing);
#endif
        }
    }
#endif
/* ibm@99356.1 end */

    return ret;
}


/**************************************************************************
 * name         - AddOption
 * description  - Adds a new VM option with the given name and value.
 * parameters   - str   Option string (e.g. "-Djava.class.path=...")
 *                info  Additional information
 * returns      -
 **************************************************************************/
int                                                                  /*ibm@73964*/
AddOption(char *str, void *info)
{
    /*
     * Expand options array if needed to accomodate at least one more
     * VM option.
     */
    if (numOptions >= maxOptions) {
        if (options == 0) {
            maxOptions = 64;                                         //ibm.41302
            options = MemAlloc(maxOptions * sizeof(JavaVMOption));
        } else {
            JavaVMOption *tmp;
            maxOptions *= 4;
            tmp = MemAlloc(maxOptions * sizeof(JavaVMOption));
            memcpy(tmp, options, numOptions * sizeof(JavaVMOption));
            MemFree(options);
            options = tmp;
        }
    }
    if (strstr(str, "verbose"))
        VerboseOutput = 1;
    options[numOptions].optionString = str;
    options[numOptions++].extraInfo = info;
    return (numOptions - 1);                                         /*ibm@73964*/
}


/**************************************************************************
 * name         - SetClassPath
 * description  - Set the classpath option using the supplied string
 * parameters   - s1  -  Path or jarfile of executable
 *                s2  -  Specified or default classpath
 * returns      -
 **************************************************************************/
static void
SetClassPath(char * s1, char * s2) {
    int    len = (int)(((s1)?strlen(s1):0) + ((s2)?strlen(s2):0) + 40);  //ibm.41953
    char * def = MemAlloc(len);
    char * dp;

    strcpy(def, "-Djava.class.path=");
    if (s1) {
        strcat(def, s1);
        if (strlen(s1) > 4 && !strcmp(s1+(strlen(s1)-4), ".jar")) {                 /*ibm@97111*/
            AddOption(def, NULL);                                                   /*ibm@96927.1*/
            return;                                                                 /*ibm@96927.1*/
        }
    }
    if (s2) {
        dp = def+strlen(def);
        if (s1)                                  //ibm.42279
            *dp++ = PATH_SEPARATOR;              //ibm.42279
        strcpy(dp, s2);
    }
    AddOption(def, NULL);
}

/* ibm@88699 start
 * The SelectVersion() routine ensures that an appropriate version of
 * the JRE is running.  The specification for the appropriate version
 * is obtained from either the manifest of a jar file (preferred) or
 * from command line options.
 */
static void
SelectVersion(int argc, char **argv, char **main_class)
{
    char    *arg;
    char    **new_argv;
    char    **new_argp;
    char    *operand;
    char    *version = NULL;
    char    *jre = NULL;
    int     jarflag = 0;
    int     restrict_search = -1;		/* -1 implies not known */
    manifest_info info;
    char    env_entry[MAXNAMELEN + 24] = ENV_ENTRY "=";
    char    *env_in;
    int     res;

    /*
     * If the version has already been selected, set *main_class
     * with the value passed through the environment (if any) and
     * simply return.
     */
    if ((env_in = getenv(ENV_ENTRY)) != NULL) {
	if (*env_in != '\0')
	    *main_class = strdup(env_in);
	return;
    }

    /*
     * Scan through the arguments for options relevant to multiple JRE
     * support.  For reference, the command line syntax is defined as:
     *
     * SYNOPSIS
     *      java [options] class [argument...]
     *
     *      java [options] -jar file.jar [argument...]
     *
     * As the scan is performed, make a copy of the argument list with
     * the version specification options (new to 1.5) removed, so that
     * a version less than 1.5 can be exec'd.
     */
    new_argv = MemAlloc((argc + 1) * sizeof(char*));
    new_argv[0] = argv[0];
    new_argp = &new_argv[1];
    argc--;
    argv++;
    while ((arg = *argv) != 0 && *arg == '-') {
	if (strncmp(arg, "-version:", 9) == 0) {
	    version = arg + 9;
	} else if (strcmp(arg, "-jre-restrict-search") == 0) {
	    restrict_search = 1;
	} else if (strcmp(arg, "-no-jre-restrict-search") == 0) {
	    restrict_search = 0;
	} else {
	    if (strcmp(arg, "-jar") == 0)
		jarflag = 1;
	    /* deal with "unfortunate" classpath syntax */
	    if ((strcmp(arg, "-classpath") == 0 || strcmp(arg, "-cp") == 0) &&
	      (argc >= 2)) {
		*new_argp++ = arg;
		argc--;
		argv++;
		arg = *argv;
	    }
	    *new_argp++ = arg;
	}
	argc--;
	argv++;
    }
    if (argc <= 0) {	/* No operand? Possibly legit with -[full]version */
	operand = NULL;
    } else {
	argc--;
	*new_argp++ = operand = *argv++;
    }
    while (argc-- > 0)  /* Copy over [argument...] */
	*new_argp++ = *argv++;
    *new_argp = NULL;

    /*
     * If there is a jar file, read the manifest. If the jarfile can't be
     * read, the manifest can't be read from the jar file, or the manifest
     * is corrupt, issue the appropriate error messages and exit.
     *
     * Even if there isn't a jar file, construct a manifest_info structure
     * containing the command line information.  It's a convenient way to carry
     * this data around.
     */
    if (jarflag && operand) {
	if ((res = parse_manifest(operand, &info)) != 0) {
	    if (res == -1)
		showMessage(stderr,"Unable.to.access.jarfile",c2jc(operand),NULL, JNI_TRUE);   /*ibm@93556*/
	    else
		showMessage(stderr,"Invalid.or.corrupt.jarfile",c2jc(operand),NULL, JNI_TRUE); /*ibm@93556*/
	    exit(1);
	}
    } else {
	info.manifest_version = NULL;
	info.main_class = NULL;
	info.jre_version = NULL;
	info.jre_restrict_search = 0;
    }

    /*
     * The JRE-Version and JRE-Restrict-Search values (if any) from the
     * manifest are overwritten by any specified on the command line.
     */
    if (version != NULL)
	info.jre_version = version;
    if (restrict_search != -1)
	info.jre_restrict_search = restrict_search;

    /*
     * "Valid" returns (other than unrecoverable errors) follow.  Set
     * main_class as a side-effect of this routine.
     */
    if (info.main_class != NULL)
	*main_class = strdup(info.main_class);

    /*
     * If no version selection information is found either on the command
     * line or in the manifest, simply return.
     */
    if (info.jre_version == NULL) {
	free_manifest();
	free(new_argv);
	return;
    }

    /*
     * Check for correct syntax of the version specification (JSR 56).
     */
    if (!valid_version_string(info.jre_version)) {
	showMessage(stderr,"Syntax.error.in.version.spec",c2jc(info.jre_version),NULL, JNI_TRUE); /*ibm@93556*/
	exit(1);
    }

    /*
     * Find the appropriate JVM on the system. Just to be as forgiving as
     * possible, if the standard algorithms don't locate an appropriate
     * jre, check to see if the one running will satisfy the requirements.
     * This can happen on systems which haven't been set-up for multiple
     * JRE support.
     */
    jre = LocateJRE(&info);
    if (_launcher_debug)
        printf("JRE-Version = %s, JRE-Restrict-Search = %s Selected = %s\n",
          (info.jre_version?info.jre_version:"null"),
          (info.jre_restrict_search?"true":"false"), (jre?jre:"null"));
    if (jre == NULL) {
	if (acceptable_release(FULL_VERSION, info.jre_version)) {
	    free_manifest();
	    free(new_argv);
	    return;
	} else {
        showMessage(stderr,"Unable.to.locate.jre.meeting.spec",c2jc(info.jre_version),NULL, JNI_TRUE); /*ibm@93556*/
	    exit(1);
	}
    }

    /*
     * If I'm not the chosen one, exec the chosen one.  Returning from
     * ExecJRE indicates that I am indeed the chosen one.
     *
     * The private environment variable _JAVA_VERSION_SET is used to
     * prevent the chosen one from re-reading the manifest file and
     * using the values found within to override the (potential) command
     * line flags stripped from argv (because the target may not
     * understand them).  Passing the MainClass value is an optimization
     * to avoid locating, expanding and parsing the manifest extra
     * times.
     */
    if (info.main_class != NULL)
	(void)strcat(env_entry, info.main_class);
    (void)putenv(env_entry);
    ExecJRE(jre, new_argv);
    free_manifest();
    free(new_argv);
    return;
}
/*ibm@88699 end*/


/**************************************************************************
 * name         - DefaultArguments
 * description  - Set defaults from an option string.
 *                This is used to get the ArgEncoding from IBM_JAVA_OPTIONS
 * parameters   - opt
 **************************************************************************/
static void DefaultArguments(char * opt) {
    if (!opt || !*opt)
        return;
    if (strstr(opt, "-Xnoargsconversion"))
        ArgEncoding = AE_LATIN;
    if (strstr(opt, "-Xargencoding"))
        ArgEncoding = AE_ESCAPE;
    if (strstr(opt, "-Xargencoding:latin"))
        ArgEncoding = AE_LATIN;
    if (strstr(opt, "-Xargencoding:utf8"))
        ArgEncoding = AE_UTF8;
}


/**************************************************************************
 * name         - ParseArguments
 * description  - Parses command line arguments.
 * parameters   - pargc
 *                pargv
 *                pjarfile
 *                pclassname
 *                pret
 * returns      - JNI_FALSE or JNI_TRUE
 **************************************************************************/
static jboolean
ParseArguments(int *pargc, char ***pargv, char **pjarfile,
                       char **pclassname, int *pret)
{
    int argc = *pargc;
    char **argv = *pargv;
    jboolean jarflag = JNI_FALSE;
    jboolean classflag = JNI_FALSE;                                  //ibm.41302
    char *arg;
    char *pname;                                                     //ibm.41302
    char *path;                                                      //ibm.41302

    *pret = 1;
    while ((arg = *argv) != 0 && *arg == '-') {
        argv++; --argc;
        if (strcmp(arg, "-version") == 0) {                          //ibm.43108
            printVersion = JNI_TRUE;
        } else if (strcmp(arg, "-showversion") == 0) {  /*ibm@5558*/
            showVersion = JNI_TRUE;                     /*ibm@5558*/
        } else if (strcmp(arg, "-classpath") == 0 || strcmp(arg, "-cp") == 0) {
#ifndef JAVA_ARGS                                           /*ibm@60272*/
            if (argc < 1) {                                 /*ibm@60272*/
#else                                                       /*ibm@60272*/
            if (argc < 2) {                                 /*ibm@60272*/
#endif                                                      /*ibm@60272*/ 
                if(!showMessage(stderr, "Option.requires.classpath", c2jc(arg), NULL, 1))  /*ibm@60272*/
                fprintf(stderr, "%s requires class path specification\n", arg); /*ibm@60272*/
                PrintUsage();
                return JNI_FALSE;
            }
            cpath2 = *argv;
            argv++; --argc;
#ifndef JAVA_ARGS       
        /*
         * These arguments cannot be specified in launchers other
         * than java and javaw as they are not JVM options.
         */
        } else if (strcmp(arg, "-jar") == 0) {
            jarflag = JNI_TRUE;
        } else if (strcmp(arg, "-class") == 0) {                     //ibm.41302
            classflag = JNI_TRUE;                                    //ibm.41302
        } else if (strcmp(arg, "-help") == 0 ||
                   strcmp(arg, "-h") == 0 ||
                   strcmp(arg, "-?") == 0) {
            PrintUsage();
            *pret = 0;
            return JNI_FALSE;
        } else if (strcmp(arg, "-X") == 0) {
            *pret = PrintJ9XUsage();                                 /*ibm@76310*/
            return JNI_FALSE;
        } else if (strcmp(arg, "-assert") == 0) {
            *pret = showMessage(stderr, "assert.usage", c2jc(progname), NULL, 1);
            return JNI_FALSE;
#endif
        } else if (strcmp(arg, "-fullversion") == 0) {
            showMessage(stderr, "full.version", c2jc(FULL_VERSION),
                        c2jc(progname), 0);
            *pret = 0;
            return JNI_FALSE;

        /*
         * The following case provide backward compatibility with 1.1 style
         * command line options.
         */
        } else if (strcmp(arg, "-verbosegc") == 0) {
            AddOption("-verbose:gc", NULL);
        } else if (strcmp(arg, "-t") == 0) {
            AddOption("-Xt", NULL);
        } else if (strcmp(arg, "-tm") == 0) {
            AddOption("-Xtm", NULL);
        } else if (strcmp(arg, "-debug") == 0) {
            AddOption("-Xdebug", NULL);
        } else if (strcmp(arg, "-noclassgc") == 0) {
            AddOption("-Xnoclassgc", NULL);
        } else if (strcmp(arg, "-verify") == 0) {
            AddOption("-Xverify:all", NULL);
        } else if (strcmp(arg, "-verifyremote") == 0) {
            AddOption("-Xverify:remote", NULL);
        } else if (strcmp(arg, "-noverify") == 0) {
            AddOption("-Xverify:none", NULL);
        } else if (strncmp(arg, "-prof", 5) == 0) {
            char *p = arg + 5;
            char *tmp = MemAlloc(strlen(arg) + 50);
            if (*p) {
                sprintf(tmp, "-Xrunhprof:cpu=old,file=%s", p + 1);
            } else {
                sprintf(tmp, "-Xrunhprof:cpu=old,file=java.prof");
            }
            AddOption(tmp, NULL);
        } else if (strcmp(arg, "-checksource") == 0 ||
                   strcmp(arg, "-cs") == 0 ||
                   strcmp(arg, "-noasyncgc") == 0) {
            /* No longer supported */
            showMessage(stderr, "No.longer.supported", c2jc(arg), NULL, 0);
        } else if (strncmp(arg, "-ss", 3) == 0 ||
                   strncmp(arg, "-oss", 4) == 0 ||
                   strncmp(arg, "-ms", 3) == 0 ||
                   strncmp(arg, "-mx", 3) == 0) {
            char *tmp = MemAlloc(strlen(arg) + 6);
            sprintf(tmp, "-X%s", arg + 1); /* skip '-' */
            AddOption(tmp, NULL);
#ifndef NO_UNITTEST
        /*
         * Unit test function: show any message
         */
        } else if (!strncmp(arg, "-XshowMessage=", 14)) {
            char * arg1, * arg2 = NULL;
            char * msg = arg+14;
            arg1 = strchr(msg, ':');
            if (arg1) {
                *arg1++ = 0;
                arg2 = strchr(arg1, ':');
                if (arg2) *arg2++ = 0;
            }
            showMessage(stderr, msg, c2jc(arg1), c2jc(arg2), 0);
            return JNI_FALSE;
#endif
        } else if (strcmp(arg, "-Xnoargsconversion") == 0) {       /*ibm@39353.1*/
            ArgEncoding = AE_LATIN;                                /*ibm@39353.1*/
            AddOption(arg, NULL);
        } else if (strncmp(arg, "-Xargencoding", 13) == 0) {
            if (arg[13]==':') {
                if (!strcmp(arg+14, "utf8"))
                    ArgEncoding = AE_UTF8;
                if (!strcmp(arg+14, "file"))
                    ArgEncoding = AE_PLATFORM;
                if (!strcmp(arg+14, "latin"))
                    ArgEncoding = AE_LATIN;
            } else {
                ArgEncoding = AE_ESCAPE;
            }
            AddOption(arg, NULL);
        } else if (strncmp(arg, "-Djava.class.path=", 18) == 0) {    //ibm.50616
            AddOption(arg, NULL);                                    //ibm.50616
            cpath1 = NULL;                                           //ibm.50616
            cpath2 = arg+18;                                         //ibm.50616
        /* Do not pass "-Xj9" Sidecar option through to JVM          ibm@57204*/
        } else if (strcmp(arg, "-Xj9") == 0) {
        /* Do not pass "-Xpd" option through to JVM                  ibm@67741*/
        } else if (strcmp(arg, "-Xpd") == 0) {
        } else if (strncmp(arg, "-version:", 9) == 0 ||				/*ibm@88699*/
                   strcmp(arg, "-no-jre-restrict-search") == 0 ||		/*ibm@88699*/
                   strcmp(arg, "-jre-restrict-search") == 0) {			/*ibm@88699*/
			; /* Ignore machine independent options already handled */	/*ibm@88699*/
		} else if (RemovableMachineDependentOption(arg) ) {				/*ibm@88699*/
			; /* Do not pass option to vm. */							/*ibm@88699*/
        } else {
            AddOption(arg, NULL);
        }
    }

    if (getenv("IBM_JVM_NOARGSCONVERSION") != 0){                  //ibm@54079.1  
        ArgEncoding = AE_LATIN;                                    //ibm@54079.1
    }                                                              //ibm@54079.1  

    /*
     * Set a property saying that the JVM was invoked via
     * the java command.                            ibm@4561
     */
    AddOption("-Dinvokedviajava",NULL);   /*ibm@4561*/

    //ibm.41302  Begin changes
    /*
     * Determine what the user wants to invoke by looking at the first
     * non-option parameter.
     */
    if (--argc >= 0) {
        *pjarfile = 0;
        *pclassname = *argv;
        if (jarflag) {
            *pjarfile = *argv;
            cpath1 = *argv;
            *pclassname = 0;
        } else if (!classflag) {
            int len = (int)strlen(*argv);                            //ibm.41953
            if (len>4 && !strcmp(*argv+len-4, ".jar")) {
                *pjarfile = *argv;
                cpath1 = *argv;
                *pclassname = 0;
            }
            if (len>6 && !strcmp(*argv+len-6, ".class")) {
                pname = PlatformName(*argv, &path);
                cpath1 = path;
                len = (int)strlen(pname);                            //ibm.41953
                if (len>6)
                    pname[len-6] = 0;
                if (_launcher_debug) {								/*ibm@88699*/
                    printf("class=%s  path=%s\n", pname, path);
                }
                *pclassname = pname;
            }
        }
        *pargc = argc;
        *pargv = ++argv;
    }
    //ibm.41302  End changes

    return JNI_TRUE;
}


/**************************************************************************
 * name         - InitializeJVM
 * description  - Initializes the Java Virtual Machine. Also frees options
 *                array when finished.
 * parameters   - pvm
 *                penv
 * returns      - true if CreateJavaVM returns JNI_OK, else false
 **************************************************************************/
static jboolean
InitializeJVM(JavaVM **pvm, JNIEnv **penv)                          /*ibm@71326*/
{
    JavaVMInitArgs args;
    jint r;

#if defined(IBM_QUICKSTART)                                         /*ibm@33550*/
    AddOption("-Xquickstart", NULL);                                /*ibm@33550*//*ibm@33806*/
#endif                                                              /*ibm@33550*/

    /* Only use our vfprintf while within this CreateJavaVM */
    AddOption("vfprintf", 0);

    SetInternalLinkage();                                           /*ibm@9648*/

    memset(&args, 0, sizeof(args));
    args.version  = JNI_VERSION_1_2;
    args.nOptions = numOptions;
    args.options  = options;
    args.ignoreUnrecognized = JNI_FALSE;

    if (_launcher_debug) {								/*ibm@88699*/
        int i = 0;
        printf("JavaVM args:\n    ");
        printf("version 0x%08lx, ", (long)args.version);
        printf("ignoreUnrecognized is %s, ",
               args.ignoreUnrecognized ? "JNI_TRUE" : "JNI_FALSE");
        printf("nOptions is %ld\n", (long)args.nOptions);
        for (i = 0; i < numOptions; i++)
            printf("    option[%2d] = '%s'\n",
                   i, args.options[i].optionString);
    }

    /* Create the JVM */
    r = ifn.CreateJavaVM(pvm, (void **)penv, &args);                /*ibm@71326*/
    MemFree(options);

    /* Put out error message and perhaps usage */
    if (r != JNI_OK)
        showMessage(stderr, "Could.not.create.JVM", NULL, NULL, 0);
    if (r == JNI_EINVAL && !badMsgCount)                             //ibm.41302
        PrintUsage();                                                /*ibm@1097*/

    return r == JNI_OK;
}


#define NULL_CHECK0(e) if ((e) == 0) return 0
#define NULL_CHECK(e) if ((e) == 0) return

/**************************************************************************
 * name         - MemAlloc
 * description  - Returns a pointer to a block of at least 'size' bytes
 *                of memory. Prints error message and exits if the memory
 *                could not be allocated.
 * parameters   - size  Size of memory requested
 * returns      - Pointer to block of allocated memory.
 **************************************************************************/
void * MemAlloc(size_t size)
{
    void *p = malloc(size);
    if (p == 0) {
        perror("malloc");
        exit(1);
    }
    return p;
}

/*
 * MemFree - Just to be consistant
 */
void MemFree(void * mem) {
    free(mem);
}

/**************************************************************************
 * name         - NewPlatformString
 * description  - Returns a new Java string object for the specified
 *                platform string.
 * parameters   - env
 *                s     Platform encoded string
 * returns      - Java string object pointer or null (0)
 **************************************************************************/
static jstring
NewPlatformString(JNIEnv *env, char * s, int encoding)
{
    size_t len = strlen(s);                                         /*ibm@7418*/
    jbyteArray ary;

    /*ibm@93382 we use > 16 references locally, so specify a reasonable value*/
    if ((*env)->EnsureLocalCapacity(env, 32) < 0) {
        return 0;
    }

    if (encoding==AE_UTF8)
        return (*env)->NewStringUTF(env, s);
    if (encoding==AE_LATIN)
        return NewEncodedString(env, s, "ISO8859_1");

    if (!newStringB)
        NULL_CHECK0(newStringB = (*env)->GetMethodID(env, StringCls, //ibm.41302
                                            "<init>", "([B)V"));     //ibm.41302
    ary = (*env)->NewByteArray(env, (jsize)len);                    /*ibm@7418*/
    if (ary != 0) {
        jstring str = 0;
        (*env)->SetByteArrayRegion(env, ary, 0, (jsize)len,         /*ibm@7418*/
                                   (jbyte *)s);
        if (!(*env)->ExceptionOccurred(env)) {
            str = (*env)->NewObject(env, StringCls, newStringB, ary);
        }
        (*env)->DeleteLocalRef(env, ary);
        if (encoding==AE_ESCAPE)
            return  NewEscapeString(env, str);
        return str;
    }
    return 0;
}

//ibm.41302
/**************************************************************************
 * name         - NewEncodedString
 * description  - Returns a new Java string object for the specified
 *                sting and encoding
 * parameters   - env
 *                s     Platform encoded string
 * returns      - Java string object pointer or null (0)
 **************************************************************************/
static jstring
NewEncodedString(JNIEnv *env, char *s, char * encoding)
{
    size_t      len = strlen(s);                                                /*ibm@64541*/
    jbyteArray ary;
    jstring    enc;

    if (!newStringBE)
        NULL_CHECK0(newStringBE = (*env)->GetMethodID(env, StringCls,
                                  "<init>", "([BLjava/lang/String;)V"));
    enc = (*env)->NewStringUTF(env, encoding);
    ary = (*env)->NewByteArray(env, (jsize)len);
    if (ary != 0) {
        jstring str = 0;
        (*env)->SetByteArrayRegion(env, ary, 0, (jsize)len,
                                   (jbyte *)s);
        if (!(*env)->ExceptionOccurred(env)) {
            str = (*env)->NewObject(env, StringCls, newStringBE, ary, enc);
        }
        (*env)->DeleteLocalRef(env, ary);
        (*env)->DeleteLocalRef(env, enc);
        return str;
    }
    return 0;
}


/**************************************************************************
 * name         - doEscape
 * description  - Do escape processing on a jchar array
 *                Only the \uXXXX format is honored and any
 *                violation of this format is ignored.
 * parameters   - out   jchar buffer for output
 *                in    jchar input buffer
 *                len   Number of input characters
 * returns      - number of output characters
 *
 **************************************************************************/
int  doEscape(jchar *out, const jchar * in, int len) {
    int     i, j;
    jchar   c, ch;
    int     val;
    jchar * start;

    /* Loop for all characters in the string */
    start = out;
    for (i=0; i<len; i++) {
        c = in[i];
        if (c == '\\') {
            if (i+5 < len && in[i+1]=='u') {
                val = 0;
                for (j=2; j<6; j++) {
                    ch = in[i+j];
                    val *= 16;
                    if (ch >= '0' && ch <= '9') {
                        val += (ch-'0');
                    } else if (ch >= 'a' && ch <= 'f') {
                        val += (ch-'a') + 10;
                    } else if (ch >= 'A' && ch <= 'F') {
                        val += (ch-'A') + 10;
                    } else {
                        val = 0x10000;
                        break;
                    }
                }
                if (val <= 0xffff) {
                    i += 5;
                    c = (jchar) val;
                }
            }
        }
        *out++ = c;
    }
    return (int)(out-start);                                         //ibm.41953
}


/**************************************************************************
 * name         - NewEscapeString
 * description  - Returns a new Java string object doing basic escape
 *                processing.  Only the \uXXXX format is honored and any
 *                violation of this format is ignored.
 * parameters   - env
 *                str    Java string object
 * returns      - Java string object pointer or null (0)
 *
 **************************************************************************/
static jstring NewEscapeString(JNIEnv *env, jstring str)    {
    const jchar * strchrs;
    int   len;
    jchar * buf;

    strchrs = (*env)->GetStringChars(env, str, NULL);
    len     = (int)((*env)->GetStringLength(env, str));              //ibm.41953
    buf     = MemAlloc(len*2);

    len = doEscape(buf, strchrs, len);

    /* We are now done with the original string */
    (*env)->ReleaseStringChars(env, str, strchrs);
    (*env)->DeleteLocalRef(env, str);

    /* Return the new string */
    return (*env)->NewString(env, buf, len);
}
//ibm.41302   End changes


/**************************************************************************
 * name         - NewPlatformStringArray
 * description  - Returns a new array of Java string objects for the specified
 *                array of platform strings.
 * parameters   - env
 *                strv      Platform encoded string array
 *                strc      Number of strings in strv
 * returns      - Java string array object pointer
 **************************************************************************/
static jobjectArray
NewPlatformStringArray(JNIEnv *env, char **strv, int strc)
{
    jarray ary;
    int i;

    NULL_CHECK0(ary = (*env)->NewObjectArray(env, strc, StringCls, 0));
    for (i = 0; i < strc; i++) {
        jstring str;
        str = NewPlatformString(env, *strv++, ArgEncoding);
        NULL_CHECK0(str);
        (*env)->SetObjectArrayElement(env, ary, i, str);
        (*env)->DeleteLocalRef(env, str);
    }
    return ary;
}


/**************************************************************************
 * name         - LoadClass
 * description  - Loads a class, convert the '.' to '/'.
 * parameters   - env
 *                name      Class name to load
 *                convert   Should name be converted
 * returns      - Java class object pointer
 **************************************************************************/
static jclass
LoadClass(JNIEnv *env, char * name, int convert)
{
    char * buf = MemAlloc(strlen(name)*3 + 1);
    jclass cls;
    jlong  start, end;
    char * s;
    jclass ThrowableCls;
    jmethodID toString = 0;
    char * orgname = name;

    if (_launcher_debug)								/*ibm@88699*/
        start = CounterGet();

    //ibm.36843  Begin changes
    strcpy(buf, name);
    /*
     * If the convert flag is not set, the name is assumed to already
     * be in UTF8 (actually CESU-8).
     */
    if (convert) {
        int    nonASCII = 0;

        /*
         * Check if there are any non-ASCII chars in the name.
         * This is just a performance enhancement in the normal case
         * where the class name is a simple ASCII string.
         */
        for (s=name; *s; s++) {
            if (*s & 0x80 || *s=='\\') {
                nonASCII = 1;
                break;
            }
        }

        /*
         * If there are non-ASCII chars in the name, convert it
         * to UTF8.
         */
        if (nonASCII) {
            jstring str = NewPlatformString(env, name, ArgEncoding);
            name = (char *)(*env)->GetStringUTFChars(env, str, 0);
            if (name != NULL) {
                strcpy(buf, name);
                (*env)->ReleaseStringUTFChars(env, str, name);
                (*env)->DeleteLocalRef(env, str);
            }
        }
    }

    /*
     * Change any period in the string to a slash since that is what
     * the class loader expects.
     */
    for (s=buf; *s; s++) {
        if (*s=='.') *s = '/';
    }

    /*
     * Get these in case we need them.  We cannot get them during
     * exception processing.
     */
    ThrowableCls = (*env)->FindClass(env, "java/lang/Throwable");
    if (ThrowableCls) {
        toString = (*env)->GetMethodID(env, ThrowableCls,
                   "toString", "()Ljava/lang/String;");
    }

    /*
     * We now have a UTF8 class name to look up.
     */
    cls = (*env)->FindClass(env, buf);
    /*
     * Put out a human readable error message for class not found
     */
    if (!cls) {
        jstring msgstr;
        jchar * msgc;
        jthrowable ex  = (*env)->ExceptionOccurred(env);
        (*env)->ExceptionClear(env);

        if (ex && toString) {
            jchar * mp, *data;
            int     i = 0;
            char    exname[64];

            /* Parse the exeption string into name and data */
            msgstr = (jstring)(*env)->CallObjectMethod(env, ex, toString);
            (*env)->ExceptionClear(env);                                          /*ibm@88767*/
            msgc   = js2jc(env, msgstr);
            mp = msgc;
            while (*mp && *mp != ':') {
                if (i<63) exname[i++] = (char)*mp;
                mp++;
            }
            exname[i] = 0;

            /*
             * Put out a translated class not found error for the common
             * case, and the exception description for abnormal errors.
             */
            if (!strcmp(exname, "java.lang.NoClassDefFoundError")) {
                jchar* data_start = (*mp == ':') ? mp+1 : mp;                     /*ibm@50678*/
                size_t data_length = ((jcharlen(data_start)+1) * sizeof(jchar));  /*ibm@50678*/
                data = MemAlloc(data_length);                                     /*ibm@50678*/
                memcpy(data, data_start, data_length);                            /*ibm@50678*/
                showMessage(stderr, "class.not.found", data, NULL, 0);
            } else {
                showMessage(stderr, "class.cannot.be.loaded", msgc, NULL, 0);     /*ibm@42804*/
            }
        } else {
            showMessage(stderr, "class.cannot.be.loaded", c2jc(name), NULL, 0);
        }
    }

    if (_launcher_debug) {								/*ibm@88699*/
        end   = CounterGet();
        printf("Load class: %s\n", buf);
        printf("%ld micro seconds to load main class\n",
               (long)(jint)Counter2Micros(end-start));
        printf("----_JAVA_LAUNCHER_DEBUG----\n");
    }
    MemFree(buf);
    //ibm.36843  End changes

    return cls;
}

static char * jarerror [] = {
    "java.error.opening.jar.file",
    "jar.file.not.found",
    "No.manifest.in.jar.file",
    "No.main.class.in.manifest"
};

/**************************************************************************
 * name         - GetMainClassName
 * description  - Returns the main class name for the specified jar file.
 * parameters   - env
 *                jarname
 * returns      - Java string object pointer holding the main class name
 **************************************************************************/
static jstring
GetMainClassName(JNIEnv *env, jstring jarname, int * where)
{
    jclass cls;
    jmethodID midinit, midget, midmain, midval;
    jobject jar, man, attr;
    jstring str, result = 0;

    *where = 0;    /* Java methods */
    NULL_CHECK0(cls = (*env)->FindClass(env, "java/util/jar/JarFile"));
    NULL_CHECK0(midinit = (*env)->GetMethodID(env, cls, "<init>",
                                          "(Ljava/lang/String;)V"));
    NULL_CHECK0(midget  = (*env)->GetMethodID(env, cls, "getManifest",
                                          "()Ljava/util/jar/Manifest;"));
    *where = 1;    /* Open Jar file */
    NULL_CHECK0(jar = (*env)->NewObject(env, cls, midinit, jarname));
    *where = 2;    /* Get manifest  */
    man = (*env)->CallObjectMethod(env, jar, midget);
    /*ibm@93101..*/
    if ((*env)->ExceptionOccurred(env)) {
        (*env)->ExceptionDescribe(env);
        (*env)->ExceptionClear(env);
        *where = 0;
        return NULL;
    }
    /*..ibm@93101*/
    (*env)->DeleteLocalRef(env, jar);                                //ibm.41302

    if (man != 0) {
        *where = 0;
        NULL_CHECK0(midmain = (*env)->GetMethodID(env,
                                    (*env)->GetObjectClass(env, man),
                                    "getMainAttributes",
                                    "()Ljava/util/jar/Attributes;"));
        *where = 3;
        attr = (*env)->CallObjectMethod(env, man, midmain);
        /*ibm@93101..*/
        if ((*env)->ExceptionOccurred(env)) {
            (*env)->ExceptionDescribe(env);
            (*env)->ExceptionClear(env);
            *where = 0;
            return NULL;
        }
        /*..ibm@93101*/
        (*env)->DeleteLocalRef(env, man);                            //ibm.41302
        if (attr != 0) {
            *where = 0;
            NULL_CHECK0(midval = (*env)->GetMethodID(env,
                             (*env)->GetObjectClass(env, attr),
                             "getValue",
                             "(Ljava/lang/String;)Ljava/lang/String;"));
            str = (*env)->NewStringUTF(env, "Main-Class");
            *where = 3;    /* Get main entry from manifest */
            result = (*env)->CallObjectMethod(env, attr, midval, str);
            /*ibm@93101..*/
            if ((*env)->ExceptionOccurred(env)) {
                (*env)->ExceptionDescribe(env);
                (*env)->ExceptionClear(env);
                *where = 0;
                return NULL;
            }
            /*..ibm@93101*/
            (*env)->DeleteLocalRef(env, str);                        //ibm.41302
        }
    }
    return result;
}

#ifdef JAVA_ARGS
static char *java_args[] = JAVA_ARGS;
static char *app_classpath[] = APP_CLASSPATH;
#define NUM_ARGS (sizeof(java_args) / sizeof(char *))
#define NUM_APP_CLASSPATH (sizeof(app_classpath) / sizeof(char *))

/**************************************************************************
 * name         - TranslateDashJArgs
 * description  - For tools convert 'javac -J-ms32m' to 'java -ms32m ...'
 * parameters   - pargc     Pointer to an int holding the size of parameter
 *                          array
 *                pargv     Pointer to array of command line parameters
 *                          (strings)
 * returns      -
 **************************************************************************/
static void
TranslateDashJArgs(int *pargc, char ***pargv)
{
    int argc = *pargc;
    char **argv = *pargv;
    int nargc = argc + (int)NUM_ARGS;                                           /*ibm@64541*/
    char **nargv = MemAlloc((nargc + 1) * sizeof(char *));
    int i;

    *pargc = nargc;
    *pargv = nargv;

    /* Copy the VM arguments (i.e. prefixed with -J) */
    for (i = 0; i < NUM_ARGS; i++) {
        char *arg = java_args[i];
        if (arg[0] == '-' && arg[1] == 'J') {
            *nargv++ = arg + 2;
        }
    }

    for (i = 0; i < argc; i++) {
        char *arg = argv[i];
        if (arg[0] == '-' && arg[1] == 'J') {
            if (arg[2] == '\0') {
                showMessage(stderr, "Blank.-J.option", NULL, NULL, 0);
                exit(1);
            }
            *nargv++ = arg + 2;
        }
    }

    /* Copy the rest of the arguments */
    for (i = 0; i < NUM_ARGS; i++) {
        char *arg = java_args[i];
        if (arg[0] != '-' || arg[1] != 'J') {
            *nargv++ = arg;
        }
    }
    for (i = 0; i < argc; i++) {
        char *arg = argv[i];
        if (arg[0] != '-' || arg[1] != 'J') {
            *nargv++ = arg;
        }
    }
    *nargv = 0;
}

/**************************************************************************
 * name         - AddApplicationOptions
 * description  -
 *      For our tools, we try to add 3 VM options:
 *          -Denv.class.path=<envcp>
 *          -Dapplication.home=<apphome>
 *          -Djava.class.path=<appcp>
 *      <envcp> is the user's setting of CLASSPATH -- for instance the user
 *              tells javac where to find binary classes through this environment
 *              variable. Notice that users will be able to compile against our
 *              tools classes (sun.tools.javac.Main) only if they explicitly add
 *              tools.jar to CLASSPATH.
 *      <apphome> is the directory where the application is installed.
 *      <appcp>   is the classpath to where our apps' classfiles are.
 * parameters   -
 * returns      - JNI_FALSE if unable to get application home, else JNI_TRUE
 **************************************************************************/
static jboolean
AddApplicationOptions()
{
    char *s, *envcp, *appcp, *apphome;
    char home[MAXPATHLEN]; /* application home */
    char separator[] = { PATH_SEPARATOR, '\0' };
    size_t size;                                                    /*ibm@7489*/
    int i;

    s = getenv("CLASSPATH");
    if (s) {
        /* 40 for -Denv.class.path= */
        envcp = (char *)MemAlloc(strlen(s) + 40);
        sprintf(envcp, "-Denv.class.path=%s", s);
        AddOption(envcp, NULL);
    }

    if (!GetApplicationHome(home, sizeof(home))) {
        showMessage(stderr, "No.application.home.found", NULL, NULL, 0);
        return JNI_FALSE;
    }

    /* 40 for '-Dapplication.home=' */
    apphome = (char *)MemAlloc(strlen(home) + 40);
    sprintf(apphome, "-Dapplication.home=%s", home);
    AddOption(apphome, NULL);

    /* How big is the application's classpath? */
    size = strlen(home) * NUM_APP_CLASSPATH + 40; /* 40: -Djava.class.path */
    for (i = 0; i < NUM_APP_CLASSPATH; i++) {
        size += strlen(app_classpath[i]);
    }
    appcp = (char *)MemAlloc(size + 1);
    strcpy(appcp, "-Djava.class.path=");
    for (i = 0; i < NUM_APP_CLASSPATH; i++) {
        strcat(appcp, home);                    /* c:\program files\myapp */
        strcat(appcp, app_classpath[i]);        /* lib\myapp.jar          */
        strcat(appcp, separator);               /* ;                      */
    }
    appcp[strlen(appcp)-1] = '\0';  /* remove trailing path separator */
    AddOption(appcp, NULL);
    return JNI_TRUE;
}
#endif

/**************************************************************************
 * name         - PrintJavaVersion
 * description  - Prints the version information from the java.version
 *                and other properties.
 * parameters   - env
 * returns      -
 **************************************************************************/
static void
PrintJavaVersion(JNIEnv *env)
{
    jclass ver;                                                      /*ibm.11412*/
    jmethodID print;                                                 /*ibm.11412*/

    NULL_CHECK(ver = (*env)->FindClass(env, "sun/misc/Version"));    /*ibm.11412*/
    NULL_CHECK(print =
        (*env)->GetStaticMethodID(env, ver, "print", "()V"));        /*ibm.11412*/

    (*env)->CallStaticVoidMethod(env, ver, print);                   /*ibm.11412*/
}

/**************************************************************************
 * name         - PrintUsage
 * description  - Prints default usage message.
 * parameters   -
 * returns      -
 **************************************************************************/
static void
PrintUsage(void)
{
    jchar * pathsep = MemAlloc(2*sizeof(jchar));
    char* pname = progname;           /*ibm@60272*/
#ifdef JAVA_ARGS           /*ibm@60272*/
    pname = "java";        /*ibm@60272*/
#endif                     /*ibm@60272*/
    pathsep[0] = PATH_SEPARATOR;
    pathsep[1] = 0;
    if (!showMessage(stdout, "usage", c2jc(pname), pathsep, 1)) {    /*ibm@60272*/
        /*
         * This is a somewhat shortened version of the help in case
         * we cannot read java.properties
         */
        fprintf(stdout,
            "Usage: %s [-options] class [args...]\n"
            "           (to execute a class)\n"
            "   or  %s -jar [-options] jarfile [args...]\n"
            "           (to execute a jar file)\n"
            "\n"
            "where options include:\n"
            "    -cp -classpath <directories and zip/jar files separated by %c>\n"
            "              set search path for application classes and resources\n"
            "    -D<name>=<value>\n"
            "              set a system property\n"
            "    -verbose[:class|gc|jni]\n"
            "              enable verbose output\n"
            "    -version  print product version\n"
            "    -version:<value>\n"
			"				    require the specified version to run\n"		/*ibm@88699*/
            "    -showversion  print product version and continue\n"
            "    -jre-restrict-search | -no-jre-restrict-search\n"
			"                  include/exclude user private JREs in the version search\n"	/*ibm@88699*/
            "    -agentlib:<libname>[=<options>]\n"
			"                  load native agent library <libname>, e.g. -agentlib:hprof\n"	/*ibm@88699*/
			"                    see also, -agentlib:jdwp=help and -agentlib:hprof=help\n"	/*ibm@88699*/
			"    -agentpath:<pathname>[=<options>]\n"
			"                  load native agent library by full pathname\n"				/*ibm@88699*/
			"    -javaagent:<jarpath>[=<options>]\n"
			"                  load Java programming language agent, see java.lang.instrument\n"	/*ibm@88699*/
            "    -showversion  print product version and continue\n"
            "    -? -help  print this help message\n",
            pname,
            pname, PATH_SEPARATOR );
    }
}

#ifndef JAVA_ARGS
/**************************************************************************
 * name         - PrintXUsage
 * description  - Print usage message for -X options.
 * parameters   -
 * returns      - 1 if failed else 0
 **************************************************************************/
static jint
PrintXUsage(void)
{
    jchar * pathsep = MemAlloc(2*sizeof(jchar));
    pathsep[0] = PATH_SEPARATOR;
    pathsep[1] = 0;

    /*ibm@59678 start*/
#ifdef DEBUG
    if (!showMessage(stdout, "classic.debug.xusage", NULL, NULL, 1)) {
        fprintf(stderr, "XUsage(debug): not available\n");
    }
#endif /*DEBUG*/
    /*ibm@59678 end*/

    if (!showMessage(stdout, "classic.xusage", c2jc(progname), pathsep, 1)) {
        fprintf(stderr, "XUsage: not available\n");
        return 1;
    }

    return 0;
}
#endif

#ifndef JAVA_ARGS
/**************************************************************************
 * name         - PrintJ9XUsage
 * description  - Print usage message for -X options on j9.
 * parameters   -
 * returns      - 1 if failed else 0
 **************************************************************************/
static jint
PrintJ9XUsage(void)
{
    char   msgfile[MAXPATHLEN];
    char * msgfname;
    msgfname = GetMessageFile(msgfile, MAXPATHLEN);
    if (ifn.GetXUsage == 0) {
        fprintf(stderr, "XUsage: not available. GetXUsage entrypoint not found\n");
        return 1;
    }
    ifn.GetXUsage(msgfname);
    return 0;
}
#endif

/*
 * Return the first argument.  We need a different implmentation when the
 * va_list is an array than if it is a scalar or structure.
 */
//ibm.41953  start
#if defined(IBM_OE) || defined(__s390__) || (defined(linux) && defined(powerpc))               /*ibm@57595*/ /*ibm@42986*/
char * peekArg(va_list args) {
    va_list tmpargs;
    memcpy(tmpargs, args, sizeof(va_list));
    return va_arg(tmpargs, char *);
}
#else
char * peekArg(va_list args) { return va_arg(args, char *); }
#endif
//ibm.41953  end

/*
 * Override the system printf with ours.  This allows us to translate
 * the common messages from the JVM.  All others are let thru.  This
 * override of vfprintf is only done while parsing the options in
 * CreateJavaVM.  If we found verbose in options, we will allow the
 * full English string to come out.
 */
jint JNICALL j_vfprintf (FILE * f, const char * tmp, va_list args) {
    int   rc = JNI_ERR;                                             /*ibm@55366*/
    int   skipmsg = 0;
    char * arg1;
    char * tmpx, * tp;
    const char * cp;
    static continueLine = 0;

    if (disablePrintfHook || !tmp)                                   //ibm.42088
        return vfprintf(f, tmp, args);

    if (badMsgCount == 0) {                                          //ibm.41953
        cp = strchr(tmp, '%');                                       //ibm.42088
        if (cp && cp[1]=='s')                                        //ibm.42088
            arg1 = peekArg(args);
        else
            arg1 = NULL;

        /*
         * Convert all "Bad xxxx: value" to Invalid option messages
         */
        if (strlen(tmp)>10 && !memcmp(tmp, "Bad ", 4) && arg1) {
            skipmsg = showMessage(f, "Option.value.invalid", c2jc(arg1), NULL, 1);
        }


        /*
         * Supress extra parsing messages
         */
        else if (strstr(tmp, "Error parsing") ||
            strstr(tmp, "Unable to parse")) {
            skipmsg = 1;
        }

        /*
         * Special case for JIT compiler message
         */
        else if (strlen(tmp)>30 && !memcmp(tmp, "Warning: JIT Compiler ", 4) && arg1) {
            skipmsg = showMessage(f, "JIT.compiler.not.found", c2jc(arg1), NULL, 1);
        }
        /*
         * Look up the string
         */
        else {
            tmpx = strdup(tmp);
            for (tp = tmpx; *tp; tp++) {
                if (*tp==':') *tp = 0;
                if (*tp==' ') *tp = '.';
            }
            skipmsg = showMessage(f, tmpx, c2jc(arg1), NULL, 1);
            if (!skipmsg)                                            //ibm.42647
                badMsgCount++;                                       //ibm.42088
            free(tmpx);
        }
    }

    /*
     * Put out all messages found during init in brackets.
     * Most verbose messages are already in brackets so do not
     * change them.
     */
    if (!skipmsg || VerboseOutput) {
        if (tmp[0]=='[' || continueLine>1) {                         //ibm.41953
            rc = vfprintf(f, tmp, args);                             //ibm.41953
            continueLine = (tmp[strlen(tmp)-1] != '\n')*2;           //ibm.42647
        } else {                                                     //ibm.41953
            tmpx = MemAlloc(strlen(tmp)*2 + 2);
            tp = tmpx;
            if (!continueLine) {                                     //ibm.42088
                tmpx[0] = '[';
                tmpx[1] = ' ';
                tp = tmpx+2;                                         //ibm.42647
            }
            for (cp=tmp; *cp; cp++) {
                if (*cp == '\n') {
                    *tp++ = ' ';
                    *tp++ = ']';
                    *tp++ = '\n';
                    if (cp[1]=='\n') cp++;
                    if (cp[1]) {
                        *tp++ = '[';
                        *tp++ = ' ';
                    }
                } else *tp++ = *cp;
            }
            *tp = 0;
            continueLine = (cp[-1] != '\n');                         //ibm.42088
            rc = vfprintf(f, tmpx, args);
            free(tmpx);
        }
    }
    fflush(f);
    return rc;
}


/*
 * This is a strlen for Unicode java chars.
 */
static int jcharlen(jchar * str) {
    jchar * start = str;
    if (!str)
        return 0;
    while (*str) str++;
    return (int)(str-start);                                         //ibm.41953
}


/*
 * Simple latin1 char to jchar converter
 * This is used for strings known to be in a limited character set
 */
jchar * c2jc(char * str) {
    jchar * jc;
    jchar * ret;

    if (!str)
        return NULL;
    jc  = MemAlloc((strlen(str)+1) * sizeof(jchar));
    ret = jc;
    while (*str) {
        *jc = (jchar)(*str&0xff);
        str++;
        jc++;
    }
    *jc = 0;
    return ret;
}


/*
 * jstring to jchar converter
 */
jchar * js2jc(JNIEnv * env, jstring jstr) {
    jchar * ret;
    const   jchar * strchrs = NULL;
    int     len = 0;

    if (jstr) {
        strchrs = (*env)->GetStringChars(env, jstr, NULL);
        len     = (int)((*env)->GetStringLength(env, jstr));         //ibm.41953
    }
    ret = MemAlloc((len+1)*sizeof(jchar));
    if (len)
        memcpy(ret, strchrs, len*sizeof(jchar));
    ret[len] = 0;
    (*env)->ReleaseStringChars(env, jstr, strchrs);
    return ret;
}


/*
 * Substitute replacement strings.  The base message string and the two
 * replacement strings are unicode.
 */
jchar * subMessage(jchar * msg, jchar * rep1, jchar * rep2, jint * lenp) {
    int     len;
    int     count = 0;
    jchar * ret, *rp;
    jchar * mp = msg;

    /* Determine the length for the output string */
    while (*mp) {
        if (*mp=='%')
            count++;
        mp++;
    }
    len = jcharlen(msg) + count * (jcharlen(rep1) + jcharlen(rep2)) + 1;
    ret = MemAlloc(len * sizeof(jchar));

    /* Loop thru the message string to create the output string */
    rp  = ret;
    mp  = msg;
    while (*mp) {
        if (*mp != '%') {
            *rp++ = *mp++;
        } else {
            switch (mp[1]) {
            case 0:                /* End of string */
                *rp++ = '%';
                mp--;
                break;
            case '%':              /* Double percent */
                *rp++ = '%';
                break;
            case '1':              /* Sub 1 */
                memcpy(rp, rep1, jcharlen(rep1)*sizeof(jchar));
                rp += jcharlen(rep1);
                break;
            case '2':              /* Sub 2 */
                memcpy(rp, rep2, jcharlen(rep2)*sizeof(jchar));
                rp += jcharlen(rep2);
                break;
            default:               /* Not an escape sequence */
                *rp++ = '%';
                *rp++ = mp[1];
                break;
            }
            mp += 2;
        }
    }
    *rp = 0;
    if (lenp)                 /* Return length */
        *lenp = (int)(rp-ret);                                       //ibm.41953
    return ret;               /* Return string */
}


/*
 * Do escape processing on a char string, returning a jchar string
 * The returned string is freed by the caller.
 */
jchar * strEscape(char * buf) {
    jchar * ret, * rp;
    char  * bp = buf;

    /*
     * Determine the size and allocate the output buffer
     */
    while (*bp) {
        if (*bp == '\\' && !bp[1]) {
            bp += 2;
            if (!*bp) bp++;
        } else bp++;
    }
    ret = MemAlloc((bp-buf+1) * sizeof(jchar));
    rp  = ret;

    /* Convert to pseudo unicode */
    bp = buf;
    while (*bp) {
        if (*bp == '\\' && bp[1]=='n') {
            *rp = '\n';
            bp++;
        } else if (*bp == '\\' && bp[1]==' ') {             //ibm.52259
            *rp = ' ';                                      //ibm.52259
            bp++;                                           //ibm.52259
        } else if (*bp == '\\' && bp[1]==0) {
            bp += 2;
            if (!*bp) bp++;   /* Allow CR/LF */
            continue;
        } else {
            *rp = (jchar) *bp;
        }
        rp++;
        bp++;
    }
    *rp = 0;

    /* Do unicode escape processing */
    doEscape(ret, ret, (int)(rp-ret+1));                             //ibm.41953
    return ret;
}


/*
 * Get a message from the message file.
 * Message returned is freed by the invoker
 * We always open and read the file on the assumption that any given
 * invocation only uses a single message.  This may not be true, but
 * users of multiple messages are not performance sensitive.
 */
jchar * getMessage(char * name) {
    char   msgfile[MAXPATHLEN];
    char * msgfname;
    FILE * msgf = NULL;
    char * buf, *bufp, * bp, * endp;
    int    namelen = (int)strlen(name);                              //ibm.41953
    jchar * ret = NULL;
    long   msgfsize;

    /*
     * Get the name of the message file from the platform code
     * and get the size of the file
     */
    msgfname = GetMessageFile(msgfile, MAXPATHLEN);
    msgf = fopen(msgfname, "r");
    if (!msgf)
        return NULL;
    if (fseek(msgf, 0, SEEK_END))
        return NULL;
    msgfsize = ftell(msgf);
    if (msgfsize < 1)
        return NULL;
    fseek(msgf, 0, SEEK_SET);

    /*
     * Read in the whole file
     */
    buf = MemAlloc((size_t)msgfsize+1);
    fread(buf, 1, (size_t)msgfsize, msgf);
    buf[msgfsize] = 0;
    bufp = buf;

    /*
     * Allow the file to be either ASCII or EBCDIC on zOS
     */
#ifdef IBM_OE
    if (buf[0]!='#')
        ConvertArgstoASCII(1, &buf);
#endif

    /*
     * Fix up the file buffer to simplify the search
     */
    while (msgfsize--) {
        if (*bufp=='\t') *bufp=' ';
        if (*bufp=='\r') *bufp=0;
        if (*bufp=='\n') *bufp=0;
        bufp++;
    }
    endp = bufp;

    /*
     * Look for the name
     */
    bufp = buf;
    while (bufp < endp) {
        bp = bufp;
        while (*bp && *bp==' ') bp++;
        if (!strncmp(name, bp, namelen) &&
            (bp[namelen]==' ' || bp[namelen]=='=')) {
            bp += namelen;
            while (*bp && *bp==' ') bp++;
            if (*bp == '=') bp++;
            while (*bp && *bp==' ') bp++;
            /* Create the string with continuations */
            ret = strEscape(bp);
            break;
        }
        bufp += strlen(bufp) + 1;
        if (!*bufp) bufp++;
    }
    fclose(msgf);
    MemFree(buf);
    return ret;
}


/*
 * Get and display a message.  The replacement strings are in Unicode
 * and are freed by this call regardless of what it returns.
 */
jboolean showMessage(FILE * f, char * name, jchar * rep1,
                            jchar * rep2, int reterr) {
    int    len;
    jint   jlen;
    char * defmsg, * dp;
    jchar * msg, * smsg;

    msg = getMessage(name);
    if (!msg) {
        /*
         * Handle the case where the message file is not found.
         * If the caller can choose to handle this.
         */
        if (reterr) {
            if (rep1)
                MemFree(rep1);
            if (rep2)
                MemFree(rep2);
            return JNI_FALSE;
        }
        /*
         * Use the message name as the message, replacing the dots
         * with spaces.  If there is data, append it to the end.
         */
        defmsg = MemAlloc(strlen(name)+16);
        strcpy(defmsg, name);
        if (rep1)
            strcat(defmsg, ": %1 %2");
        for (dp=defmsg; *dp; dp++)
            if (*dp=='.') *dp = ' ';
        strcat(defmsg, (rep1) ? " - %1 %2" : ".");
        msg = c2jc(defmsg);
        MemFree(defmsg);
    }

    /*
     * Do string replacement, allowing the order to vary
     */
    smsg = subMessage(msg, rep1, rep2, &jlen);
    len = (int)jlen;
    MemFree(msg);

    /*
     * Let the platform output the string
     */
    ShowUnicode(f, smsg, len);
    fprintf(f, "\n");
    fflush(f);

    MemFree(smsg);
    if (rep1)
        MemFree(rep1);
    if (rep2)
        MemFree(rep2);
    return JNI_TRUE;
}
