/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalComboBoxUI.java, swing, asdev, 20060428 1.23
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74904  071004 chenerys  Upgrade to 5.0 Swing 
 * 80020  171104 chenerys  Accessibility fix for JComboBox
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)MetalComboBoxUI.java	1.49 04/05/18
 *
 */

package javax.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;
import java.io.Serializable;
import java.beans.*;


/**
 * Metal UI for JComboBox
 * <p>
 * <strong>Warning:</strong>
 * Serialized objects of this class will not be compatible with
 * future Swing releases. The current serialization support is
 * appropriate for short term storage or RMI between applications running
 * the same version of Swing.  As of 1.4, support for long term storage
 * of all JavaBeans<sup><font size="-2">TM</font></sup>
 * has been added to the <code>java.beans</code> package.
 * Please see {@link java.beans.XMLEncoder}.
 *
 * @see MetalComboBoxEditor
 * @see MetalComboBoxButton
 * @version 1.49 05/18/04
 * @author Tom Santos
 */
public class MetalComboBoxUI extends BasicComboBoxUI {

    private ActionListener editorActionListener;                /* ibm@80020 */

    public static ComponentUI createUI(JComponent c) {
        return new MetalComboBoxUI();
    }

    public void paint(Graphics g, JComponent c) {
        if (MetalLookAndFeel.usingOcean()) {
            super.paint(g, c);
        }
    }

    /**
     * If necessary paints the currently selected item.
     *
     * @param g Graphics to paint to
     * @param bounds Region to paint current value to
     * @param hasFocus whether or not the JComboBox has focus
     * @throws NullPointerException if any of the arguments are null.
     * @since 1.5
     */
    public void paintCurrentValue(Graphics g, Rectangle bounds,
                                  boolean hasFocus) {
        // This is really only called if we're using ocean.
        if (MetalLookAndFeel.usingOcean()) {
            bounds.x += 2;
            bounds.y += 2;
            bounds.width -= 3;
            bounds.height -= 4;
            super.paintCurrentValue(g, bounds, hasFocus);
        }
        else if (g == null || bounds == null) {
            throw new NullPointerException(
                "Must supply a non-null Graphics and Rectangle");
        }
    }

    /**
     * If necessary paints the background of the currently selected item.
     *
     * @param g Graphics to paint to
     * @param bounds Region to paint background to
     * @param hasFocus whether or not the JComboBox has focus
     * @throws NullPointerException if any of the arguments are null.
     * @since 1.5
     */
    public void paintCurrentValueBackground(Graphics g, Rectangle bounds,
                                            boolean hasFocus) {
        // This is really only called if we're using ocean.
        if (MetalLookAndFeel.usingOcean()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height - 1);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 2,
                       bounds.height - 3);
        }
        else if (g == null || bounds == null) {
            throw new NullPointerException(
                "Must supply a non-null Graphics and Rectangle");
        }
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    /*ibm@80020 start*/
    protected KeyListener createKeyListener() {
        return new NoSelectKeyHandler();
    }
    private class NoSelectKeyHandler extends KeyAdapter {
        private int selectionForKey(char aKey) {
            int i,c;
            int currentSelection = -1;
            Object selectedItem = listBox.getSelectedValue();
            String v;
            String pattern;
            ListModel aModel = listBox.getModel();
            
            if ( selectedItem != null ) {
                
                for ( i=0,c=aModel.getSize();i<c;i++ ) {
                    if ( selectedItem == aModel.getElementAt(i) ) {
                        currentSelection  =  i;
                        break;
                    }
                    
                }
            }
            
            pattern = ("" + aKey).toLowerCase();
            aKey = pattern.charAt(0);
            
            for ( i = ++currentSelection, c = aModel.getSize() ; i < c ; i++ ) {
                if (aModel.getElementAt(i) != null && aModel.getElementAt(i).toString() != null) { 
                    v = aModel.getElementAt(i).toString().toLowerCase();
                    if ( v.length() > 0 && v.charAt(0) == aKey )
                        return i;
                }
            }
            
            for ( i = 0 ; i < currentSelection ; i ++ ) {
                if (aModel.getElementAt(i) != null && aModel.getElementAt(i).toString() != null) { 
                    v = aModel.getElementAt(i).toString().toLowerCase();
                    if ( v.length() > 0 && v.charAt(0) == aKey )
                        return i;
                }
            }
            return -1;
        }

        private boolean selectWithKeyCharNoAction(char keyChar) {
            int index = selectionForKey(keyChar);
            if ( index != -1 ) {
                // the popup has to be showing now, otherwise the selected item
                // will not be seen
                comboBox.setPopupVisible(true);
                listBox.setSelectedIndex(index);
                listBox.ensureIndexIsVisible(index);
                return true;
            } else {
                return false;
            }
        }

        public void keyPressed( KeyEvent e ) {
            if ( comboBox.isEnabled() &&
                 !isNavigationKey( e.getKeyCode() ) &&
                 isTypeAheadKey( e ) ) {

                if (comboBox.getKeySelectionManager() != null) {
                    if ( comboBox.selectWithKeyChar(e.getKeyChar()) ) {
                        e.consume();
                    }
                } else {
                    if (selectWithKeyCharNoAction(e.getKeyChar()) ) {
                        e.consume();
                    }
                }
            }
        } 

        boolean isTypeAheadKey( KeyEvent e ) {
            return !e.isAltDown() && !e.isControlDown() && !e.isMetaDown();
        }
    }
    
    protected void selectNextPossibleValue() {
        int si = listBox.getSelectedIndex();
        if ( si < comboBox.getModel().getSize() - 1 ) {
            listBox.setSelectedIndex( si + 1 );
            listBox.ensureIndexIsVisible( si + 1 );
            comboBox.repaint();
        }
    }
    protected void selectPreviousPossibleValue() {
        int si = listBox.getSelectedIndex();
        if ( si > 0 ) {
            listBox.setSelectedIndex( si - 1 );
            listBox.ensureIndexIsVisible( si - 1 );
            comboBox.repaint();
        }
    }
    /*ibm@80020 end*/

    protected JButton createArrowButton() {
        boolean iconOnly = (comboBox.isEditable() ||
                            MetalLookAndFeel.usingOcean());
        JButton button = new MetalComboBoxButton( comboBox,
                                                  new MetalComboBoxIcon(),
                                                  iconOnly,
                                                  currentValuePane,
                                                  listBox );
        button.setMargin( new Insets( 0, 1, 1, 3 ) );
        if (MetalLookAndFeel.usingOcean()) {
            // Disabled rollover effect.
            button.putClientProperty(MetalBorders.NO_BUTTON_ROLLOVER,
                                     Boolean.TRUE);
        }
        updateButtonForOcean(button);
        return button;
    }

    /**
     * Resets the necessary state on the ComboBoxButton for ocean.
     */
    private void updateButtonForOcean(JButton button) {
        if (MetalLookAndFeel.usingOcean()) {
            // Ocean renders the focus in a different way, this
            // would be redundant.
            button.setFocusPainted(comboBox.isEditable());
        }
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     */          
    public class MetalPropertyChangeListener extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange( e );
            String propertyName = e.getPropertyName();

            if ( propertyName == "editable" ) {
		MetalComboBoxButton button = (MetalComboBoxButton)arrowButton;
		button.setIconOnly( comboBox.isEditable() ||
                                    MetalLookAndFeel.usingOcean() );
		comboBox.repaint();
                updateButtonForOcean(button);
            } else if ( propertyName == "background" ) {
                Color color = (Color)e.getNewValue();
                arrowButton.setBackground(color);
                listBox.setBackground(color);
                
            } else if ( propertyName == "foreground" ) {
                Color color = (Color)e.getNewValue();
                arrowButton.setForeground(color);
                listBox.setForeground(color);
            }
        }
    }

    /**
     * As of Java 2 platform v1.4 this method is no longer used. Do not call or
     * override. All the functionality of this method is in the
     * MetalPropertyChangeListener.
     *
     * @deprecated As of Java 2 platform v1.4.
     */
    @Deprecated
    protected void editablePropertyChanged( PropertyChangeEvent e ) { }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     */          
    public class MetalComboBoxLayoutManager extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer( Container parent ) {
            layoutComboBox( parent, this );
        }
        public void superLayout( Container parent ) {
            super.layoutContainer( parent );
        }
    }

    // This is here because of a bug in the compiler.  
    // When a protected-inner-class-savvy compiler comes out we
    // should move this into MetalComboBoxLayoutManager.
    public void layoutComboBox( Container parent, MetalComboBoxLayoutManager manager ) {
        if (comboBox.isEditable() && !MetalLookAndFeel.usingOcean()) {
            manager.superLayout( parent );
            return;
        }

        if (arrowButton != null) {
            if (MetalLookAndFeel.usingOcean() &&
                                (arrowButton instanceof MetalComboBoxButton)) {
                Icon icon = ((MetalComboBoxButton)arrowButton).getComboIcon();
                Insets buttonInsets = arrowButton.getInsets();
                Insets insets = comboBox.getInsets();
                int buttonWidth = icon.getIconWidth() + buttonInsets.left +
                                  buttonInsets.right;
		arrowButton.setBounds(MetalUtils.isLeftToRight(comboBox)
				? (comboBox.getWidth() - insets.right - buttonWidth)
				: insets.left,
                            insets.top, buttonWidth,
                            comboBox.getHeight() - insets.top - insets.bottom);
            }
            else {
                Insets insets = comboBox.getInsets();
                int width = comboBox.getWidth();
                int height = comboBox.getHeight();
                arrowButton.setBounds( insets.left, insets.top,
                                       width - (insets.left + insets.right),
                                       height - (insets.top + insets.bottom) );
            }
        }

        if (editor != null && MetalLookAndFeel.usingOcean()) {
            Rectangle cvb = rectangleForCurrentValue();
            editor.setBounds(cvb);
        }
    }

    /**
     * As of Java 2 platform v1.4 this method is no
     * longer used.
     *
     * @deprecated As of Java 2 platform v1.4.
     */
    @Deprecated
    protected void removeListeners() {
        if ( propertyChangeListener != null ) {
            comboBox.removePropertyChangeListener( propertyChangeListener );
        }
    }

    // These two methods were overloaded and made public. This was probably a
    // mistake in the implementation. The functionality that they used to 
    // provide is no longer necessary and should be removed. However, 
    // removing them will create an uncompatible API change.

    public void configureEditor() {
	super.configureEditor();
        if (editorActionListener == null) {                      /* ibm@80020 */
            editorActionListener = new ActionListener() {        /* ibm@80020 */
                    public void actionPerformed(ActionEvent e) { /* ibm@80020 */
                        if (isPopupVisible(comboBox)) {          /* ibm@80020 */
                            comboBox.setSelectedIndex(           /* ibm@80020 */
                                    listBox.getSelectedIndex()); /* ibm@80020 */
                        }                                        /* ibm@80020 */
                    }                                            /* ibm@80020 */
                };                                               /* ibm@80020 */
            comboBox.getEditor().addActionListener(              /* ibm@80020 */
                                         editorActionListener);  /* ibm@80020 */
        }                                                        /* ibm@80020 */
    }

    public void unconfigureEditor() {
	super.unconfigureEditor();
        if (editorActionListener != null) {                      /* ibm@80020 */
            (comboBox.getEditor()).removeActionListener(         /* ibm@80020 */
                                          editorActionListener); /* ibm@80020 */
            editorActionListener = null;                         /* ibm@80020 */
        }                                                        /* ibm@80020 */
    }

    public Dimension getMinimumSize( JComponent c ) {
        if ( !isMinimumSizeDirty ) {
            return new Dimension( cachedMinimumSize );
        }

        Dimension size = null;

        if ( !comboBox.isEditable() &&
             arrowButton != null &&
             arrowButton instanceof MetalComboBoxButton ) {

            MetalComboBoxButton button = (MetalComboBoxButton)arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = comboBox.getInsets();

            size = getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        }
        else if ( comboBox.isEditable() &&
                  arrowButton != null &&
                  editor != null ) {
            size = super.getMinimumSize( c );
            Insets margin = arrowButton.getMargin();
            size.height += margin.top + margin.bottom;
            size.width += margin.left + margin.right;
        }
        else {
            size = super.getMinimumSize( c );
        }

        cachedMinimumSize.setSize( size.width, size.height ); 
        isMinimumSizeDirty = false;

        return new Dimension( cachedMinimumSize );
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     *
     * This class is now obsolete and doesn't do anything and
     * is only included for backwards API compatibility. Do not call or 
     * override.
     * 
     * @deprecated As of Java 2 platform v1.4.
     */          
    @Deprecated
    public class MetalComboPopup extends BasicComboPopup {

	public MetalComboPopup( JComboBox cBox) {
	    super( cBox );
	}

	// This method was overloaded and made public. This was probably
	// mistake in the implementation. The functionality that they used to 
	// provide is no longer necessary and should be removed. However, 
	// removing them will create an uncompatible API change.

	public void delegateFocus(MouseEvent e) {
	    super.delegateFocus(e);
	}
    }
}


