/*
 * @(#)src/classes/sov/javax/swing/colorchooser/DefaultPreviewPanel.java, swing, asdev, 20060428 1.16
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74904  071004 chenerys  Upgrade to 5.0 Swing 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)DefaultPreviewPanel.java	1.13 03/12/19
 *
 */

package javax.swing.colorchooser;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import com.sun.java.swing.SwingUtilities2;


/**
 * The standard preview panel for the color chooser.
 * <p>
 * <strong>Warning:</strong>
 * Serialized objects of this class will not be compatible with
 * future Swing releases. The current serialization support is
 * appropriate for short term storage or RMI between applications running
 * the same version of Swing.  As of 1.4, support for long term storage
 * of all JavaBeans<sup><font size="-2">TM</font></sup>
 * has been added to the <code>java.beans</code> package.
 * Please see {@link java.beans.XMLEncoder}.
 *
 * @version 1.13 12/19/03
 * @author Steve Wilson
 * @see JColorChooser
 */
class DefaultPreviewPanel extends JPanel {

    private int squareSize = 25;
    private int squareGap = 5;
    private int innerGap = 5;
  

    private int textGap = 5;
    private Font font = new Font("Dialog", Font.PLAIN, 12);
    private String sampleText = UIManager.getString("ColorChooser.sampleText");

    private int swatchWidth = 50;

    private Color oldColor = null;

    private JColorChooser getColorChooser() {
        return (JColorChooser)SwingUtilities.getAncestorOfClass(
                                   JColorChooser.class, this);
    }

    public Dimension getPreferredSize() {
        JComponent host = getColorChooser();
        if (host == null) {
            host = this;
        }
	FontMetrics fm = host.getFontMetrics(getFont());

	int ascent = fm.getAscent();
	int height = fm.getHeight();
	int width = SwingUtilities2.stringWidth(host, fm, sampleText);

        int y = height*3 + textGap*3;
	int x = squareSize * 3 + squareGap*2 + swatchWidth + width + textGap*3;
        return new Dimension( x,y );
    }

    public void paintComponent(Graphics g) {
        if (oldColor == null)
	    oldColor = getForeground();

        g.setColor(getBackground());
	g.fillRect(0,0,getWidth(),getHeight());

	if (this.getComponentOrientation().isLeftToRight()) {
	    int squareWidth = paintSquares(g, 0);
	    int textWidth = paintText(g, squareWidth);
	    paintSwatch(g, squareWidth + textWidth);
	} else {
	    int swatchWidth = paintSwatch(g, 0);
	    int textWidth = paintText(g, swatchWidth);
	    paintSquares(g , swatchWidth + textWidth);

	}
    }

    private int paintSwatch(Graphics g, int offsetX) {
        int swatchX = offsetX;
	g.setColor(oldColor);
	g.fillRect(swatchX, 0, swatchWidth, (squareSize) + (squareGap/2));
	g.setColor(getForeground());
	g.fillRect(swatchX, (squareSize) + (squareGap/2), swatchWidth, (squareSize) + (squareGap/2) );
	return (swatchX+swatchWidth);
    }

    private int paintText(Graphics g, int offsetX) {
	g.setFont(getFont());
        JComponent host = getColorChooser();
        if (host == null) {
            host = this;
        }
	FontMetrics fm = SwingUtilities2.getFontMetrics(host, g);

	int ascent = fm.getAscent();
	int height = fm.getHeight();
	int width = SwingUtilities2.stringWidth(host, fm, sampleText);

	int textXOffset = offsetX + textGap;

        Color color = getForeground();

	g.setColor(color);

        SwingUtilities2.drawString(host, g, sampleText,textXOffset+(textGap/2),
                                   ascent+2);

	g.fillRect(textXOffset,
		   ( height) + textGap, 
		   width + (textGap),
		   height +2);

	g.setColor(Color.black);
	SwingUtilities2.drawString(host, g, sampleText, 
		     textXOffset+(textGap/2), 
		     height+ascent+textGap+2);


	g.setColor(Color.white);

	g.fillRect(textXOffset,
		   ( height + textGap) * 2, 
		   width + (textGap),
		   height +2);

	g.setColor(color);
	SwingUtilities2.drawString(host, g, sampleText,
		     textXOffset+(textGap/2), 
		     ((height+textGap) * 2)+ascent+2);

	return width + textGap*3;
	
    }

    private int paintSquares(Graphics g, int offsetX) {

	int squareXOffset = offsetX;
        Color color = getForeground();

        g.setColor(Color.white);
	g.fillRect(squareXOffset,0,squareSize,squareSize);
	g.setColor(color);
	g.fillRect(squareXOffset+innerGap, 
		   innerGap, 
		   squareSize - (innerGap*2), 
		   squareSize - (innerGap*2));
	g.setColor(Color.white);
	g.fillRect(squareXOffset+innerGap*2,
		   innerGap*2,
		   squareSize - (innerGap*4),
		   squareSize - (innerGap*4));

        g.setColor(color);
	g.fillRect(squareXOffset,squareSize+squareGap,squareSize,squareSize);

	g.translate(squareSize+squareGap, 0);
        g.setColor(Color.black);
	g.fillRect(squareXOffset,0,squareSize,squareSize);
	g.setColor(color);
	g.fillRect(squareXOffset+innerGap, 
		   innerGap, 
		   squareSize - (innerGap*2), 
		   squareSize - (innerGap*2));
	g.setColor(Color.white);
	g.fillRect(squareXOffset+innerGap*2,
		   innerGap*2,
		   squareSize - (innerGap*4),
		   squareSize - (innerGap*4));
	g.translate(-(squareSize+squareGap), 0);

	g.translate(squareSize+squareGap, squareSize+squareGap);
        g.setColor(Color.white);
	g.fillRect(squareXOffset,0,squareSize,squareSize);
	g.setColor(color);
	g.fillRect(squareXOffset+innerGap, 
		   innerGap, 
		   squareSize - (innerGap*2), 
		   squareSize - (innerGap*2));
	g.translate(-(squareSize+squareGap), -(squareSize+squareGap));
	


	g.translate((squareSize+squareGap)*2, 0);
        g.setColor(Color.white);
	g.fillRect(squareXOffset,0,squareSize,squareSize);
	g.setColor(color);
	g.fillRect(squareXOffset+innerGap, 
		   innerGap, 
		   squareSize - (innerGap*2), 
		   squareSize - (innerGap*2));
	g.setColor(Color.black);
	g.fillRect(squareXOffset+innerGap*2,
		   innerGap*2,
		   squareSize - (innerGap*4),
		   squareSize - (innerGap*4));
	g.translate(-((squareSize+squareGap)*2), 0);

	g.translate((squareSize+squareGap)*2, (squareSize+squareGap));
        g.setColor(Color.black);
	g.fillRect(squareXOffset,0,squareSize,squareSize);
	g.setColor(color);
	g.fillRect(squareXOffset+innerGap, 
		   innerGap, 
		   squareSize - (innerGap*2), 
		   squareSize - (innerGap*2));
	g.translate(-((squareSize+squareGap)*2), -(squareSize+squareGap));

	return (squareSize*3+squareGap*2);

    }

}
