/*
 * @(#)src/classes/sov/javax/swing/LayoutComparator.java, swing, asdev, 20060428 1.10
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 60083  150503 chenerys Ensure ClassCastException thrown in compare, not NPE
 * 74904  071004 chenerys  Upgrade to 5.0 Swing 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)LayoutComparator.java	1.7 04/02/05
 *
 */
package javax.swing;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Window;


/**
 * Comparator which attempts to sort Components based on their size and
 * position. Code adapted from original javax.swing.DefaultFocusManager
 * implementation.
 *
 * @version 1.7, 02/05/04
 * @author David Mendenhall
 */
final class LayoutComparator implements Comparator, java.io.Serializable {

    private static final int ROW_TOLERANCE = 10;

    private boolean horizontal = true;
    private boolean leftToRight = true;

    void setComponentOrientation(ComponentOrientation orientation) {
	horizontal = orientation.isHorizontal();
	leftToRight = orientation.isLeftToRight();
    }

    public int compare(Object o1, Object o2) {
	Component a = (Component)o1;
	Component b = (Component)o2;

	if (a == b) {
	    return 0;
	}

	// Row/Column algorithm only applies to siblings. If 'a' and 'b'
	// aren't siblings, then we need to find their most inferior
	// ancestors which share a parent. Compute the ancestory lists for
	// each Component and then search from the Window down until the
	// hierarchy branches.
	if (a.getParent() != b.getParent()) {
	    LinkedList aAncestory, bAncestory;
            Component topNonWindow=null;/*ibm@60083*/

	    for(aAncestory = new LinkedList(); a != null; a = a.getParent()) {
		aAncestory.add(a);
		if (a instanceof Window) {
		    break;
		}
                topNonWindow=a;/*ibm@60083*/
	    }
	    if (a == null) {
		// 'a' is not part of a Window hierarchy. Can't cope.
		throw new ClassCastException("Top ancestor not a Window: "+
                                             topNonWindow.toString());/*ibm@60083*/
	    }

	    for(bAncestory = new LinkedList(); b != null; b = b.getParent()) {
		bAncestory.add(b);
		if (b instanceof Window) {
		    break;
		}
                topNonWindow=b;/*ibm@60083*/
	    }
	    if (b == null) {
		// 'b' is not part of a Window hierarchy. Can't cope.
		throw new ClassCastException("Top ancestor not a Window: "+
                                             topNonWindow.toString());/*ibm@60083*/
	    }

	    for (ListIterator
		     aIter = aAncestory.listIterator(aAncestory.size()),
		     bIter = bAncestory.listIterator(bAncestory.size()); ;) {
		if (aIter.hasPrevious()) {
		    a = (Component)aIter.previous();
		} else {
		    // a is an ancestor of b
		    return -1;
		}

		if (bIter.hasPrevious()) {
		    b = (Component)bIter.previous();
		} else {
		    // b is an ancestor of a
		    return 1;
		}

		if (a != b) {
		    break;
		}
	    }
	}

        int ax = a.getX(), ay = a.getY(), bx = b.getX(), by = b.getY();

	int zOrder = a.getParent().getComponentZOrder(a) - b.getParent().getComponentZOrder(b);
	if (horizontal) {
	    if (leftToRight) {

		// LT - Western Europe (optional for Japanese, Chinese, Korean)

		if (Math.abs(ay - by) < ROW_TOLERANCE) {
		    return (ax < bx) ? -1 : ((ax > bx) ? 1 : zOrder);
		} else {
		    return (ay < by) ? -1 : 1;
		}
	    } else { // !leftToRight

		// RT - Middle East (Arabic, Hebrew)

		if (Math.abs(ay - by) < ROW_TOLERANCE) {
		    return (ax > bx) ? -1 : ((ax < bx) ? 1 : zOrder);
		} else {
		    return (ay < by) ? -1 : 1;
		}
	    }
	} else { // !horizontal
	    if (leftToRight) {

		// TL - Mongolian

		if (Math.abs(ax - bx) < ROW_TOLERANCE) {
		    return (ay < by) ? -1 : ((ay > by) ? 1 : zOrder);
		} else {
		    return (ax < bx) ? -1 : 1;
		}
	    } else { // !leftToRight

		// TR - Japanese, Chinese, Korean

		if (Math.abs(ax - bx) < ROW_TOLERANCE) {
		    return (ay < by) ? -1 : ((ay > by) ? 1 : zOrder);
		} else {
		    return (ax > bx) ? -1 : 1;
		}
	    }
	}
    }
}
