/*
 * @(#)src/classes/sov/javax/sound/midi/MidiUnavailableException.java, audio, asdev, 20060428 1.18
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74919   220704  karagate  5.0 codemerge 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)MidiUnavailableException.java	1.13 03/12/19
 *
 */

package javax.sound.midi;		  


/**
 * A <code>MidiUnavailableException</code> is thrown when a requested MIDI 
 * component cannot be opened or created because it is unavailable.  This often
 * occurs when a device is in use by another application.  More generally, it
 * can occur when there is a finite number of a certain kind of resource that can 
 * be used for some purpose, and all of them are already in use (perhaps all by
 * this application).  For an example of the latter case, see the
 * {@link Transmitter#setReceiver(Receiver) setReceiver} method of 
 * <code>Transmitter</code>. 
 *
 * @version 1.13, 12/19/03
 * @author Kara Kytle
 */
public class MidiUnavailableException extends Exception {

    /**
     * Constructs a <code>MidiUnavailableException</code> that has 
     * <code>null</code> as its error detail message.
     */
    public MidiUnavailableException() {

	super();
    }


    /**
     *  Constructs a <code>MidiUnavailableException</code> with the 
     * specified detail message.
     *
     * @param message the string to display as an error detail message
     */
    public MidiUnavailableException(String message) {

	super(message);
    }
}
