/*
 * @(#)src/classes/sov/javax/sound/midi/InvalidMidiDataException.java, audio, asdev, 20060428 1.18
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74919   220704  karagate  5.0 codemerge 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)InvalidMidiDataException.java	1.11 03/12/19
 *
 */

package javax.sound.midi;		  


/**
 * An <code>InvalidMidiDataException</code> indicates that inappropriate MIDI 
 * data was encountered. This often means that the data is invalid in and of
 * itself, from the perspective of the MIDI specification.  An example would
 * be an undefined status byte.  However, the exception might simply
 * mean that the data was invalid in the context it was used, or that 
 * the object to which the data was given was unable to parse or use it.
 * For example, a file reader might not be able to parse a Type 2 MIDI file, even
 * though that format is defined in the MIDI specification.
 *
 * @version 1.11, 12/19/03
 * @author Kara Kytle
 */
public class InvalidMidiDataException extends Exception {

    /**
     * Constructs an <code>InvalidMidiDataException</code> with
     * <code>null</code> for its error detail message.
     */
    public InvalidMidiDataException() {

	super();
    }


    /**
     *  Constructs an <code>InvalidMidiDataException</code> with the 
     * specified detail message.
     *
     * @param message the string to display as an error detail message
     */
    public InvalidMidiDataException(String message) {

	super(message);
    }
}
