/*
 * @(#)src/classes/sov/javax/print/PrintException.java, print, asdev, 20060428 1.8
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */





/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 64632   250903 psuryana  Add IBM module header;
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

package javax.print;

/**
 * Class PrintException encapsulates a printing-related error condition that 
 * occurred while using a Print Service instance. This base class 
 * furnishes only a string description of the error. Subclasses furnish more 
 * detailed information if applicable.
 *
 */
public class PrintException extends Exception {


    /**
     * Construct a print exception with no detail message. 
     */
    public PrintException() {
    	super();
    }

    /**
     * Construct a print exception with the given detail message. 
     *
     * @param  s  Detail message, or null if no detail message.
     */
    public PrintException (String s) {
    	super (s);
    }
    
    /**
     * Construct a print exception chaining the supplied exception.
     *
     * @param  e  Chained exception.
     */
    public PrintException (Exception e) {
    	super ( e);
    }
    
    /**
     * Construct a print exception with the given detail message
     * and chained exception.
     * @param  s  Detail message, or null if no detail message.
     * @param  e  Chained exception.
     */
    public PrintException (String s, Exception e) {
    	super (s, e);
    }

}
