/*
 * @(#)src/classes/sov/javax/naming/ldap/UnsolicitedNotificationEvent.java, jndi, asdev, 20060428 1.11
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */



package javax.naming.ldap;

/**
 * This class represents an event fired in response to an unsolicited
 * notification sent by the LDAP server.
 * 
 * @author Rosanna Lee
 * @author Scott Seligman
 * @author Vincent Ryan
 * @version 1.8 03/12/19
 *
 * @see UnsolicitedNotification
 * @see UnsolicitedNotificationListener
 * @see javax.naming.event.EventContext#addNamingListener
 * @see javax.naming.event.EventDirContext#addNamingListener
 * @see javax.naming.event.EventContext#removeNamingListener
 * @since 1.3
 */

public class UnsolicitedNotificationEvent extends java.util.EventObject {
    /**
     * The notification that caused this event to be fired.
     * @serial
     */
    private UnsolicitedNotification notice;

    /**
     * Constructs a new instance of <tt>UnsolicitedNotificationEvent</tt>.
     * 
     * @param src The non-null source that fired the event.
     * @param notice The non-null unsolicited notification.
     */
    public UnsolicitedNotificationEvent(Object src, 
	UnsolicitedNotification notice) {
	super(src);
	this.notice = notice;
    }
	

    /**
     * Returns the unsolicited notification.
     * @return The non-null unsolicited notification that caused this
     * event to be fired.
     */
    public UnsolicitedNotification getNotification() {
	return notice;
    }

    /**
     * Invokes the <tt>notificationReceived()</tt> method on
     * a listener using this event.
     * @param listener The non-null listener on which to invoke
     * <tt>notificationReceived</tt>.
     */
    public void dispatch(UnsolicitedNotificationListener listener) {
	listener.notificationReceived(this);
    }

    private static final long serialVersionUID = -2382603380799883705L;
}
