/*
 * @(#)src/classes/sov/javax/naming/directory/InvalidAttributesException.java, jndi, asdev, 20060428 1.9
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */



package javax.naming.directory;

import javax.naming.NamingException;

/**
  * This exception is thrown when an attempt is
  * made to add or modify an attribute set that has been specified
  * incompletely or incorrectly. This could happen, for example, 
  * when attempting to add or modify a binding, or to create a new 
  * subcontext without specifying all the mandatory attributes
  * required for creation of the object.  Another situation in
  * which this exception is thrown is by specification of incompatible
  * attributes within the same attribute set, or attributes in conflict
  * with that specified by the object's schema.
  * <p>
  * Synchronization and serialization issues that apply to NamingException
  * apply directly here.
  *
  * @author Rosanna Lee
  * @author Scott Seligman
  * @version 1.7 03/12/19
  * @since 1.3
  */

public class InvalidAttributesException extends NamingException {
    /**
     * Constructs a new instance of InvalidAttributesException using an
     * explanation. All other fields are set to null.
     * @param	explanation	Additional detail about this exception. Can be null.
     * @see java.lang.Throwable#getMessage
     */
    public InvalidAttributesException(String explanation) {
	super(explanation);
    }

    /**
      * Constructs a new instance of InvalidAttributesException.
      * All fields are set to null.
      */
    public InvalidAttributesException() {
	super();
    }

    /**
     * Use serialVersionUID from JNDI 1.1.1 for interoperability
     */
    private static final long serialVersionUID = 2607612850539889765L;
}
