/*
 * @(#)src/classes/sov/javax/naming/directory/InvalidAttributeIdentifierException.java, jndi, asdev, 20060428 1.9
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */



package javax.naming.directory;

import javax.naming.NamingException;

/**
  * This exception is thrown when an attempt is
  * made to add to create an attribute with an invalid attribute identifier.
  * The validity of an attribute identifier is directory-specific.
  * <p>
  * Synchronization and serialization issues that apply to NamingException
  * apply directly here.
  *
  * @author Rosanna Lee
  * @author Scott Seligman
  * @version 1.7 03/12/19
  * @since 1.3
  */

public class InvalidAttributeIdentifierException extends NamingException {
    /**
     * Constructs a new instance of InvalidAttributeIdentifierException using the
     * explanation supplied. All other fields set to null.
     * @param	explanation	Possibly null string containing additional detail about this exception.
     * @see java.lang.Throwable#getMessage
     */
    public InvalidAttributeIdentifierException(String explanation) {
	super(explanation);
    }

    /**
      * Constructs a new instance of InvalidAttributeIdentifierException.
      * All fields are set to null.
      */
    public InvalidAttributeIdentifierException() {
	super();
    }

    /**
     * Use serialVersionUID from JNDI 1.1.1 for interoperability
     */
    private static final long serialVersionUID = -9036920266322999923L;
}
