/*
 * @(#)src/classes/sov/javax/naming/NameParser.java, jndi, asdev, 20060428 1.9
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */



package javax.naming;

/**
  * This interface is used for parsing names from a hierarchical
  * namespace.  The NameParser contains knowledge of the syntactic
  * information (like left-to-right orientation, name separator, etc.)
  * needed to parse names.
  *
  * The equals() method, when used to compare two NameParsers, returns
  * true if and only if they serve the same namespace.
  *
  * @author Rosanna Lee
  * @author Scott Seligman
  * @version 1.8 04/05/05
  *
  * @see CompoundName
  * @see Name
  * @since 1.3
  */

public interface NameParser {
	/**
	  * Parses a name into its components.
	  *
	  * @param name The non-null string name to parse.
	  * @return A non-null parsed form of the name using the naming convention
	  * of this parser.
          * @exception InvalidNameException If name does not conform to
          * 	syntax defined for the namespace.
          * @exception NamingException If a naming exception was encountered.
	  */
	Name parse(String name)	throws NamingException;
}
