/*
 * @(#)src/classes/sov/javax/management/remote/JMXServerErrorException.java, management, asdev, 20060428 1.3
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)JMXServerErrorException.java	1.10 03/12/19
 * 
 */


package javax.management.remote;

import java.io.IOException;

// imports for javadoc
import javax.management.MBeanServer;

/**
 * Exception thrown as the result of a remote {@link MBeanServer}
 * method invocation when an <code>Error</code> is thrown while
 * processing the invocation in the remote MBean server.  A
 * <code>JMXServerErrorException</code> instance contains the original
 * <code>Error</code> that occurred as its cause.
 *
 * @see java.rmi.ServerError
 * @since 1.5
 * @since.unbundled 1.0
 */
public class JMXServerErrorException extends IOException {

    private static final long serialVersionUID = 3996732239558744666L;

    /**
     * Constructs a <code>JMXServerErrorException</code> with the specified
     * detail message and nested error.
     *
     * @param s the detail message.
     * @param err the nested error.  An instance of this class can be
     * constructed where this parameter is null, but the standard
     * connectors will never do so.
     */
    public JMXServerErrorException(String s, Error err) {
	super(s);
	cause = err;
    }

    public Throwable getCause() {
	return cause;
    }

    /**
     * @serial An {@link Error} that caused this exception to be thrown.
     * @see #getCause()
     **/
    private final Error cause;
}
