/*
 * @(#)src/classes/sov/javax/management/RuntimeOperationsException.java, management, asdev, 20060428 1.3
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)RuntimeOperationsException.java	4.19 03/12/19
 * 
 */

package javax.management; 



/**
 * Represents runtime exceptions thrown in the agent when performing operations on MBeans. 
 * It wraps the actual <CODE>java.lang.RuntimeException</CODE> thrown.
 *
 * @since 1.5
 */
public class RuntimeOperationsException extends JMRuntimeException   { 

    /* Serial version */
    private static final long serialVersionUID = -8408923047489133588L;

    /**
     * @serial The encapsulated {@link RuntimeException}
     */
    private java.lang.RuntimeException runtimeException ;


    /**
     * Creates a <CODE>RuntimeOperationsException</CODE> that wraps the actual <CODE>java.lang.RuntimeException</CODE>.
     *
     * @param e the wrapped exception.
     */
    public RuntimeOperationsException(java.lang.RuntimeException e) { 
	super() ;
	runtimeException = e ;
    } 
   
    /**
     * Creates a <CODE>RuntimeOperationsException</CODE> that wraps the actual <CODE>java.lang.RuntimeException</CODE>
     * with a detailed message.
     *
     * @param e the wrapped exception.
     * @param message the detail message.
     */
    public RuntimeOperationsException(java.lang.RuntimeException e, String message) { 
	super(message);
	runtimeException = e ;
    } 
    
    /**
     * Returns the actual {@link RuntimeException} thrown.
     *
     * @return the wrapped {@link RuntimeException}.
     */
    public java.lang.RuntimeException getTargetException()  { 
	return runtimeException ;
    } 
    
    /**
     * Returns the actual {@link RuntimeException} thrown.
     *
     * @return the wrapped {@link RuntimeException}.
     */
    public Throwable getCause() {
	return runtimeException;
    }
}
