/*
 * @(#)src/classes/sov/javax/management/DescriptorAccess.java, management, asdev, 20060428 1.3
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)file      DescriptorAccess.java
 * @(#)author    IBM Corp.
 * @(#)version   1.17
 * @(#)lastedit      03/12/19
 */
/*
 * 
 * The program is provided "as is" without any warranty express or implied,
 * including the warranty of non-infringement and the implied warranties of
 * merchantibility and fitness for a particular purpose. IBM will not be
 * liable for any damages suffered by you or any third party claim against 
 * you regarding the Program.
 *
 * 
 * Ce logiciel est propriete de Sun Microsystems, Inc.
 * Distribue par des licences qui en restreignent l'utilisation. 
 *
 */


package javax.management;


/**
 * This interface is used to gain access to descriptors of the Descriptor class 
 * which are associated with a JMX component, i.e. MBean, MBeanInfo, 
 * MBeanAttributeInfo, MBeanNotificationInfo,
 * MBeanOperationInfo, MBeanParameterInfo.
 * <P>
 * ModelMBeans make extensive use of this interface in ModelMBeanInfo classes.
 *
 * @since 1.5
 */
public interface DescriptorAccess
{
    /** 
    * Returns a copy of Descriptor.
    *
    * @return Descriptor associated with the component implementing this interface.
    * Null should never be returned. At a minimum a default descriptor with the 
    * descriptor name and descriptorType should be returned.
    *
    * @see #setDescriptor
    */
    public Descriptor getDescriptor();
    
    /**
    * Sets Descriptor (full replace).
    *
    * @param inDescriptor replaces the Descriptor associated with the 
    * component implementing this interface. If the inDescriptor is invalid for the
    * type of Info object it is being set for, an exception is thrown.  If the
    * inDescriptor is null, then the Descriptor will revert to its default value
    * which should contain, at a minimum, the descriptor name and descriptorType.
    * 
    * @see #getDescriptor
    */
    public void setDescriptor(Descriptor inDescriptor);
}
