/*
 * @(#)src/classes/sov/javax/accessibility/AccessibleStreamable.java, accessibility, asdev, 20060428 1.3
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 74911  271004 chenerys  Upgrade to 5.0 Accessibility 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/**
 * @(#)AccessibleStreamable.java	1.3 03/12/19
 *
 */

package javax.accessibility;

import java.io.InputStream;
import java.awt.datatransfer.DataFlavor;

/*
 *
 * The <code>AccessibleStreamable</code> interface should be implemented
 * by the <code>AccessibleContext</code> of any component that presents the
 * raw stream behind a component on the display screen.  Examples of such
 * components are HTML, bitmap images and MathML.  An object that implements
 * <code>AccessibleStreamable</code> provides two things: a list of MIME
 * types supported by the object and a streaming interface for each MIME type to
 * get the data.
 *
 * @version 1.3 12/19/03
 * @author Lynn Monsanto
 * @author Peter Korn
 *
 * @see javax.accessibility.AccessibleContext
 * @since 1.5
 */
public interface AccessibleStreamable {
    /**
      * Returns an array of DataFlavor objects for the MIME types
      * this object supports.
      *
      * @return an array of DataFlavor objects for the MIME types
      * this object supports.
      */
     DataFlavor[] getMimeTypes();
 
    /**
      * Returns an InputStream for a DataFlavor
      *
      * @param flavor the DataFlavor
      * @return an ImputStream if an ImputStream for this DataFlavor exists.  
      * Otherwise, null is returned.
      */
     InputStream getStream(DataFlavor flavor);
}
