/*
 * @(#)src/classes/sov/java/nio/charset/IllegalCharsetNameException.java, i18n, asdev, 20060428 1.4
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */




/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio.charset;

/**
 * Unchecked exception thrown when a string that is not a
 * <a href=Charset.html#names>legal charset name</a> is used as such.
 *
 * @version 1.2, 01/09/17
 * @since 1.4
 */

public class IllegalCharsetNameException extends IllegalArgumentException {

   private String charsetName;

   /**
    * Constructs an instance of this class. </p>
    *
    * @param  charsetName
    *         The illegal charset name
    */
   public IllegalCharsetNameException(String charsetName) {
      super(String.valueOf(charsetName));
      this.charsetName = charsetName;
   }

   /**
    * Retrieves the illegal charset name. </p>
    *
    * @return  The illegal charset name
    */
   public String getCharsetName() {
      return charsetName;
   }

}
