/*
 * @(#)src/classes/sov/java/nio/HeapIntBufferR.java, nio, asdev, 20060428 1.5
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)Heap-X-Buffer.java	1.28 03/12/19
 *
 */

// -- This file was mechanically generated: Do not edit! -- //

package java.nio;


/**



 * A read-only HeapIntBuffer.  This class extends the corresponding
 * read/write class, overriding the mutation methods to throw a {@link
 * ReadOnlyBufferException} and overriding the view-buffer methods to return an
 * instance of this class rather than of the superclass.

 */

class HeapIntBufferR
    extends HeapIntBuffer
{

    // For speed these fields are actually declared in X-Buffer;
    // these declarations are here as documentation
    /*




    */

    HeapIntBufferR(int cap, int lim) {		// package-private







	super(cap, lim);
	this.isReadOnly = true;

    }

    HeapIntBufferR(int[] buf, int off, int len) { // package-private







	super(buf, off, len);
	this.isReadOnly = true;

    }

    protected HeapIntBufferR(int[] buf,
				   int mark, int pos, int lim, int cap,
				   int off)
    {







	super(buf, mark, pos, lim, cap, off);
	this.isReadOnly = true;

    }

    public IntBuffer slice() {
	return new HeapIntBufferR(hb,
					-1,
					0,
					this.remaining(),
					this.remaining(),
					this.position() + offset);
    }

    public IntBuffer duplicate() {
	return new HeapIntBufferR(hb,
					this.markValue(),
					this.position(),
					this.limit(),
					this.capacity(),
					offset);
    }

    public IntBuffer asReadOnlyBuffer() {








	return duplicate();

    }






























    public boolean isReadOnly() {
	return true;
    }

    public IntBuffer put(int x) {




	throw new ReadOnlyBufferException();

    }

    public IntBuffer put(int i, int x) {




	throw new ReadOnlyBufferException();

    }

    public IntBuffer put(int[] src, int offset, int length) {








	throw new ReadOnlyBufferException();

    }

    public IntBuffer put(IntBuffer src) {























	throw new ReadOnlyBufferException();

    }

    public IntBuffer compact() {






	throw new ReadOnlyBufferException();

    }



































































































































































































































































































































































    public ByteOrder order() {
	return ByteOrder.nativeOrder();
    }



}
