/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsShortBufferRB.java, nio, asdev, 20060428 1.5
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)ByteBufferAs-X-Buffer.java	1.16 03/12/19
 *
 */

// -- This file was mechanically generated: Do not edit! -- //

package java.nio;


class ByteBufferAsShortBufferRB			// package-private
    extends ByteBufferAsShortBufferB
{








    ByteBufferAsShortBufferRB(ByteBuffer bb) {	// package-private












	super(bb);

    }

    ByteBufferAsShortBufferRB(ByteBuffer bb,
				     int mark, int pos, int lim, int cap,
				     int off)
    {





	super(bb, mark, pos, lim, cap, off);

    }

    public ShortBuffer slice() {
	int pos = this.position();
	int lim = this.limit();
	assert (pos <= lim);
	int rem = (pos <= lim ? lim - pos : 0);
	int off = (pos << 1) + offset;
	return new ByteBufferAsShortBufferRB(bb, -1, 0, rem, rem, off);
    }

    public ShortBuffer duplicate() {
	return new ByteBufferAsShortBufferRB(bb,
						    this.markValue(),
						    this.position(),
						    this.limit(),
						    this.capacity(),
						    offset);
    }

    public ShortBuffer asReadOnlyBuffer() {








	return duplicate();

    }

















    public ShortBuffer put(short x) {




	throw new ReadOnlyBufferException();

    }

    public ShortBuffer put(int i, short x) {




	throw new ReadOnlyBufferException();

    }

    public ShortBuffer compact() {
















	throw new ReadOnlyBufferException();

    }

    public boolean isDirect() {
	return bb.isDirect();
    }

    public boolean isReadOnly() {
	return true;
    }








































    public ByteOrder order() {

	return ByteOrder.BIG_ENDIAN;




    }

}
