/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsShortBufferL.java, nio, asdev, 20060428 1.5
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)ByteBufferAs-X-Buffer.java	1.16 03/12/19
 *
 */

// -- This file was mechanically generated: Do not edit! -- //

package java.nio;


class ByteBufferAsShortBufferL			// package-private
    extends ShortBuffer
{



    protected final ByteBuffer bb;
    protected final int offset;



    ByteBufferAsShortBufferL(ByteBuffer bb) {	// package-private

	super(-1, 0,
	      bb.remaining() >> 1,
	      bb.remaining() >> 1);
	this.bb = bb;
	// enforce limit == capacity
	int cap = this.capacity();
	this.limit(cap);
	int pos = this.position();
	assert (pos <= cap);
	offset = pos;



    }

    ByteBufferAsShortBufferL(ByteBuffer bb,
				     int mark, int pos, int lim, int cap,
				     int off)
    {

	super(mark, pos, lim, cap);
	this.bb = bb;
	offset = off;



    }

    public ShortBuffer slice() {
	int pos = this.position();
	int lim = this.limit();
	assert (pos <= lim);
	int rem = (pos <= lim ? lim - pos : 0);
	int off = (pos << 1) + offset;
	return new ByteBufferAsShortBufferL(bb, -1, 0, rem, rem, off);
    }

    public ShortBuffer duplicate() {
	return new ByteBufferAsShortBufferL(bb,
						    this.markValue(),
						    this.position(),
						    this.limit(),
						    this.capacity(),
						    offset);
    }

    public ShortBuffer asReadOnlyBuffer() {

	return new ByteBufferAsShortBufferRL(bb,
						 this.markValue(),
						 this.position(),
						 this.limit(),
						 this.capacity(),
						 offset);



    }



    protected int ix(int i) {
	return (i << 1) + offset;
    }

    public short get() {
	return Bits.getShortL(bb, ix(nextGetIndex()));
    }

    public short get(int i) {
	return Bits.getShortL(bb, ix(checkIndex(i)));
    }



    public ShortBuffer put(short x) {

	Bits.putShortL(bb, ix(nextPutIndex()), x);
	return this;



    }

    public ShortBuffer put(int i, short x) {

	Bits.putShortL(bb, ix(checkIndex(i)), x);
	return this;



    }

    public ShortBuffer compact() {

	int pos = position();
	int lim = limit();
	assert (pos <= lim);
	int rem = (pos <= lim ? lim - pos : 0);

	ByteBuffer db = bb.duplicate();
 	db.limit(ix(lim));
	db.position(ix(0));
	ByteBuffer sb = db.slice();
	sb.position(pos << 1);
	sb.compact();
 	position(rem);
	limit(capacity());
	return this;



    }

    public boolean isDirect() {
	return bb.isDirect();
    }

    public boolean isReadOnly() {
	return false;
    }








































    public ByteOrder order() {




	return ByteOrder.LITTLE_ENDIAN;

    }

}
