/*
 * @(#)src/classes/sov/java/lang/StringCoding.java, i18n, asdev, 20060428 1.15
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */






/*
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    --------------------------------------------------
 *  39354  011213 kwb       Rewrite as part of 1.4 integration
 *  39789  020104 kwb       Catch and ignore MalformedInput in encode and decode
 *  52333  020627 kwb       Keep preceeding text on malformed input
 *  55142  170902 kwb       Fix the detection of bad file.encoding
 *  55235  240902 kwb       Fix error action for nio converters
 *  55582  270902 kwb       Another fix for the error path
 *  61845  010703 venkatgk  String conversion from MS932 to UTF8
 *  64726.1 120304 smithwil Handle IllegalCharsetNameException
 *  86874  180405 stalleyj  Handle IllegalCharsetNameException in getDecoder
 *
 * Notes:
 *     This version is a major rewrite of the Sun code.  Be very careful
 *     porting Sun changes into this code.
 *
 *     The Sun code uses nio charsets ahead of sun.io converters.  Here
 *     the sun.io converters are used ahead of nio charsets.
 *
 *     This code implements the logic for both converters and charsets that
 *     malformed input is ignored, and unmappable characters are substituted.
 *
 *     String converter performance is very critical to some applications.
 *     Make sure that changes for JDK 1.4 do not hurt performance.
 */
//ibm.39354  Rewrite of the entire file - do not use the Sun source

package java.lang;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.security.PrivilegedActionException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import sun.io.MalformedInputException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.Converters;
import sun.misc.MessageUtils;                                        //ibm.55142


/**
 * Utility class for string encoding and decoding.
 */

class StringCoding {

    private StringCoding() { }

    /* The cached coders for each thread
     */
    private static ThreadLocal decoder = new ThreadLocal();
    private static ThreadLocal encoder = new ThreadLocal();


    /*
     * Keep an n-way decoder cache per thread
     */
    private final static class DecoderCache {
        private static final int CACHE_SIZE = 6;
        private int    max = 0;
        private int    reuse   = 0;
        private int    current = 0;
        private String encoding [] = new String[CACHE_SIZE];
        private Object decoders [] = new Object[CACHE_SIZE];

        /*
         * Make a decoder or converter by name
         */
        Object makeDecoder(final String enc) {
            String encoding = enc;
            if (enc.equals("\uFFFC"))
                encoding = Converters.getDefaultEncodingName();
            try {
                return (Object)ByteToCharConverter.getConverter(encoding);
            } catch (UnsupportedEncodingException e) {
            }
            Charset cs;
            try {
                cs = Charset.forName(encoding);
            } catch (UnsupportedCharsetException x) {
                //ibm.55142, 55582 start
                Object ret = null;
                if (enc.equals("\uFFFC")) {
                    String oldenc = encoding;
                    while (ret == null) {
                        encoding = Converters.getFallbackEncoding(encoding);
                        if (encoding == null)
                            break;
                        ret = makeDecoder(encoding);
                    }
                    warnUnsupportedCharset(oldenc, ret);
                }
                return ret;
                //ibm.55142, 55582  end
            }
            return (Object)(cs.newDecoder()
                .onMalformedInput(CodingErrorAction.IGNORE)          //ibm.55235
                .onUnmappableCharacter(CodingErrorAction.REPLACE));  //ibm.55235
        }

        /*
         * Get a decoder or converter by name
         */
        Object getDecoder(final String enc)
             throws UnsupportedEncodingException {
            Object obj;

            /* In the normal case we are using the same as previous */
            if (max > 0 && encoding[current].equals(enc)) {
                return  decoders[current];
            }

            /* Try the others entries in the cache */
            int i;
            for (i=0; i<max; i++) {
                if (i!=current && encoding[i].equals(enc)) {
                    current = i;
                    return decoders[i];
                }
            }
            try {
                obj = (java.security.AccessController.doPrivileged(
                    new java.security.PrivilegedExceptionAction() {
                        public Object run () {
                            return makeDecoder(enc);
                        }
                    }
                ));
            } catch (PrivilegedActionException e) {
                throw (UnsupportedEncodingException)e.getException();
            } catch (java.nio.charset.IllegalCharsetNameException ee) { /*ibm@86874*/
                throw new UnsupportedEncodingException(enc);            /*ibm@86874*/
            }                                                           /*ibm@86874*/

            if (obj==null) {
                throw new UnsupportedEncodingException(enc);
            }

            /* Determine position to reuse and fill in cache */
            if (max < CACHE_SIZE) {
                i = max++;
            } else {
                i = reuse++;             /* round robin replacement */
                if (reuse == CACHE_SIZE)
                    reuse = 0;
            }
            decoders[i] = obj;
            encoding[i] = enc;
            current = i;
            return obj;
        }
    }


    /*
     * Keep an n-way encoder cache per thread
     */
    private final static class EncoderCache {
        private static final int CACHE_SIZE = 6;
        private int    max = 0;
        private int    reuse   = 0;
        private int    current = 0;
        private String encoding [] = new String[CACHE_SIZE];
        private Object encoders [] = new Object[CACHE_SIZE];

        /*
         * Make a decoder or converter by name
         */
        Object makeEncoder(final String enc) {
            String encoding = enc;
            if (enc.equals("\uFFFC"))
                encoding = Converters.getDefaultEncodingName();
            try {
                return (Object)CharToByteConverter.getConverter(encoding);
            } catch (UnsupportedEncodingException e) {}
            Charset cs;
            try {
                cs = Charset.forName(encoding);
            } catch (UnsupportedCharsetException x) {
                //ibm.55142, 55582  start
                Object ret = null;
                if (enc.equals("\uFFFC")) {
                    String oldenc = encoding;
                    while (ret == null) {
                        encoding = Converters.getFallbackEncoding(encoding);
                        if (encoding == null)
                            break;
                        ret = makeEncoder(encoding);
                    }
                    warnUnsupportedCharset(oldenc, ret);
                }
                return ret;
                //ibm.55142, 55582  end
            }
            return cs.newEncoder()
                .onMalformedInput(CodingErrorAction.IGNORE)          //ibm.55235
                .onUnmappableCharacter(CodingErrorAction.REPLACE);   //ibm.55235
        }

        /*
         * Get a decoder or converter by name
         */
        Object getEncoder(final String enc)
             throws UnsupportedEncodingException {
            Object obj;

            /* In the normal case we are using the same as previous */
            if (max > 0 && encoding[current].equals(enc)) {
                return  encoders[current];
            }

            /* Try the others entries in the cache */
            int i;
            for (i=0; i<max; i++) {
                if (i!=current && encoding[i].equals(enc)) {
                    current = i;
                    return encoders[i];
                }
            }
            try {
                obj = (java.security.AccessController.doPrivileged(
                    new java.security.PrivilegedExceptionAction() {
                        public Object run () {
                            return makeEncoder(enc);
                        }
                    }
                ));
            } catch (PrivilegedActionException e) {
                throw (UnsupportedEncodingException)e.getException();
            } catch (java.nio.charset.IllegalCharsetNameException ee) { //ibm@64726.1
                throw new UnsupportedEncodingException(enc);            //ibm@64726.1
            }                                                           //ibm@64726.1

            if (obj==null) {
                throw new UnsupportedEncodingException(enc);
            }

            /* Determine position to reuse and fill in cache */
            if (max < CACHE_SIZE) {
                i = max++;
            } else {
                i = reuse++;             /* round robin replacement */
                if (reuse == CACHE_SIZE)
                    reuse = 0;
            }
            encoders[i] = obj;
            encoding[i] = enc;
            current = i;
            return obj;
        }
    }


   /*
    * Returns an Decoder from the cache
    */
    private static Object getDecoder(final String encoding)
                                  throws UnsupportedEncodingException {
        /*
         * Put all object creation inside a doPriv so that it appears on
         * the middleware heap, and not as a cross heap reference
         */
        DecoderCache cache;

        cache = (DecoderCache)decoder.get();
        if (cache == null) {
            cache = (DecoderCache) (
            java.security.AccessController.doPrivileged(
                new java.security.PrivilegedAction() {
                public Object run () {
                    return new DecoderCache();
                }
            }
            ));
            decoder.set(cache);
        }
        return cache.getDecoder(encoding);
    }


   /*
    * Returns an Encoder from the cache
    */
    private static Object getEncoder(final String encoding)
                                  throws UnsupportedEncodingException {
        /*
         * Put all object creation inside a doPriv so that it appears on
         * the middleware heap, and not as a cross heap reference
         */
        EncoderCache cache;

        cache = (EncoderCache)encoder.get();
        if (cache == null) {
            cache = (EncoderCache) (
            java.security.AccessController.doPrivileged(
                new java.security.PrivilegedAction() {
                public Object run () {
                    return new EncoderCache();
                }
            }
            ));
            encoder.set(cache);
        }
        return cache.getEncoder(encoding);
    }


    /*
     * Trim the given byte array to the given length
     */
    private static byte[] trim(byte[] ba, int len) {
        if (len == ba.length)
            return ba;
        byte[] tba = new byte[len];
        System.arraycopy(ba, 0, tba, 0, len);
        return tba;
    }


    /*
     * Trim the given char array to the given length
     */
    private static char[] trim(char[] ca, int len) {
        if (len == ca.length)
            return ca;
        char[] tca = new char[len];
        System.arraycopy(ca, 0, tca, 0, len);
        return tca;
    }


    /*
     * Warn about unsupported charset
     */
    private static void warnUnsupportedCharset(String csn, Object coder) {
        if (coder == null) {
            /* This is a fatal condition */
            MessageUtils.err("Error: The encoding ISO-8859-1 is not available.");
            System.exit(1);
        }
        String name = coder.toString();
        int ix = name.indexOf(": ");
        if (ix>=0)
            name = name.substring(ix+2);
        Converters.setDefaultEncodingName(name);
        MessageUtils.err("[ Warning: The encoding '" + csn +
                         "' is not supported; using '" + name + "' instead. ]");
    }


    /*
     * Decode from a named charset
     */
    static char[] decode(String charsetName, byte[] ba, int off, int len)
        throws UnsupportedEncodingException {
        Object obj = getDecoder(charsetName);

        /*
         * ByteToCharConverter
         */
        if (obj instanceof ByteToCharConverter) {
            ByteToCharConverter b2c = (ByteToCharConverter)obj;
            int en = b2c.getMaxCharsPerByte() * len;
            char[] ca = new char[en];
            if (len == 0)
                return ca;

            b2c.reset();

            /*
             * Loop thru the buffer ingoring MalforedInput
             */
            int outlen = 0;
            int inend  = off+len;
            for (;;) {
                try {
                    outlen += b2c.convert(ba, off, inend, ca, outlen, en); /*ibm@61845*/
                    break;
                } catch (MalformedInputException x) {
                    int newoff = b2c.nextByteIndex() + b2c.getBadInputLength();
                    if (newoff <= off)   /* paranoid check for loop */
                        break;
                    off = newoff;
                    outlen = b2c.nextCharIndex();       //ibm.52333
                } catch (Exception e) {
                    throw new Error(e);
                }
            }

            /*
             * Fast return for single byte.  We can do this because neither
             * flush() nor trim is required.
             *
            if (en == outlen)
                return ca;

            /*
             * Flush the converter and trim the output
             */
            try {
                outlen += b2c.flush(ca, b2c.nextCharIndex(), en);
            } catch (MalformedInputException x) {
            } catch (Exception e) {
                throw new Error(e);
            }
            return trim(ca, outlen);
        }

        /*
         * Charset Decoder
         */
        else {
            CharsetDecoder cd = (CharsetDecoder)obj;
            int en = (int)(cd.maxCharsPerByte() * len);
            char[] ca = new char[en];
            if (len == 0)
                return ca;
            cd.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
            CharBuffer cb = CharBuffer.wrap(ca);
            CoderResult cr = cd.decode(bb, cb, true);
            cr = cd.flush(cb);
            return trim(ca, cb.position());
        }
    }


    /*
     * Decode from the default charset
     */
    static char[] decode(byte[] ba, int off, int len) {
        try {
            return decode("\ufffc", ba, off, len);
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }


    /*
     * Encode to a named charset
     */
    static byte[] encode(String charsetName, char[] ca, int off, int len)
        throws UnsupportedEncodingException {
        Object obj = getEncoder(charsetName);

        /*
         * CharToByteConverter
         */
        if (obj instanceof CharToByteConverter) {
            CharToByteConverter c2b = (CharToByteConverter)obj;
            int    en = c2b.getMaxBytesPerChar() * len;
            byte[] ba = new byte[en];
            if (len == 0)
                return ba;

            c2b.reset();
            int outlen = 0;
            int inend  = off+len;
            for (;;) {
                try {
                    outlen += c2b.convert(ca, off, inend, ba, outlen, en);
                    break;
                } catch (MalformedInputException e) {
                    /* Ignore malformed input.  Be paranoid about badInputLength */
                    int newoff = c2b.nextCharIndex() + c2b.getBadInputLength();
                    if (newoff <= off)
                        break;
                    off = newoff;
                    outlen = c2b.nextByteIndex();     //ibm.52333
                } catch (Exception e) {
                    throw new Error(e);           /* Should never happen */
                }
            }
            try {
                outlen += c2b.flush(ba, c2b.nextByteIndex(), en);
            } catch (MalformedInputException x) {
            } catch (Exception e) {
                throw new Error(e);
            }
            return trim(ba, outlen);
        }

        /*
         * Charset Encoder
         */
        else {
            CharsetEncoder ce = (CharsetEncoder)obj;
            int en = (int)(ce.maxBytesPerChar() * len);
            byte[] ba = new byte[en];
            if (len == 0)
                return ba;

            ce.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba);
            CharBuffer cb = CharBuffer.wrap(ca, off, len);
            CoderResult cr = ce.encode(cb, bb, true);
            cr = ce.flush(bb);
            return trim(ba, bb.position());
        }
    }


    /*
     * Encode to the default charset
     */
    static byte[] encode(char[] ca, int off, int len) {
        try {
            return encode("\ufffc", ca, off, len);
        } catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}
