/*
 * @(#)src/classes/sov/java/beans/beancontext/BeanContextServiceRevokedListener.java, bean, asdev, 20060428 1.11
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */

/*
 * @(#)BeanContextServiceRevokedListener.java	1.9 03/12/19
 *
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContextServiceRevokedEvent;

import java.util.EventListener;

/**
 *  The listener interface for receiving 
 * <code>BeanContextServiceRevokedEvent</code> objects. A class that is 
 * interested in processing a <code>BeanContextServiceRevokedEvent</code>
 * implements this interface. 
 */
public interface BeanContextServiceRevokedListener extends EventListener {

    /**
     * The service named has been revoked. getService requests for
     * this service will no longer be satisifed.
     * @param bcsre the <code>BeanContextServiceRevokedEvent</code> received 
     * by this listener. 
     */
    void serviceRevoked(BeanContextServiceRevokedEvent bcsre);
}



