/*
 * @(#)src/classes/sov/java/awt/datatransfer/ClipboardOwner.java, awt-dnd, asdev, 20060428 1.14
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v5.0
 * (C) Copyright IBM Corp. 1998, 2005. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 (C) Copyright Sun Microsystems Inc, 1992, 2004. All rights reserved.
 * ===========================================================================
 */


/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)ClipboardOwner.java	1.10 03/01/23
 *
 */

package java.awt.datatransfer;

/**
 * Defines the interface for classes that will provide data to
 * a clipboard. An instance of this interface becomes the owner
 * of the contents of a clipboard (clipboard owner) if it is
 * passed as an argument to
 * {@link java.awt.datatransfer.Clipboard#setContents} method of
 * the clipboard and this method returns successfully. 
 * The instance remains the clipboard owner until another application
 * or another object within this application asserts ownership
 * of this clipboard.
 *
 * @see java.awt.datatransfer.Clipboard
 * 
 * @version 	1.10, 01/23/03
 * @author	Amy Fowler
 */

public interface ClipboardOwner {

    /**
     * Notifies this object that it is no longer the clipboard owner.
     * This method will be called when another application or another
     * object within this application asserts ownership of the clipboard.
     *
     * @param clipboard the clipboard that is no longer owned
     * @param contents the contents which this owner had placed on the clipboard
     */
    public void lostOwnership(Clipboard clipboard, Transferable contents);

}
