/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.basic;

import com.ibm.gsk.ikeyman.Ikeyman;
import com.ibm.gsk.ikeyman.awt.MsgDialog;
import com.ibm.gsk.ikeyman.basic.CMSKeyDatabaseException;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.IkeymanLogger;
import com.ibm.gsk.ikeyman.basic.KMException;
import com.ibm.gsk.ikeyman.basic.KMUSKrypto;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import com.ibm.gsk.ikeyman.ikeycmd;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class KMSystem
implements IkeymanConstants {
    private static boolean isKMSystemInitialized = false;
    private static int version = 17;
    private static boolean nativeMethodEnabled = false;
    private static boolean nativeLibraryInited = false;
    private static boolean enableJNITracing = false;
    private static boolean isUSVersion = false;
    private static boolean printVerboseMsg = false;
    private static boolean useDosPrompt = false;
    private static Vector verboseMsgQueue = new Vector();
    private static boolean msgQueueEnabled = true;
    private static boolean isJarExisted = true;
    private static boolean isCMSExisted = false;
    public static boolean MSKeyStoreOS = false;
    private static String defaultFileLocation = null;
    private static String hostName = "";
    private static String countryName = "";
    public static String nativeLibraryName = "gsk7kjni";
    public static Locale locale = null;
    private static String logging = null;
    private static String logFilter = null;
    private static String logFile = null;
    private static ResourceBundle custErrRB;
    public static String custErrRBString;
    private static ResourceBundle errRB;
    private static ResourceBundle initRB;
    private static ResourceBundle userRB;
    private static String cryptographicTokenInitializationFailureMessage;
    private static boolean defaultFileLocationSpecified;
    private static String lastDirName;
    private static String lastCMSDirName;
    private static String lastJKSDirName;
    private static String lastJCEKSDirName;
    private static String lastPKCS12DirName;
    private static String lastCMSFileName;
    private static String lastJKSFileName;
    private static String lastJCEKSFileName;
    private static String lastPKCS12FileName;
    public static boolean isFIPSON;
    public static final String[][] ISO_3166_COUNTRY_CODE_TABLE;
    public static final String[] ISO_3166_ORDERED_COUNTRY_CODES;

    public static native boolean c_IsUSSharedLibraryLoaded();

    public static native int c_GSKKMInit(boolean var0);

    public static native int c_GSKKMInitDebug(boolean var0, boolean var1);

    public static native int c_GSKKMCleanAll();

    public static native void c_ShowLibInfo();

    public static native int c_enableFIPSMode(boolean var0, int var1);

    public static void showLibInfo() {
        KMSystem.c_ShowLibInfo();
    }

    public static void cleanAll() {
        if (nativeMethodEnabled) {
            KMSystem.c_GSKKMCleanAll();
        }
    }

    public static void init() throws MissingResourceException {
        KMSystem.init(null);
    }

    public static void init(JApplet jApplet) throws MissingResourceException {
        KMUtil.debugMsg("KMSystem::init() 0000");
        if (!isKMSystemInitialized) {
            if (locale == null) {
                locale = KMSystem.getLocale(jApplet);
            }
            KMSystem.loadErrorMessageResource(jApplet);
            String string = System.getProperty("java.ext.dirs") + System.getProperty("file.separator");
            String string2 = new File(System.getProperty("java.ext.dirs")).getParent() + System.getProperty("file.separator");
            KMUtil.debugMsg("KMSystem::init() 0100, ext.dirs=" + string);
            if (System.getProperty("java.specification.version").compareTo("1.4") < 0) {
                KMSystem.checkNeedFiles(new String[]{string + "ibmjcefw.jar", string + "ibmpkcs.jar", string + "ibmjceprovider.jar", string + "local_policy.jar", string + "US_export_policy.jar"});
            } else if (!System.getProperty("java.specification.version").startsWith("IBM")) {
                KMSystem.checkNeedFiles(new String[]{string + "ibmjceprovider.jar", string2 + "security" + File.separator + "local_policy.jar", string2 + "security" + File.separator + "US_export_policy.jar"});
            }
            KMSystem.getUserEnv(jApplet);
            KMSystem.getMSKeyStoreOS();
            KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_LOADED_ERR_RES"));
            KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_LOCALE") + " " + locale.toString());
            if (jApplet == null) {
                String string3 = System.getProperty("java.version");
                KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_JDK_VER") + " " + string3);
                if (string3.compareTo("1.1.2") < 0) {
                    System.out.println(KMSystem.getNLSErrString("GSKKM_ERR_JDK_VER"));
                }
                KMSystem.initHostInformation();
                KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_HOSTNAME") + " " + hostName);
            }
            if (jApplet == null) {
                KMSystem.loadJNI();
            }
            KMSystem.determineExportStatus(jApplet);
            KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_IKM_VER") + " " + (isUSVersion ? "US " : KMSystem.getNLSErrString("GSKKM_MSG_V_IKM_VER_EXPORT")) + KMSystem.getVersionString());
            KMSystem.enableFIPS(KMSystem.getInitSetting("DEFAULT_FIPS_MODE_PROCESSING"), KMSystem.getInitSetting("DEFAULT_CRYPTOGRAPHIC_BASE_LIBRARY"));
            isKMSystemInitialized = true;
        }
        KMUtil.debugMsg("KMSystem::init() 9999, isKMSystemInitialized=" + isKMSystemInitialized);
    }

    static void checkNeedFiles(String[] stringArray) throws MissingResourceException {
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(stringArray[n]);
            if (!file.exists()) {
                KMUtil.debugMsg("KMSystem::init() 9999-1, the missing filename=" + stringArray[n]);
                throw new MissingResourceException(KMSystem.getNLSErrString("GSKKM_ERR_PROVIDER_IBMJCE_LIBRARIES_NOTFOUND"), "", "");
            }
            ++n;
        }
    }

    public static int getDefaultSignatureAlg() {
        String string = KMSystem.getInitSetting("DEFAULT_SIGNATURE_ALGORITHM");
        int n = string == null ? (isFIPSON ? 2 : 1) : (string.equalsIgnoreCase("MD5_WITH_RSA") ? 1 : (string.equalsIgnoreCase("SHA1_WITH_RSA") ? 2 : 1));
        return n;
    }

    static boolean isJCEFIPSFirst() {
        KMUtil.debugMsg("KeyStoreManager::isJCEFIPSFirst(void) 0000");
        Provider[] providerArray = Security.getProviders();
        int n = 9999;
        int n2 = 9999;
        int n3 = 0;
        while (n3 < providerArray.length) {
            String string = providerArray[n3].toString();
            if (string.startsWith("IBMJCE version")) {
                n = n3;
            }
            if (string.startsWith("IBMJCEFIPS")) {
                n2 = n3;
            }
            ++n3;
        }
        if (n < n2) {
            KMUtil.debugMsg("KeyStoreManager::isJCEFIPSFirst(void) 9999-1 FIPS second" + n + ", " + n2);
            return false;
        }
        KMUtil.debugMsg("KeyStoreManager::isJCEFIPSFirst(void) 09999-2 FIPS first" + n + ", " + n2);
        return true;
    }

    private static void enableFIPS(String string, String string2) throws MissingResourceException {
        int n;
        int n2 = KeyStoreManager.SYSTEM_DEFAULT;
        if (string != null && string.equalsIgnoreCase("on")) {
            isFIPSON = true;
        }
        if (string2 != null) {
            n2 = string2.equalsIgnoreCase("ICC") ? KeyStoreManager.ICC : (string2.equalsIgnoreCase("RSA") ? KeyStoreManager.RSA : KeyStoreManager.SYSTEM_DEFAULT);
        }
        if (nativeMethodEnabled && (n = KMSystem.c_enableFIPSMode(isFIPSON, n2)) != 0) {
            if (n == 153) {
                IkeymanLogger.error("KMSystem", "enableFIPS(String,String) Line 662", "FIPS not enabled due to RSA order problem.");
                throw new MissingResourceException(KMSystem.getNLSErrString("GSKKM_ERR_FIPS_CONFLICT_SETTING"), "", "");
            }
            IkeymanLogger.error("KMSystem", "enableFIPS(String,String) Line 666", "FIPS not enabled/supported.");
            throw new MissingResourceException(KMSystem.getNLSErrString("GSKKM_ERR_FIPS_NOT_SUPPORTED"), "", "");
        }
        if (isFIPSON) {
            if (KMSystem.isJCEFIPSFirst()) {
                String string3 = KMSystem.getInitSetting("DEFAULT_SIGNATURE_ALGORITHM");
                if (string3 != null && string3.equalsIgnoreCase("MD5_WITH_RSA")) {
                    IkeymanLogger.warning("KMSystem", "enableFIPS(String,String) Line 679", "An attempt to enable FIPS support has failed. Please make sure the default algorithm was set to SHA1_WITH_RSA.");
                    throw new MissingResourceException(KMSystem.getNLSErrString("GSKKM_ERR_FIPS_CONFLICT_ALGORITHM"), "", "warning");
                }
            } else {
                IkeymanLogger.warning("KMSystem", "enableFIPS(String,String) Line 684", "An attempt to enable FIPS support has failed. Please make sure the IBMJCEFIPS provider was registered at a  higher priority than IBMJCE.");
                throw new MissingResourceException(KMSystem.getNLSErrString("GSKKM_ERR_FIPS_CONFLICT_PROVIDER_SETTING"), "", "warning");
            }
        }
    }

    private static void loadJNI() {
        KMUtil.debugMsg("KMSystem::loadJNI() 0000");
        try {
            Object[] objectArray;
            nativeMethodEnabled = true;
            nativeLibraryInited = true;
            String string = KMSystem.getNLSErrString("GSKKM_MSG_V_LOAD_JNI");
            String string2 = nativeLibraryName;
            String string3 = System.getProperty("sun.arch.data.model");
            String string4 = System.getProperty("gskit.lib");
            if (string3 != null && string3.equals("64")) {
                string2 = string2 + "_64";
            } else if (string4 != null) {
                string2 = string2 + string4;
            } else {
                objectArray = System.getProperty("IKEYMAN_JNI_SUFFIX");
                if (objectArray != null) {
                    string2 = string2 + (String)objectArray;
                }
            }
            objectArray = new Object[]{string2};
            String string5 = MessageFormat.format(string, objectArray);
            KMSystem.verboseMsg(string5);
            System.loadLibrary(string2);
            KMUtil.debugMsg("KMSystem::loadJNI() 0100, before call c_GSKKMInitDebug");
            int n = KMSystem.c_GSKKMInitDebug(enableJNITracing, KMUtil.printDebugMsg);
            if (n != 0) {
                KMUtil.debugMsg("KMSystem::loadJNI() 0100, rc=" + n);
                System.err.println(KMSystem.getNLSErrString("GSKKM_ERR_NOT_INITIALIZED"));
                nativeMethodEnabled = false;
                nativeLibraryInited = false;
            } else {
                KMSystem.verboseMsg(KMSystem.getNLSErrString("GSKKM_MSG_V_LOAD_CMS_ERR"));
                try {
                    CMSKeyDatabaseException.buildErrCodeNameTable();
                }
                catch (KMException kMException) {
                    nativeMethodEnabled = false;
                    IkeymanLogger.exception("KMSystem", "loadJNI() Line 751", kMException, "The native method was not enabled.");
                    kMException.printStackTrace();
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            IkeymanLogger.exception("KMSystem", "loadJNI() Line 757", unsatisfiedLinkError, "The native method was not enabled.");
            nativeMethodEnabled = false;
        }
        KMUtil.debugMsg("KMSystem::loadJNI() 9999, nativeMethodEnabled=" + nativeMethodEnabled);
    }

    public static Locale getLocale() {
        return KMSystem.getLocale(null);
    }

    public static Locale getLocale(JApplet jApplet) {
        if (locale == null) {
            String string = jApplet == null ? System.getProperty("keyman.lang") : jApplet.getParameter("keyman.lang");
            if (string != null) {
                if (string.length() == 5 && string.charAt(2) == '_') {
                    Locale locale = new Locale(string.substring(0, 2), string.substring(3, 5));
                    Locale.setDefault(locale);
                    KMSystem.locale = locale;
                }
            } else {
                locale = Locale.getDefault();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static void setLocale(Locale locale) {
        KMSystem.locale = locale;
    }

    public static String getNLSErrString(String string) {
        String string2;
        if (errRB == null) {
            string2 = null;
            string2 = "Can not find NLS message for " + string + " due to empty resource handle.";
        } else {
            try {
                string2 = custErrRB != null ? (String)custErrRB.getObject(string) : (String)errRB.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (custErrRB != null) {
                    try {
                        string2 = (String)errRB.getObject(string);
                    }
                    catch (MissingResourceException missingResourceException2) {
                        string2 = "Error occured while getting NLS message for " + string;
                    }
                }
                string2 = "Error occured while getting NLS message for " + string;
            }
        }
        return string2;
    }

    public static String getInitSetting(String string) {
        KMUtil.debugMsg("KMSystem::getInitSetting() 0000, identifier=" + string);
        String string2 = null;
        string2 = KMSystem.getInitSetting(userRB, string);
        if (string2 == null) {
            string2 = KMSystem.getInitSetting(initRB, string);
        }
        KMUtil.debugMsg("KMSystem::getInitSetting() 9999, msg=" + string2);
        if (null != string2) {
            string2 = string2.trim();
        }
        return string2;
    }

    private static String getInitSetting(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        if (resourceBundle == null) {
            string2 = null;
        } else {
            try {
                string2 = (String)resourceBundle.getObject(string);
                if (KMUtil.trimBlankSpace(string2) == null) {
                    string2 = null;
                }
            }
            catch (MissingResourceException missingResourceException) {
                string2 = null;
            }
        }
        return string2;
    }

    public static String findCountryAbbreviationName(String string) {
        KMUtil.debugMsg("KMSystem::findCountryAbbreviationName() 0000, hostName=" + (string == null ? "null" : string));
        if (string == null || string.length() == 0) {
            KMUtil.debugMsg("KMSystem::findCountryAbbreviationName() 9999-1");
            return null;
        }
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n <= 0 || n == string.length() - 1) {
            KMUtil.debugMsg("KMSystem::findCountryAbbreviationName() 9999-2, CountryAbbreviationName=null");
            return null;
        }
        string2 = string.substring(n + 1);
        string2 = string2.length() == 3 ? "US" : (string2.length() == 2 ? string2.toUpperCase() : null);
        KMUtil.debugMsg("KMSystem::findCountryAbbreviationName() 9999, CountryAbbreviationName=" + string2);
        return string2;
    }

    public static boolean isUSVersion() {
        KMUtil.debugMsg("KMSystem::isUSVersion(), isUSVersion=" + isUSVersion);
        return isUSVersion;
    }

    public static void getMSKeyStoreOS() {
        String string = System.getProperty("os.name");
        MSKeyStoreOS = string.equalsIgnoreCase("Windows 2000") || string.equalsIgnoreCase("Windows XP");
    }

    public static boolean isMSKeyStoreOS() {
        return MSKeyStoreOS;
    }

    public static int getVersion() {
        KMUtil.debugMsg("KMSystem::getVersion(), version=" + version);
        return version;
    }

    public static int getVersionMajor() {
        return version >> 4;
    }

    public static int getVersionMinor() {
        return version & 0xF;
    }

    public static String getVersionString() {
        return "" + KMSystem.getVersionMajor() + "." + KMSystem.getVersionMinor();
    }

    public static String getHostName() {
        if (hostName == null || hostName.equals("")) {
            KMSystem.initHostInformation();
        }
        return hostName;
    }

    public static String getCountryName() {
        if (countryName == null || countryName.length() != 2) {
            KMSystem.initHostInformation();
        }
        return countryName;
    }

    public static boolean isJNIEnabled() {
        KMUtil.debugMsg("KMSystem::isJNIEnabled(), nativeMethodEnabled=" + nativeMethodEnabled);
        return nativeMethodEnabled;
    }

    public static synchronized void verboseMsg(String string) {
        if (printVerboseMsg && useDosPrompt) {
            System.out.println("[" + string + "]");
        }
        if (!useDosPrompt && msgQueueEnabled) {
            KMSystem.updateMsgQueue("[" + string + "]", true);
        }
    }

    public static synchronized void updateMsgQueue(String string, boolean bl) {
        if (!msgQueueEnabled) {
            return;
        }
        if (bl) {
            if (string != null) {
                verboseMsgQueue.addElement(string);
            }
        } else if (!verboseMsgQueue.isEmpty()) {
            verboseMsgQueue.removeElementAt(0);
        }
    }

    public static synchronized String getVerboseMsg() {
        String string = null;
        if (!verboseMsgQueue.isEmpty()) {
            string = (String)verboseMsgQueue.firstElement();
            KMSystem.updateMsgQueue(null, false);
        }
        return string;
    }

    public static synchronized void setMsgQueueEnabled(boolean bl) {
        msgQueueEnabled = bl;
    }

    public static String getWorkingDirName() {
        KMUtil.debugMsg("KMSystem::getWorkingDirName() 0000");
        if (defaultFileLocationSpecified) {
            KMUtil.debugMsg("KMSystem::getWorkingDirName() 9999-1, defaultFileLocation=" + defaultFileLocation);
            return defaultFileLocation;
        }
        if (lastDirName == null) {
            lastDirName = defaultFileLocation;
        }
        KMUtil.debugMsg("KMSystem::getWorkingDirName() 9999-2, lastDirName=" + lastDirName);
        return lastDirName;
    }

    public static String getWorkingDirName(int n) {
        KMUtil.debugMsg("KMSystem::getWorkingDirName(databaseType) 0000");
        String string = KeyStoreManager.getKeyStoreName(n);
        String string2 = string.equals("CMS") ? (!KeyStoreManager.USE_LAST_OPENED_LOCATION_CMS || lastCMSDirName == null ? KeyStoreManager.DEFAULT_KEYDB_LOCATION_CMS : lastCMSDirName) : (string.equals("JKS") ? (!KeyStoreManager.USE_LAST_OPENED_LOCATION_JKS || lastJKSDirName == null ? KeyStoreManager.DEFAULT_JKS_FILE_LOCATION : lastJKSDirName) : (string.equals("JCEKS") ? (!KeyStoreManager.USE_LAST_OPENED_LOCATION_JCEKS || lastJCEKSDirName == null ? KeyStoreManager.DEFAULT_JCEKS_FILE_LOCATION : lastJCEKSDirName) : (string.equals("PKCS12") ? (!KeyStoreManager.USE_LAST_OPENED_LOCATION_PKCS12 || lastPKCS12DirName == null ? KeyStoreManager.DEFAULT_PKCS12_FILE_LOCATION : lastPKCS12DirName) : KMSystem.getWorkingDirName())));
        KMUtil.debugMsg("KMSystem::getWorkingDirName(databaseType) 9999 dataBaseType=" + string + " lastCmdDirName=" + lastCMSDirName + ",Working Dir Name=" + string2);
        return string2;
    }

    public static String setCurrentWorkingDirName(String string) {
        KMUtil.debugMsg("KMSystem::setCurrentWorkingDirName(currentDirName) 0000 currDirName=" + string);
        lastDirName = string;
        return lastDirName;
    }

    public static String setCurrentWorkingDirName(String string, int n) {
        String string2 = KeyStoreManager.getKeyStoreName(n);
        KMUtil.debugMsg("KMSystem::setCurrentWorkingDirName(currentDirName,databaseType) 0000databaseType=" + string2 + " currDirName=" + string);
        if (string2 == null) {
            lastDirName = string;
        } else if (string2.equals("CMS") && KeyStoreManager.USE_LAST_OPENED_LOCATION_CMS) {
            lastCMSDirName = string;
        } else if (string2.equals("JKS") && KeyStoreManager.USE_LAST_OPENED_LOCATION_JKS) {
            lastJKSDirName = string;
        } else if (string2.equals("JCEKS") && KeyStoreManager.USE_LAST_OPENED_LOCATION_JCEKS) {
            lastJCEKSDirName = string;
        } else if (string2.equals("PKCS12") && KeyStoreManager.USE_LAST_OPENED_LOCATION_PKCS12) {
            lastPKCS12DirName = string;
        } else {
            lastDirName = string;
        }
        return string;
    }

    public static String getWorkingFileName(int n) {
        KMUtil.debugMsg("KMSystem::getWorkingFileName(databaseType) 0000");
        String string = KeyStoreManager.getKeyStoreName(n);
        String string2 = KeyStoreManager.getDefaultKeyDbFileName(string);
        if (string.equals("CMS")) {
            if (lastCMSFileName != null) {
                string2 = lastCMSFileName;
            }
        } else if (string.equals("JKS")) {
            if (lastJKSDirName != null) {
                string2 = lastJKSFileName;
            }
        } else if (string.equals("JCEKS")) {
            if (lastJCEKSDirName != null) {
                string2 = lastJCEKSFileName;
            }
        } else if (lastPKCS12DirName != null) {
            string2 = lastPKCS12FileName;
        }
        KMUtil.debugMsg("KMSystem::getWorkingFileName(databaseType) 9999 dataBaseType=" + string + ",Working File Name=" + string2);
        return string2;
    }

    public static String setCurrentWorkingFileName(String string, int n) {
        String string2 = KeyStoreManager.getKeyStoreName(n);
        KMUtil.debugMsg("KMSystem::setCurrentWorkingFileName(currentFileName,databaseType) 0000databaseType=" + string2 + " currFileName=" + string);
        if (string2.equals("CMS")) {
            lastCMSFileName = string;
        } else if (string2.equals("JKS")) {
            lastJKSFileName = string;
        } else if (string2.equals("JCEKS")) {
            lastJCEKSFileName = string;
        } else if (string2.equals("PKCS12")) {
            lastPKCS12FileName = string;
        }
        return string;
    }

    public static String getCryptographicTokenInitializationFailureMessage() {
        KMUtil.debugMsg("KMSystem::getCryptographicTokenInitializationFailureMessage(), cryptographicTokenInitializationFailureMessage=" + cryptographicTokenInitializationFailureMessage);
        return cryptographicTokenInitializationFailureMessage;
    }

    public static void setCryptographicTokenInitializationFailureMessage(String string) {
        cryptographicTokenInitializationFailureMessage = string;
    }

    private static void getUserEnv(JApplet jApplet) {
        String string;
        String string2;
        KMUtil.debugMsg("KMSystem::getUserEnv() 0000");
        String string3 = null;
        if (jApplet == null) {
            string2 = System.getProperty("keyman.verbose");
            string = System.getProperty("keyman.jnitracing");
            string3 = System.getProperty("keyman.useDosPrompt");
            logging = System.getProperty("keyman.logging");
            logFilter = System.getProperty("keyman.logFilter");
            logFile = System.getProperty("keyman.logFile");
        } else {
            string2 = jApplet.getParameter("keyman.verbose");
            string = System.getProperty("keyman.jnitracing");
            string3 = jApplet.getParameter("keyman.useDosPrompt");
            logging = jApplet.getParameter("keyman.logging");
            logFilter = jApplet.getParameter("keyman.logFilter");
            logFile = jApplet.getParameter("keyman.logFile");
        }
        if (logging == null) {
            logging = KMSystem.getInitSetting("DEFAULT_LOGGING");
        }
        if (logFilter == null) {
            logFilter = KMSystem.getInitSetting("DEFAULT_LOGGING_FILTER");
        }
        if (logFile == null) {
            logFile = KMSystem.getInitSetting("DEFAULT_LOGGING_FILE");
        }
        if (string2 != null) {
            printVerboseMsg = string2.equals("true") || string2.equals("TRUE");
        }
        if (string != null) {
            enableJNITracing = string.equals("on") || string.equals("ON");
        }
        if (string3 != null && (string3.equals("true") || string3.equals("TRUE"))) {
            useDosPrompt = true;
            msgQueueEnabled = false;
        } else {
            useDosPrompt = false;
            msgQueueEnabled = true;
        }
        defaultFileLocation = KMUtil.getFullPathFileName(KMSystem.getInitSetting("DEFAULT_FILE_LOCATION"));
        if (defaultFileLocation == null) {
            defaultFileLocationSpecified = false;
            defaultFileLocation = KMUtil.getFullPathFileName(".");
            if (defaultFileLocation == null) {
                defaultFileLocation = "." + File.separator;
            }
        } else {
            defaultFileLocationSpecified = true;
        }
        KeyStoreManager.loadInitSetting();
        IkeymanLogger.init(logging, logFilter, logFile);
        KMUtil.debugMsg("KMSystem::getUserEnv() 9999");
    }

    private static void loadErrorMessageResource(JApplet jApplet) throws MissingResourceException {
        String string;
        KMUtil.debugMsg("KMSystem::loadErrorMessageResource() 0000");
        String string2 = "ikminit";
        string2 = jApplet == null ? KMUtil.trimBlankSpace(System.getProperty("initPropertyFile")) : KMUtil.trimBlankSpace(jApplet.getParameter("initPropertyFile"));
        if (string2 == null) {
            string2 = "ikminit";
        } else if (string2.endsWith(".properties")) {
            string = ".properties";
            int n = string.length();
            string2 = string2.substring(0, string2.length() - n);
        }
        KMSystem.loadInitSettingResource(string2);
        string = "ikmuser";
        string = jApplet == null ? KMUtil.trimBlankSpace(System.getProperty("userPropertyFile")) : KMUtil.trimBlankSpace(jApplet.getParameter("userPropertyFile"));
        if (string == null) {
            string = "ikmuser";
        } else if (string.endsWith(".properties")) {
            String string3 = ".properties";
            int n = string3.length();
            string = string.substring(0, string.length() - n);
        }
        KMSystem.loadUserSettingResource(string);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Locale locale = KMSystem.locale;
        String string4 = KMSystem.getInitSetting("DEFAULT_ENGLISH_ERROR_MESSAGE");
        if (string4 == null) {
            KMUtil.debugMsg("KMSystem::loadErrorMessageResource() 2000, no init setting");
            string4 = "false";
        }
        if (string4.equalsIgnoreCase("true")) {
            Locale.setDefault(Locale.ENGLISH);
            KMSystem.locale = Locale.getDefault();
        }
        custErrRB = null;
        try {
            errRB = ResourceBundle.getBundle("ikmerr", KMSystem.locale);
            if (custErrRBString != null && custErrRBString.length() != 0) {
                try {
                    custErrRB = ResourceBundle.getBundle(custErrRBString, KMSystem.locale);
                }
                catch (MissingResourceException missingResourceException) {
                    JFrame jFrame = new JFrame();
                    JOptionPane.setRootFrame(jFrame);
                    String string5 = KMSystem.getNLSErrString("GSKKM_ERR_PROPERTYFILE_TYPEWRONG_CUSTERR");
                    Object[] objectArray = new Object[]{custErrRBString};
                    String string6 = MessageFormat.format(string5, objectArray);
                    KMSystem.verboseMsg(string6);
                    Icon icon = UIManager.getDefaults().getIcon("OptionPane.errorIcon");
                    String string7 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_ERROR");
                    MsgDialog msgDialog = new MsgDialog(jFrame, string7, icon, string6);
                    Dimension dimension = msgDialog.getSize();
                    ((Component)msgDialog).setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
                    ((Component)msgDialog).setVisible(true);
                    missingResourceException.printStackTrace();
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            KMUtil.debugMsg("KMSystem::loadErrorMessageResource() 9999-1");
            if (ikeycmd.getIsReasonCodeReqd()) {
                System.exit(200);
            }
            System.exit(1);
        }
        KMSystem.locale = locale;
        KMUtil.debugMsg("KMSystem::loadErrorMessageResource() 9999");
    }

    private static void loadInitSettingResource(String string) {
        KMUtil.debugMsg("KMSystem::loadInitSettingResource() 0000, propertyFile=" + string);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            initRB = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            initRB = null;
        }
        KMUtil.debugMsg("KMSystem::loadInitSettingResource() 9999");
    }

    private static void loadUserSettingResource(String string) {
        KMUtil.debugMsg("KMSystem::loadUserSettingResource() 0000, propertyFile=" + string);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            userRB = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            userRB = null;
        }
        KMUtil.debugMsg("KMSystem::loadUserSettingResource() 9999");
    }

    private static void initHostInformation() {
        KMUtil.debugMsg("KMSystem::initHostInformation() 0000");
        KMSystem.findHostInformation();
        countryName = KMSystem.findCountryNameByLocale();
        if (countryName == null || countryName.equals("")) {
            countryName = KMSystem.findCountryAbbreviationName(hostName);
        }
        if (countryName == null || countryName.equals("")) {
            countryName = "US";
        }
        KMUtil.debugMsg("KMSystem::initHostInformation() 9999, countryName=" + countryName);
    }

    private static void findHostInformation() {
        KMUtil.debugMsg("KMSystem::findHostInformation() 0000");
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            InetAddress inetAddress2 = InetAddress.getByName(inetAddress.getHostAddress());
            hostName = inetAddress2.getHostName();
            String string = System.getProperty("os.name");
            if (string != null && string.startsWith("Windows 9")) {
                try {
                    ServerSocket serverSocket = new ServerSocket(11111);
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            hostName = "";
        }
        KMUtil.debugMsg("KMSystem::findHostInformation() 9999, hostName=" + hostName);
    }

    private static String findCountryNameByLocale() {
        KMUtil.debugMsg("KMSystem::findCountryNameByLocale() 0000");
        String string = "";
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != null && (string = locale.getCountry()) != null && string.equals("KO") && locale.getLanguage().equals("ko")) {
            string = "KR";
        }
        KMUtil.debugMsg("KMSystem::findCountryNameByLocale() 9999, country=" + string);
        return string;
    }

    private static void determineExportStatus(JApplet jApplet) {
        KMUtil.debugMsg("KMSystem::determineExportStatus() 0000");
        try {
            Class<?> clazz = Class.forName("com.ibm.gsk.ikeyman.basic.KMUSKrypto");
            if (KMUSKrypto.hashValue() == 103) {
                isUSVersion = true;
            }
            if (jApplet == null && nativeMethodEnabled) {
                isUSVersion = KMSystem.c_IsUSSharedLibraryLoaded();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IkeymanLogger.exception("KMSystem", "loadJNI() Line 1645", classNotFoundException, "Export cryptography control is not US Version.");
            isUSVersion = false;
            classNotFoundException.printStackTrace();
        }
        KMUtil.debugMsg("KMSystem::determineExportStatus() 9999, isUSVersion=" + isUSVersion);
    }

    private static Vector getOrderedCountryCodes() {
        int n;
        Vector<String> vector = new Vector<String>(ISO_3166_COUNTRY_CODE_TABLE.length);
        vector.addElement(ISO_3166_COUNTRY_CODE_TABLE[0][1]);
        int n2 = 1;
        while (n2 < ISO_3166_COUNTRY_CODE_TABLE.length) {
            n = 0;
            int n3 = 0;
            n3 = 0;
            while (n3 < n2) {
                if (ISO_3166_COUNTRY_CODE_TABLE[n2][1].compareTo((String)vector.elementAt(n3)) < 0) {
                    vector.insertElementAt(ISO_3166_COUNTRY_CODE_TABLE[n2][1], n3);
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                vector.addElement(ISO_3166_COUNTRY_CODE_TABLE[n2][1]);
            }
            ++n2;
        }
        System.out.println("public static final String ISO_3166_ORDERED_COUNTRY_CODES[] = {");
        n = 0;
        while (n < vector.size()) {
            if (n > 0 && n % 10 == 0) {
                System.out.println("");
            }
            System.out.print("\"" + vector.elementAt(n) + "\", ");
            ++n;
        }
        System.out.println("};");
        return vector;
    }

    static {
        errRB = null;
        initRB = null;
        userRB = null;
        cryptographicTokenInitializationFailureMessage = null;
        defaultFileLocationSpecified = false;
        lastDirName = null;
        lastCMSDirName = null;
        lastJKSDirName = null;
        lastJCEKSDirName = null;
        lastPKCS12DirName = null;
        lastCMSFileName = null;
        lastJKSFileName = null;
        lastJCEKSFileName = null;
        lastPKCS12FileName = null;
        isFIPSON = false;
        ISO_3166_COUNTRY_CODE_TABLE = new String[][]{{"AFGHANISTAN", "AF", "AFG", "004"}, {"ALBANIA", "AL", "ALB", "008"}, {"ALGERIA", "DZ", "DZA", "012"}, {"AMERICAN SAMOA", "AS", "ASM", "016"}, {"ANDORRA", "AD", "AND", "020"}, {"ANGOLA", "AO", "AGO", "024"}, {"ANGUILLA", "AI", "AIA", "660"}, {"ANTARCTICA", "AQ", "ATA", "010"}, {"ANTIGUA AND BARBUDA", "AG", "ATG", "028"}, {"ARGENTINA", "AR", "ARG", "032"}, {"ARMENIA", "AM", "ARM", "051"}, {"ARUBA", "AW", "ABW", "533"}, {"AUSTRALIA", "AU", "AUS", "036"}, {"AUSTRIA", "AT", "AUT", "040"}, {"AZERBAIJAN", "AZ", "AZE", "031"}, {"BAHAMAS", "BS", "BHS", "044"}, {"BAHRAIN", "BH", "BHR", "048"}, {"BANGLADESH", "BD", "BGD", "050"}, {"BARBADOS", "BB", "BRB", "052"}, {"BELARUS", "BY", "BLR", "112"}, {"BELGIUM", "BE", "BEL", "056"}, {"BELIZE", "BZ", "BLZ", "084"}, {"BENIN", "BJ", "BEN", "204"}, {"BERMUDA", "BM", "BMU", "060"}, {"BHUTAN", "BT", "BTN", "064"}, {"BOLIVIA", "BO", "BOL", "068"}, {"BOSNIA AND HERZEGOWINA", "BA", "BIH", "070"}, {"BOTSWANA", "BW", "BWA", "072"}, {"BOUVET ISLAND", "BV", "BVT", "074"}, {"BRAZIL", "BR", "BRA", "076"}, {"BRITISH INDIAN OCEAN TERRITORY", "IO", "IOT", "086"}, {"BRUNEI DARUSSALAM", "BN", "BRN", "096"}, {"BULGARIA", "BG", "BGR", "100"}, {"BURKINA FASO", "BF", "BFA", "854"}, {"BURUNDI", "BI", "BDI", "108"}, {"CAMBODIA", "KH", "KHM", "116"}, {"CAMEROON", "CM", "CMR", "120"}, {"CANADA", "CA", "CAN", "124"}, {"CAPE VERDE", "CV", "CPV", "132"}, {"CAYMAN ISLANDS", "KY", "CYM", "136"}, {"CENTRAL AFRICAN REPUBLIC", "CF", "CAF", "140"}, {"CHAD", "TD", "TCD", "148"}, {"CHILE", "CL", "CHL", "152"}, {"CHINA", "CN", "CHN", "156"}, {"CHRISTMAS ISLAND", "CX", "CXR", "162"}, {"COCOS (KEELING) ISLANDS", "CC", "CCK", "166"}, {"COLOMBIA", "CO", "COL", "170"}, {"COMOROS", "KM", "COM", "174"}, {"CONGO", "CG", "COG", "178"}, {"COOK ISLANDS", "CK", "COK", "184"}, {"COSTA RICA", "CR", "CRI", "188"}, {"COTE D'IVOIRE", "CI", "CIV", "384"}, {"CROATIA (local name: Hrvatska)", "HR", "HRV", "191"}, {"CUBA", "CU", "CUB", "192"}, {"CYPRUS", "CY", "CYP", "196"}, {"CZECH REPUBLIC", "CZ", "CZE", "203"}, {"DENMARK", "DK", "DNK", "208"}, {"DJIBOUTI", "DJ", "DJI", "262"}, {"DOMINICA", "DM", "DMA", "212"}, {"DOMINICAN REPUBLIC", "DO", "DOM", "214"}, {"EAST TIMOR", "TP", "TMP", "626"}, {"ECUADOR", "EC", "ECU", "218"}, {"EGYPT", "EG", "EGY", "818"}, {"EL SALVADOR", "SV", "SLV", "222"}, {"EQUATORIAL GUINEA", "GQ", "GNQ", "226"}, {"ERITREA", "ER", "ERI", "232"}, {"ESTONIA", "EE", "EST", "233"}, {"ETHIOPIA", "ET", "ETH", "231"}, {"FALKLAND ISLANDS (MALVINAS)", "FK", "FLK", "238"}, {"FAROE ISLANDS", "FO", "FRO", "234"}, {"FIJI", "FJ", "FJI", "242"}, {"FINLAND", "FI", "FIN", "246"}, {"FRANCE", "FR", "FRA", "250"}, {"FRANCE, METROPOLITAN", "FX", "FXX", "249"}, {"FRENCH GUIANA", "GF", "GUF", "254"}, {"FRENCH POLYNESIA", "PF", "PYF", "258"}, {"FRENCH SOUTHERN TERRITORIES", "TF", "ATF", "260"}, {"GABON", "GA", "GAB", "266"}, {"GAMBIA", "GM", "GMB", "270"}, {"GEORGIA", "GE", "GEO", "268"}, {"GERMANY", "DE", "DEU", "276"}, {"GHANA", "GH", "GHA", "288"}, {"GIBRALTAR", "GI", "GIB", "292"}, {"GREECE", "GR", "GRC", "300"}, {"GREENLAND", "GL", "GRL", "304"}, {"GRENADA", "GD", "GRD", "308"}, {"GUADELOUPE", "GP", "GLP", "312"}, {"GUAM", "GU", "GUM", "316"}, {"GUATEMALA", "GT", "GTM", "320"}, {"GUINEA", "GN", "GIN", "324"}, {"GUINEA-BISSAU", "GW", "GNB", "624"}, {"GUYANA", "GY", "GUY", "328"}, {"HAITI", "HT", "HTI", "332"}, {"HEARD AND MC DONALD ISLANDS", "HM", "HMD", "334"}, {"HONDURAS", "HN", "HND", "340"}, {"HONG KONG", "HK", "HKG", "344"}, {"HUNGARY", "HU", "HUN", "348"}, {"ICELAND", "IS", "ISL", "352"}, {"INDIA", "IN", "IND", "356"}, {"INDONESIA", "ID", "IDN", "360"}, {"IRAN (ISLAMIC REPUBLIC OF)", "IR", "IRN", "364"}, {"IRAQ", "IQ", "IRQ", "368"}, {"IRELAND", "IE", "IRL", "372"}, {"ISRAEL", "IL", "ISR", "376"}, {"ITALY", "IT", "ITA", "380"}, {"JAMAICA", "JM", "JAM", "388"}, {"JAPAN", "JP", "JPN", "392"}, {"JORDAN", "JO", "JOR", "400"}, {"KAZAKHSTAN", "KZ", "KAZ", "398"}, {"KENYA", "KE", "KEN", "404"}, {"KIRIBATI", "KI", "KIR", "296"}, {"KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF", "KP", "PRK", "408"}, {"KOREA, REPUBLIC OF", "KR", "KOR", "410"}, {"KUWAIT", "KW", "KWT", "414"}, {"KYRGYZSTAN", "KG", "KGZ", "417"}, {"LAO PEOPLE'S DEMOCRATIC REPUBLIC", "LA", "LAO", "418"}, {"LATVIA", "LV", "LVA", "428"}, {"LEBANON", "LB", "LBN", "422"}, {"LESOTHO", "LS", "LSO", "426"}, {"LIBERIA", "LR", "LBR", "430"}, {"LIBYAN ARAB JAMAHIRIYA", "LY", "LBY", "434"}, {"LIECHTENSTEIN", "LI", "LIE", "438"}, {"LITHUANIA", "LT", "LTU", "440"}, {"LUXEMBOURG", "LU", "LUX", "442"}, {"MACAU", "MO", "MAC", "446"}, {"MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF", "MK", "MKD", "807"}, {"MADAGASCAR", "MG", "MDG", "450"}, {"MALAWI", "MW", "MWI", "454"}, {"MALAYSIA", "MY", "MYS", "458"}, {"MALDIVES", "MV", "MDV", "462"}, {"MALI", "ML", "MLI", "466"}, {"MALTA", "MT", "MLT", "470"}, {"MARSHALL ISLANDS", "MH", "MHL", "584"}, {"MARTINIQUE", "MQ", "MTQ", "474"}, {"MAURITANIA", "MR", "MRT", "478"}, {"MAURITIUS", "MU", "MUS", "480"}, {"MAYOTTE", "YT", "MYT", "175"}, {"MEXICO", "MX", "MEX", "484"}, {"MICRONESIA, FEDERATED STATES OF", "FM", "FSM", "583"}, {"MOLDOVA, REPUBLIC OF", "MD", "MDA", "498"}, {"MONACO", "MC", "MCO", "492"}, {"MONGOLIA", "MN", "MNG", "496"}, {"MONTSERRAT", "MS", "MSR", "500"}, {"MOROCCO", "MA", "MAR", "504"}, {"MOZAMBIQUE", "MZ", "MOZ", "508"}, {"MYANMAR", "MM", "MMR", "104"}, {"NAMIBIA", "NA", "NAM", "516"}, {"NAURU", "NR", "NRU", "520"}, {"NEPAL", "NP", "NPL", "524"}, {"NETHERLANDS", "NL", "NLD", "528"}, {"NETHERLANDS ANTILLES", "AN", "ANT", "530"}, {"NEW CALEDONIA", "NC", "NCL", "540"}, {"NEW ZEALAND", "NZ", "NZL", "554"}, {"NICARAGUA", "NI", "NIC", "558"}, {"NIGER", "NE", "NER", "562"}, {"NIGERIA", "NG", "NGA", "566"}, {"NIUE", "NU", "NIU", "570"}, {"NORFOLK ISLAND", "NF", "NFK", "574"}, {"NORTHERN MARIANA ISLANDS", "MP", "MNP", "580"}, {"NORWAY", "NO", "NOR", "578"}, {"OMAN", "OM", "OMN", "512"}, {"PAKISTAN", "PK", "PAK", "586"}, {"PALAU", "PW", "PLW", "585"}, {"PANAMA", "PA", "PAN", "591"}, {"PAPUA NEW GUINEA", "PG", "PNG", "598"}, {"PARAGUAY", "PY", "PRY", "600"}, {"PERU", "PE", "PER", "604"}, {"PHILIPPINES", "PH", "PHL", "608"}, {"PITCAIRN", "PN", "PCN", "612"}, {"POLAND", "PL", "POL", "616"}, {"PORTUGAL", "PT", "PRT", "620"}, {"PUERTO RICO", "PR", "PRI", "630"}, {"QATAR", "QA", "QAT", "634"}, {"REUNION", "RE", "REU", "638"}, {"ROMANIA", "RO", "ROM", "642"}, {"RUSSIAN FEDERATION", "RU", "RUS", "643"}, {"RWANDA", "RW", "RWA", "646"}, {"SAINT KITTS AND NEVIS", "KN", "KNA", "659"}, {"SAINT LUCIA", "LC", "LCA", "662"}, {"SAINT VINCENT AND THE GRENADINES", "VC", "VCT", "670"}, {"SAMOA", "WS", "WSM", "882"}, {"SAN MARINO", "SM", "SMR", "674"}, {"SAO TOME AND PRINCIPE", "ST", "STP", "678"}, {"SAUDI ARABIA", "SA", "SAU", "682"}, {"SENEGAL", "SN", "SEN", "686"}, {"SEYCHELLES", "SC", "SYC", "690"}, {"SIERRA LEONE", "SL", "SLE", "694"}, {"SINGAPORE", "SG", "SGP", "702"}, {"SLOVAKIA (Slovak Republic)", "SK", "SVK", "703"}, {"SLOVENIA", "SI", "SVN", "705"}, {"SOLOMON ISLANDS", "SB", "SLB", "090"}, {"SOMALIA", "SO", "SOM", "706"}, {"SOUTH AFRICA", "ZA", "ZAF", "710"}, {"SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS", "GS", "SGS", "239"}, {"SPAIN", "ES", "ESP", "724"}, {"SRI LANKA", "LK", "LKA", "144"}, {"ST. HELENA", "SH", "SHN", "654"}, {"ST. PIERRE AND MIQUELON", "PM", "SPM", "666"}, {"SUDAN", "SD", "SDN", "736"}, {"SURINAME", "SR", "SUR", "740"}, {"SVALBARD AND JAN MAYEN ISLANDS", "SJ", "SJM", "744"}, {"SWAZILAND", "SZ", "SWZ", "748"}, {"SWEDEN", "SE", "SWE", "752"}, {"SWITZERLAND", "CH", "CHE", "756"}, {"SYRIAN ARAB REPUBLIC", "SY", "SYR", "760"}, {"TAIWAN, PROVINCE OF CHINA", "TW", "TWN", "158"}, {"TAJIKISTAN", "TJ", "TJK", "762"}, {"TANZANIA, UNITED REPUBLIC OF", "TZ", "TZA", "834"}, {"THAILAND", "TH", "THA", "764"}, {"TOGO", "TG", "TGO", "768"}, {"TOKELAU", "TK", "TKL", "772"}, {"TONGA", "TO", "TON", "776"}, {"TRINIDAD AND TOBAGO", "TT", "TTO", "780"}, {"TUNISIA", "TN", "TUN", "788"}, {"TURKEY", "TR", "TUR", "792"}, {"TURKMENISTAN", "TM", "TKM", "795"}, {"TURKS AND CAICOS ISLANDS", "TC", "TCA", "796"}, {"TUVALU", "TV", "TUV", "798"}, {"UGANDA", "UG", "UGA", "800"}, {"UKRAINE", "UA", "UKR", "804"}, {"UNITED ARAB EMIRATES", "AE", "ARE", "784"}, {"UNITED KINGDOM", "GB", "GBR", "826"}, {"UNITED STATES", "US", "USA", "840"}, {"UNITED STATES MINOR OUTLYING ISLANDS", "UM", "UMI", "581"}, {"URUGUAY", "UY", "URY", "858"}, {"UZBEKISTAN", "UZ", "UZB", "860"}, {"VANUATU", "VU", "VUT", "548"}, {"VATICAN CITY STATE (HOLY SEE)", "VA", "VAT", "336"}, {"VENEZUELA", "VE", "VEN", "862"}, {"VIET NAM", "VN", "VNM", "704"}, {"VIRGIN ISLANDS (BRITISH)", "VG", "VGB", "092"}, {"VIRGIN ISLANDS (U.S.)", "VI", "VIR", "850"}, {"WALLIS AND FUTUNA ISLANDS", "WF", "WLF", "876"}, {"WESTERN SAHARA", "EH", "ESH", "732"}, {"YEMEN", "YE", "YEM", "887"}, {"YUGOSLAVIA", "YU", "YUG", "891"}, {"ZAIRE", "ZR", "ZAR", "180"}, {"ZAMBIA", "ZM", "ZMB", "894"}, {"ZIMBABWE", "ZW", "ZWE", "716"}};
        ISO_3166_ORDERED_COUNTRY_CODES = new String[]{"AD", "AE", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "AS", "AT", "AU", "AW", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CC", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EE", "EG", "EH", "ER", "ES", "ET", "FI", "FJ", "FK", "FM", "FO", "FR", "FX", "GA", "GB", "GD", "GE", "GF", "GH", "GI", "GL", "GM", "GN", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IN", "IO", "IQ", "IR", "IS", "IT", "JM", "JO", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "MG", "MH", "MK", "ML", "MM", "MN", "MO", "MP", "MQ", "MR", "MS", "MT", "MU", "MV", "MW", "MX", "MY", "MZ", "NA", "NC", "NE", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PT", "PW", "PY", "QA", "RE", "RO", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SV", "SY", "SZ", "TC", "TD", "TF", "TG", "TH", "TJ", "TK", "TM", "TN", "TO", "TP", "TR", "TT", "TV", "TW", "TZ", "UA", "UG", "UM", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "YE", "YT", "YU", "ZA", "ZM", "ZR", "ZW"};
    }
}

