/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman;

import com.ibm.gsk.ikeyman.awt.HelpFrame;
import com.ibm.gsk.ikeyman.awt.KMFrame;
import com.ibm.gsk.ikeyman.awt.LoadMonitor;
import com.ibm.gsk.ikeyman.awt.MsgDialog;
import com.ibm.gsk.ikeyman.basic.CryptographicToken;
import com.ibm.gsk.ikeyman.basic.IkeymanConstants;
import com.ibm.gsk.ikeyman.basic.IkeymanLogger;
import com.ibm.gsk.ikeyman.basic.KMSystem;
import com.ibm.gsk.ikeyman.basic.KMUtil;
import com.ibm.gsk.ikeyman.basic.KeyStoreManager;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;

public class Ikeyman
implements IkeymanConstants {
    public static Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    public static Font defaultFont = Font.decode("Serif");
    public static Font defaultMonospacedFont = Font.decode("Monospaced");
    public static Font defaultBoldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
    private static ResourceBundle guiRB;
    private static ResourceBundle custGuiRB;
    private static String custGuiRBString;
    private static KMFrame frame;
    private static Frame helpFrame;
    private static Class helpClass;
    private static String helpClassName;
    private static boolean isHelpClassFound;
    private static boolean isHelpClassInstanceOk;
    private static boolean firstLoadErr;
    public static boolean printDebugMsg;
    public static String defaultDebugDumpFileName;
    private static FileOutputStream debugDumpOutputStream;
    private static PrintWriter debugPrintWriter;
    private static int msgIndent;
    private static boolean isMsgInnerLoop;
    public static String javaDocPath;
    public static JApplet appletInstance;
    public static boolean javaOnly;

    public Ikeyman() {
        this(null);
    }

    public Ikeyman(JApplet jApplet) {
        appletInstance = jApplet;
    }

    public static boolean jniLoadErr() {
        if (!KMSystem.isJNIEnabled() && !javaOnly) {
            if (firstLoadErr) {
                Cloneable cloneable;
                Object object;
                String string;
                Icon icon;
                String string2;
                JFrame jFrame = new JFrame();
                JOptionPane.setRootFrame(jFrame);
                if (KMSystem.getVersion() < 17) {
                    string2 = Ikeyman.getNLSErrString("GSKKM_ERR_NATIVE_NOT_ENABLED");
                    icon = UIManager.getDefaults().getIcon("OptionPane.errorIcon");
                    string = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_ERROR");
                } else {
                    object = CryptographicToken.getCryptographicModuleName();
                    if (object != null && ((String)object).length() > 0) {
                        string2 = Ikeyman.getNLSResString("GUI_MSG_NATIVE_NOT_FOUND_WITH_CRYPTOGRAPHIC_TOKEN");
                    } else {
                        string2 = Ikeyman.getNLSResString("GUI_MSG_NATIVE_NOT_FOUND");
                        cloneable = Security.getProvider("IBMCMS");
                        cloneable.clear();
                    }
                    string = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                    icon = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                }
                object = new MsgDialog(jFrame, string, icon, string2);
                cloneable = ((Component)object).getSize();
                ((Component)object).setLocation((Ikeyman.screenSize.width - ((Dimension)cloneable).width) / 2, (Ikeyman.screenSize.height - ((Dimension)cloneable).height) / 2);
                ((Component)object).setVisible(true);
                if (KMSystem.getVersion() < 17) {
                    IkeymanLogger.error("Ikeyman", "jniLoadErr() Line 210", "Cannot load JNI libraries: Ikeyman version is less than 1.1");
                    System.exit(1);
                }
                jFrame.dispose();
            }
            IkeymanLogger.error("Ikeyman", "jniLoadErr() Line 214", "Cannot load JNI libraries.");
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        LoadMonitor loadMonitor;
        boolean bl;
        Object object7;
        Date date;
        boolean bl2;
        block44: {
            int n;
            bl2 = false;
            date = new Date();
            UIManager.put("Button.focus", Color.blue);
            UIManager.put("ToggleButton.focus", Color.blue);
            UIManager.put("CheckBox.focus", Color.blue);
            UIManager.put("RadioButton.focus", Color.blue);
            UIManager.put("TabbedPane.focus", Color.blue);
            UIManager.put("activeCaptionBorder", Color.blue);
            String string = appletInstance == null ? System.getProperty("keyman.timer") : appletInstance.getParameter("keyman.timer");
            if (string != null && (string.equals("on") || string.equals("ON"))) {
                bl2 = true;
            }
            if ((custGuiRBString = appletInstance == null ? KMUtil.trimBlankSpace(System.getProperty("guiPropertyFile")) : KMUtil.trimBlankSpace(appletInstance.getParameter("guiPropertyFile"))) == null) {
                custGuiRBString = System.getProperty("guiPropertyFile");
            } else if (custGuiRBString.endsWith(".properties")) {
                object7 = ".properties";
                n = ((String)object7).length();
                custGuiRBString = custGuiRBString.substring(0, custGuiRBString.length() - n);
            }
            KMSystem.custErrRBString = appletInstance == null ? KMUtil.trimBlankSpace(System.getProperty("errPropertyFile")) : KMUtil.trimBlankSpace(appletInstance.getParameter("errPropertyFile"));
            if (KMSystem.custErrRBString == null) {
                KMSystem.custErrRBString = System.getProperty("errPropertyFile");
            } else if (KMSystem.custErrRBString.endsWith(".properties")) {
                object7 = ".properties";
                n = ((String)object7).length();
                KMSystem.custErrRBString = KMSystem.custErrRBString.substring(0, KMSystem.custErrRBString.length() - n);
            }
            object7 = new JFrame();
            JOptionPane.setRootFrame((Frame)object7);
            String string2 = null;
            bl = false;
            loadMonitor = null;
            string2 = appletInstance == null ? System.getProperty("keyman.useDosPrompt") : appletInstance.getParameter("keyman.useDosPrompt");
            this.loadGUIMessageResource();
            if (string2 != null && (string2.equals("true") || string2.equals("TRUE"))) {
                bl = true;
            }
            if (!bl) {
                loadMonitor = new LoadMonitor(Ikeyman.getNLSResString("GUI_TITLE"), Ikeyman.getNLSResString("GUI_MSG_V_LOADED_GUI_RES"));
                loadMonitor.start();
            }
            Ikeyman.initUserEnv();
            try {
                KMSystem.init(appletInstance);
                if (bl) {
                    KMSystem.verboseMsg(Ikeyman.getNLSResString("GUI_MSG_V_LOADED_GUI_RES"));
                }
            }
            catch (MissingResourceException missingResourceException) {
                if (missingResourceException.toString().equals("java.util.MissingResourceException: JCE")) {
                    object6 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                    object5 = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                    object4 = Ikeyman.getNLSErrString("GSKKM_ERR_PROVIDER_IBMJCE_LIBRARIES_NOTFOUND");
                    object3 = new MsgDialog((JFrame)object7, (String)object6, (Icon)object5, (String)object4);
                    object2 = ((Component)object3).getSize();
                    ((Component)object3).setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
                    ((Component)object3).setVisible(true);
                    System.exit(0);
                }
                if (missingResourceException.toString().equals("java.util.MissingResourceException: CMS")) {
                    Security.removeProvider("IBMCMS");
                    object6 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                    object5 = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                    object4 = Ikeyman.getNLSErrString("GSKKM_ERR_PROVIDER_CMS_LIBRARIES_NOTFOUND");
                    object3 = new MsgDialog((JFrame)object7, (String)object6, (Icon)object5, (String)object4);
                    object2 = ((Component)object3).getSize();
                    ((Component)object3).setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
                    ((Component)object3).setVisible(true);
                }
                object6 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                object5 = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                object4 = missingResourceException.getMessage();
                object3 = new MsgDialog((JFrame)object7, (String)object6, (Icon)object5, (String)object4);
                object2 = ((Component)object3).getSize();
                ((Component)object3).setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
                ((Component)object3).setVisible(true);
                if (missingResourceException.getKey() != null && !missingResourceException.getKey().equals("")) break block44;
                System.exit(0);
            }
        }
        String string = null;
        string = appletInstance == null ? System.getProperty("keyman.javaOnly") : appletInstance.getParameter("keyman.javaOnly");
        if (string != null && (string.equals("true") || string.equals("TRUE"))) {
            javaOnly = true;
        }
        if (appletInstance == null && !javaOnly && KeyStoreManager.isDbTypeSupported(1)) {
            if (!KMSystem.isJNIEnabled()) {
                if (KMSystem.getVersion() < 17) {
                    object6 = Ikeyman.getNLSErrString("GSKKM_ERR_NATIVE_NOT_ENABLED");
                    object4 = UIManager.getDefaults().getIcon("OptionPane.errorIcon");
                    object5 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_ERROR");
                } else {
                    object3 = CryptographicToken.getCryptographicModuleName();
                    if (object3 != null && ((String)object3).length() > 0) {
                        object6 = Ikeyman.getNLSResString("GUI_MSG_NATIVE_NOT_ENABLED_WITH_CRYPTOGRAPHIC_TOKEN");
                    } else {
                        object6 = Ikeyman.getNLSResString("GUI_MSG_NATIVE_NOT_ENABLED");
                        object2 = Security.getProvider("IBMCMS");
                        ((Provider)object2).clear();
                    }
                    object5 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                    object4 = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                }
                object3 = new MsgDialog((JFrame)object7, (String)object5, (Icon)object4, (String)object6);
                object2 = ((Component)object3).getSize();
                ((Component)object3).setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
                ((Component)object3).setVisible(true);
                if (KMSystem.getVersion() < 17) {
                    System.exit(1);
                }
            } else {
                object6 = KMSystem.getCryptographicTokenInitializationFailureMessage();
                if (object6 != null) {
                    object5 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_WARNING");
                    object4 = UIManager.getDefaults().getIcon("OptionPane.warningIcon");
                    object3 = new MsgDialog((JFrame)object7, (String)object5, (Icon)object4, (String)object6);
                    object2 = ((Component)object3).getSize();
                    ((Component)object3).setLocation((Ikeyman.screenSize.width - ((Dimension)object2).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object2).height) / 2);
                    ((Component)object3).setVisible(true);
                }
            }
        }
        try {
            helpClassName = System.getProperty("keyman.helpClassName");
            if (helpClassName == null) {
                helpClassName = "CSSgKey";
            } else if (helpClassName.endsWith(".class")) {
                helpClassName = helpClassName.substring(0, helpClassName.length() - 6);
            }
            helpClass = Class.forName(helpClassName);
            isHelpClassFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            isHelpClassFound = false;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            isHelpClassFound = false;
        }
        catch (Error error) {
            isHelpClassFound = false;
        }
        catch (Exception exception) {
            isHelpClassFound = false;
        }
        object6 = KMSystem.getLocale(appletInstance);
        if (((Locale)object6).getLanguage().equals("ja") && appletInstance == null && (object5 = System.getProperty("os.name")) != null && ((String)object5).equals("Windows 95")) {
            object4 = UIManager.getDefaults();
            object3 = ((Hashtable)object4).keys();
            try {
                while (object3.hasMoreElements()) {
                    object2 = object3.nextElement();
                    try {
                        object = (String)object2;
                        if (!((String)object).endsWith(".font")) continue;
                        UIManager.put(object, defaultMonospacedFont);
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
        }
        KMSystem.verboseMsg(Ikeyman.getNLSResString("GUI_MSG_V_LOAD_MAIN_FRAME"));
        frame = new KMFrame(appletInstance);
        JOptionPane.setRootFrame(frame);
        ((Window)object7).dispose();
        KMSystem.verboseMsg(Ikeyman.getNLSResString("GUI_MSG_V_SHOW_MAIN_FRAME"));
        object5 = frame.getSize();
        object4 = frame.getPreferredSize();
        object3 = frame.getBounds();
        if (((Dimension)object4).height <= Ikeyman.screenSize.height * 3 / 4 && ((Dimension)object4).width <= Ikeyman.screenSize.width * 3 / 4) {
            ((Component)frame).setSize(3 * Ikeyman.screenSize.width / 4, 3 * Ikeyman.screenSize.height / 4);
        } else {
            ((Component)frame).setSize(screenSize);
        }
        object5 = frame.getSize();
        object4 = frame.getPreferredSize();
        ((Component)frame).setLocation((Ikeyman.screenSize.width - ((Dimension)object5).width) / 2, (Ikeyman.screenSize.height - ((Dimension)object5).height) / 2);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        if (!bl && loadMonitor != null) {
            loadMonitor.stopLoop();
        }
        ((Component)frame).setVisible(true);
        defaultFont = frame.getFont();
        if (defaultFont == null) {
            defaultFont = Font.decode("Serif");
        }
        defaultBoldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
        object2 = null;
        object2 = appletInstance == null ? System.getProperty("keyman.keydatabase") : appletInstance.getParameter("keyman.keydatabase");
        if (object2 != null) {
            frame.menuItem_Open_Handler((String)object2);
        }
        if (!bl2) return;
        object = new Date();
        if (printDebugMsg) {
            KMUtil.debugMsg("Running Time: " + (((Date)object).getTime() - date.getTime()) + " milliseconds");
            return;
        }
        System.out.println("Running Time: " + (((Date)object).getTime() - date.getTime()) + " milliseconds");
    }

    public static void printUsage() {
        String[] stringArray = new String[]{"Usage: ", "    ikmgui [-options] ", "or ", "    java [-java options] com.ibm.ikeyman.Ikeyman [-options] ", "", "where options include: ", "    -h[elp]              print out this message", "    -ver[sion]           print out build version ", "    -v[erbose]           generate verbose output ", "    -db <kdb|kyr> <file> indicate a database file of the specified type", "    -dn <dn-name>        a distinguished name input with format:", "                         dn-name ::= \"cn=<common name>, \\", "                                      o=<organization name>, \\", "                                      ou=<organization unit name>, \\", "                                      c=<country name>\"", "    -l[abel] <string>    a label input for a new entry in key database", "    -in <file>           input file", "    -out <file>          output file to save result", "    -p12pwd <password>   a password for a PKCS#12 key exchange file", "    -p <password>        password input for a key database", "                         Be careful to use this option because other", "                         users in your machine can detect your password", "                         input by simply looking at process list.", "                         All the following action options need a password", "                         input. You need to pass a password with option -p,", "                         or enter a password when you are prompted to do so.", "    -c[reate] [-cert|-certreq -l <string> -dn <dn-name>] -db <kdb|kyr> <file> [-out <file>]", "                         create the named new key database, a self-signed", "                         certificate, or a new certificate request", "    -exp[ort] [-a|-d|-f] -db <kdb|kyr> <file> -p12pwd <password> -out <file>", "                         export a private key entry", "    -a                   export all keys in the database", "    -d                   export the default key", "    -f                   export the first private key found in the database", "    -ext[ract] -l <label string> -db <kdb|kyr> <file> -out <file>", "                         extract a certificate or certificate request by label", "    -imp[ort] -p12pwd <password> -in <PKCS#12 file> -db <kdb|kyr> <file>", "                         import keys from the file into the named key database", "    -kyr2kdb <keyring file> <CMS key database file> ", "                         convert a keyring file to CMS key database", "    -kdb2kyr <CMS key database file> <keyring file>", "                         convert a CMS key database to keyring file", "    -r[eceive] -in <certificate file> -db <kdb|kyr> <file> ", "                         store the certificate for your request from CA", "    -s[tore]ca -l <label> -in <certificate file> -db <kdb|kyr> <file>", "                         store a CA certificate into the key database", "    -stash -db <kdb|kyr> <file> ", "                         stash the database password"};
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        Ikeyman ikeyman = new Ikeyman();
        ikeyman.init();
    }

    public static void initUserEnv() {
        String string;
        String string2;
        if (appletInstance == null) {
            string2 = System.getProperty("keyman.debug");
            string = System.getProperty("keyman.debugDumpFileName");
        } else {
            string2 = appletInstance.getParameter("keyman.debug");
            string = appletInstance.getParameter("keyman.debugDumpFileName");
        }
        if (string2 != null && (string2.equals("true") || string2.equals("TRUE"))) {
            printDebugMsg = true;
            if (string == null) {
                string = defaultDebugDumpFileName;
            }
            if (string != null) {
                File file = new File(string);
                boolean bl = file.exists();
                try {
                    debugDumpOutputStream = new FileOutputStream(file);
                    debugPrintWriter = new PrintWriter(debugDumpOutputStream, true);
                }
                catch (IOException iOException) {
                    if (debugDumpOutputStream != null) {
                        try {
                            debugDumpOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                    }
                    debugDumpOutputStream = null;
                    debugPrintWriter = null;
                }
            }
        } else {
            printDebugMsg = false;
        }
        javaDocPath = appletInstance == null ? System.getProperty("keyman.docpath") : appletInstance.getParameter("keyman.docpath");
        KMUtil.printDebugMsg = printDebugMsg;
        KMUtil.defaultDebugDumpFileName = defaultDebugDumpFileName;
        KMUtil.debugDumpOutputStream = debugDumpOutputStream;
        KMUtil.debugPrintWriter = debugPrintWriter;
    }

    public static void debugMsg(String string) {
        if (msgIndent < 0) {
            msgIndent = 0;
        }
        if (string.indexOf("9999") != -1) {
            isMsgInnerLoop = false;
            msgIndent -= 2;
            string = "<<" + string;
        } else {
            string = ">>" + string;
        }
        int n = 0;
        while (n < msgIndent) {
            string = " " + string;
            ++n;
        }
        if (string.indexOf("0000") != -1) {
            isMsgInnerLoop = true;
            msgIndent += 2;
        }
        if (KMUtil.printDebugMsg) {
            if (debugDumpOutputStream != null && debugPrintWriter != null) {
                debugPrintWriter.println(string);
            } else {
                System.out.println(string);
            }
        }
    }

    public static void closeDebugDumpFile() {
        if (debugDumpOutputStream != null && debugPrintWriter != null) {
            debugPrintWriter.close();
            try {
                debugDumpOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        debugDumpOutputStream = null;
        debugPrintWriter = null;
    }

    public static String getNLSResString(String string) {
        String string2;
        if (guiRB == null) {
            string2 = null;
            string2 = "Error occured while getting NLS message for " + string + " due to empty resource handle.";
        } else {
            try {
                string2 = custGuiRB != null ? (String)custGuiRB.getObject(string) : (String)guiRB.getObject(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (custGuiRB != null) {
                    try {
                        string2 = (String)guiRB.getObject(string);
                    }
                    catch (MissingResourceException missingResourceException2) {
                        KMUtil.debugMsg("DEBUG......can not find message for " + string);
                        missingResourceException2.printStackTrace();
                        string2 = "Error occured while getting NLS message for " + string;
                    }
                }
                KMUtil.debugMsg("DEBUG......can not find message for " + string);
                missingResourceException.printStackTrace();
                string2 = "Error occured while getting NLS message for " + string;
            }
        }
        return string2;
    }

    public static String getNLSErrString(String string) {
        return KMSystem.getNLSErrString(string);
    }

    public void loadGUIMessageResource() {
        guiRB = null;
        custGuiRB = null;
        Locale locale = KMSystem.getLocale(appletInstance);
        KMUtil.debugMsg("DEBUG......locale=" + locale);
        try {
            guiRB = ResourceBundle.getBundle("ikmgui", locale);
            if (custGuiRBString != null && custGuiRBString.length() != 0) {
                try {
                    custGuiRB = ResourceBundle.getBundle(custGuiRBString, locale);
                }
                catch (MissingResourceException missingResourceException) {
                    KMSystem.init(null);
                    JFrame jFrame = new JFrame();
                    JOptionPane.setRootFrame(jFrame);
                    String string = KMSystem.getNLSErrString("GSKKM_ERR_PROPERTYFILE_TYPEWRONG_CUSTGUI");
                    Object[] objectArray = new Object[]{custGuiRBString};
                    String string2 = MessageFormat.format(string, objectArray);
                    KMSystem.verboseMsg(string2);
                    Icon icon = UIManager.getDefaults().getIcon("OptionPane.errorIcon");
                    String string3 = Ikeyman.getNLSResString("GUI_DIALOG_TITLE_ERROR");
                    MsgDialog msgDialog = new MsgDialog(jFrame, string3, icon, string2);
                    Dimension dimension = msgDialog.getSize();
                    ((Component)msgDialog).setLocation((Ikeyman.screenSize.width - dimension.width) / 2, (Ikeyman.screenSize.height - dimension.height) / 2);
                    ((Component)msgDialog).setVisible(true);
                    missingResourceException.printStackTrace();
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
            System.exit(1);
        }
    }

    public static String getDatabaseNLSTypeName(int n) {
        String string = KeyStoreManager.getKeyStoreName(n);
        try {
            if (string.equals("CMS")) {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_CMS");
            } else if (string.equals("SSLight")) {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_SSLIGHT");
            } else if (string.equals("JKS")) {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JKS");
            } else if (string.equals("JCEKS")) {
                string = Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_JCEKS");
            } else if (string.equals("PKCS12")) {
                string = Ikeyman.getNLSResString("GUI_LABEL_KEY_FILE_TYPE_PFX");
            } else {
                string = KeyStoreManager.getKeyStoreName(n);
                if (string == null) {
                    return Ikeyman.getNLSResString("GUI_LABEL_DBTYPE_UNKNOWN");
                }
            }
        }
        catch (Exception exception) {
            return string;
        }
        return string;
    }

    public static void closeHelpFrame() {
        if (helpFrame != null && helpFrame.isShowing()) {
            helpFrame.dispose();
            helpFrame = null;
        }
    }

    public static void showHelpWindow(String string) {
        Ikeyman.showHelpWindow(frame, string);
    }

    public static void showHelpWindow(JFrame jFrame, String string) {
        Serializable serializable;
        if (!isHelpClassFound) {
            return;
        }
        if (helpFrame != null && !helpFrame.isShowing()) {
            helpFrame = null;
        }
        if (helpFrame != null) {
            // empty if block
        }
        if (jFrame != null) {
            jFrame.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (helpFrame == null) {
            if (isHelpClassFound && helpClass != null) {
                try {
                    helpFrame = (Frame)helpClass.newInstance();
                    isHelpClassInstanceOk = true;
                }
                catch (InstantiationException instantiationException) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
                catch (Error error) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
                catch (Exception exception) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
            }
            if (helpFrame == null && !isHelpClassInstanceOk) {
                if (jFrame != null) {
                    jFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
        } else if (!(isHelpClassFound && isHelpClassInstanceOk || string == null)) {
            serializable = HelpFrame.getURL(string);
            if (serializable == null) {
                serializable = HelpFrame.getHomeURL();
            }
            ((HelpFrame)helpFrame).linkActivated((URL)serializable, false);
        }
        if (helpFrame.isShowing()) {
            serializable = new WindowEvent(helpFrame, 205);
            helpFrame.dispatchEvent((AWTEvent)serializable);
            serializable = new WindowEvent(helpFrame, 204);
            helpFrame.dispatchEvent((AWTEvent)serializable);
        }
        int n = Ikeyman.helpFrame.getSize().width;
        int n2 = Ikeyman.helpFrame.getSize().height;
        if (!isHelpClassFound || !isHelpClassInstanceOk) {
            Dimension dimension = helpFrame.getPreferredSize();
            n = dimension.width;
            n2 = dimension.height;
            if (n < Ikeyman.screenSize.width * 3 / 5) {
                n = Ikeyman.screenSize.width * 3 / 5;
            } else if (n > Ikeyman.screenSize.width * 4 / 5) {
                n = Ikeyman.screenSize.width * 4 / 5;
            }
            if (dimension.height < Ikeyman.screenSize.height * 3 / 4) {
                n2 = Ikeyman.screenSize.height * 3 / 4;
            } else if (dimension.height > Ikeyman.screenSize.height * 4 / 5) {
                n2 = Ikeyman.screenSize.height * 4 / 5;
            }
            ((Component)helpFrame).setSize(n, n2);
        }
        ((Component)helpFrame).setLocation(Ikeyman.screenSize.width - n - 5, 5);
        ((Component)helpFrame).setVisible(true);
        if (jFrame != null) {
            jFrame.setCursor(Cursor.getPredefinedCursor(0));
        }
        helpFrame.setCursor(Cursor.getPredefinedCursor(0));
        helpFrame.toFront();
    }

    public static void showHelpWindow(JDialog jDialog, String string) {
        Serializable serializable;
        KMUtil.debugMsg("DEBUG......enter showHelpWindow()");
        if (!isHelpClassFound) {
            return;
        }
        if (helpFrame != null && !helpFrame.isShowing()) {
            helpFrame = null;
        }
        if (helpFrame != null) {
            KMUtil.debugMsg("DEBUG......helpFrame show " + helpFrame.isShowing() + ", visible " + helpFrame.isVisible() + ", valid " + helpFrame.isValid());
        }
        if (jDialog != null) {
            jDialog.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (helpFrame == null) {
            if (isHelpClassFound && helpClass != null) {
                try {
                    helpFrame = (Frame)helpClass.newInstance();
                    isHelpClassInstanceOk = true;
                }
                catch (InstantiationException instantiationException) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
                catch (Error error) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
                catch (Exception exception) {
                    isHelpClassInstanceOk = false;
                    helpFrame = null;
                }
            }
            if (helpFrame == null && !isHelpClassInstanceOk) {
                if (jDialog != null) {
                    jDialog.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
        } else if (!(isHelpClassFound && isHelpClassInstanceOk || string == null)) {
            serializable = HelpFrame.getURL(string);
            if (serializable == null) {
                serializable = HelpFrame.getHomeURL();
            }
            ((HelpFrame)helpFrame).linkActivated((URL)serializable, false);
        }
        if (helpFrame.isShowing()) {
            serializable = new WindowEvent(helpFrame, 205);
            KMUtil.debugMsg("DEBUG......WindowEvent " + serializable);
            helpFrame.dispatchEvent((AWTEvent)serializable);
            serializable = new WindowEvent(helpFrame, 204);
            KMUtil.debugMsg("DEBUG......WindowEvent " + serializable);
            helpFrame.dispatchEvent((AWTEvent)serializable);
        }
        int n = Ikeyman.helpFrame.getSize().width;
        int n2 = Ikeyman.helpFrame.getSize().height;
        if (!isHelpClassFound || !isHelpClassInstanceOk) {
            Dimension dimension = helpFrame.getPreferredSize();
            n = dimension.width;
            n2 = dimension.height;
            if (n < Ikeyman.screenSize.width * 3 / 5) {
                n = Ikeyman.screenSize.width * 3 / 5;
            } else if (n > Ikeyman.screenSize.width * 4 / 5) {
                n = Ikeyman.screenSize.width * 4 / 5;
            }
            if (dimension.height < Ikeyman.screenSize.height * 3 / 4) {
                n2 = Ikeyman.screenSize.height * 3 / 4;
            } else if (dimension.height > Ikeyman.screenSize.height * 4 / 5) {
                n2 = Ikeyman.screenSize.height * 4 / 5;
            }
            KMUtil.debugMsg("DEBUG......HelpFrame: prefSize=" + dimension + ", x=" + n + ",y=" + n2);
            ((Component)helpFrame).setSize(n, n2);
        }
        ((Component)helpFrame).setLocation(Ikeyman.screenSize.width - n - 5, 5);
        ((Component)helpFrame).setVisible(true);
        if (jDialog != null) {
            jDialog.setCursor(Cursor.getPredefinedCursor(0));
        }
        helpFrame.setCursor(Cursor.getPredefinedCursor(0));
        helpFrame.getFocusOwner();
        helpFrame.toFront();
    }

    public static boolean isHelpAvailable() {
        return isHelpClassFound;
    }

    public static boolean isOverwriteConfirmedFileDialog() {
        if (appletInstance == null) {
            try {
                String string = System.getProperty("os.name");
                return string != null && string.startsWith("Windows");
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return false;
    }

    public static char getHotKeyChars(String string) {
        int n = string.indexOf("&");
        if (n != -1) {
            return string.charAt(n + 1);
        }
        return '\u0000';
    }

    public static String getMenuItemstr(String string) {
        int n = string.indexOf("&");
        if (n != -1) {
            String string2 = string.substring(0, n) + string.substring(n + 1);
            return string2;
        }
        return string;
    }

    static {
        helpFrame = null;
        helpClass = null;
        helpClassName = "CSSgKey";
        isHelpClassFound = false;
        isHelpClassInstanceOk = false;
        firstLoadErr = true;
        printDebugMsg = false;
        defaultDebugDumpFileName = "ikmgdbg.log";
        debugDumpOutputStream = null;
        msgIndent = 0;
        isMsgInnerLoop = false;
        javaDocPath = null;
        appletInstance = null;
        javaOnly = false;
    }
}

