/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.BasicOCSPResponse;
import com.ibm.security.cert.OCSPResponseStatus;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;

public class OCSPResponse {
    private OCSPResponseStatus status;
    private byte[] responseData;
    private ObjectIdentifier responseType;
    public static final ObjectIdentifier basicResponseType;

    public OCSPResponse(OCSPResponseStatus status, BasicOCSPResponse response) {
        if (status == null) {
            throw new IllegalArgumentException("status can not be null");
        }
        this.status = status;
        try {
            this.responseData = response.encode();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.responseType = basicResponseType;
    }

    public OCSPResponse(byte[] encodedData) throws IOException {
        this.init(new DerInputStream(encodedData));
    }

    public OCSPResponse(DerValue der) throws IOException {
        this.init(der.toDerInputStream());
    }

    void init(DerInputStream indata) throws IOException {
        DerValue[] ders = indata.getSequence(2);
        if (ders.length > 0) {
            this.status = new OCSPResponseStatus(ders[0]);
            if (ders.length > 1) {
                int tag = ders[1].getTag() & 0x1F;
                if (tag != 0) {
                    throw new IOException("invalid tag of ResponseBytes: " + tag);
                }
                DerInputStream dis = ders[1].getData();
                DerValue[] ders2 = dis.getSequence(2);
                if (ders2.length != 2) {
                    throw new IOException("invalid sequence of ResponseBytes, length=" + ders2.length);
                }
                if (!ders2[0].getOID().equals(basicResponseType)) {
                    throw new IOException("unknown response type, oid=" + ders2[0].getOID());
                }
                this.responseData = ders2[1].getOctetString();
                this.responseType = basicResponseType;
            }
        } else {
            throw new IOException("input data does not contain valid OCSPResponse value");
        }
    }

    public byte[] encode() throws IOException {
        DerValue[] ders = null;
        ders = this.responseData == null ? new DerValue[1] : new DerValue[2];
        ders[0] = new DerValue(this.status.encode());
        if (ders.length == 2) {
            DerValue[] ders2 = new DerValue[2];
            DerOutputStream dos = new DerOutputStream();
            dos.putOID(basicResponseType);
            ders2[0] = new DerValue(dos.toByteArray());
            dos = new DerOutputStream();
            dos.putOctetString(this.responseData);
            ders2[1] = new DerValue(dos.toByteArray());
            dos = new DerOutputStream();
            dos.putSequence(ders2);
            ders[1] = new DerValue(dos.toByteArray());
        }
        DerOutputStream temp = new DerOutputStream();
        temp.putSequence(ders);
        return temp.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("OCSPResponse:[\n");
        sb.append("  status: " + this.status.getStatusAsString() + "\n");
        if (this.responseData != null) {
            sb.append("  response type: " + this.responseType.toString() + "\n");
            sb.append("  response data: \n" + new HexDumpEncoder().encode(this.responseData));
        }
        sb.append("  ]");
        return sb.toString();
    }

    public OCSPResponseStatus getResponseStatus() {
        return this.status;
    }

    public ObjectIdentifier getResponseType() {
        return this.responseType;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    static {
        ObjectIdentifier temp = null;
        try {
            temp = new ObjectIdentifier("1.3.6.1.5.5.7.48.1.1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        basicResponseType = temp;
    }
}

