/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.cert.OCSPException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class CertID {
    private String issuerDN;
    private AlgorithmId hashAlg;
    private PublicKey issuerPubKey;
    private BigInteger certSerialNum;
    private byte[] issuerNameHash;
    private byte[] issuerkeyHash;
    private static Debug debug = Debug.getInstance((String)"certpath");

    public CertID(X509Certificate issuerCert, X509Certificate targetCert) {
        block13: {
            block11: {
                this.issuerDN = null;
                this.hashAlg = null;
                this.issuerPubKey = null;
                this.certSerialNum = null;
                this.issuerNameHash = null;
                this.issuerkeyHash = null;
                if (issuerCert == null) {
                    OCSPException e = new OCSPException("error issuerCert is null");
                    e.printStackTrace();
                    return;
                }
                if (targetCert == null) {
                    OCSPException e = new OCSPException("error targetCert is null");
                    e.printStackTrace();
                    return;
                }
                try {
                    this.hashAlg = AlgorithmId.get((String)"SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    if (debug == null) break block11;
                    System.out.println("internal error");
                    e.printStackTrace();
                }
            }
            this.issuerDN = ((Object)issuerCert.getIssuerDN()).toString();
            this.certSerialNum = targetCert.getSerialNumber();
            this.issuerPubKey = issuerCert.getPublicKey();
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            md.update(issuerCert.getIssuerX500Principal().getEncoded());
            this.issuerNameHash = md.digest();
            byte[] data = this.issuerPubKey.getEncoded();
            if (data == null) {
                IOException e = new IOException("The key does not support encoding.");
                e.printStackTrace();
            }
            try {
                MessageDigest sha1;
                byte[] keyBytes;
                block12: {
                    DerValue val = new DerValue(data);
                    DerValue[] seq = new DerValue[]{val.getData().getDerValue(), val.getData().getDerValue()};
                    keyBytes = seq[1].getBitString();
                    sha1 = null;
                    this.issuerkeyHash = new byte[20];
                    try {
                        sha1 = MessageDigest.getInstance("SHA-1");
                    }
                    catch (NoSuchAlgorithmException ex) {
                        if (debug == null) break block12;
                        System.out.println("internal error");
                        ex.printStackTrace();
                    }
                }
                sha1.update(keyBytes);
                this.issuerkeyHash = sha1.digest();
            }
            catch (IOException ex) {
                if (debug == null) break block13;
                System.out.println("internal error");
                ex.printStackTrace();
            }
        }
    }

    public CertID(String issuerDN, PublicKey issuerPubKey, BigInteger certSerialNum, String hashAlg) {
        block20: {
            MessageDigest md;
            block18: {
                block17: {
                    this.issuerDN = null;
                    this.hashAlg = null;
                    this.issuerPubKey = null;
                    this.certSerialNum = null;
                    this.issuerNameHash = null;
                    this.issuerkeyHash = null;
                    if (issuerDN == null) {
                        OCSPException e = new OCSPException("error issuerDn is null");
                        e.printStackTrace();
                        return;
                    }
                    if (issuerPubKey == null) {
                        OCSPException e = new OCSPException("error issuerPubKey is null");
                        e.printStackTrace();
                        return;
                    }
                    if (certSerialNum == null) {
                        OCSPException e = new OCSPException("error certSerialNum is null");
                        e.printStackTrace();
                        return;
                    }
                    if (hashAlg == null) {
                        try {
                            this.hashAlg = AlgorithmId.get((String)"SHA-1");
                        }
                        catch (NoSuchAlgorithmException e) {
                            if (debug != null) {
                                System.out.println("internal error");
                                e.printStackTrace();
                            }
                            break block17;
                        }
                    }
                    try {
                        this.hashAlg = AlgorithmId.get((String)hashAlg);
                    }
                    catch (NoSuchAlgorithmException e) {
                        if (debug == null) break block17;
                        System.out.println("internal error");
                        e.printStackTrace();
                    }
                }
                this.issuerDN = issuerDN;
                this.issuerPubKey = issuerPubKey;
                this.certSerialNum = certSerialNum;
                md = null;
                try {
                    md = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException e) {
                    System.out.println("internal error");
                    e.printStackTrace();
                }
                try {
                    md.update(new X500Name(issuerDN).getEncoded());
                }
                catch (IOException ex) {
                    if (debug == null) break block18;
                    System.out.println("internal error");
                    ex.printStackTrace();
                }
            }
            this.issuerNameHash = md.digest();
            byte[] data = this.issuerPubKey.getEncoded();
            try {
                MessageDigest sha1;
                byte[] keyBytes;
                block19: {
                    DerValue val = new DerValue(data);
                    DerValue[] seq = new DerValue[]{val.getData().getDerValue(), val.getData().getDerValue()};
                    keyBytes = seq[1].getBitString();
                    sha1 = null;
                    this.issuerkeyHash = new byte[20];
                    try {
                        sha1 = MessageDigest.getInstance("SHA-1");
                    }
                    catch (NoSuchAlgorithmException ex) {
                        if (debug == null) break block19;
                        System.out.println("internal error");
                        ex.printStackTrace();
                    }
                }
                sha1.update(keyBytes);
                this.issuerkeyHash = sha1.digest();
            }
            catch (IOException ex) {
                if (debug == null) break block20;
                System.out.println("internal error");
                ex.printStackTrace();
            }
        }
    }

    public CertID(byte[] encodedData) throws IOException {
        this.issuerDN = null;
        this.hashAlg = null;
        this.issuerPubKey = null;
        this.certSerialNum = null;
        this.issuerNameHash = null;
        this.issuerkeyHash = null;
        DerValue val = new DerValue(encodedData);
        DerValue[] derValues = new DerInputStream(val.toByteArray()).getSequence(2);
        this.hashAlg = AlgorithmId.parse((DerValue)derValues[0]);
        this.issuerNameHash = derValues[1].getOctetString();
        this.issuerkeyHash = derValues[2].getOctetString();
        int cernum = derValues[3].getInteger().intValue();
        this.certSerialNum = new BigInteger("" + cernum);
    }

    public CertID(DerValue der) throws IOException {
        this(der.toByteArray());
    }

    public String getHashAlgorithm() {
        return this.hashAlg.getName();
    }

    public String toString() {
        StringBuffer ar = new StringBuffer();
        try {
            ar.append("CertId \n");
            ar.append("Algorithm: " + this.hashAlg.toString() + "\n");
            ar.append("issuerName \n");
            ar.append(this.issuerDN);
            HexDumpEncoder encoder = new HexDumpEncoder();
            ar.append("issuerNameHash\n");
            ar.append(encoder.encode(this.issuerNameHash));
            ar.append("\nissuerKey: \n");
            if (this.issuerkeyHash == null) {
                ar.append(encoder.encode(this.issuerPubKey.getEncoded()));
            } else {
                ar.append(encoder.encode(this.issuerkeyHash));
            }
            ar.append("\n" + this.certSerialNum.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ar.toString();
    }

    public byte[] encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        if (this.hashAlg == null) {
            throw new IOException("hash alg is null");
        }
        this.hashAlg.encode(out);
        out.putOctetString(this.issuerNameHash);
        out.putOctetString(this.issuerkeyHash);
        out.putInteger(this.certSerialNum.intValue());
        temp.write((byte)48, out.toByteArray());
        return temp.toByteArray();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof CertID)) {
            return false;
        }
        CertID tst = (CertID)obj;
        if (debug != null) {
            System.out.println("CertID.equal, hash alg: " + this.hashAlg.getName() + ", tst hash alg: " + tst.getHashAlgorithm());
        }
        if (this.hashAlg.getName().equals(tst.getHashAlgorithm()) && Arrays.equals(this.issuerNameHash, tst.issuerNameHash)) {
            if (debug != null) {
                System.out.println("CertID.equal, name hash is equal");
            }
            if (Arrays.equals(this.issuerkeyHash, tst.issuerkeyHash)) {
                if (debug != null) {
                    System.out.println("CertID.equal, key hash is equal");
                }
                if (this.certSerialNum.equals(tst.certSerialNum)) {
                    if (debug != null) {
                        System.out.println("CertID.equal, serial number is equal");
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public BigInteger getTargetCertSerialNumber() {
        return this.certSerialNum;
    }

    public String getIssuerName() {
        return this.issuerDN;
    }

    public PublicKey getIssuerPublicKey() {
        return this.issuerPubKey;
    }
}

