/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertPathUtil;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.X509CertImpl;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicChecker
extends PKIXCertPathChecker {
    static final String[] myExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.BasicConstraints").toString(), OIDMap.getOID((String)"x509.info.extensions.KeyUsage").toString()};
    static final String[] mySometimesExtensions = new String[]{OIDMap.getOID((String)"x509.info.extensions.ExtKeyUsage").toString()};
    private PublicKey workingPublicKey;
    private X500Principal workingIssuerName;
    private String workingPubKeyAlg;
    private Set trustBaseSet;
    private Date validationDate;
    private int numberOfCertsInCertPath;
    private CertPath certPath;
    private int currentCertIndex;
    private int maxPathLength;
    private String sigProvider;
    private TrustAnchor anchor;

    public BasicChecker(CertPath certPath, Set trustBaseSet, Date validationDate, String sigProvider) throws CertPathValidatorException {
        this.certPath = certPath;
        this.trustBaseSet = trustBaseSet;
        this.validationDate = validationDate;
        this.sigProvider = sigProvider;
        List<? extends Certificate> certPathCerts = certPath.getCertificates();
        this.maxPathLength = this.numberOfCertsInCertPath = certPathCerts.size();
        this.currentCertIndex = this.numberOfCertsInCertPath - 1;
        if (this.numberOfCertsInCertPath < 1) {
            return;
        }
        X509Certificate rootCert = (X509Certificate)certPathCerts.get(this.numberOfCertsInCertPath - 1);
        if (rootCert != null) {
            try {
                this.anchor = CertPathUtil.findIssuer(rootCert, trustBaseSet, sigProvider);
            }
            catch (CertPathValidatorException e) {
                throw new CertPathValidatorException("The certificate issued by " + rootCert.getIssuerX500Principal().toString() + " is not trusted", (Throwable)e, certPath, this.numberOfCertsInCertPath - 1);
            }
            X509Certificate issuer = this.anchor.getTrustedCert();
            if (issuer != null) {
                if (!(issuer instanceof X509CertImpl)) {
                    try {
                        issuer = new X509CertImpl(issuer.getEncoded());
                    }
                    catch (CertificateException ex) {
                        throw new CertPathValidatorException(ex.getMessage());
                    }
                }
                this.workingPublicKey = issuer.getPublicKey();
                this.workingIssuerName = issuer.getSubjectX500Principal();
                this.workingPubKeyAlg = this.workingPublicKey.getAlgorithm();
            } else {
                this.workingPublicKey = this.anchor.getCAPublicKey();
                this.workingIssuerName = this.anchor.getCA();
                this.workingPubKeyAlg = this.workingPublicKey.getAlgorithm();
            }
        } else {
            throw new CertPathValidatorException("No certificates in the path", null, certPath, this.numberOfCertsInCertPath - 1);
        }
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("The direction of forward is not supported");
        }
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate certificate, Collection unresolvedCritExts) throws CertPathValidatorException {
        X509CertImpl currentCert;
        if (certificate instanceof X509CertImpl) {
            currentCert = (X509CertImpl)certificate;
        } else {
            try {
                currentCert = new X509CertImpl(certificate.getEncoded());
            }
            catch (CertificateException ex) {
                throw new CertPathValidatorException(ex.getMessage());
            }
        }
        try {
            int result = CertPathUtil.verifyIssuer((X509Certificate)currentCert, this.workingPublicKey, this.workingIssuerName, this.sigProvider);
        }
        catch (CertPathValidatorException e) {
            throw new CertPathValidatorException("Fail to verify issuer", (Throwable)e, this.certPath, this.currentCertIndex);
        }
        try {
            currentCert.checkValidity(this.validationDate);
        }
        catch (CertificateExpiredException e) {
            throw new CertPathValidatorException("The certificate expired at " + currentCert.getNotAfter(), (Throwable)e, this.certPath, this.currentCertIndex);
        }
        catch (CertificateNotYetValidException e) {
            throw new CertPathValidatorException("The certificate is not valid until " + currentCert.getNotBefore(), (Throwable)e, this.certPath, this.currentCertIndex);
        }
        if (this.currentCertIndex > 0) {
            String message;
            int pathLC;
            boolean caCertificate = true;
            Object[] bcResult = CertPathUtil.getBasicConstraints((X509Certificate)currentCert);
            if (bcResult[0] == null) {
                throw new CertPathValidatorException("The CA certificate did not contain BasicConstraints", null, this.certPath, this.currentCertIndex);
            }
            caCertificate = (Boolean)bcResult[1];
            if (!caCertificate) {
                throw new CertPathValidatorException("The certificate is not a CA certificate.", null, this.certPath, this.currentCertIndex);
            }
            if (!currentCert.getIssuerX500Principal().equals(currentCert.getSubjectX500Principal())) {
                if (this.maxPathLength > 0) {
                    --this.maxPathLength;
                } else {
                    throw new CertPathValidatorException("Max path length incorrect", null, this.certPath, this.currentCertIndex);
                }
            }
            if ((pathLC = ((Integer)bcResult[2]).intValue()) >= 0 && pathLC < this.maxPathLength) {
                this.maxPathLength = pathLC;
            }
            if ((message = this.checkKeyUsage((X509Certificate)currentCert, unresolvedCritExts)) != null) {
                throw new CertPathValidatorException(message, null, this.certPath, this.currentCertIndex);
            }
            this.workingPublicKey = currentCert.getPublicKey();
            this.workingIssuerName = currentCert.getSubjectX500Principal();
            --this.currentCertIndex;
        }
        CertPathUtil.removeExtensions(unresolvedCritExts, myExtensions);
    }

    @Override
    public Object clone() {
        return null;
    }

    String checkKeyUsage(X509Certificate cert, Collection unresolvedCritExts) throws CertPathValidatorException {
        String errorString = null;
        boolean[] keyUsage = CertPathUtil.getKeyUsage(cert);
        if (keyUsage != null) {
            if (!keyUsage[5]) {
                errorString = "This certificate may not sign other certificates";
                return errorString;
            }
            Collection extKeyUsage = CertPathUtil.getExtendedKeyUsage(cert);
            if (extKeyUsage != null) {
                Iterator iter = extKeyUsage.iterator();
                boolean found = false;
                while (iter.hasNext()) {
                    String eku = (String)iter.next();
                    if (eku.equals("1.3.6.1.5.5.7.1")) {
                        if (!keyUsage[0] && !keyUsage[2] && !keyUsage[4]) continue;
                        found = true;
                        break;
                    }
                    if (eku.equals("1.3.6.1.5.5.7.2")) {
                        if (!keyUsage[0] && !keyUsage[4]) continue;
                        found = true;
                        break;
                    }
                    if (eku.equals("1.3.6.1.5.5.7.3")) {
                        if (!keyUsage[0]) continue;
                        found = true;
                        break;
                    }
                    if (eku.equals("1.3.6.1.5.5.7.4")) {
                        if (!keyUsage[0] && !keyUsage[1] && !keyUsage[2] && !keyUsage[4]) continue;
                        found = true;
                        break;
                    }
                    if (!eku.equals("1.3.6.1.5.5.7.8") || !keyUsage[0] && !keyUsage[1]) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    errorString = "Inconsistent key usage in the certificate.";
                }
            }
        }
        return errorString;
    }

    public TrustAnchor getTrustAnchor() {
        return this.anchor;
    }
}

