/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.JDKClassLoader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class ClassInfo {
    private static final ClassLoader NULL_CL = NULL_CL_CLASS.access$000();
    private static final Reference NULL_CL_REF = new StrongReference(NULL_CL);
    static final Class NULL_CLASS = NULL_CLASS_TYPE.class;
    static final Reference NULL_CLASS_REF = new StrongReference(NULL_CLASS);
    static final String thisClassName = "com.ibm.rmi.util.ClassInfo";
    private static Method latestLoaderMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JDKClassLoader.getMethodLatestUserDefinedLoader();
        }
    });
    private Reference actualTypeRef;
    private Reference expectedTypeRef;
    private String codebase;
    private String repID;
    private Reference preferredLoaderRef;
    private Reference userLoaderRef;
    private Reference contextLoaderRef;
    private Reference actualLoaderRef;

    public ClassInfo(Class clazz, Class clazz2, String string, String string2, ClassLoader classLoader) {
        this.setActualType(clazz);
        this.setExpectedType(clazz2);
        this.codebase = string;
        this.repID = string2;
        this.setPreferredLoader(classLoader);
        this.setLatestUserDefinedLoader(ClassInfo.latestUserDefinedLoader());
        this.setContextLoader(Thread.currentThread().getContextClassLoader());
        this.setActualLoader(clazz == null ? null : clazz.getClassLoader());
    }

    public boolean isActualClassFindable() {
        return this.getActualType() != NULL_CLASS;
    }

    public boolean matches(Class clazz, String string, String string2, ClassLoader classLoader) {
        if (this.codebase != null && !this.codebase.equals(string) || this.codebase == null && string != null) {
            return false;
        }
        if (this.repID != null && !this.repID.equals(string2) || this.repID == null && string2 != null) {
            return false;
        }
        clazz = ClassInfo.substituteIfNull(clazz);
        classLoader = ClassInfo.substituteIfNull(classLoader);
        ClassLoader classLoader2 = ClassInfo.substituteIfNull(ClassInfo.latestUserDefinedLoader());
        ClassLoader classLoader3 = ClassInfo.substituteIfNull(Thread.currentThread().getContextClassLoader());
        Class clazz2 = this.getActualType();
        Class clazz3 = this.getExpectedType();
        ClassLoader classLoader4 = this.getPreferredLoader();
        ClassLoader classLoader5 = this.getUserLoader();
        ClassLoader classLoader6 = this.getContextLoader();
        ClassLoader classLoader7 = this.getActualLoader();
        if (clazz2 == null) {
            return false;
        }
        if (clazz2 == NULL_CLASS) {
            return classLoader4 == classLoader && classLoader5 == classLoader2 && classLoader6 == classLoader3 && clazz3 == clazz;
        }
        if (clazz != NULL_CLASS && !clazz.isAssignableFrom(clazz2)) {
            return false;
        }
        if (classLoader7 == null) {
            return false;
        }
        if (classLoader7 == NULL_CL) {
            return true;
        }
        if (ClassInfo.isAncestor(classLoader7, classLoader)) {
            return true;
        }
        if (classLoader == classLoader4) {
            if (ClassInfo.isAncestor(classLoader7, classLoader2)) {
                return true;
            }
            if (classLoader2 == classLoader5) {
                if (ClassInfo.isAncestor(classLoader7, classLoader3)) {
                    return true;
                }
                if (classLoader3 == classLoader6) {
                    return true;
                }
            }
        }
        return false;
    }

    private static ClassLoader substituteIfNull(ClassLoader classLoader) {
        return classLoader == null ? NULL_CL : classLoader;
    }

    private static Reference createClassLoaderRef(ClassLoader classLoader) {
        return classLoader == null ? NULL_CL_REF : new WeakReference<ClassLoader>(classLoader);
    }

    private static Class substituteIfNull(Class clazz) {
        return clazz == null ? NULL_CLASS : clazz;
    }

    private static Reference createClassRef(Class clazz) {
        return clazz == null ? NULL_CLASS_REF : new WeakReference<Class>(clazz);
    }

    public static boolean isCompatible(Class clazz, Class clazz2, ClassLoader classLoader) {
        if (clazz2 != null && !clazz2.isAssignableFrom(clazz)) {
            return false;
        }
        ClassLoader classLoader2 = clazz.getClassLoader();
        if (classLoader2 == null) {
            return true;
        }
        return ClassInfo.isAncestor(classLoader2, classLoader) || ClassInfo.isAncestor(classLoader2, Thread.currentThread().getContextClassLoader()) || ClassInfo.isAncestor(classLoader2, ClassInfo.latestUserDefinedLoader());
    }

    public Class getActualClass() {
        Class clazz = this.getActualType();
        return clazz == NULL_CLASS ? null : clazz;
    }

    private static boolean isAncestor(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 != NULL_CL) {
            while (classLoader2 != null && classLoader != classLoader2) {
                classLoader2 = classLoader2.getParent();
            }
        }
        return classLoader == classLoader2;
    }

    private static ClassLoader latestUserDefinedLoader() {
        ClassLoader classLoader = null;
        if (latestLoaderMethod != null) {
            try {
                classLoader = (ClassLoader)latestLoaderMethod.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, thisClassName, "latestUserDefinedLoader:332", exception);
            }
        }
        return classLoader;
    }

    private void setActualLoader(ClassLoader classLoader) {
        this.actualLoaderRef = ClassInfo.createClassLoaderRef(classLoader);
    }

    private ClassLoader getActualLoader() {
        return (ClassLoader)this.actualLoaderRef.get();
    }

    private void setPreferredLoader(ClassLoader classLoader) {
        this.preferredLoaderRef = ClassInfo.createClassLoaderRef(classLoader);
    }

    private ClassLoader getPreferredLoader() {
        return (ClassLoader)this.preferredLoaderRef.get();
    }

    private void setLatestUserDefinedLoader(ClassLoader classLoader) {
        this.userLoaderRef = ClassInfo.createClassLoaderRef(classLoader);
    }

    private ClassLoader getUserLoader() {
        return (ClassLoader)this.userLoaderRef.get();
    }

    private void setContextLoader(ClassLoader classLoader) {
        this.contextLoaderRef = ClassInfo.createClassLoaderRef(classLoader);
    }

    private ClassLoader getContextLoader() {
        return (ClassLoader)this.contextLoaderRef.get();
    }

    private void setActualType(Class clazz) {
        this.actualTypeRef = ClassInfo.createClassRef(clazz);
    }

    private Class getActualType() {
        return (Class)this.actualTypeRef.get();
    }

    private void setExpectedType(Class clazz) {
        this.expectedTypeRef = ClassInfo.createClassRef(clazz);
    }

    private Class getExpectedType() {
        return (Class)this.expectedTypeRef.get();
    }

    private static final class NULL_CLASS_TYPE {
        private NULL_CLASS_TYPE() {
        }
    }

    private static final class NULL_CL_CLASS
    extends ClassLoader {
        private static final ClassLoader instance = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new NULL_CL_CLASS();
            }
        });

        private NULL_CL_CLASS() {
        }

        private static ClassLoader getInstance() {
            return instance;
        }

        static /* synthetic */ ClassLoader access$000() {
            return NULL_CL_CLASS.getInstance();
        }
    }

    private static final class StrongReference
    extends WeakReference {
        private Object referent;

        StrongReference(Object object) {
            super(null);
            this.referent = object;
        }

        public Object get() {
            return this.referent;
        }
    }
}

