/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.poa;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.pi.InterceptorManager;
import com.ibm.rmi.poa.POACurrent;
import com.ibm.rmi.poa.POAImpl;
import com.ibm.rmi.poa.POAManagerImplState;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA_2_3.ORB;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAManagerPackage.State;

public class POAManagerImpl
extends LocalObject
implements POAManager {
    private static final String CLASS = POAManagerImpl.class.getName();
    private ORB orb;
    private POAManagerImplState state = POAManagerImplState.HOLDING;
    private Set poas = Collections.synchronizedSet(new HashSet());
    private int nInvocations = 0;
    private int nThreads = 0;
    private boolean beingDestroyed = false;
    private static int nextId = 0;
    private int id = -1;
    private static Set poaManagers = Collections.synchronizedSet(new HashSet());
    private static final String[] _type_ids = new String[]{"IDL:omg.org/PortableServer/POAManager:1.0"};
    private static final long serialVersionUID = 0L;

    public POAManagerImpl(ORB oRB) {
        this.orb = oRB;
        this.id = nextId++;
        poaManagers.add(this);
    }

    protected ORB getORB() {
        return this.orb;
    }

    public int getID() {
        return this.id;
    }

    public static void shutdown(ORB oRB, boolean bl) {
        Object[] objectArray = poaManagers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            POAManagerImpl pOAManagerImpl = (POAManagerImpl)((Object)objectArray[i]);
            if (pOAManagerImpl.getORB() != oRB) continue;
            try {
                pOAManagerImpl.deactivate(true, bl);
                continue;
            }
            catch (AdapterInactive adapterInactive) {
                if (!ORBRas.isTrcLogging) continue;
                ORBRas.orbTrcLogger.trace(4112L, (Object)pOAManagerImpl, "shutdown:121", adapterInactive.toString());
            }
        }
    }

    synchronized void addPOA(POA pOA) {
        if (this.state != POAManagerImplState.INACTIVE && this.state != POAManagerImplState.NON_EXISTENT) {
            this.poas.add(pOA);
        }
    }

    synchronized void removePOA(POA pOA) {
        this.poas.remove(pOA);
        try {
            this.discard_requests(false);
        }
        catch (AdapterInactive adapterInactive) {
            // empty catch block
        }
    }

    public synchronized void activate() throws AdapterInactive {
        if (this.state == POAManagerImplState.INACTIVE || this.state == POAManagerImplState.NON_EXISTENT) {
            throw new AdapterInactive();
        }
        this.setState(POAManagerImplState.ACTIVE);
        ((Object)((Object)this)).notifyAll();
    }

    public synchronized State get_state() {
        int n = this.state.value();
        if (n == 4) {
            n = 3;
        }
        return State.from_int((int)n);
    }

    public synchronized void hold_requests(boolean bl) throws AdapterInactive {
        if (this.state == POAManagerImplState.INACTIVE || this.state == POAManagerImplState.NON_EXISTENT) {
            throw new AdapterInactive();
        }
        if (bl && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER("wait_for_completion is TRUE and the current thread is in an invocation context dispatched from some POA belonging to the same ORB as this POA", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        this.setState(POAManagerImplState.HOLDING);
        ((Object)((Object)this)).notifyAll();
        if (bl) {
            ++this.nThreads;
            while (this.state == POAManagerImplState.HOLDING && this.nInvocations > 0) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.nThreads;
        }
    }

    public synchronized void discard_requests(boolean bl) throws AdapterInactive {
        if (this.state == POAManagerImplState.INACTIVE || this.state == POAManagerImplState.NON_EXISTENT) {
            throw new AdapterInactive();
        }
        if (bl && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER("wait_for_completion is TRUE and the current thread is in an invocation context dispatched from some POA belonging to the same ORB as this POA", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        this.setState(POAManagerImplState.DISCARDING);
        ((Object)((Object)this)).notifyAll();
        if (bl) {
            ++this.nThreads;
            while (this.state == POAManagerImplState.DISCARDING && this.nInvocations > 0) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.nThreads;
        }
    }

    public synchronized void deactivate(boolean bl, boolean bl2) throws AdapterInactive {
        if (!(this.state != POAManagerImplState.NON_EXISTENT && this.state != POAManagerImplState.INACTIVE || this.beingDestroyed)) {
            throw new AdapterInactive();
        }
        if (bl2 && this.isInInvocationContext()) {
            throw new BAD_INV_ORDER("wait_for_completion is TRUE and the current thread is in an invocation context dispatched from some POA belonging to the same ORB as this POA", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        if (this.beingDestroyed) {
            if (bl2) {
                while (this.beingDestroyed) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            return;
        }
        this.beingDestroyed = true;
        this.setState(POAManagerImplState.INACTIVE);
        ((Object)((Object)this)).notifyAll();
        if (bl2) {
            ++this.nThreads;
            while (this.nInvocations > 0) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.nThreads;
        }
        if (bl) {
            if (bl2) {
                this.etherealizePOAs();
                this.internalDeactivate();
            } else {
                Thread thread = new Thread(){

                    public void run() {
                        POAManagerImpl.this.etherealizePOAs();
                        POAManagerImpl.this.internalDeactivate();
                    }
                };
                thread.start();
            }
        } else {
            this.internalDeactivate();
        }
    }

    private synchronized void internalDeactivate() {
        poaManagers.remove((Object)this);
        this.poas.clear();
        this.beingDestroyed = false;
        this.setState(POAManagerImplState.NON_EXISTENT);
        ((Object)((Object)this)).notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void etherealizePOAs() {
        Set set = this.poas;
        synchronized (set) {
            for (POAImpl pOAImpl : this.poas) {
                pOAImpl.etherealizeAll();
            }
        }
    }

    protected boolean isInInvocationContext() {
        POA[] pOAArray = null;
        POACurrent pOACurrent = null;
        POA pOA = null;
        try {
            pOACurrent = (POACurrent)this.orb.resolve_initial_references("POACurrent");
            pOA = (POA)this.orb.resolve_initial_references("RootPOA");
        }
        catch (InvalidName invalidName) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(4112L, (Object)this, "isInInvocationContext:395", invalidName.toString());
            }
            return false;
        }
        try {
            pOAArray = pOACurrent.get_POA_stack();
        }
        catch (NoContext noContext) {
            return false;
        }
        for (int i = 0; i < pOAArray.length; ++i) {
            while (pOAArray[i].the_parent() != null) {
                pOAArray[i] = pOAArray[i].the_parent();
            }
            if (pOAArray[i] != pOA) continue;
            return true;
        }
        return false;
    }

    synchronized void enter() {
        while (this.state != POAManagerImplState.ACTIVE) {
            switch (this.state.value()) {
                case 0: {
                    while (this.state == POAManagerImplState.HOLDING) {
                        try {
                            ((Object)((Object)this)).wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    break;
                }
                case 2: {
                    throw new TRANSIENT(1330446337, CompletionStatus.COMPLETED_NO);
                }
                case 3: {
                    throw new OBJ_ADAPTER("This POA is in INACTIVE state", 1229126557, CompletionStatus.COMPLETED_NO);
                }
                case 4: {
                    throw new OBJ_ADAPTER("This POA is in NON_EXISTENT state", 1229126583, CompletionStatus.COMPLETED_NO);
                }
            }
        }
        ++this.nInvocations;
    }

    synchronized void exit() {
        --this.nInvocations;
        if (this.nThreads > 0 && this.nInvocations == 0) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    private void setState(POAManagerImplState pOAManagerImplState) {
        this.state = pOAManagerImplState;
        com.ibm.CORBA.iiop.ORB oRB = (com.ibm.CORBA.iiop.ORB)this.orb;
        if (oRB.getState() != 4) {
            InterceptorManager interceptorManager = (InterceptorManager)oRB.getInterceptorManager();
            interceptorManager.iterateAdapterManagerStateChanged(this.id, (short)this.state.value());
        }
    }

    public String[] _ids() {
        return (String[])_type_ids.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        NotSerializableException notSerializableException = new NotSerializableException(((Object)((Object)this)).getClass().getName());
        Trc.ffdc(notSerializableException, CLASS, "writeObject:480");
        throw notSerializableException;
    }
}

