/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.pi;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.PMIPlugin;
import com.ibm.CORBA.iiop.Request;
import com.ibm.CORBA.iiop.RequestMessage;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.Profile;
import com.ibm.rmi.corba.ClientDelegate;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.pi.ClientRequestInfoImpl;
import com.ibm.rmi.pi.CurrentImpl;
import com.ibm.rmi.pi.IORInfoImpl;
import com.ibm.rmi.pi.ORBInitInfoImpl;
import com.ibm.rmi.pi.ServerRequestInfoImpl;
import com.ibm.rmi.poa.POAImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.IORInterceptor_3_0;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorManager
implements com.ibm.CORBA.iiop.InterceptorManager {
    private static final String CLASS = InterceptorManager.class.getName();
    private ORB orb;
    private PMIPlugin pmiServer;
    public static final int STATE_NOTHING = 0;
    public static final int STATE_PRE_INIT = 1;
    public static final int STATE_POST_INIT = 2;
    public static final int STATE_SEND_REQUEST = 3;
    public static final int STATE_SEND_POLL = 4;
    public static final int STATE_RECEIVE_REPLY = 5;
    public static final int STATE_RECEIVE_EXCEPTION = 6;
    public static final int STATE_RECEIVE_OTHER = 7;
    public static final int STATE_RECEIVE_CONTEXT = 8;
    public static final int STATE_RECEIVE_REQUEST = 9;
    public static final int STATE_SEND_REPLY = 10;
    public static final int STATE_SEND_EXCEPTION = 11;
    public static final int STATE_SEND_OTHER = 12;
    public static final int STATE_ESTABLISH_COMPONENTS = 13;
    public static final int STATE_COMPONENTS_ESTABLISHED = 14;
    public static final int STATE_COMPONENTS_ESTABLISHED_COMPLETE = 15;
    private ORBInitInfoImpl orbInitInfo = null;
    private InterceptorList clientList = null;
    private InterceptorList serverList = null;
    private InterceptorList iorList = null;
    private ClientRequestInterceptor[] clientInterceptors = null;
    private ClientRequestInterceptor[] clientLocalItors = null;
    private ServerRequestInterceptor[] serverInterceptors = null;
    private ServerRequestInterceptor[] serverLocalItors = null;
    private IORInterceptor[] iorInterceptors = null;
    private CurrentImpl piCurrent;
    private int maxSlotId = 0;

    public InterceptorManager(ORB oRB) {
        this.orb = oRB;
    }

    public void pmiInit() {
        if (this.orb != null) {
            this.pmiServer = this.orb.getPMIServer();
        }
    }

    public List runPreInit(List list) {
        Trc.begin(CLASS, "runPreInit:150");
        this.pmiInit();
        this.clientList = new InterceptorList(!this.orb.noLocalInterceptors());
        this.serverList = new InterceptorList(!this.orb.noLocalInterceptors());
        this.iorList = new InterceptorList(false);
        ArrayList<ORBInitializer> arrayList = new ArrayList<ORBInitializer>();
        for (int i = 0; i < list.size(); ++i) {
            ORBInitializer oRBInitializer;
            String string = (String)list.get(i);
            try {
                Trc.info("Run initializer: ", string, CLASS, "runPreInit:169");
                Class clazz = Util.loadClass((String)string, null, null);
                oRBInitializer = (ORBInitializer)clazz.newInstance();
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "runPreInit:176");
                continue;
            }
            try {
                oRBInitializer.pre_init(this.getORBInitInfo(1));
            }
            catch (RuntimeException runtimeException) {
                if (this.orb.getUseOMG5689()) {
                    throw runtimeException;
                }
                Trc.ffdc(runtimeException, CLASS, "runPreInit:190");
            }
            arrayList.add(oRBInitializer);
        }
        Trc.complete(CLASS, "runPreInit:196");
        return arrayList;
    }

    public void runPostInit(List list) {
        Trc.begin(CLASS, "runPostInit:202");
        for (int i = 0; i < list.size(); ++i) {
            ORBInitializer oRBInitializer = (ORBInitializer)list.get(i);
            Trc.info("Run initializer: ", Trc.clz(oRBInitializer), CLASS, "runPostInit:208");
            try {
                oRBInitializer.post_init(this.getORBInitInfo(2));
                continue;
            }
            catch (RuntimeException runtimeException) {
                if (this.orb.getUseOMG5689()) {
                    throw runtimeException;
                }
                Trc.ffdc(runtimeException, CLASS, "runPostInit:220");
            }
        }
        Trc.complete(CLASS, "runPostInit:225");
    }

    private ORBInitInfo getORBInitInfo(int n) {
        if (this.orbInitInfo == null) {
            this.orbInitInfo = new ORBInitInfoImpl(this.orb, this);
        }
        this.orbInitInfo.setState(n);
        return this.orbInitInfo;
    }

    public void addClientInterceptor(ClientRequestInterceptor clientRequestInterceptor, boolean bl, boolean bl2) throws DuplicateName {
        this.clientList.add((Interceptor)clientRequestInterceptor, bl, bl2);
    }

    public void addServerInterceptor(ServerRequestInterceptor serverRequestInterceptor, boolean bl, boolean bl2) throws DuplicateName {
        this.serverList.add((Interceptor)serverRequestInterceptor, bl, bl2);
    }

    public void addIORInterceptor(IORInterceptor iORInterceptor, boolean bl) throws DuplicateName {
        this.iorList.add((Interceptor)iORInterceptor, bl, false);
    }

    public void initComplete(CurrentImpl currentImpl) {
        this.clientInterceptors = this.clientList.getClientInterceptors(false);
        this.clientLocalItors = this.clientList.getClientInterceptors(true);
        this.serverInterceptors = this.serverList.getServerInterceptors(false);
        this.serverLocalItors = this.serverList.getServerInterceptors(true);
        this.iorInterceptors = this.iorList.getIORInterceptors();
        this.iorList = null;
        this.serverList = null;
        this.clientList = null;
        this.piCurrent = currentImpl;
        this.piCurrent.setSlotCount(this.maxSlotId);
    }

    public boolean haveClientInterceptors() {
        return this.clientInterceptors != null;
    }

    public boolean haveServerInterceptors() {
        return this.serverInterceptors != null;
    }

    public boolean haveIORInterceptors() {
        return this.iorInterceptors != null;
    }

    public boolean haveLocalClientInterceptors() {
        return this.clientLocalItors != null;
    }

    public boolean haveLocalServerInterceptors() {
        return this.serverLocalItors != null;
    }

    private ForwardRequest iterateClientInterceptors(ClientRequestInfoImpl clientRequestInfoImpl) {
        int n;
        int n2;
        int n3;
        ClientRequestInterceptor[] clientRequestInterceptorArray;
        ClientRequestInterceptor[] clientRequestInterceptorArray2 = clientRequestInterceptorArray = clientRequestInfoImpl.notLocal() ? this.clientInterceptors : this.clientLocalItors;
        if (clientRequestInterceptorArray == null) {
            return null;
        }
        switch (clientRequestInfoImpl.state) {
            case 3: {
                n3 = 0;
                n2 = clientRequestInterceptorArray.length;
                n = 1;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n3 = clientRequestInfoImpl.getLastIndex();
                n2 = -1;
                n = -1;
                break;
            }
            default: {
                throw new INTERNAL("Unexpected state for ClientRequestInfo: " + clientRequestInfoImpl.state);
            }
        }
        int n4 = n3;
        try {
            this.piCurrent.push();
            for (n4 = n3; n4 != n2; n4 += n) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateClientInterceptors:400", "Run interceptor: " + clientRequestInterceptorArray[n4]);
                }
                if (this.pmiServer == null) {
                    this.invokeInterceptor(clientRequestInterceptorArray[n4], clientRequestInfoImpl);
                    continue;
                }
                long l = System.currentTimeMillis();
                this.invokeInterceptor(clientRequestInterceptorArray[n4], clientRequestInfoImpl);
                l = System.currentTimeMillis() - l;
                this.pmiServer.postInterceptorRun((Interceptor)clientRequestInterceptorArray[n4], l);
            }
        }
        catch (ForwardRequest forwardRequest) {
            if (ORBRas.isTrcLogging || clientRequestInfoImpl.state == 5) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateClientInterceptors:417", (Exception)((java.lang.Object)forwardRequest));
            }
            ForwardRequest forwardRequest2 = forwardRequest;
            return forwardRequest2;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (RuntimeException runtimeException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "iterateClientInterceptors:425", (Exception)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateClientInterceptors:430", error.toString(), (java.lang.Object)error);
            throw error;
        }
        finally {
            this.piCurrent.pop();
            clientRequestInfoImpl.setLastIndex(n4 - 1);
        }
        return null;
    }

    private ForwardRequest iterateServerInterceptors(ServerRequestInfoImpl serverRequestInfoImpl) {
        boolean bl;
        boolean bl2;
        int n;
        int n2;
        int n3;
        ServerRequestInterceptor[] serverRequestInterceptorArray;
        ServerRequestInterceptor[] serverRequestInterceptorArray2 = serverRequestInterceptorArray = serverRequestInfoImpl.notLocal() ? this.serverInterceptors : this.serverLocalItors;
        if (serverRequestInterceptorArray == null) {
            return null;
        }
        switch (serverRequestInfoImpl.state) {
            case 8: {
                n3 = 0;
                n2 = serverRequestInterceptorArray.length;
                n = 1;
                bl2 = true;
                bl = true;
                break;
            }
            case 9: {
                n3 = 0;
                n2 = serverRequestInfoImpl.getLastIndex() + 1;
                n = 1;
                bl2 = false;
                bl = false;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                n3 = serverRequestInfoImpl.getLastIndex();
                n2 = -1;
                n = -1;
                bl2 = false;
                bl = true;
                break;
            }
            default: {
                throw new INTERNAL("Unexpected state for ServerRequestInfo: " + serverRequestInfoImpl.state);
            }
        }
        int n4 = n3;
        try {
            if (bl2) {
                this.piCurrent.push();
            }
            for (n4 = n3; n4 != n2; n4 += n) {
                if (ORBRas.isTrcLogging) {
                    ORBRas.orbTrcLogger.trace(4112L, this, "iterateServerInterceptors:500", "Run interceptor: " + serverRequestInterceptorArray[n4]);
                }
                if (this.pmiServer == null) {
                    this.invokeInterceptor(serverRequestInterceptorArray[n4], serverRequestInfoImpl);
                    continue;
                }
                long l = System.currentTimeMillis();
                this.invokeInterceptor(serverRequestInterceptorArray[n4], serverRequestInfoImpl);
                l = System.currentTimeMillis() - l;
                this.pmiServer.postInterceptorRun((Interceptor)serverRequestInterceptorArray[n4], l);
            }
        }
        catch (ForwardRequest forwardRequest) {
            if (ORBRas.isTrcLogging || serverRequestInfoImpl.state == 10) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateServerInterceptors:517", (Exception)((java.lang.Object)forwardRequest));
            }
            ForwardRequest forwardRequest2 = forwardRequest;
            return forwardRequest2;
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (RuntimeException runtimeException) {
            ORBRas.orbTrcLogger.exception(4104L, this, "iterateServerInterceptors:525", (Exception)runtimeException);
            throw runtimeException;
        }
        catch (Error error) {
            ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateServerInterceptors:530", error.toString(), (java.lang.Object)error);
            throw error;
        }
        finally {
            if (bl2) {
                this.piCurrent.pop();
            }
            if (bl) {
                serverRequestInfoImpl.setLastIndex(n4 - 1);
            }
        }
        return null;
    }

    private void invokeInterceptor(ClientRequestInterceptor clientRequestInterceptor, ClientRequestInfoImpl clientRequestInfoImpl) throws ForwardRequest {
        switch (clientRequestInfoImpl.state) {
            case 3: {
                clientRequestInterceptor.send_request((ClientRequestInfo)clientRequestInfoImpl);
                break;
            }
            case 5: {
                clientRequestInterceptor.receive_reply((ClientRequestInfo)clientRequestInfoImpl);
                break;
            }
            case 6: {
                clientRequestInterceptor.receive_exception((ClientRequestInfo)clientRequestInfoImpl);
                break;
            }
            case 7: {
                clientRequestInterceptor.receive_other((ClientRequestInfo)clientRequestInfoImpl);
                break;
            }
            default: {
                throw new INTERNAL("Unexpected state for ClientRequestInfo: " + clientRequestInfoImpl.state);
            }
        }
    }

    private void invokeInterceptor(ServerRequestInterceptor serverRequestInterceptor, ServerRequestInfoImpl serverRequestInfoImpl) throws ForwardRequest {
        switch (serverRequestInfoImpl.state) {
            case 8: {
                serverRequestInterceptor.receive_request_service_contexts((ServerRequestInfo)serverRequestInfoImpl);
                break;
            }
            case 9: {
                serverRequestInterceptor.receive_request((ServerRequestInfo)serverRequestInfoImpl);
                break;
            }
            case 10: {
                serverRequestInterceptor.send_reply((ServerRequestInfo)serverRequestInfoImpl);
                break;
            }
            case 11: {
                serverRequestInterceptor.send_exception((ServerRequestInfo)serverRequestInfoImpl);
                break;
            }
            case 12: {
                serverRequestInterceptor.send_other((ServerRequestInfo)serverRequestInfoImpl);
                break;
            }
            default: {
                throw new INTERNAL("Unexpected state for ServerRequestInfo: " + serverRequestInfoImpl.state);
            }
        }
    }

    public void iterateSendRequest(ExtendedClientRequestInfo extendedClientRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendRequest:619");
        }
        ClientRequestInfoImpl clientRequestInfoImpl = (ClientRequestInfoImpl)extendedClientRequestInfo;
        clientRequestInfoImpl.setState(3);
        clientRequestInfoImpl.setRecursionDepth(this.piCurrent.depth());
        ForwardRequest forwardRequest = this.iterateClientInterceptors(clientRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendRequest:632");
        }
    }

    public void iterateReceiveReply(ExtendedClientRequestInfo extendedClientRequestInfo) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveReply:641");
        }
        ClientRequestInfoImpl clientRequestInfoImpl = (ClientRequestInfoImpl)extendedClientRequestInfo;
        clientRequestInfoImpl.setState(5);
        this.iterateClientInterceptors(clientRequestInfoImpl);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveReply:652");
        }
    }

    public void iterateReceiveException(ExtendedClientRequestInfo extendedClientRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveException:661");
        }
        ClientRequestInfoImpl clientRequestInfoImpl = (ClientRequestInfoImpl)extendedClientRequestInfo;
        clientRequestInfoImpl.setState(6);
        ForwardRequest forwardRequest = this.iterateClientInterceptors(clientRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveException:673");
        }
    }

    public void iterateReceiveOther(ExtendedClientRequestInfo extendedClientRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveOther:682");
        }
        ClientRequestInfoImpl clientRequestInfoImpl = (ClientRequestInfoImpl)extendedClientRequestInfo;
        clientRequestInfoImpl.setState(7);
        ForwardRequest forwardRequest = this.iterateClientInterceptors(clientRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveOther:694");
        }
    }

    public void iterateReceiveContext(ExtendedServerRequestInfo extendedServerRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveContext:708");
        }
        ServerRequestInfoImpl serverRequestInfoImpl = (ServerRequestInfoImpl)extendedServerRequestInfo;
        serverRequestInfoImpl.setState(8);
        ForwardRequest forwardRequest = this.iterateServerInterceptors(serverRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveContext:720");
        }
    }

    public void iterateReceiveRequest(ExtendedServerRequestInfo extendedServerRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateReceiveRequest:729");
        }
        ServerRequestInfoImpl serverRequestInfoImpl = (ServerRequestInfoImpl)extendedServerRequestInfo;
        serverRequestInfoImpl.setState(9);
        ForwardRequest forwardRequest = this.iterateServerInterceptors(serverRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateReceiveRequest:744");
        }
    }

    public void iterateSendReply(ExtendedServerRequestInfo extendedServerRequestInfo) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendReply:753");
        }
        ServerRequestInfoImpl serverRequestInfoImpl = (ServerRequestInfoImpl)extendedServerRequestInfo;
        serverRequestInfoImpl.setState(10);
        this.iterateServerInterceptors(serverRequestInfoImpl);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendReply:764");
        }
    }

    public void iterateSendException(ExtendedServerRequestInfo extendedServerRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendException:773");
        }
        ServerRequestInfoImpl serverRequestInfoImpl = (ServerRequestInfoImpl)extendedServerRequestInfo;
        serverRequestInfoImpl.setState(11);
        ForwardRequest forwardRequest = this.iterateServerInterceptors(serverRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendException:785");
        }
    }

    public void iterateSendOther(ExtendedServerRequestInfo extendedServerRequestInfo) throws ForwardRequest {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateSendOther:794");
        }
        ServerRequestInfoImpl serverRequestInfoImpl = (ServerRequestInfoImpl)extendedServerRequestInfo;
        serverRequestInfoImpl.setState(12);
        ForwardRequest forwardRequest = this.iterateServerInterceptors(serverRequestInfoImpl);
        if (forwardRequest != null) {
            throw forwardRequest;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateSendOther:806");
        }
    }

    public void iterateEstablishComponents(IORInfoImpl iORInfoImpl) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateEstablishComponents:814");
        }
        iORInfoImpl.setState(13);
        if (this.iorInterceptors != null) {
            try {
                for (int i = 0; i < this.iorInterceptors.length; ++i) {
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, this, "iterateEstablishComponents:825", "Run interceptor: " + this.iorInterceptors[i]);
                    }
                    if (this.pmiServer != null) {
                        long l = System.currentTimeMillis();
                        this.iorInterceptors[i].establish_components((IORInfo)iORInfoImpl);
                        long l2 = System.currentTimeMillis();
                        this.pmiServer.postInterceptorRun((Interceptor)this.iorInterceptors[i], l2 - l);
                        continue;
                    }
                    this.iorInterceptors[i].establish_components((IORInfo)iORInfoImpl);
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateEstablishComponents:848", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateEstablishComponents:855");
        }
    }

    public void iterateComponentsEstablished(IORInfoImpl iORInfoImpl) throws OBJ_ADAPTER {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateComponentsEstablished:864");
        }
        iORInfoImpl.setState(14);
        if (this.iorInterceptors != null) {
            try {
                for (int i = 0; i < this.iorInterceptors.length; ++i) {
                    if (!(this.iorInterceptors[i] instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 iORInterceptor_3_0 = (IORInterceptor_3_0)this.iorInterceptors[i];
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, this, "iterateComponentsEstablished:878", "Running interceptor: " + iORInterceptor_3_0);
                    }
                    if (this.pmiServer != null) {
                        long l = System.currentTimeMillis();
                        iORInterceptor_3_0.components_established((IORInfo)iORInfoImpl);
                        long l2 = System.currentTimeMillis();
                        this.pmiServer.postInterceptorRun((Interceptor)iORInterceptor_3_0, l2 - l);
                        continue;
                    }
                    iORInterceptor_3_0.components_established((IORInfo)iORInfoImpl);
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
                if (throwable instanceof Exception) {
                    ORBRas.orbTrcLogger.exception(4104L, this, "iterateComponentsEstablished:900", (Exception)throwable);
                } else {
                    ORBRas.orbTrcLogger.trace(4104L, (java.lang.Object)this, "iterateComponentsEstablished:904", throwable.toString(), (java.lang.Object)throwable);
                }
                throw new OBJ_ADAPTER(throwable.toString(), 1330446342, CompletionStatus.COMPLETED_NO);
            }
        }
        iORInfoImpl.setState(15);
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateComponentsEstablished:916");
        }
    }

    public void iterateAdapterManagerStateChanged(int n, short s) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateAdapterManagerStateChanged:926");
        }
        if (this.iorInterceptors != null) {
            try {
                for (int i = 0; i < this.iorInterceptors.length; ++i) {
                    if (!(this.iorInterceptors[i] instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 iORInterceptor_3_0 = (IORInterceptor_3_0)this.iorInterceptors[i];
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, this, "iterateAdapterManagerStateChanged:938", "Run interceptor: " + iORInterceptor_3_0);
                    }
                    if (this.pmiServer != null) {
                        long l = System.currentTimeMillis();
                        iORInterceptor_3_0.adapter_manager_state_changed(n, s);
                        long l2 = System.currentTimeMillis();
                        this.pmiServer.postInterceptorRun((Interceptor)iORInterceptor_3_0, l2 - l);
                        continue;
                    }
                    iORInterceptor_3_0.adapter_manager_state_changed(n, s);
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateAdapterManagerStateChanged:959", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateAdapterManagerStateChanged:966");
        }
    }

    public void iterateAdapterStateChanged(ObjectReferenceTemplate[] objectReferenceTemplateArray, short s) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "iterateAdapterManagerStateChanged:976");
        }
        if (this.iorInterceptors != null) {
            try {
                for (int i = 0; i < this.iorInterceptors.length; ++i) {
                    if (!(this.iorInterceptors[i] instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 iORInterceptor_3_0 = (IORInterceptor_3_0)this.iorInterceptors[i];
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(4112L, this, "iterateAdapterManagerStateChanged:988", "Run interceptor: " + iORInterceptor_3_0);
                    }
                    if (this.pmiServer != null) {
                        long l = System.currentTimeMillis();
                        iORInterceptor_3_0.adapter_state_changed(objectReferenceTemplateArray, s);
                        long l2 = System.currentTimeMillis();
                        this.pmiServer.postInterceptorRun((Interceptor)iORInterceptor_3_0, l2 - l);
                        continue;
                    }
                    iORInterceptor_3_0.adapter_state_changed(objectReferenceTemplateArray, s);
                }
            }
            catch (Exception exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "iterateAdapterManagerStateChanged:1009", exception);
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "iterateAdapterManagerStateChanged:1016");
        }
    }

    public ExtendedClientRequestInfo createClientInfo(Request request, RequestMessage requestMessage, ClientDelegate clientDelegate, Object object, org.omg.CORBA.Request request2, java.lang.Object object2, boolean bl) {
        ClientRequestInfoImpl clientRequestInfoImpl = new ClientRequestInfoImpl(this.orb, request, requestMessage, clientDelegate, object, object2, bl);
        if (request2 != null) {
            clientRequestInfoImpl.setParameters(request2);
        }
        clientRequestInfoImpl.setRequestCurrent(this.piCurrent.peek());
        return clientRequestInfoImpl;
    }

    public ExtendedServerRequestInfo createServerInfo(Request request, RequestMessage requestMessage, java.lang.Object object, boolean bl) {
        ServerRequestInfoImpl serverRequestInfoImpl = new ServerRequestInfoImpl(this.orb, request, requestMessage, object, bl);
        serverRequestInfoImpl.setRequestCurrent(this.piCurrent.empty());
        return serverRequestInfoImpl;
    }

    public IORInfoImpl createIORInfo(Profile profile, java.lang.Object object, POAImpl pOAImpl) {
        IORInfoImpl iORInfoImpl = new IORInfoImpl(this.orb, profile, object, pOAImpl);
        return iORInfoImpl;
    }

    public void setThreadCurrent(Any[] anyArray) {
        this.piCurrent.set(anyArray);
    }

    public int getNextSlotId() {
        return this.maxSlotId++;
    }

    public CurrentImpl getPICurrent() {
        return this.piCurrent;
    }

    public Interceptor[] getInterceptors() {
        int n = this.clientInterceptors == null ? 0 : this.clientInterceptors.length;
        int n2 = this.serverInterceptors == null ? 0 : this.serverInterceptors.length;
        int n3 = this.iorInterceptors == null ? 0 : this.iorInterceptors.length;
        Interceptor[] interceptorArray = new Interceptor[n + n2 + n3];
        if (n != 0) {
            System.arraycopy(this.clientInterceptors, 0, interceptorArray, 0, n);
        }
        if (n2 != 0) {
            System.arraycopy(this.serverInterceptors, 0, interceptorArray, n, n2);
        }
        if (n3 != 0) {
            System.arraycopy(this.iorInterceptors, 0, interceptorArray, n + n2, n3);
        }
        return interceptorArray;
    }

    private class InterceptorList {
        private final ArrayList list = new ArrayList();
        private final ArrayList localList;
        private final Set names;

        public InterceptorList(boolean bl) {
            this.localList = bl ? new ArrayList() : null;
            this.names = new HashSet();
        }

        public void add(Interceptor interceptor, boolean bl, boolean bl2) throws DuplicateName {
            String string = interceptor.name();
            if (string == null) {
                throw new BAD_PARAM("Interceptor name is null", 1229124118, CompletionStatus.COMPLETED_NO);
            }
            if (!"".equals(string) && this.names.contains(string)) {
                throw new DuplicateName(string);
            }
            this.names.add(string);
            if (bl) {
                this.list.add(0, interceptor);
            } else {
                this.list.add(interceptor);
            }
            if (bl2 && this.localList != null) {
                if (bl) {
                    this.localList.add(0, interceptor);
                } else {
                    this.localList.add(interceptor);
                }
            }
            if (InterceptorManager.this.pmiServer != null) {
                InterceptorManager.this.pmiServer.onInterceptorRegister(interceptor);
            }
        }

        public ClientRequestInterceptor[] getClientInterceptors(boolean bl) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = bl ? this.localList : this.list;
            if (arrayList == null || arrayList.isEmpty()) {
                return null;
            }
            ClientRequestInterceptor[] clientRequestInterceptorArray = new ClientRequestInterceptor[arrayList.size()];
            arrayList.toArray(clientRequestInterceptorArray);
            return clientRequestInterceptorArray;
        }

        public ServerRequestInterceptor[] getServerInterceptors(boolean bl) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList = bl ? this.localList : this.list;
            if (arrayList == null || arrayList.isEmpty()) {
                return null;
            }
            ServerRequestInterceptor[] serverRequestInterceptorArray = new ServerRequestInterceptor[arrayList.size()];
            arrayList.toArray(serverRequestInterceptorArray);
            return serverRequestInterceptorArray;
        }

        public IORInterceptor[] getIORInterceptors() {
            if (this.list == null || this.list.isEmpty()) {
                return null;
            }
            IORInterceptor[] iORInterceptorArray = new IORInterceptor[this.list.size()];
            this.list.toArray(iORInterceptorArray);
            return iORInterceptorArray;
        }
    }
}

