/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.iiop.WorkQueue;
import com.ibm.rmi.iiop.WorkerThread;
import java.util.LinkedList;

final class WorkerPool {
    private LinkedList pool;
    private int minSize;
    private int maxSize;
    private boolean isGrowable;
    private long inactivityTimeout;
    private boolean shutdownPending = false;
    private WorkQueue workQueue = null;
    private int threadCounter = 0;
    private boolean initialized = false;

    private WorkerPool() {
    }

    public WorkerPool(int n, int n2, long l, boolean bl) {
        this.pool = new LinkedList();
        this.minSize = n;
        this.maxSize = n2;
        this.inactivityTimeout = l == -1L ? 0L : (l == 0L ? -1L : l);
        this.isGrowable = bl;
    }

    synchronized void setWorkQueue(WorkQueue workQueue) {
        this.workQueue = workQueue;
    }

    synchronized void initializeThreads() {
        if (!this.initialized) {
            for (int i = 0; i < this.minSize; ++i) {
                this.createThread();
            }
            this.initialized = true;
        }
    }

    synchronized boolean createThread() {
        if (this.pool.size() < this.maxSize) {
            return this.pool.add(this.createWorkerThread(true));
        }
        if (this.isGrowable) {
            this.createWorkerThread(false);
            return true;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4128L, this, "createThread:341", "Could not create a new Thread to service the request, it will be queued until an existing thread becomes available. If you see a lot of these messages, and suspect a Thread bottleneck, please review the com.ibm.CORBA.ThreadPoolImpl property settings.");
        }
        return false;
    }

    synchronized void removeWorkerThread(WorkerThread workerThread) {
        if (this.pool.remove(workerThread) && ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4160L, this, "removeWorkerThread:360", "Removed WorkerThread " + workerThread.getName() + " from the ThreadPool.");
        }
        if (!this.isShutdownPending() && this.pool.size() < this.minSize) {
            this.pool.add(this.createWorkerThread(true));
        }
    }

    void shutdown() {
        this.setShutdownPending(true);
    }

    private WorkerThread createWorkerThread(boolean bl) {
        String string = "WT=" + this.getThreadCounter();
        this.incrementThreadCounter();
        return new WorkerThread(this.inactivityTimeout, bl, this.workQueue, string);
    }

    private synchronized void setShutdownPending(boolean bl) {
        this.shutdownPending = true;
    }

    private synchronized boolean isShutdownPending() {
        return this.shutdownPending;
    }

    private synchronized int getThreadCounter() {
        return this.threadCounter;
    }

    private synchronized void incrementThreadCounter() {
        ++this.threadCounter;
    }
}

