/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CodeSetComponentInfo;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ServerDelegate;
import com.ibm.CORBA.iiop.ServerRequest;
import com.ibm.CORBA.iiop.ServerResponse;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.iiop.CDROutputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.IIOPInputStream;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.PseudoRequestMessage;
import com.ibm.rmi.iiop.PseudoRequestMsgImpl;
import com.ibm.rmi.iiop.ReplyMessage;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.iiop.ServerResponseImpl;
import com.ibm.rmi.pi.InterceptorManager;
import com.ibm.rmi.pi.ServerRequestInfoImpl;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.UnknownException;
import org.omg.PortableServer.POA;

public class ServerRequestImpl
extends IIOPInputStream
implements ServerRequest {
    private static final String CLASS = ServerRequestImpl.class.getName();
    OutputStream replyStream;
    OutputStream exceptionReplyStream;
    private int startBodyOffset;
    private final RequestMessage request;
    private final PseudoRequestMessage pseudoRequest;
    private Throwable interceptorException = null;
    protected ServerRequestInfoImpl interceptorInfo;
    private ServerDelegate sd;
    private boolean responseDone = false;
    private Object cookie;
    private POA poa;
    private Object servant;
    private ServerResponseImpl firstResponse = null;

    ServerRequestImpl(Connection connection, byte[] byArray, RequestMessage requestMessage, int n) throws IOException {
        super(connection, byArray, requestMessage, n);
        this.setConnectionType((byte)2);
        this.request = requestMessage;
        this.pseudoRequest = this.request;
    }

    ServerRequestImpl(Connection connection, byte[] byArray, RequestMessage requestMessage, int n, int n2) throws IOException {
        super(connection, byArray, requestMessage, n, n2);
        this.setConnectionType((byte)2);
        this.request = requestMessage;
        this.pseudoRequest = this.request;
        this.startBodyOffset = n2;
    }

    public ServerRequestImpl(String string, boolean bl) {
        this.request = null;
        this.pseudoRequest = new PseudoRequestMsgImpl(string, bl);
    }

    public void runInterceptors() {
        InterceptorManager interceptorManager = (InterceptorManager)((com.ibm.rmi.corba.ORB)this.orb).getInterceptorManager();
        if (interceptorManager.haveServerInterceptors()) {
            this.interceptorInfo = (ServerRequestInfoImpl)interceptorManager.createServerInfo(this, this.request, this.conn.getConnectionData(), false);
            try {
                interceptorManager.iterateReceiveContext(this.interceptorInfo);
            }
            catch (Throwable throwable) {
                this.interceptorException = throwable;
            }
        }
    }

    public void throwInterceptorException() throws Throwable {
        if (this.interceptorException != null) {
            throw this.interceptorException;
        }
    }

    public boolean hasException() {
        return this.interceptorException != null;
    }

    public int getRequestId() {
        this.checkServerRequestIntegrity("getRequestId");
        return this.request.getRequestId();
    }

    public boolean isOneWay() {
        return !this.pseudoRequest.isResponseExpected();
    }

    public boolean isConnectionless() {
        return this.request == null;
    }

    public ServiceContext[] getServiceContextList() {
        return this.pseudoRequest.getServiceContextList();
    }

    public ServiceContext getServiceContext(int n) {
        return this.pseudoRequest.getServiceContext(n);
    }

    public boolean setServiceContext(ServiceContext serviceContext, boolean bl) {
        return this.pseudoRequest.setServiceContext(serviceContext, bl);
    }

    public String getOperationName() {
        return this.pseudoRequest.getOperation();
    }

    public ObjectKey getObjectKeyObject() {
        this.checkServerRequestIntegrity("getObjectKeyObject");
        return this.request.getObjectKeyObject();
    }

    public byte[] getObjectKey() {
        this.checkServerRequestIntegrity("getObjectKey");
        return this.request.getObjectKeyObject().getBytes();
    }

    public byte[] getAdapterId() {
        this.checkServerRequestIntegrity("getAdapterId");
        return this.request.getAdapterId();
    }

    public byte getGIOPMajor() {
        this.checkServerRequestIntegrity("getGIOPMajor");
        return this.request.getGIOPMajor();
    }

    public byte getGIOPMinor() {
        this.checkServerRequestIntegrity("getGIOPMinor");
        return this.request.getGIOPMinor();
    }

    public ServerResponse createResponse(ServiceContext[] serviceContextArray) {
        ServerResponseImpl serverResponseImpl = new ServerResponseImpl(this, serviceContextArray);
        if (serviceContextArray != null) {
            serverResponseImpl.setReplyHasInitialContexts();
        }
        return serverResponseImpl;
    }

    public OutputStream createReply() {
        if (this.replyStream == null) {
            this.replyStream = (OutputStream)this.createResponse(this.getConnection().getServiceContextReplyList());
        }
        return this.replyStream;
    }

    public OutputStream createExceptionReply() {
        if (this.exceptionReplyStream == null) {
            this.exceptionReplyStream = (OutputStream)this.createUserExceptionResponse();
        }
        return this.exceptionReplyStream;
    }

    public ServerResponse createUserExceptionResponse() {
        return new ServerResponseImpl(this, this.getConnection().getServiceContextReplyList(), true);
    }

    public ServerResponse createUnknownExceptionResponse(UnknownException unknownException) {
        CDROutputStream cDROutputStream;
        ServiceContext[] serviceContextArray = this.getConnection().getServiceContextReplyList();
        UNKNOWN uNKNOWN = new UNKNOWN("Unknown exception:" + unknownException.getMessage(), 1229127302, CompletionStatus.COMPLETED_MAYBE);
        try {
            int n;
            cDROutputStream = new CDROutputStream(this.orb, this.getGIOPMajor(), this.getGIOPMinor());
            ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).putEndian();
            ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).write_value(unknownException.originalEx);
            byte[] byArray = ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).toByteArray();
            ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).releaseBuffer();
            int n2 = n = serviceContextArray == null ? 0 : serviceContextArray.length;
            if (n == 0) {
                serviceContextArray = new ServiceContext[2];
            } else {
                ServiceContext[] serviceContextArray2 = serviceContextArray;
                serviceContextArray = new ServiceContext[n + 2];
                System.arraycopy(serviceContextArray2, 0, serviceContextArray, 0, n);
            }
            serviceContextArray[n] = com.ibm.CORBA.iiop.ORB.createServiceContext(9, byArray);
            serviceContextArray[n + 1] = this.createExceptionDetailMessage(unknownException.originalEx);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                ORBRas.orbTrcLogger.exception(4104L, this, "createUnknownExceptionResponse:325", (Exception)throwable);
            }
            ORBRas.orbTrcLogger.trace(4104L, (Object)this, "createUnknownExceptionResponse:330", throwable.toString(), (Object)throwable);
        }
        cDROutputStream = new ServerResponseImpl(this, serviceContextArray, (SystemException)uNKNOWN);
        Utility.writeSystemException((SystemException)uNKNOWN, (OutputStream)cDROutputStream);
        return cDROutputStream;
    }

    public ServerResponse createSystemExceptionResponse(SystemException systemException) {
        ServiceContext[] serviceContextArray = this.getConnection().getServiceContextReplyList();
        int n = serviceContextArray == null ? 0 : serviceContextArray.length;
        ServiceContext[] serviceContextArray2 = new ServiceContext[n + 1];
        for (int i = 0; i < n; ++i) {
            serviceContextArray2[i] = serviceContextArray[i];
        }
        serviceContextArray2[n] = this.createExceptionDetailMessage(systemException);
        ServerResponseImpl serverResponseImpl = new ServerResponseImpl(this, serviceContextArray2, systemException);
        Utility.writeSystemException(systemException, (OutputStream)serverResponseImpl);
        return serverResponseImpl;
    }

    private String createLongExceptionDetails(Throwable throwable) {
        String string = ((com.ibm.CORBA.iiop.ORB)this.orb).getORBServerHost();
        int n = ((com.ibm.CORBA.iiop.ORB)this.orb).getServerId();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        printWriter.print("\t>> SERVER (id=");
        printWriter.print(Integer.toHexString(n));
        printWriter.print(", host=");
        printWriter.print(string);
        printWriter.println(") TRACE START:");
        printWriter.print("\t>>    ");
        printWriter.println(throwable);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            printWriter.print("\t>>\t at ");
            printWriter.println(stackTraceElementArray[i].toString());
        }
        printWriter.print("\t>> SERVER (id=");
        printWriter.print(Integer.toHexString(n));
        printWriter.print(", host=");
        printWriter.print(string);
        printWriter.println(") TRACE END.");
        printWriter.flush();
        return stringWriter.toString();
    }

    private ServiceContext createExceptionDetailMessage(Throwable throwable) {
        CDROutputStream cDROutputStream = new CDROutputStream(this.orb, this.getGIOPMajor(), this.getGIOPMinor());
        ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).putEndian();
        if (((ORB)this.orb).isShortExceptionDetails()) {
            ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).write_wstring(throwable.toString());
        } else {
            ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).write_wstring(this.createLongExceptionDetails(throwable));
        }
        byte[] byArray = ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).toByteArray();
        ((com.ibm.CORBA.iiop.CDROutputStream)cDROutputStream).releaseBuffer();
        return com.ibm.CORBA.iiop.ORB.createServiceContext(14, byArray);
    }

    public ServerResponse createDummyExceptionResponse(SystemException systemException) {
        ServerResponseImpl serverResponseImpl = new ServerResponseImpl(this, systemException);
        return serverResponseImpl;
    }

    public ServerResponse createLocationForward(IOR iOR) {
        ReplyMessage replyMessage = new ReplyMessage(this.getConnection().getServiceContextReplyList(), this.getRequestId(), 3, this.getGIOPMajor(), this.getGIOPMinor());
        ServerResponseImpl serverResponseImpl = new ServerResponseImpl(this, replyMessage, iOR, true);
        return serverResponseImpl;
    }

    public ServerResponse createNeedsAddressingMode(short s) {
        ReplyMessage replyMessage = new ReplyMessage(this.getConnection().getServiceContextReplyList(), this.getRequestId(), 5, this.getGIOPMajor(), this.getGIOPMinor());
        ServerResponseImpl serverResponseImpl = new ServerResponseImpl(this, replyMessage, s);
        return serverResponseImpl;
    }

    public ServerRequestInfoImpl getServerRequestInfo() {
        return this.interceptorInfo;
    }

    public void setPostInvoke(ServerDelegate serverDelegate, POA pOA, Object object, Object object2) {
        this.sd = serverDelegate;
        this.poa = pOA;
        this.servant = object;
        this.cookie = object2;
    }

    public void callPostInvoke() {
        if (this.sd != null) {
            this.sd.doPostinvoke(this.poa, this.getObjectKeyObject(), this.servant, this.cookie, this.getOperationName());
        }
    }

    public boolean isResponseDone() {
        return this.responseDone;
    }

    public void setResponseDone() {
        this.responseDone = true;
    }

    public void cancelFirstResponse(ServerResponseImpl serverResponseImpl) {
        if (this.firstResponse == null) {
            this.firstResponse = serverResponseImpl;
        } else {
            this.firstResponse.cancelReply();
        }
    }

    public final void consumeServiceContexts() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.entry(4100L, this, "consumeServiceContexts:517");
        }
        ORB oRB = (ORB)this.orb;
        Connection connection = this.getConnection();
        if (connection != null && oRB.useChannelFramework()) {
            return;
        }
        ServiceContext[] serviceContextArray = this.getServiceContextList();
        block6: for (int i = 0; i < serviceContextArray.length; ++i) {
            switch (serviceContextArray[i].getId()) {
                case 1: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    CDRInputStream cDRInputStream = oRB.newInputStream(byArray, byArray.length);
                    cDRInputStream.consumeEndian();
                    CodeSetComponentInfo.CodeSetContext codeSetContext = new CodeSetComponentInfo.CodeSetContext();
                    codeSetContext.read(cDRInputStream);
                    int n = codeSetContext.getCharCodeSet();
                    int n2 = codeSetContext.getWCharCodeSet();
                    Trc.info("CODE_SETS: ", "char_data=", Trc.hex(n), "wchar_data=", Trc.hex(n2), CLASS, "consumeServiceContexts:542");
                    CodeSetComponentInfo codeSetComponentInfo = oRB.getCodeSetComponentInfo();
                    if (!codeSetComponentInfo.validate(codeSetContext)) {
                        if (n == 65537 && connection != null && connection.getCharCodeSet() == 0) {
                            Trc.info("Ignoring unexpected Latin-1 codeset", CLASS, "consumeServiceContexts:553");
                            continue block6;
                        }
                        throw new DATA_CONVERSION("CodeSetComponent 0x" + Utility.bytesToHexString(byArray) + " appears to be invalid.", 1229124488, CompletionStatus.COMPLETED_NO);
                    }
                    if (connection == null) continue block6;
                    int n3 = connection.getCharCodeSet();
                    int n4 = connection.getWCharCodeSet();
                    if (n3 != 0 && n3 != n || n4 != 0 && n4 != n2) {
                        throw new MARSHAL("Codeset has already been set.", 1229125859, CompletionStatus.COMPLETED_NO);
                    }
                    connection.setCodeSets(n, n2);
                    continue block6;
                }
                case 6: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, this, "consumeServiceContexts:584", "SENDING_CONTEXT_RUNTIME");
                    }
                    if (connection == null) continue block6;
                    connection.setCodeBaseRefByteArray(byArray);
                    continue block6;
                }
                case 1229081874: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    CDRInputStream cDRInputStream = oRB.newInputStream(byArray, byArray.length);
                    cDRInputStream.consumeEndian();
                    short s = cDRInputStream.read_ushort();
                    int n = cDRInputStream.read_ulong();
                    short s2 = PartnerVersionUtil.unpackMajor(n);
                    short s3 = PartnerVersionUtil.unpackMinor(n);
                    if (ORBRas.isTrcLogging) {
                        ORBRas.orbTrcLogger.trace(8208L, (Object)this, "consumeServiceContexts:603", "IBM_ORB_VERSION", (Object)(s2 + "(0x" + Integer.toHexString(s2) + "):" + s3 + ":" + s));
                    }
                    if (connection == null) continue block6;
                    if (n == 0) {
                        connection.setPartnerVersion(PartnerVersionUtil.getORB11(), (short)0, s);
                        continue block6;
                    }
                    connection.setPartnerVersion(s2, s3, s);
                    continue block6;
                }
                case 17: {
                    byte[] byArray = serviceContextArray[i].getContextData();
                    CDRInputStream cDRInputStream = oRB.newInputStream(byArray, byArray.length);
                    cDRInputStream.consumeEndian();
                    if (connection != null) {
                        connection.setStreamFormatVersion(cDRInputStream.read_octet());
                    }
                    if (!ORBRas.isTrcLogging) continue block6;
                    ORBRas.orbTrcLogger.trace(8208L, this, "consumeServiceContexts:628", "RMICustomMaxStreamFormat=" + this.getStreamFormatVersion());
                }
            }
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.exit(4100L, this, "consumeServiceContexts:636");
        }
    }

    public void close() throws IOException {
        this.replyStream = null;
        this.firstResponse = null;
        this.servant = null;
        if (this.interceptorInfo != null) {
            this.interceptorInfo.clearResponse();
        }
        super.close();
    }

    private void checkServerRequestIntegrity(String string) {
        if (this.isConnectionless()) {
            INTERNAL iNTERNAL = new INTERNAL("ServerRequest has no connection details", 1229125051, CompletionStatus.COMPLETED_NO);
            ORBRas.orbTrcLogger.exception(4104L, this, string + ":662", (Exception)((Object)iNTERNAL));
            throw iNTERNAL;
        }
    }
}

