/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.CORBA.transport.TransportConnection;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.ras.Trace;
import com.ibm.rmi.ras.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.io.IOException;
import java.util.LinkedList;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.InputStream;

public class IIOPInputStream
extends CDRInputStream
implements com.ibm.CORBA.iiop.IIOPInputStream {
    private static final String CLASS = IIOPInputStream.class.getName();
    private GIOPConnectionContext giopConnCtx = null;
    protected Connection conn = null;
    protected Message msg;
    boolean firstFragment = true;
    boolean dumpBuffer = true;
    boolean dumpMsgHeader = true;
    private int markOffset;
    private int markIndex;
    private boolean markFirstFragment;
    private long markBlockLength;
    private LinkedList bufsFromMark = null;
    private LinkedList resetBufs = null;
    private boolean useCFW = false;

    public IIOPInputStream() {
    }

    public IIOPInputStream(com.ibm.rmi.ORB oRB) {
        super((org.omg.CORBA.ORB)oRB, null, 0);
    }

    public IIOPInputStream(ORB oRB, Connection connection) {
        super((org.omg.CORBA.ORB)oRB, null, 0);
        this.conn = connection;
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl, Message message) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.msg = message;
        this.setGIOPVersion(message.getGIOPMajor(), message.getGIOPMinor(), true);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n, boolean bl) {
        super((org.omg.CORBA.ORB)oRB, byArray, n, bl);
        this.logCommTrace(byArray, n, 0);
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message, int n) throws IOException {
        this(connection.getORB(), connection);
        this.setUpHeader(byArray, message, n);
        if (connection != null) {
            connection.updateTimeStamp();
        }
        this.logCommTrace(byArray, this.size, n);
    }

    public byte[] readWholeHeader(Message message, byte[] byArray, TransportConnection transportConnection) {
        boolean bl;
        this.useCFW = true;
        this.setUpHeader(byArray, message, 0);
        message.setBodyOffset(this.get_offset());
        Trc.info("reqId=", Trc.str(message.getRequestId()), " buffer length=", Trc.str(byArray.length), " bodyOffset =", Trc.str(message.bodyOffset), CLASS, "readWholeHeader:164");
        if (transportConnection != null && (bl = this.orb instanceof ORB ? ((ORB)this.orb).CommTraceIsEnabled() : ORBRas.isTrcLogging) && transportConnection != null) {
            Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, byArray, this.size, this.offset, transportConnection);
        }
        return this.buf;
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message, int n, int n2) {
        this(connection.getORB(), connection);
        this.initMsgData(byArray, message, n);
        this.index = n2;
    }

    private void initMsgData(byte[] byArray, Message message, int n) {
        this.buf = byArray;
        this.msg = message;
        this.setGIOPVersion(this.msg.getGIOPMajor(), this.msg.getGIOPMinor(), true);
        this.littleEndian = this.msg.isLittleEndian();
        this.size = this.msg.getSize() + n;
        this.start = n;
        this.index = n + 12;
    }

    private void setUpHeader(byte[] byArray, Message message, int n) {
        this.initMsgData(byArray, message, n);
        int n2 = message.getType();
        if (!(this.msg.preGIOP12() || n2 != 0 && n2 != 3 && n2 != 1 && n2 != 4 && n2 != 7)) {
            this.msg.setRequestId(this.read_long());
            if (this.useCFW) {
                this.msg.read((InputStream)this);
            } else if (!this.msg.isFragmentToFollow() && n2 != 7) {
                this.msg.read((InputStream)this);
            } else if (n2 != 7) {
                this.dumpMsgHeader = false;
            }
        } else {
            this.msg.read((InputStream)this);
        }
    }

    public final Connection getConnection() {
        return this.conn;
    }

    public final void setConnection(Connection connection) {
        this.conn = connection;
        this.orb = connection.getORB();
    }

    public final com.ibm.CORBA.iiop.Message getMessage() {
        return this.msg;
    }

    protected boolean isFirstFragment() {
        return this.firstFragment;
    }

    public void setGIOPConnectionContext(GIOPConnectionContext gIOPConnectionContext) {
        this.giopConnCtx = gIOPConnectionContext;
    }

    public void getNextBuffer() {
        this.offset += this.index - this.start;
        this.offset -= 16;
        if (this.resetBufs != null) {
            SavedBuf savedBuf = (SavedBuf)this.resetBufs.removeFirst();
            if (this.resetBufs.isEmpty()) {
                this.resetBufs = null;
            }
            this.processNextBuffer(savedBuf);
        } else if (null != this.giopConnCtx) {
            try {
                int n = this.msg.getRequestId();
                WsByteBuffer[] wsByteBufferArray = this.giopConnCtx.getNextFragment(n);
                byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray);
                WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])wsByteBufferArray);
                this.processNextBuffer(byArray);
            }
            catch (TIMEOUT tIMEOUT) {
                Trc.warn("Timed out waiting for next fragment", CLASS, "getNextBuffer:310");
                throw tIMEOUT;
            }
            catch (Exception exception) {
                Trc.ffdc(exception, CLASS, "getNextBuffer:313");
                throw new INTERNAL(exception.toString(), 1229125060, CompletionStatus.COMPLETED_NO);
            }
        } else if (null != this.conn) {
            IIOPInputStream iIOPInputStream = this.conn.getNextFragment(this.msg.getRequestId(), this.msg.getType());
            this.processNextBuffer(iIOPInputStream);
        } else {
            Trc.ffdc("Client response without connection details", CLASS, "getNextBuffer:324");
            throw new INTERNAL("ClientResponse without connection details", 1229125052, CompletionStatus.COMPLETED_NO);
        }
    }

    private void processNextBuffer(byte[] byArray, int n, int n2, Message message, boolean bl) {
        if (bl && this.bufsFromMark != null) {
            SavedBuf savedBuf = new SavedBuf(byArray, n, n2, message);
            this.bufsFromMark.addLast(savedBuf);
        }
        this.firstFragment = false;
        this.buf = byArray;
        this.start = n;
        this.size = n2;
        this.msg = message;
        this.index = n + 12 + 4;
        Trc.info("reqId", Trc.str(message.getRequestId()), "new frag offset_hex", Trc.hex(this.get_offset()), CLASS, "processNextBuffer:351");
    }

    private void processNextBuffer(IIOPInputStream iIOPInputStream) {
        this.processNextBuffer(iIOPInputStream.buf, iIOPInputStream.start, iIOPInputStream.size, iIOPInputStream.msg, true);
    }

    private void processNextBuffer(SavedBuf savedBuf) {
        this.processNextBuffer(savedBuf.buf, savedBuf.start, savedBuf.size, savedBuf.msg, false);
    }

    private void processNextBuffer(byte[] byArray) {
        if (byArray == null) {
            Trc.ffdc("Null buffer for next fragment", CLASS, "processNextBuffer:371");
            throw new INTERNAL("Null buffer for next fragment", 1229125059, CompletionStatus.COMPLETED_NO);
        }
        this.processNextBuffer(byArray, 0, byArray.length, this.msg, true);
    }

    public int mark() {
        this.markOffset = this.offset;
        this.markIndex = this.index;
        this.markFirstFragment = this.firstFragment;
        this.markBlockLength = this.blockLength;
        SavedBuf savedBuf = new SavedBuf(this.buf, this.start, this.size, this.msg);
        if (this.bufsFromMark != null) {
            SavedBuf savedBuf2;
            while ((savedBuf2 = (SavedBuf)this.bufsFromMark.removeFirst()).buf != this.buf || savedBuf2.start != this.start) {
            }
            if (savedBuf2.size != this.size || !savedBuf2.msg.equals(this.msg)) {
                throw new MARSHAL("Stream mark error", 1229125871, CompletionStatus.COMPLETED_NO);
            }
        } else {
            this.bufsFromMark = this.resetBufs == null ? new LinkedList() : (LinkedList)this.resetBufs.clone();
        }
        this.bufsFromMark.addFirst(savedBuf);
        Trc.info("New or updated mark buffer: ", "markOffset=", Trc.str(this.markOffset), ", markIndex=", Trc.str(this.markIndex), ", bufsFromMark.size()=", Trc.str(this.bufsFromMark.size()), CLASS, "mark:408");
        return this.index;
    }

    public void reset(int n) {
        if (n != this.markIndex) {
            throw new MARSHAL("resetIndex (" + n + ") is not equal to markIndex (" + this.markIndex + ")", 1229125823, CompletionStatus.COMPLETED_NO);
        }
        this.reset();
    }

    public void reset() {
        String string = "reset";
        if (this.bufsFromMark != null) {
            Trc.info("Resetting stream: ", "markOffset=", Trc.str(this.markOffset), ", markIndex=", Trc.str(this.markIndex), ", bufsFromMark.size()=", Trc.str(this.bufsFromMark.size()), CLASS, string + ":429");
            this.offset = this.markOffset;
            this.index = this.markIndex;
            this.firstFragment = this.markFirstFragment;
            this.blockLength = this.markBlockLength;
            this.resetBufs = this.bufsFromMark;
            this.bufsFromMark = null;
            SavedBuf savedBuf = (SavedBuf)this.resetBufs.removeFirst();
            this.buf = savedBuf.buf;
            this.start = savedBuf.start;
            this.size = savedBuf.size;
            this.msg = savedBuf.msg;
            if (this.resetBufs.isEmpty()) {
                this.resetBufs = null;
            }
        } else {
            throw new MARSHAL("Stream reset error", 1229125823, CompletionStatus.COMPLETED_NO);
        }
    }

    protected void grow(int n, int n2) {
        throw new MARSHAL("Read beyond end of input stream", 1229125844, CompletionStatus.COMPLETED_MAYBE);
    }

    protected void logCommTrace() {
        this.dumpBuffer = false;
        this.dumpMsgHeader = true;
        this.logCommTrace(this.buf, this.size, this.start);
    }

    private void logCommTrace(byte[] byArray, int n, int n2) {
        if (this.conn != null && ((ORB)this.orb).CommTraceIsEnabled()) {
            Trace.dump(Utility.getMessage("Trace.inComing"), this.dumpMsgHeader, this.dumpBuffer, byArray, n, n2, this.conn.getTransportConnection());
        }
    }

    private static final class SavedBuf {
        private final int start;
        private final int size;
        private final Message msg;
        private final byte[] buf;

        private SavedBuf(byte[] byArray, int n, int n2, Message message) {
            this.buf = byArray;
            this.start = n;
            this.size = n2;
            this.msg = message;
        }
    }
}

