/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.giop.GIOPWriteCompletedCallback;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.MessageWriter;
import com.ibm.rmi.iiop.IIOPOutputStream;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcp.channel.TCPWriteRequestContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.omg.CORBA.INTERNAL;

public class GIOPMessageContextBase
extends OutputStream
implements GIOPMessageContext,
TCPWriteCompletedCallback,
GIOPWriteCompletedCallback,
Externalizable {
    private static final String CLASS = "GIOPMessageContextBase";
    private static WsByteBufferPoolManager bBPoolManager = WsByteBufferPoolManagerImpl.getRef();
    private GIOPWriteCompletedCallback appWriteCallback;
    protected Message msg;
    private int msgSize;
    private WsByteBuffer[] headerBuffers;
    private int headerSize = 0;
    private WsByteBuffer[] bodyBuffers;
    private int bodySize = 0;
    private boolean completedBody = false;
    protected IOR initialIOR;
    protected IOR targetIOR;
    protected IOR currentIOR;
    protected ObjectKey targetObjectKey;
    protected ObjectKey initialObjectKey;
    protected ServiceContext[] serviceContexts;
    private GIOPMessageContextBase headerFragmentContext;
    private GIOPMessageContextBase bodyFragmentContext;
    private MessageWriter appWriteContext;
    private boolean appForceQueue;
    private int appTimeout;
    private boolean inputMode;
    private IIOPOutputStream exceptionResponse = null;
    private Object requestIdToken;

    public GIOPMessageContextBase(Message message, ByteBuffer byteBuffer) throws Exception {
        this.msg = message;
        this.requestIdToken = new Integer(message.getRequestId());
        if (byteBuffer != null && byteBuffer.getSize() != 0) {
            byteBuffer.flushTo(this);
            byteBuffer.reset();
        }
        this.completedBody = true;
        this.inputMode = false;
    }

    public GIOPMessageContextBase(Message message, byte[] byArray, int n) {
        this.msg = message;
        this.requestIdToken = new Integer(message.getRequestId());
        WsByteBuffer[] wsByteBufferArray = null;
        if (byArray != null) {
            WsByteBuffer wsByteBuffer = this.fastWrap(byArray, 0, byArray.length);
            wsByteBuffer.position(n);
            wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer};
        }
        this.setMessageBody(wsByteBufferArray);
        this.inputMode = true;
    }

    protected WsByteBuffer fastWrap(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        WsByteBuffer wsByteBuffer = bBPoolManager.allocateDirect(n3);
        wsByteBuffer.put(byArray, n, n3);
        wsByteBuffer.position(0);
        Trc.info("WsByteBuffer created: msgBytes[].length=", Trc.str(byArray.length), ", start=", Trc.str(n), ", end=", Trc.str(n2), ", Result: ", wsByteBuffer, CLASS, "fastWrap:216");
        return wsByteBuffer;
    }

    public GIOPMessageContextBase(Message message) {
        this.msg = message;
        this.completedBody = true;
    }

    public GIOPMessageContextBase(Message message, WsByteBuffer[] wsByteBufferArray) {
        this.msg = message;
        this.setMessageBody(wsByteBufferArray);
        this.completedBody = true;
    }

    public GIOPMessageContextBase() {
    }

    public com.ibm.CORBA.iiop.Message getMessage() {
        Trc.info("msg = ", this.msg, CLASS, "getMessage262");
        return this.msg;
    }

    public WsByteBuffer[] getMessageBody() {
        if (Trc.enabled()) {
            String string = this.bodyBuffers == null ? "Body data is null" : "Body length = " + WsByteBufferUtils.lengthOf((WsByteBuffer[])this.bodyBuffers) + ", Body parts = " + this.bodyBuffers.length;
            Trc.info(string, CLASS, "getMessageBody277");
        }
        return this.bodyBuffers;
    }

    private WsByteBuffer[] getMessageBodyOnly() {
        byte[] byArray = WsByteBufferUtils.asByteArray((WsByteBuffer[])this.bodyBuffers);
        WsByteBuffer wsByteBuffer = this.fastWrap(byArray, this.msg.getBodyOffset(), byArray.length);
        return new WsByteBuffer[]{wsByteBuffer};
    }

    public void setMessageBody(WsByteBuffer[] wsByteBufferArray) {
        if (this.bodyBuffers != null) {
            throw new IllegalStateException("GIOPMessageContextBase.setMessageBody cannot be used: body data already exists");
        }
        this.bodySize = wsByteBufferArray == null ? 0 : WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        this.bodyBuffers = wsByteBufferArray;
        this.completedBody = true;
        if (Trc.enabled()) {
            String string = this.bodyBuffers == null ? "Body data cleared" : "Body length = " + this.bodySize + ", Body parts = " + this.bodyBuffers.length;
            Trc.info(string, CLASS, "setMessageBody310");
        }
    }

    public WsByteBuffer[] removeMessageBody() {
        WsByteBuffer[] wsByteBufferArray = this.getMessageBody();
        this.bodyBuffers = null;
        this.bodySize = 0;
        Trc.info("Body data removed", CLASS, "removeMessageBody323");
        return wsByteBufferArray;
    }

    public int getRequestId() {
        return this.msg.getRequestId();
    }

    public int getType() {
        return this.msg.getType();
    }

    public String getTypeName() {
        return this.msg.getTypeName();
    }

    public boolean isRequest() {
        return false;
    }

    public IOR getInitialIOR() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getInitialIOR not supported for Message Type " + this.msg.getTypeName());
    }

    public IOR getTargetIOR() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getTargetIOR not supported for Message Type " + this.msg.getTypeName());
    }

    public IOR getCurrentIOR() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getIOR not supported for Message Type " + this.msg.getTypeName());
    }

    public void setCurrentIOR(IOR iOR) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setIOR not supported for Message Type " + this.msg.getTypeName());
    }

    public ObjectKey getInitialObjectKeyObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getInitialObjectKeyObject not supported for Message Type " + this.msg.getTypeName());
    }

    public ObjectKey getObjectKeyObject() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getObjectKeyObject not supported for Message Type " + this.msg.getTypeName());
    }

    public void setObjectKeyObject(ObjectKey objectKey) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setObjectKeyObject not supported for Message Type " + this.msg.getTypeName());
    }

    public void releaseExceptionResponse() {
        this.exceptionResponse.releaseBuffer();
        Message message = (Message)this.exceptionResponse.getMessage();
        GIOPMessageContext gIOPMessageContext = message.getMessageContext();
        gIOPMessageContext.release();
    }

    public void release() {
        Trc.info("headerBuffers=", this.headerBuffers, " bodyBuffers=", this.bodyBuffers, " headerFragmentContext=", this.headerFragmentContext, " bodyFragmentContext=", this.bodyFragmentContext, CLASS, "release:444");
        if (this.headerBuffers != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.headerBuffers);
        }
        if (this.bodyBuffers != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.bodyBuffers);
        }
        if (this.headerFragmentContext != null) {
            this.headerFragmentContext.release();
        }
        if (this.bodyFragmentContext != null) {
            this.bodyFragmentContext.release();
        }
        if (this.exceptionResponse != null) {
            this.releaseExceptionResponse();
        }
    }

    public void complete(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext) {
        if (this.exceptionResponse != null) {
            this.releaseExceptionResponse();
        }
        this.appWriteCallback.completeWrite(virtualConnection, this);
    }

    public void error(VirtualConnection virtualConnection, TCPWriteRequestContext tCPWriteRequestContext, IOException iOException) {
        if (this.exceptionResponse != null) {
            this.releaseExceptionResponse();
        }
        this.appWriteCallback.completeWrite(virtualConnection, this);
    }

    public void write(int n) throws IOException {
        throw new INTERNAL("write method should not be called");
    }

    public void write(byte[] byArray, int n, int n2) {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "write:531", "data size=" + byArray.length + " offset=" + n + " length=" + n2);
        }
        if (this.completedBody) {
            WsByteBuffer wsByteBuffer = this.fastWrap(byArray, n, n + n2);
            this.headerBuffers = this.headerBuffers == null ? new WsByteBuffer[]{wsByteBuffer} : WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.headerBuffers, (WsByteBuffer)wsByteBuffer);
        } else {
            WsByteBuffer wsByteBuffer = this.fastWrap(byArray, n, n + n2);
            this.bodyBuffers = this.bodyBuffers == null ? new WsByteBuffer[]{wsByteBuffer} : WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.bodyBuffers, (WsByteBuffer)wsByteBuffer);
            this.bodySize = WsByteBufferUtils.lengthOf((WsByteBuffer[])this.bodyBuffers);
        }
    }

    public long write(MessageWriter messageWriter, int n) throws IOException {
        long l = 0L;
        if (this.bodySize > 0) {
            if (!this.inputMode && this.msg.isFragmentToFollow() && this.msg.getType() != 7) {
                this.headerFragmentContext = new GIOPMessageContextBase(this.msg);
                l = this.headerFragmentContext.writeHeader(messageWriter, true, n);
                Message message = this.msg.createAssociatedMessage((byte)7);
                message.setFragmentToFollow(true);
                this.bodyFragmentContext = new GIOPMessageContextBase(message, this.bodyBuffers);
                l += this.bodyFragmentContext.writeHeaderWithBody(messageWriter, true, n);
            } else {
                if (this.inputMode) {
                    this.bodyBuffers = this.getMessageBodyOnly();
                    this.msg.setBodyOffset(0);
                    Trc.info("write for Proxy Testing that should not be in production", CLASS, "write:609");
                }
                boolean bl = false;
                if (this.msg.getType() == 7) {
                    bl = true;
                }
                l = this.writeHeaderWithBody(messageWriter, bl, n);
            }
        } else {
            l = this.writeHeader(messageWriter, false, n);
        }
        this.release();
        return l;
    }

    protected long write(OutputStream outputStream, int n) throws IOException {
        long l = 0L;
        if (this.bodySize > 0) {
            boolean bl = false;
            if (this.msg.getType() == 7) {
                bl = true;
            }
            l = this.writeHeaderWithBody(outputStream, bl, n);
        } else {
            l = this.writeHeader(outputStream, false, n);
        }
        return l;
    }

    public VirtualConnection write(MessageWriter messageWriter, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl, int n) throws IOException {
        VirtualConnection virtualConnection = null;
        this.appWriteContext = messageWriter;
        this.appWriteCallback = gIOPWriteCompletedCallback;
        this.appForceQueue = bl;
        this.appTimeout = n;
        if (this.bodySize > 0) {
            if (!this.inputMode && this.msg.isFragmentToFollow() && this.msg.getType() != 7) {
                this.headerFragmentContext = new GIOPMessageContextBase(this.msg);
                Message message = this.msg.createAssociatedMessage((byte)7);
                message.setFragmentToFollow(true);
                this.bodyFragmentContext = new GIOPMessageContextBase(message, this.bodyBuffers);
                virtualConnection = this.headerFragmentContext.writeHeader(messageWriter, true, this, false, n);
                if (virtualConnection != null) {
                    this.completeWrite(virtualConnection, this.headerFragmentContext);
                }
            } else {
                if (this.inputMode) {
                    this.bodyBuffers = this.getMessageBodyOnly();
                    this.msg.setBodyOffset(0);
                    Trc.info("write for Proxy Testing that should not be in production", CLASS, "write:723");
                }
                boolean bl2 = false;
                if (this.msg.getType() == 7) {
                    bl2 = true;
                }
                virtualConnection = this.writeHeaderWithBody(messageWriter, bl2, this.appWriteCallback, bl, n);
            }
        } else {
            virtualConnection = this.writeHeader(messageWriter, false, gIOPWriteCompletedCallback, bl, n);
        }
        return virtualConnection;
    }

    protected long writeHeaderWithBody(OutputStream outputStream, boolean bl, int n) throws IOException {
        long l = 0L;
        this.flushMessageHeaderWithBody(bl);
        WsByteBuffer[] wsByteBufferArray = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.headerBuffers, (WsByteBuffer[])this.bodyBuffers);
        if (outputStream instanceof MessageWriter) {
            l = ((MessageWriter)outputStream).write(this.msg, wsByteBufferArray, this.msgSize, n);
        } else {
            outputStream.write(WsByteBufferUtils.asByteArray((WsByteBuffer[])wsByteBufferArray));
            l = this.headerSize + this.bodySize;
        }
        return l;
    }

    public VirtualConnection writeHeaderWithBody(MessageWriter messageWriter, boolean bl, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl2, int n) throws IOException {
        this.flushMessageHeaderWithBody(bl);
        WsByteBuffer[] wsByteBufferArray = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.headerBuffers, (WsByteBuffer[])this.bodyBuffers);
        VirtualConnection virtualConnection = messageWriter.write(this.msg, wsByteBufferArray, this.msgSize, this, bl2, n);
        return virtualConnection;
    }

    protected long writeHeader(OutputStream outputStream, boolean bl, int n) throws IOException {
        long l = 0L;
        this.flushMessageHeader(bl);
        if (outputStream instanceof MessageWriter) {
            l = ((MessageWriter)outputStream).write(this.msg, this.headerBuffers, this.headerSize, n);
        } else {
            outputStream.write(WsByteBufferUtils.asByteArray((WsByteBuffer[])this.headerBuffers));
            l = this.headerSize;
        }
        return l;
    }

    public VirtualConnection writeHeader(MessageWriter messageWriter, boolean bl, GIOPWriteCompletedCallback gIOPWriteCompletedCallback, boolean bl2, int n) throws IOException {
        this.flushMessageHeader(bl);
        VirtualConnection virtualConnection = messageWriter.write(this.msg, this.headerBuffers, this.headerSize, this, bl2, n);
        return virtualConnection;
    }

    private ByteBuffer marshalMessageHeader(boolean bl, boolean bl2) {
        ByteBuffer byteBuffer = this.msg.writeHeader(bl, bl2);
        return byteBuffer;
    }

    private void flushMessageHeader(boolean bl) throws IOException {
        ByteBuffer byteBuffer = this.marshalMessageHeader(false, bl);
        this.headerSize = byteBuffer.getWriteOffset();
        Trc.info("headerSize=", Trc.str(this.headerSize), CLASS, "flushMessageHeader:871");
        this.msg.setSize(this.headerSize);
        byteBuffer.flushTo(this);
        byteBuffer.reset();
    }

    private void flushMessageHeaderWithBody(boolean bl) throws IOException {
        ByteBuffer byteBuffer = this.marshalMessageHeader(bl, true);
        this.headerSize = byteBuffer.getWriteOffset();
        this.msgSize = this.headerSize + this.bodySize;
        Trc.info("msgSize= ", Trc.str(this.msgSize), " headerSize=", Trc.str(this.headerSize), " bodySize=", Trc.str(this.bodySize), CLASS, "flushMessageHeaderWithBody:895");
        this.msg.setSize(this.msgSize);
        byteBuffer.flushTo(this);
        byteBuffer.reset();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.msg);
        objectOutput.writeInt(this.bodySize);
        if (this.bodySize != 0) {
            objectOutput.writeObject(this.bodyBuffers);
        }
        Message.writeIOR(objectOutput, this.initialIOR);
        Message.writeIOR(objectOutput, this.targetIOR);
        Message.writeIOR(objectOutput, this.currentIOR);
        objectOutput.writeObject(this.initialObjectKey);
        objectOutput.writeObject(this.targetObjectKey);
        this.requestIdToken = new Integer(this.msg.getRequestId());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.msg = (Message)objectInput.readObject();
        this.bodySize = objectInput.readInt();
        WsByteBuffer[] wsByteBufferArray = null;
        if (this.bodySize != 0) {
            wsByteBufferArray = (WsByteBuffer[])objectInput.readObject();
        }
        this.setMessageBody(wsByteBufferArray);
        this.initialIOR = Message.readIOR(objectInput);
        this.targetIOR = Message.readIOR(objectInput);
        this.currentIOR = Message.readIOR(objectInput);
        this.initialObjectKey = (ObjectKey)objectInput.readObject();
        this.targetObjectKey = (ObjectKey)objectInput.readObject();
    }

    public void completeWrite(VirtualConnection virtualConnection, GIOPMessageContext gIOPMessageContext) {
        VirtualConnection virtualConnection2 = null;
        try {
            virtualConnection2 = this.bodyFragmentContext.writeHeaderWithBody(this.appWriteContext, true, this.appWriteCallback, this.appForceQueue, this.appTimeout);
            if (virtualConnection2 != null) {
                this.appWriteCallback.completeWrite(virtualConnection2, this);
            }
        }
        catch (IOException iOException) {
            this.appWriteCallback.errorWrite(virtualConnection2, this, iOException);
        }
    }

    public void errorWrite(VirtualConnection virtualConnection, GIOPMessageContext gIOPMessageContext, IOException iOException) {
        this.appWriteCallback.errorWrite(virtualConnection, this, iOException);
    }

    public ServiceContextList getServiceContexts() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getServiceContexts not supported for Message Type " + this.msg.getTypeName());
    }

    public void setServiceContexts(ServiceContextList serviceContextList) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setServiceContexts not supported for Message Type " + this.msg.getTypeName());
    }

    public IIOPOutputStream getExceptionResponse() {
        return this.exceptionResponse;
    }

    public void setExceptionResponse(IIOPOutputStream iIOPOutputStream) {
        this.exceptionResponse = iIOPOutputStream;
    }

    public Object getRequestIdToken() {
        return this.requestIdToken;
    }

    public boolean isFragmentToFollow() {
        return this.msg.isFragmentToFollow();
    }

    public boolean isResponseExpected() {
        return false;
    }

    public WsByteBuffer[] getSendingContextBytes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("getSendingContextBytes not supported for Message Type " + this.msg.getTypeName());
    }

    public void setSendingContextBytes(WsByteBuffer[] wsByteBufferArray) {
    }
}

