/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.channel.orb.CallLink;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ChannelTransportConnection;
import com.ibm.rmi.channel.orb.ORBChannelHelper;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.ORB;
import com.ibm.wsspi.channel.base.InboundApplicationLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.io.IOException;

public class ORBServerCallLink
extends InboundApplicationLink
implements CallLink {
    private static final String CLASS = ORBServerCallLink.class.getName();
    private ORB orb;
    private GIOPConnectionContext connCtx = null;
    private ORBChannelHelper channelHelper;
    private int requestTimeout;
    private Connection conn;

    public void setGIOPConnectionContext(GIOPConnectionContext gIOPConnectionContext) {
        this.connCtx = gIOPConnectionContext;
    }

    public GIOPConnectionContext getGIOPConnectionContext() {
        return this.connCtx;
    }

    public ORBServerCallLink(VirtualConnection virtualConnection, ORBChannelHelper oRBChannelHelper) {
        this.init(virtualConnection);
        this.channelHelper = oRBChannelHelper;
        this.orb = oRBChannelHelper.getOrb();
        this.requestTimeout = oRBChannelHelper.getTimeout(this.orb.getRequestTimeout());
    }

    public void ready(VirtualConnection virtualConnection) {
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
    }

    public void destroy(Exception exception) {
    }

    public void error(VirtualConnection virtualConnection, Exception exception) {
        Trc.warn(exception, CLASS, "error:106");
    }

    public void processMessage(GIOPMessageContext gIOPMessageContext) {
        Trc.begin(CLASS, "processMessage:111");
        ChannelTransportConnection channelTransportConnection = new ChannelTransportConnection(this.channelHelper.getOrb(), this.connCtx);
        this.conn = new Connection(this.channelHelper.getOrb(), this.channelHelper.getGIOPImpl(), true);
        this.conn.setContext(this, channelTransportConnection, this.connCtx);
        try {
            this.channelHelper.processCall(this.conn, this.connCtx, gIOPMessageContext, this, this.requestTimeout);
        }
        catch (Exception exception) {
            Trc.warn(exception, CLASS, "processMessage:125");
            if (gIOPMessageContext.isResponseExpected()) {
                try {
                    this.connCtx.sendExceptionResponse(exception, gIOPMessageContext, -1);
                }
                catch (IOException iOException) {
                    Trc.warn(iOException, CLASS, "processMessage:132");
                    this.connCtx.finishRequest(gIOPMessageContext.getRequestId());
                }
            }
            this.connCtx.finishRequest(gIOPMessageContext.getRequestId());
        }
        gIOPMessageContext.release();
        Trc.complete(CLASS, "processMessage:141");
    }

    public void errorResponse(Exception exception) {
        Trc.warn("should never be called on Server", CLASS, "errorResponse:151");
    }
}

