/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.ChannelTransportConnection;
import com.ibm.rmi.channel.giop.GIOPChannelConfig;
import com.ibm.rmi.channel.giop.GIOPConnection;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.channel.giop.GIOPServerChannel;
import com.ibm.rmi.channel.giop.MessageReader;
import com.ibm.rmi.channel.giop.ServerConnectionKey;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.ORB;
import com.ibm.wsspi.channel.ConnectionLink;
import com.ibm.wsspi.channel.base.InboundProtocolLink;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.tcp.channel.TCPConnectionContext;

public class GIOPServerLink
extends InboundProtocolLink {
    private static final String CLASS = GIOPServerLink.class.getName();
    private GIOPConnection giopConn;
    private GIOPServerChannel giopChannel;
    private TCPConnectionContext tcpConnCtx = null;
    private GIOPChannelConfig giopConfig;
    private GIOPChannelPlugin giopPlugin;
    private Connection conn;

    public GIOPServerLink(VirtualConnection virtualConnection, GIOPChannelConfig gIOPChannelConfig, GIOPServerChannel gIOPServerChannel) {
        this.init(virtualConnection);
        this.giopConfig = gIOPChannelConfig;
        this.giopChannel = gIOPServerChannel;
    }

    public Object getChannelAccessor() {
        return this.giopConn;
    }

    public void ready(VirtualConnection virtualConnection) {
        this.tcpConnCtx = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        String string = (String)virtualConnection.getStateMap().get("TCP_THREADPOOL_NAME");
        Trc.info("local=", this.tcpConnCtx.getLocalAddress().getHostName(), ":", Trc.str(this.tcpConnCtx.getLocalPort()), ", remote=", this.tcpConnCtx.getRemoteAddress().getHostName(), ":", Trc.str(this.tcpConnCtx.getRemotePort()), CLASS, "ready:95");
        try {
            this.giopPlugin = this.giopConfig.getGIOPChannelPlugin();
        }
        catch (Exception exception) {
            Trc.ffdc(exception, CLASS, "ready:101");
        }
        ORB oRB = this.giopConfig.getOrb();
        this.conn = new Connection(oRB, oRB.getServerGIOP(), true);
        ChannelTransportConnection channelTransportConnection = new ChannelTransportConnection(oRB);
        ServerConnectionKey serverConnectionKey = new ServerConnectionKey(virtualConnection, this.tcpConnCtx.getRemoteAddress().getHostName(), this.tcpConnCtx.getRemotePort());
        GIOPConnectionTable gIOPConnectionTable = this.giopConfig.getConnectionTable();
        gIOPConnectionTable.addConnection(serverConnectionKey, this.conn);
        this.giopConn = new GIOPConnection(virtualConnection, (ConnectionLink)this, this.conn, channelTransportConnection, this.giopConfig, this.giopPlugin, this.tcpConnCtx, string);
        channelTransportConnection.setConnectionContext(this.giopConn);
        this.conn.setContext(channelTransportConnection, this.giopConn);
        MessageReader messageReader = (MessageReader)this.giopConn.getReadInterface();
        try {
            messageReader.readFirstMessage();
        }
        catch (Exception exception) {
            ORBRas.orbTrcLogger.exception(4104L, (Object)this, "ready:135", exception);
            this.giopConn.closeConnection(exception);
        }
    }

    public void close(VirtualConnection virtualConnection, Exception exception) {
        Trc.info(exception.getMessage(), CLASS, "close:147");
        this.giopConn.waitForPermissionToClose(exception);
        this.getDeviceLink().close(virtualConnection, exception);
    }

    public void destroy(Exception exception) {
    }

    public GIOPServerChannel getChannel() {
        return this.giopChannel;
    }
}

