/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.orb.ORBConfigConstants;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.ServerGIOP;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportService;
import java.util.Map;

public class GIOPChannelConfig
implements ORBConfigConstants {
    private static final String CLASS = GIOPChannelConfig.class.getName();
    public static String CONNECTION = "Connection";
    protected static final int USE_JIT_MODE = 1;
    protected static final int DO_NOT_SET_MODE = 2;
    protected static final int USE_ALLOCATE_MODE = 3;
    private int giopBufferMode = 1;
    private Map giopProperty;
    private ORB orb;
    private GIOPChannelPlugin giopPlugin;
    private ServerGIOP giopImpl;
    private TransportService transportService;

    GIOPChannelConfig(Map map) {
        this.giopProperty = map;
        this.setGIOPBufferMode();
    }

    GIOPChannelPlugin getGIOPChannelPlugin() {
        if (this.giopPlugin == null) {
            this.giopPlugin = (GIOPChannelPlugin)this.getOrb().getPlugin(GIOPChannelPlugin.class.getName());
        }
        if (this.giopPlugin == null) {
            String string = "GIOPChannelPlugin not set on registered ORB";
            Trc.ffdc(string, CLASS, "getGIOPPlugin:92");
            throw new Error(string);
        }
        return this.giopPlugin;
    }

    ORB getOrb() {
        if (this.orb == null) {
            this.orb = (ORB)this.giopProperty.get("ORB");
            Trc.info("ORB from giopProperty=", this.orb, CLASS, "getOrb:108");
            if (this.orb == null) {
                this.orb = GIOPChannelHelper.getOrb();
                this.giopProperty.put("ORB", this.orb);
                Trc.info("ORB from GIOChannelHelper=", this.orb, CLASS, "getOrb:114");
            }
            if (this.orb == null) {
                String string = "ORB property not set andORB not available from GIOPChannelHelper";
                Trc.ffdc(string, CLASS, "getOrb:119");
                throw new Error(string);
            }
        }
        this.transportService = (TransportService)this.orb.getTransport();
        return this.orb;
    }

    private void setGIOPBufferMode() {
        String string = (String)this.giopProperty.get("SetInputBuffer");
        if (string == null) {
            return;
        }
        if (string.equals("USE_JIT")) {
            this.giopBufferMode = 1;
            return;
        }
        if (string.equals("USE_ALLOCATE")) {
            this.giopBufferMode = 3;
            return;
        }
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "setGIOPBufferMode:146", "SetInputBuffer = " + string + " not recognized - default is used");
        }
    }

    int getGIOPBufferMode() {
        return this.giopBufferMode;
    }

    public synchronized GIOPConnectionTable getConnectionTable() {
        if (this.transportService == null) {
            this.transportService = (TransportService)this.getOrb().getTransport();
        }
        return this.transportService.getConnectionTable();
    }

    public ServerGIOP getGIOPImpl() {
        if (this.giopImpl == null) {
            this.giopImpl = this.getOrb().getServerGIOP();
        }
        return this.giopImpl;
    }
}

