/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.channel.giop.GIOPUtil;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.util.LinkedList;

final class FragmentQueue
extends LinkedList {
    private static final long serialVersionUID = 0L;
    private static final String CLASS = FragmentQueue.class.getName();
    private static final int fragTimeout = 300;
    final int requestId;
    final byte msgType;
    private boolean lastFragmentReceived = false;

    public Object writeReplace() throws ObjectStreamException {
        throw new NotSerializableException(this.getClass().getName());
    }

    FragmentQueue(int n, byte by) {
        this.requestId = n;
        this.msgType = by;
    }

    synchronized void addNextFragment(WsByteBuffer[] wsByteBufferArray) {
        Trc.info("Next fragment for ", GIOPUtil.messageTypeName(this.msgType), " message, request number ", Trc.str(this.requestId), Trc.hex(wsByteBufferArray), CLASS, "addNextFragment:65");
        this.add(wsByteBufferArray);
        this.notify();
    }

    synchronized void addLastFragment(WsByteBuffer[] wsByteBufferArray) {
        this.lastFragmentReceived = true;
        this.addNextFragment(wsByteBufferArray);
        Trc.info("Last fragment received.", CLASS, "addLastFragment:74");
    }

    synchronized WsByteBuffer[] getNextFragment() {
        if (this.size() > 0) {
            return (WsByteBuffer[])this.removeFirst();
        }
        long l = 300000L;
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                this.wait(l);
                return (WsByteBuffer[])this.removeFirst();
            }
            catch (InterruptedException interruptedException) {
                if (this.size() > 0) {
                    return (WsByteBuffer[])this.removeFirst();
                }
                l = l2 - System.currentTimeMillis();
            }
        }
        throw GIOPUtil.fragmentTimeoutException(this.requestId, this.msgType);
    }

    synchronized boolean finished() {
        return this.lastFragmentReceived && this.isEmpty();
    }
}

