/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.ras;

import com.ibm.CORBA.iiop.OrbMsgLogger;
import com.ibm.CORBA.iiop.OrbTrcLogger;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.rmi.util.Utility;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;

public class Trc {
    private static final long BEGIN = 4100L;
    private static final long COMPLETE = 4100L;
    private static final long FAIL = 8196L;
    private static final long INFO = 4112L;
    private static final long WARN = 8208L;
    private static final long FFDC = 8208L;
    private static final long INFO_EXC = 4104L;
    private static final long WARN_EXC = 8200L;
    private static final long FFDC_EXC = 8200L;
    private static final String UNCOMPUTED = "<not calculated>";
    private static final String UNAVAILABLE = "<not available>";
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private static final String[] ZEROES = new String[]{null, "0000000", "000000", "00000", "0000", "000", "00", "0", ""};

    private Trc() {
        throw new Error("Illegal construction of Trc object.");
    }

    public static final boolean enabled() {
        return ORBRas.isTrcLogging;
    }

    public static final OrbTrcLogger logger() {
        return ORBRas.orbTrcLogger;
    }

    public static final OrbMsgLogger msgLogger() {
        return ORBRas.orbMsgLogger;
    }

    public static final void logger(OrbTrcLogger orbTrcLogger) {
        ORBRas.orbTrcLogger = orbTrcLogger;
    }

    public static final void msgLogger(OrbMsgLogger orbMsgLogger) {
        ORBRas.orbMsgLogger = orbMsgLogger;
    }

    public static final void inApplet(boolean bl) {
        ORBRas.isRunningInApplet = bl;
    }

    public static String concat(String string, String string2) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return string + string2;
    }

    public static String concat(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return string + string2 + string3 + string4 + string5 + string6 + string7 + string8 + string9 + string10;
    }

    public static String hex(long l) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.paddedHex(l, 16);
    }

    public static String hex(int n) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.paddedHex(n, 8);
    }

    public static String hex(short s) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.paddedHex(s, 4);
    }

    public static String hex(byte by) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.paddedHex(by, 2);
    }

    public static String hex(byte[] byArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Utility.bytesToHexString(byArray);
    }

    public static String hex(WsByteBuffer[] wsByteBufferArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (wsByteBufferArray == null) {
            return "null";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            int n2 = wsByteBuffer.limit();
            for (int j = 0; j < n2; ++j) {
                if (n % 16 == 0) {
                    printWriter.println();
                    printWriter.print("\t");
                    String string = Integer.toHexString(n);
                    printWriter.print(ZEROES[string.length()]);
                    printWriter.print(string);
                    printWriter.print(": ");
                } else if (n % 4 == 0) {
                    printWriter.print(" ");
                }
                byte by = wsByteBuffer.get(j);
                printWriter.print(Trc.hi(by));
                printWriter.print(Trc.lo(by));
                ++n;
            }
        }
        return stringWriter.toString();
    }

    public static String hex(ByteBuffer byteBuffer) {
        byte[] byArray;
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (byteBuffer == null) {
            return "null";
        }
        if (byteBuffer.hasArray()) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[byteBuffer.limit()];
            byteBuffer.rewind();
            byteBuffer.get(byArray);
        }
        return Utility.bytesToHexString(byArray);
    }

    private static String paddedHex(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer("0x");
        String string = Long.toHexString(l);
        for (int i = string.length(); i < n; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String str(long l) {
        return Trc.enabled() ? Long.toString(l) : UNCOMPUTED;
    }

    public static String str(double d) {
        return Trc.enabled() ? Double.toString(d) : UNCOMPUTED;
    }

    public static String str(boolean bl) {
        return Trc.enabled() ? Boolean.toString(bl) : UNCOMPUTED;
    }

    public static String str(Object object) {
        return Trc.enabled() ? object.toString() : UNCOMPUTED;
    }

    public static String str(long[] lArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (lArray == null) {
            return "null";
        }
        if (lArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = lArray.length - 1;
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(lArray[i]);
            stringBuffer.append("L");
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String str(int[] nArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = nArray.length - 1;
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String str(byte[] byArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = byArray.length - 1;
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append("0x");
            stringBuffer.append(Integer.toHexString(byArray[i]));
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String str(Object[] objectArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = objectArray.length - 1;
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]);
            if (i == n) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static String stackTrace(Throwable throwable) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        StringBuffer stringBuffer = new StringBuffer(throwable.toString()).append("\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("\tat ").append(stackTraceElementArray[i].toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String stack() {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.stack(1);
    }

    public static String stack(int n) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.stackImpl(new Throwable(), n + 1, null);
    }

    public static String stack(String string) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        return Trc.stackImpl(new Throwable(), 0, string);
    }

    private static String stackImpl(Throwable throwable, int n, String string) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return UNAVAILABLE;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = stackTraceElementArray.length - 1; i >= 0; --i) {
            String string2 = stackTraceElementArray[i].toString();
            stringBuffer.append(string2);
            if (i == n || string != null && string2.startsWith(string)) break;
            stringBuffer.append(" -> ");
        }
        return stringBuffer.toString();
    }

    public static String clz(Object object) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (object == null) {
            return "null";
        }
        return object.getClass().getName();
    }

    public static String array(WsByteBuffer[] wsByteBufferArray) {
        if (!Trc.enabled()) {
            return UNCOMPUTED;
        }
        if (wsByteBufferArray == null) {
            return "null";
        }
        if (wsByteBufferArray.length == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            if (wsByteBuffer == null) {
                stringBuffer.append("null, ");
                continue;
            }
            stringBuffer.append(System.identityHashCode(wsByteBuffer)).append("p=").append(wsByteBuffer.position()).append("l=").append(wsByteBuffer.limit()).append(", ");
        }
        stringBuffer.setCharAt(stringBuffer.length() - 2, '}');
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    private static final char hi(byte by) {
        return HEX[by >> 4 & 0xF];
    }

    private static final char lo(byte by) {
        return HEX[by & 0xF];
    }

    public static void begin(String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string, string2);
        }
    }

    public static void begin1(Object object, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string, string2, object);
        }
    }

    public static void begin1(String string, Object object, String string2, String string3) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string2, string3, (Object)(string + object));
        }
    }

    public static void begin2(Object object, Object object2, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string, string2, object, object2);
        }
    }

    public static void begin2(String string, Object object, String string2, Object object2, String string3, String string4) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string3, string4, (Object)(string + object), (Object)(string2 + object2));
        }
    }

    public static void beginN(Object[] objectArray, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string, string2, objectArray);
        }
    }

    public static void beginN(String string, Object[] objectArray, String string2, String string3) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string2, string3);
        }
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string2, string3, string, objectArray);
        }
    }

    public static void beginN(Object object, String string, Object[] objectArray, String string2, String string3) {
        if (Trc.enabled()) {
            Trc.logger().entry(4100L, string2, string3, object);
        }
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string2, string3, string, objectArray);
        }
    }

    public static void complete(String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2);
        }
    }

    public static void complete(Object object, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, object);
        }
    }

    public static void complete(Object object, Object object2, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, (Object)("" + object + object2));
        }
    }

    public static void complete(Object object, Object object2, Object object3, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, (Object)("" + object + object2 + object3));
        }
    }

    public static void complete(Object object, Object object2, Object object3, Object object4, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, (Object)("" + object + object2 + object3 + object4));
        }
    }

    public static void complete(Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5));
        }
    }

    public static void complete(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6));
        }
    }

    public static void complete(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(4100L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6 + object7));
        }
    }

    public static void fail(String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2);
        }
    }

    public static void fail(Object object, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object));
        }
    }

    public static void fail(Object object, Object object2, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2));
        }
    }

    public static void fail(Object object, Object object2, Object object3, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3));
        }
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4));
        }
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5));
        }
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6));
        }
    }

    public static void fail(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exit(8196L, string, string2, (Object)("" + object + object2 + object3 + object4 + object5 + object6 + object7));
        }
    }

    public static void info(String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "");
        }
    }

    public static void info(Object object, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object);
        }
    }

    public static void info(Object object, Object object2, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2);
        }
    }

    public static void info(Object object, Object object2, Object object3, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11 + object12);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11 + object12 + object13);
        }
    }

    public static void info(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10, Object object11, Object object12, Object object13, Object object14, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8 + object9 + object10 + object11 + object12 + object13 + object14);
        }
    }

    public static void info(Exception exception, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exception(4104L, string, string2, exception);
        }
    }

    public static void vals(String string, Object object, String string2, String string3) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string2, string3, string + "=" + object);
        }
    }

    public static void vals(String string, Object object, String string2, Object object2, String string3, String string4) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string3, string4, string + "=" + object + ", " + string2 + "=" + object2);
        }
    }

    public static void vals(String string, Object object, String string2, Object object2, String string3, Object object3, String string4, String string5) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string4, string5, string + "=" + object + ", " + string2 + "=" + object2 + ", " + string3 + "=" + object3);
        }
    }

    public static void vals(String string, Object object, String string2, Object object2, String string3, Object object3, String string4, Object object4, String string5, String string6) {
        if (Trc.enabled()) {
            Trc.logger().trace(4112L, string5, string6, string + "=" + object + ", " + string2 + "=" + object2 + ", " + string3 + "=" + object3 + ", " + string4 + "=" + object4);
        }
    }

    public static void warn(Object object, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object);
        }
    }

    public static void warn(Object object, Object object2, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2);
        }
    }

    public static void warn(Object object, Object object2, Object object3, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3);
        }
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4);
        }
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5);
        }
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6);
        }
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7);
        }
    }

    public static void warn(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().trace(8208L, string, string2, "" + object + object2 + object3 + object4 + object5 + object6 + object7 + object8);
        }
    }

    public static void warn(Exception exception, String string, String string2) {
        if (Trc.enabled()) {
            Trc.logger().exception(8200L, string, string2, exception);
        }
    }

    public static void ffdc(String string, String string2, String string3) {
        Trc.logger().trace(8208L, string2, string3, string);
    }

    public static void ffdc(Exception exception, String string, String string2) {
        Trc.logger().exception(8200L, string, string2, exception);
    }
}

